/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * gnome-scan
 * Copyright (C) Étienne Bersac 2007 <bersace03@laposte.net>
 * 
 * gnome-scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */

#include <glib/gi18n.h>
#include "gnome-scan-enum-widget.h"
#include "gnome-scan-param-specs.h"

#define GET_PRIVATE(o)  (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_TYPE_SCAN_ENUM_WIDGET, GnomeScanEnumWidgetPrivate))

typedef struct _GnomeScanEnumWidgetPrivate GnomeScanEnumWidgetPrivate;
struct _GnomeScanEnumWidgetPrivate
{
	GtkWidget*		combo;
	GtkListStore*	liststore;
};

enum
{
	ENUM_LABEL,
	ENUM_VALUE,
	ENUM_N_COLUMNS
};


static void	gsew_selected (GtkComboBox *combo, GnomeScanEnumWidget *gspw);

GS_DEFINE_PARAM_WIDGET (GnomeScanEnumWidget, gnome_scan_enum_widget);

static void
gnome_scan_enum_widget_init (GnomeScanEnumWidget *object)
{
	/* TODO: Add initialization code here */
}

static void
gnome_scan_enum_widget_finalize (GObject *object)
{
	/* TODO: Add deinitalization code here */

	G_OBJECT_CLASS (gnome_scan_enum_widget_parent_class)->finalize (object);
}



static void
gnome_scan_enum_widget_build (GnomeScanParamWidget *gspw)
{
	GnomeScanEnumWidgetPrivate *priv = GET_PRIVATE (gspw);
	GtkCellRenderer *renderer;
	GtkTreeIter iter;
	GValueArray *values = GS_PARAM_SPEC_ENUM (gspw->pspec)->values;
	GValue *label;
	const gchar *slabel;
	gint i;
	
		
	priv->liststore = gtk_list_store_new (ENUM_N_COLUMNS,
										  G_TYPE_STRING,
										  G_TYPE_VALUE);
	priv->combo = gtk_combo_box_new_with_model (GTK_TREE_MODEL (priv->liststore));
	
	renderer = gtk_cell_renderer_text_new ();
	gtk_cell_layout_pack_start (GTK_CELL_LAYOUT (priv->combo), renderer, TRUE);
	gtk_cell_layout_add_attribute (GTK_CELL_LAYOUT (priv->combo), renderer,
								   "text", ENUM_LABEL);
	
	gtk_box_pack_start (GTK_BOX (gspw), priv->combo, FALSE, FALSE, 0);

	/* available values */
	label = g_new0 (GValue, 1);
	g_value_init (label, G_TYPE_STRING);
	for (i = 0; i < values->n_values; i++) {
		
		if (G_VALUE_HOLDS_STRING (values->values+i)) {
			slabel = dgettext (gs_param_spec_get_domain (gspw->pspec),
							   g_value_get_string (values->values+i));
		}
		else {
			g_value_transform ((values->values+i), label);
			slabel = g_value_get_string(label);
		}
		
		gtk_list_store_append (priv->liststore, &iter);
		gtk_list_store_set (priv->liststore, &iter,
							ENUM_LABEL, slabel,
							ENUM_VALUE, (values->values+i),
							-1);
	}
	g_value_unset (label);
	g_free (label);
	
	g_signal_connect (priv->combo, "changed",
					  (GCallback) gsew_selected,
					  GNOME_SCAN_ENUM_WIDGET (gspw));
	
}

static void
gnome_scan_enum_widget_set (GnomeScanParamWidget *gspw, GValue *value)
{
	GnomeScanEnumWidgetPrivate *priv = GET_PRIVATE (gspw);
	GtkTreeIter iter;
	GValue *test_value;
	
	gtk_tree_model_get_iter_first (GTK_TREE_MODEL (priv->liststore), &iter);
	for (; gtk_list_store_iter_is_valid (priv->liststore, &iter)
		 ; gtk_tree_model_iter_next (GTK_TREE_MODEL (priv->liststore), &iter)) {
		gtk_tree_model_get (GTK_TREE_MODEL (priv->liststore), &iter,
							ENUM_VALUE, &test_value,
							-1);
		if (gs_param_values_cmp (gspw->pspec, value, test_value) == 0) {
			gtk_combo_box_set_active_iter (GTK_COMBO_BOX (priv->combo),
										   &iter);
			break;
		}
	}
}


static void
gsew_selected (GtkComboBox *combo, GnomeScanEnumWidget *gsew)
{
	GnomeScanParamWidget *gspw = GNOME_SCAN_PARAM_WIDGET (gsew);
	GnomeScanEnumWidgetPrivate *priv = GET_PRIVATE (gsew);
	GtkTreeIter iter;
	GValue *value;
	
	gtk_combo_box_get_active_iter (GTK_COMBO_BOX (priv->combo), &iter);
	gtk_tree_model_get (GTK_TREE_MODEL (priv->liststore), &iter,
						ENUM_VALUE, &value,
						-1);
	
	g_value_copy (value, gspw->value);
	gnome_scan_param_widget_changed (gspw);
}



