package servicefabric

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ArmServicePackageActivationMode enumerates the values for arm service package activation mode.
type ArmServicePackageActivationMode string

const (
	// ArmServicePackageActivationModeExclusiveProcess Indicates the application package activation mode will
	// use exclusive process.
	ArmServicePackageActivationModeExclusiveProcess ArmServicePackageActivationMode = "ExclusiveProcess"
	// ArmServicePackageActivationModeSharedProcess Indicates the application package activation mode will use
	// shared process.
	ArmServicePackageActivationModeSharedProcess ArmServicePackageActivationMode = "SharedProcess"
)

// PossibleArmServicePackageActivationModeValues returns an array of possible values for the ArmServicePackageActivationMode const type.
func PossibleArmServicePackageActivationModeValues() []ArmServicePackageActivationMode {
	return []ArmServicePackageActivationMode{ArmServicePackageActivationModeExclusiveProcess, ArmServicePackageActivationModeSharedProcess}
}

// ArmUpgradeFailureAction enumerates the values for arm upgrade failure action.
type ArmUpgradeFailureAction string

const (
	// ArmUpgradeFailureActionManual Indicates that a manual repair will need to be performed by the
	// administrator if the upgrade fails. Service Fabric will not proceed to the next upgrade domain
	// automatically.
	ArmUpgradeFailureActionManual ArmUpgradeFailureAction = "Manual"
	// ArmUpgradeFailureActionRollback Indicates that a rollback of the upgrade will be performed by Service
	// Fabric if the upgrade fails.
	ArmUpgradeFailureActionRollback ArmUpgradeFailureAction = "Rollback"
)

// PossibleArmUpgradeFailureActionValues returns an array of possible values for the ArmUpgradeFailureAction const type.
func PossibleArmUpgradeFailureActionValues() []ArmUpgradeFailureAction {
	return []ArmUpgradeFailureAction{ArmUpgradeFailureActionManual, ArmUpgradeFailureActionRollback}
}

// ClusterState enumerates the values for cluster state.
type ClusterState string

const (
	// ClusterStateAutoScale ...
	ClusterStateAutoScale ClusterState = "AutoScale"
	// ClusterStateBaselineUpgrade ...
	ClusterStateBaselineUpgrade ClusterState = "BaselineUpgrade"
	// ClusterStateDeploying ...
	ClusterStateDeploying ClusterState = "Deploying"
	// ClusterStateEnforcingClusterVersion ...
	ClusterStateEnforcingClusterVersion ClusterState = "EnforcingClusterVersion"
	// ClusterStateReady ...
	ClusterStateReady ClusterState = "Ready"
	// ClusterStateUpdatingInfrastructure ...
	ClusterStateUpdatingInfrastructure ClusterState = "UpdatingInfrastructure"
	// ClusterStateUpdatingUserCertificate ...
	ClusterStateUpdatingUserCertificate ClusterState = "UpdatingUserCertificate"
	// ClusterStateUpdatingUserConfiguration ...
	ClusterStateUpdatingUserConfiguration ClusterState = "UpdatingUserConfiguration"
	// ClusterStateUpgradeServiceUnreachable ...
	ClusterStateUpgradeServiceUnreachable ClusterState = "UpgradeServiceUnreachable"
	// ClusterStateWaitingForNodes ...
	ClusterStateWaitingForNodes ClusterState = "WaitingForNodes"
)

// PossibleClusterStateValues returns an array of possible values for the ClusterState const type.
func PossibleClusterStateValues() []ClusterState {
	return []ClusterState{ClusterStateAutoScale, ClusterStateBaselineUpgrade, ClusterStateDeploying, ClusterStateEnforcingClusterVersion, ClusterStateReady, ClusterStateUpdatingInfrastructure, ClusterStateUpdatingUserCertificate, ClusterStateUpdatingUserConfiguration, ClusterStateUpgradeServiceUnreachable, ClusterStateWaitingForNodes}
}

// ClusterUpgradeCadence enumerates the values for cluster upgrade cadence.
type ClusterUpgradeCadence string

const (
	// ClusterUpgradeCadenceWave0 Cluster upgrade starts immediately after a new version is rolled out.
	// Recommended for Test/Dev clusters.
	ClusterUpgradeCadenceWave0 ClusterUpgradeCadence = "Wave0"
	// ClusterUpgradeCadenceWave1 Cluster upgrade starts 7 days after a new version is rolled out. Recommended
	// for Pre-prod clusters.
	ClusterUpgradeCadenceWave1 ClusterUpgradeCadence = "Wave1"
	// ClusterUpgradeCadenceWave2 Cluster upgrade starts 14 days after a new version is rolled out. Recommended
	// for Production clusters.
	ClusterUpgradeCadenceWave2 ClusterUpgradeCadence = "Wave2"
)

// PossibleClusterUpgradeCadenceValues returns an array of possible values for the ClusterUpgradeCadence const type.
func PossibleClusterUpgradeCadenceValues() []ClusterUpgradeCadence {
	return []ClusterUpgradeCadence{ClusterUpgradeCadenceWave0, ClusterUpgradeCadenceWave1, ClusterUpgradeCadenceWave2}
}

// DurabilityLevel enumerates the values for durability level.
type DurabilityLevel string

const (
	// DurabilityLevelBronze ...
	DurabilityLevelBronze DurabilityLevel = "Bronze"
	// DurabilityLevelGold ...
	DurabilityLevelGold DurabilityLevel = "Gold"
	// DurabilityLevelSilver ...
	DurabilityLevelSilver DurabilityLevel = "Silver"
)

// PossibleDurabilityLevelValues returns an array of possible values for the DurabilityLevel const type.
func PossibleDurabilityLevelValues() []DurabilityLevel {
	return []DurabilityLevel{DurabilityLevelBronze, DurabilityLevelGold, DurabilityLevelSilver}
}

// Environment enumerates the values for environment.
type Environment string

const (
	// EnvironmentLinux ...
	EnvironmentLinux Environment = "Linux"
	// EnvironmentWindows ...
	EnvironmentWindows Environment = "Windows"
)

// PossibleEnvironmentValues returns an array of possible values for the Environment const type.
func PossibleEnvironmentValues() []Environment {
	return []Environment{EnvironmentLinux, EnvironmentWindows}
}

// ManagedIdentityType enumerates the values for managed identity type.
type ManagedIdentityType string

const (
	// ManagedIdentityTypeNone Indicates that no identity is associated with the resource.
	ManagedIdentityTypeNone ManagedIdentityType = "None"
	// ManagedIdentityTypeSystemAssigned Indicates that system assigned identity is associated with the
	// resource.
	ManagedIdentityTypeSystemAssigned ManagedIdentityType = "SystemAssigned"
	// ManagedIdentityTypeSystemAssignedUserAssigned Indicates that both system assigned and user assigned
	// identity are associated with the resource.
	ManagedIdentityTypeSystemAssignedUserAssigned ManagedIdentityType = "SystemAssigned, UserAssigned"
	// ManagedIdentityTypeUserAssigned Indicates that user assigned identity is associated with the resource.
	ManagedIdentityTypeUserAssigned ManagedIdentityType = "UserAssigned"
)

// PossibleManagedIdentityTypeValues returns an array of possible values for the ManagedIdentityType const type.
func PossibleManagedIdentityTypeValues() []ManagedIdentityType {
	return []ManagedIdentityType{ManagedIdentityTypeNone, ManagedIdentityTypeSystemAssigned, ManagedIdentityTypeSystemAssignedUserAssigned, ManagedIdentityTypeUserAssigned}
}

// MoveCost enumerates the values for move cost.
type MoveCost string

const (
	// MoveCostHigh Specifies the move cost of the service as High. The value is 3.
	MoveCostHigh MoveCost = "High"
	// MoveCostLow Specifies the move cost of the service as Low. The value is 1.
	MoveCostLow MoveCost = "Low"
	// MoveCostMedium Specifies the move cost of the service as Medium. The value is 2.
	MoveCostMedium MoveCost = "Medium"
	// MoveCostZero Zero move cost. This value is zero.
	MoveCostZero MoveCost = "Zero"
)

// PossibleMoveCostValues returns an array of possible values for the MoveCost const type.
func PossibleMoveCostValues() []MoveCost {
	return []MoveCost{MoveCostHigh, MoveCostLow, MoveCostMedium, MoveCostZero}
}

// NotificationChannel enumerates the values for notification channel.
type NotificationChannel string

const (
	// NotificationChannelEmailSubscription For subscription receivers. In this case, the parameter receivers
	// should be a list of roles of the subscription for the cluster (eg. Owner, AccountAdmin, etc) that will
	// receive the notifications.
	NotificationChannelEmailSubscription NotificationChannel = "EmailSubscription"
	// NotificationChannelEmailUser For email user receivers. In this case, the parameter receivers should be a
	// list of email addresses that will receive the notifications.
	NotificationChannelEmailUser NotificationChannel = "EmailUser"
)

// PossibleNotificationChannelValues returns an array of possible values for the NotificationChannel const type.
func PossibleNotificationChannelValues() []NotificationChannel {
	return []NotificationChannel{NotificationChannelEmailSubscription, NotificationChannelEmailUser}
}

// NotificationLevel enumerates the values for notification level.
type NotificationLevel string

const (
	// NotificationLevelAll Receive all notifications.
	NotificationLevelAll NotificationLevel = "All"
	// NotificationLevelCritical Receive only critical notifications.
	NotificationLevelCritical NotificationLevel = "Critical"
)

// PossibleNotificationLevelValues returns an array of possible values for the NotificationLevel const type.
func PossibleNotificationLevelValues() []NotificationLevel {
	return []NotificationLevel{NotificationLevelAll, NotificationLevelCritical}
}

// PartitionScheme enumerates the values for partition scheme.
type PartitionScheme string

const (
	// PartitionSchemeInvalid Indicates the partition kind is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	PartitionSchemeInvalid PartitionScheme = "Invalid"
	// PartitionSchemeNamed Indicates that the partition is based on string names, and is a
	// NamedPartitionSchemeDescription object. The value is 3
	PartitionSchemeNamed PartitionScheme = "Named"
	// PartitionSchemeSingleton Indicates that the partition is based on string names, and is a
	// SingletonPartitionSchemeDescription object, The value is 1.
	PartitionSchemeSingleton PartitionScheme = "Singleton"
	// PartitionSchemeUniformInt64Range Indicates that the partition is based on Int64 key ranges, and is a
	// UniformInt64RangePartitionSchemeDescription object. The value is 2.
	PartitionSchemeUniformInt64Range PartitionScheme = "UniformInt64Range"
)

// PossiblePartitionSchemeValues returns an array of possible values for the PartitionScheme const type.
func PossiblePartitionSchemeValues() []PartitionScheme {
	return []PartitionScheme{PartitionSchemeInvalid, PartitionSchemeNamed, PartitionSchemeSingleton, PartitionSchemeUniformInt64Range}
}

// PartitionSchemeBasicPartitionSchemeDescription enumerates the values for partition scheme basic partition
// scheme description.
type PartitionSchemeBasicPartitionSchemeDescription string

const (
	// PartitionSchemeBasicPartitionSchemeDescriptionPartitionSchemeNamed ...
	PartitionSchemeBasicPartitionSchemeDescriptionPartitionSchemeNamed PartitionSchemeBasicPartitionSchemeDescription = "Named"
	// PartitionSchemeBasicPartitionSchemeDescriptionPartitionSchemePartitionSchemeDescription ...
	PartitionSchemeBasicPartitionSchemeDescriptionPartitionSchemePartitionSchemeDescription PartitionSchemeBasicPartitionSchemeDescription = "PartitionSchemeDescription"
	// PartitionSchemeBasicPartitionSchemeDescriptionPartitionSchemeSingleton ...
	PartitionSchemeBasicPartitionSchemeDescriptionPartitionSchemeSingleton PartitionSchemeBasicPartitionSchemeDescription = "Singleton"
	// PartitionSchemeBasicPartitionSchemeDescriptionPartitionSchemeUniformInt64Range ...
	PartitionSchemeBasicPartitionSchemeDescriptionPartitionSchemeUniformInt64Range PartitionSchemeBasicPartitionSchemeDescription = "UniformInt64Range"
)

// PossiblePartitionSchemeBasicPartitionSchemeDescriptionValues returns an array of possible values for the PartitionSchemeBasicPartitionSchemeDescription const type.
func PossiblePartitionSchemeBasicPartitionSchemeDescriptionValues() []PartitionSchemeBasicPartitionSchemeDescription {
	return []PartitionSchemeBasicPartitionSchemeDescription{PartitionSchemeBasicPartitionSchemeDescriptionPartitionSchemeNamed, PartitionSchemeBasicPartitionSchemeDescriptionPartitionSchemePartitionSchemeDescription, PartitionSchemeBasicPartitionSchemeDescriptionPartitionSchemeSingleton, PartitionSchemeBasicPartitionSchemeDescriptionPartitionSchemeUniformInt64Range}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCanceled ...
	ProvisioningStateCanceled ProvisioningState = "Canceled"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	// ProvisioningStateUpdating ...
	ProvisioningStateUpdating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCanceled, ProvisioningStateFailed, ProvisioningStateSucceeded, ProvisioningStateUpdating}
}

// ReliabilityLevel enumerates the values for reliability level.
type ReliabilityLevel string

const (
	// ReliabilityLevelBronze ...
	ReliabilityLevelBronze ReliabilityLevel = "Bronze"
	// ReliabilityLevelGold ...
	ReliabilityLevelGold ReliabilityLevel = "Gold"
	// ReliabilityLevelNone ...
	ReliabilityLevelNone ReliabilityLevel = "None"
	// ReliabilityLevelPlatinum ...
	ReliabilityLevelPlatinum ReliabilityLevel = "Platinum"
	// ReliabilityLevelSilver ...
	ReliabilityLevelSilver ReliabilityLevel = "Silver"
)

// PossibleReliabilityLevelValues returns an array of possible values for the ReliabilityLevel const type.
func PossibleReliabilityLevelValues() []ReliabilityLevel {
	return []ReliabilityLevel{ReliabilityLevelBronze, ReliabilityLevelGold, ReliabilityLevelNone, ReliabilityLevelPlatinum, ReliabilityLevelSilver}
}

// ReliabilityLevel1 enumerates the values for reliability level 1.
type ReliabilityLevel1 string

const (
	// ReliabilityLevel1Bronze ...
	ReliabilityLevel1Bronze ReliabilityLevel1 = "Bronze"
	// ReliabilityLevel1Gold ...
	ReliabilityLevel1Gold ReliabilityLevel1 = "Gold"
	// ReliabilityLevel1None ...
	ReliabilityLevel1None ReliabilityLevel1 = "None"
	// ReliabilityLevel1Platinum ...
	ReliabilityLevel1Platinum ReliabilityLevel1 = "Platinum"
	// ReliabilityLevel1Silver ...
	ReliabilityLevel1Silver ReliabilityLevel1 = "Silver"
)

// PossibleReliabilityLevel1Values returns an array of possible values for the ReliabilityLevel1 const type.
func PossibleReliabilityLevel1Values() []ReliabilityLevel1 {
	return []ReliabilityLevel1{ReliabilityLevel1Bronze, ReliabilityLevel1Gold, ReliabilityLevel1None, ReliabilityLevel1Platinum, ReliabilityLevel1Silver}
}

// RollingUpgradeMode enumerates the values for rolling upgrade mode.
type RollingUpgradeMode string

const (
	// RollingUpgradeModeInvalid Indicates the upgrade mode is invalid. All Service Fabric enumerations have
	// the invalid type. The value is zero.
	RollingUpgradeModeInvalid RollingUpgradeMode = "Invalid"
	// RollingUpgradeModeMonitored The upgrade will stop after completing each upgrade domain and automatically
	// monitor health before proceeding. The value is 3
	RollingUpgradeModeMonitored RollingUpgradeMode = "Monitored"
	// RollingUpgradeModeUnmonitoredAuto The upgrade will proceed automatically without performing any health
	// monitoring. The value is 1
	RollingUpgradeModeUnmonitoredAuto RollingUpgradeMode = "UnmonitoredAuto"
	// RollingUpgradeModeUnmonitoredManual The upgrade will stop after completing each upgrade domain, giving
	// the opportunity to manually monitor health before proceeding. The value is 2
	RollingUpgradeModeUnmonitoredManual RollingUpgradeMode = "UnmonitoredManual"
)

// PossibleRollingUpgradeModeValues returns an array of possible values for the RollingUpgradeMode const type.
func PossibleRollingUpgradeModeValues() []RollingUpgradeMode {
	return []RollingUpgradeMode{RollingUpgradeModeInvalid, RollingUpgradeModeMonitored, RollingUpgradeModeUnmonitoredAuto, RollingUpgradeModeUnmonitoredManual}
}

// ServiceCorrelationScheme enumerates the values for service correlation scheme.
type ServiceCorrelationScheme string

const (
	// ServiceCorrelationSchemeAffinity Indicates that this service has an affinity relationship with another
	// service. Provided for backwards compatibility, consider preferring the Aligned or NonAlignedAffinity
	// options. The value is 1.
	ServiceCorrelationSchemeAffinity ServiceCorrelationScheme = "Affinity"
	// ServiceCorrelationSchemeAlignedAffinity Aligned affinity ensures that the primaries of the partitions of
	// the affinitized services are collocated on the same nodes. This is the default and is the same as
	// selecting the Affinity scheme. The value is 2.
	ServiceCorrelationSchemeAlignedAffinity ServiceCorrelationScheme = "AlignedAffinity"
	// ServiceCorrelationSchemeInvalid An invalid correlation scheme. Cannot be used. The value is zero.
	ServiceCorrelationSchemeInvalid ServiceCorrelationScheme = "Invalid"
	// ServiceCorrelationSchemeNonAlignedAffinity Non-Aligned affinity guarantees that all replicas of each
	// service will be placed on the same nodes. Unlike Aligned Affinity, this does not guarantee that replicas
	// of particular role will be collocated. The value is 3.
	ServiceCorrelationSchemeNonAlignedAffinity ServiceCorrelationScheme = "NonAlignedAffinity"
)

// PossibleServiceCorrelationSchemeValues returns an array of possible values for the ServiceCorrelationScheme const type.
func PossibleServiceCorrelationSchemeValues() []ServiceCorrelationScheme {
	return []ServiceCorrelationScheme{ServiceCorrelationSchemeAffinity, ServiceCorrelationSchemeAlignedAffinity, ServiceCorrelationSchemeInvalid, ServiceCorrelationSchemeNonAlignedAffinity}
}

// ServiceKind enumerates the values for service kind.
type ServiceKind string

const (
	// ServiceKindInvalid Indicates the service kind is invalid. All Service Fabric enumerations have the
	// invalid type. The value is zero.
	ServiceKindInvalid ServiceKind = "Invalid"
	// ServiceKindStateful Uses Service Fabric to make its state or part of its state highly available and
	// reliable. The value is 2.
	ServiceKindStateful ServiceKind = "Stateful"
	// ServiceKindStateless Does not use Service Fabric to make its state highly available or reliable. The
	// value is 1.
	ServiceKindStateless ServiceKind = "Stateless"
)

// PossibleServiceKindValues returns an array of possible values for the ServiceKind const type.
func PossibleServiceKindValues() []ServiceKind {
	return []ServiceKind{ServiceKindInvalid, ServiceKindStateful, ServiceKindStateless}
}

// ServiceKindBasicServiceResourceProperties enumerates the values for service kind basic service resource
// properties.
type ServiceKindBasicServiceResourceProperties string

const (
	// ServiceKindBasicServiceResourcePropertiesServiceKindServiceResourceProperties ...
	ServiceKindBasicServiceResourcePropertiesServiceKindServiceResourceProperties ServiceKindBasicServiceResourceProperties = "ServiceResourceProperties"
	// ServiceKindBasicServiceResourcePropertiesServiceKindStateful ...
	ServiceKindBasicServiceResourcePropertiesServiceKindStateful ServiceKindBasicServiceResourceProperties = "Stateful"
	// ServiceKindBasicServiceResourcePropertiesServiceKindStateless ...
	ServiceKindBasicServiceResourcePropertiesServiceKindStateless ServiceKindBasicServiceResourceProperties = "Stateless"
)

// PossibleServiceKindBasicServiceResourcePropertiesValues returns an array of possible values for the ServiceKindBasicServiceResourceProperties const type.
func PossibleServiceKindBasicServiceResourcePropertiesValues() []ServiceKindBasicServiceResourceProperties {
	return []ServiceKindBasicServiceResourceProperties{ServiceKindBasicServiceResourcePropertiesServiceKindServiceResourceProperties, ServiceKindBasicServiceResourcePropertiesServiceKindStateful, ServiceKindBasicServiceResourcePropertiesServiceKindStateless}
}

// ServiceKindBasicServiceResourceUpdateProperties enumerates the values for service kind basic service
// resource update properties.
type ServiceKindBasicServiceResourceUpdateProperties string

const (
	// ServiceKindBasicServiceResourceUpdatePropertiesServiceKindServiceResourceUpdateProperties ...
	ServiceKindBasicServiceResourceUpdatePropertiesServiceKindServiceResourceUpdateProperties ServiceKindBasicServiceResourceUpdateProperties = "ServiceResourceUpdateProperties"
	// ServiceKindBasicServiceResourceUpdatePropertiesServiceKindStateful ...
	ServiceKindBasicServiceResourceUpdatePropertiesServiceKindStateful ServiceKindBasicServiceResourceUpdateProperties = "Stateful"
	// ServiceKindBasicServiceResourceUpdatePropertiesServiceKindStateless ...
	ServiceKindBasicServiceResourceUpdatePropertiesServiceKindStateless ServiceKindBasicServiceResourceUpdateProperties = "Stateless"
)

// PossibleServiceKindBasicServiceResourceUpdatePropertiesValues returns an array of possible values for the ServiceKindBasicServiceResourceUpdateProperties const type.
func PossibleServiceKindBasicServiceResourceUpdatePropertiesValues() []ServiceKindBasicServiceResourceUpdateProperties {
	return []ServiceKindBasicServiceResourceUpdateProperties{ServiceKindBasicServiceResourceUpdatePropertiesServiceKindServiceResourceUpdateProperties, ServiceKindBasicServiceResourceUpdatePropertiesServiceKindStateful, ServiceKindBasicServiceResourceUpdatePropertiesServiceKindStateless}
}

// ServiceLoadMetricWeight enumerates the values for service load metric weight.
type ServiceLoadMetricWeight string

const (
	// ServiceLoadMetricWeightHigh Specifies the metric weight of the service load as High. The value is 3.
	ServiceLoadMetricWeightHigh ServiceLoadMetricWeight = "High"
	// ServiceLoadMetricWeightLow Specifies the metric weight of the service load as Low. The value is 1.
	ServiceLoadMetricWeightLow ServiceLoadMetricWeight = "Low"
	// ServiceLoadMetricWeightMedium Specifies the metric weight of the service load as Medium. The value is 2.
	ServiceLoadMetricWeightMedium ServiceLoadMetricWeight = "Medium"
	// ServiceLoadMetricWeightZero Disables resource balancing for this metric. This value is zero.
	ServiceLoadMetricWeightZero ServiceLoadMetricWeight = "Zero"
)

// PossibleServiceLoadMetricWeightValues returns an array of possible values for the ServiceLoadMetricWeight const type.
func PossibleServiceLoadMetricWeightValues() []ServiceLoadMetricWeight {
	return []ServiceLoadMetricWeight{ServiceLoadMetricWeightHigh, ServiceLoadMetricWeightLow, ServiceLoadMetricWeightMedium, ServiceLoadMetricWeightZero}
}

// ServicePlacementPolicyType enumerates the values for service placement policy type.
type ServicePlacementPolicyType string

const (
	// ServicePlacementPolicyTypeInvalid Indicates the type of the placement policy is invalid. All Service
	// Fabric enumerations have the invalid type. The value is zero.
	ServicePlacementPolicyTypeInvalid ServicePlacementPolicyType = "Invalid"
	// ServicePlacementPolicyTypeInvalidDomain Indicates that the ServicePlacementPolicyDescription is of type
	// ServicePlacementInvalidDomainPolicyDescription, which indicates that a particular fault or upgrade
	// domain cannot be used for placement of this service. The value is 1.
	ServicePlacementPolicyTypeInvalidDomain ServicePlacementPolicyType = "InvalidDomain"
	// ServicePlacementPolicyTypeNonPartiallyPlaceService Indicates that the ServicePlacementPolicyDescription
	// is of type ServicePlacementNonPartiallyPlaceServicePolicyDescription, which indicates that if possible
	// all replicas of a particular partition of the service should be placed atomically. The value is 5.
	ServicePlacementPolicyTypeNonPartiallyPlaceService ServicePlacementPolicyType = "NonPartiallyPlaceService"
	// ServicePlacementPolicyTypePreferredPrimaryDomain Indicates that the ServicePlacementPolicyDescription is
	// of type ServicePlacementPreferPrimaryDomainPolicyDescription, which indicates that if possible the
	// Primary replica for the partitions of the service should be located in a particular domain as an
	// optimization. The value is 3.
	ServicePlacementPolicyTypePreferredPrimaryDomain ServicePlacementPolicyType = "PreferredPrimaryDomain"
	// ServicePlacementPolicyTypeRequiredDomain Indicates that the ServicePlacementPolicyDescription is of type
	// ServicePlacementRequireDomainDistributionPolicyDescription indicating that the replicas of the service
	// must be placed in a specific domain. The value is 2.
	ServicePlacementPolicyTypeRequiredDomain ServicePlacementPolicyType = "RequiredDomain"
	// ServicePlacementPolicyTypeRequiredDomainDistribution Indicates that the
	// ServicePlacementPolicyDescription is of type ServicePlacementRequireDomainDistributionPolicyDescription,
	// indicating that the system will disallow placement of any two replicas from the same partition in the
	// same domain at any time. The value is 4.
	ServicePlacementPolicyTypeRequiredDomainDistribution ServicePlacementPolicyType = "RequiredDomainDistribution"
)

// PossibleServicePlacementPolicyTypeValues returns an array of possible values for the ServicePlacementPolicyType const type.
func PossibleServicePlacementPolicyTypeValues() []ServicePlacementPolicyType {
	return []ServicePlacementPolicyType{ServicePlacementPolicyTypeInvalid, ServicePlacementPolicyTypeInvalidDomain, ServicePlacementPolicyTypeNonPartiallyPlaceService, ServicePlacementPolicyTypePreferredPrimaryDomain, ServicePlacementPolicyTypeRequiredDomain, ServicePlacementPolicyTypeRequiredDomainDistribution}
}

// SfZonalUpgradeMode enumerates the values for sf zonal upgrade mode.
type SfZonalUpgradeMode string

const (
	// SfZonalUpgradeModeHierarchical If this value is omitted or set to Hierarchical, VMs are grouped to
	// reflect the zonal distribution in up to 15 UDs. Each of the three zones has five UDs. This ensures that
	// the zones are updated one at a time, moving to next zone only after completing five UDs within the first
	// zone. This update process is safer for the cluster and the user application.
	SfZonalUpgradeModeHierarchical SfZonalUpgradeMode = "Hierarchical"
	// SfZonalUpgradeModeParallel VMs under the node type are grouped into UDs and ignore the zone info in five
	// UDs. This setting causes UDs across all zones to be upgraded at the same time. This deployment mode is
	// faster for upgrades, we don't recommend it because it goes against the SDP guidelines, which state that
	// the updates should be applied to one zone at a time.
	SfZonalUpgradeModeParallel SfZonalUpgradeMode = "Parallel"
)

// PossibleSfZonalUpgradeModeValues returns an array of possible values for the SfZonalUpgradeMode const type.
func PossibleSfZonalUpgradeModeValues() []SfZonalUpgradeMode {
	return []SfZonalUpgradeMode{SfZonalUpgradeModeHierarchical, SfZonalUpgradeModeParallel}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeServicePlacementPolicyDescription ...
	TypeServicePlacementPolicyDescription Type = "ServicePlacementPolicyDescription"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeServicePlacementPolicyDescription}
}

// UpgradeMode enumerates the values for upgrade mode.
type UpgradeMode string

const (
	// UpgradeModeAutomatic The cluster will be automatically upgraded to the latest Service Fabric runtime
	// version, **upgradeWave** will determine when the upgrade starts after the new version becomes available.
	UpgradeModeAutomatic UpgradeMode = "Automatic"
	// UpgradeModeManual The cluster will not be automatically upgraded to the latest Service Fabric runtime
	// version. The cluster is upgraded by setting the **clusterCodeVersion** property in the cluster resource.
	UpgradeModeManual UpgradeMode = "Manual"
)

// PossibleUpgradeModeValues returns an array of possible values for the UpgradeMode const type.
func PossibleUpgradeModeValues() []UpgradeMode {
	return []UpgradeMode{UpgradeModeAutomatic, UpgradeModeManual}
}

// VmssZonalUpgradeMode enumerates the values for vmss zonal upgrade mode.
type VmssZonalUpgradeMode string

const (
	// VmssZonalUpgradeModeHierarchical VMs are grouped to reflect the zonal distribution in up to 15 UDs. Each
	// of the three zones has five UDs. This ensures that the zones are updated one at a time, moving to next
	// zone only after completing five UDs within the first zone.
	VmssZonalUpgradeModeHierarchical VmssZonalUpgradeMode = "Hierarchical"
	// VmssZonalUpgradeModeParallel Updates will happen in all Availability Zones at once for the virtual
	// machine scale sets.
	VmssZonalUpgradeModeParallel VmssZonalUpgradeMode = "Parallel"
)

// PossibleVmssZonalUpgradeModeValues returns an array of possible values for the VmssZonalUpgradeMode const type.
func PossibleVmssZonalUpgradeModeValues() []VmssZonalUpgradeMode {
	return []VmssZonalUpgradeMode{VmssZonalUpgradeModeHierarchical, VmssZonalUpgradeModeParallel}
}

// X509StoreName enumerates the values for x509 store name.
type X509StoreName string

const (
	// X509StoreNameAddressBook ...
	X509StoreNameAddressBook X509StoreName = "AddressBook"
	// X509StoreNameAuthRoot ...
	X509StoreNameAuthRoot X509StoreName = "AuthRoot"
	// X509StoreNameCertificateAuthority ...
	X509StoreNameCertificateAuthority X509StoreName = "CertificateAuthority"
	// X509StoreNameDisallowed ...
	X509StoreNameDisallowed X509StoreName = "Disallowed"
	// X509StoreNameMy ...
	X509StoreNameMy X509StoreName = "My"
	// X509StoreNameRoot ...
	X509StoreNameRoot X509StoreName = "Root"
	// X509StoreNameTrustedPeople ...
	X509StoreNameTrustedPeople X509StoreName = "TrustedPeople"
	// X509StoreNameTrustedPublisher ...
	X509StoreNameTrustedPublisher X509StoreName = "TrustedPublisher"
)

// PossibleX509StoreNameValues returns an array of possible values for the X509StoreName const type.
func PossibleX509StoreNameValues() []X509StoreName {
	return []X509StoreName{X509StoreNameAddressBook, X509StoreNameAuthRoot, X509StoreNameCertificateAuthority, X509StoreNameDisallowed, X509StoreNameMy, X509StoreNameRoot, X509StoreNameTrustedPeople, X509StoreNameTrustedPublisher}
}

// X509StoreName1 enumerates the values for x509 store name 1.
type X509StoreName1 string

const (
	// X509StoreName1AddressBook ...
	X509StoreName1AddressBook X509StoreName1 = "AddressBook"
	// X509StoreName1AuthRoot ...
	X509StoreName1AuthRoot X509StoreName1 = "AuthRoot"
	// X509StoreName1CertificateAuthority ...
	X509StoreName1CertificateAuthority X509StoreName1 = "CertificateAuthority"
	// X509StoreName1Disallowed ...
	X509StoreName1Disallowed X509StoreName1 = "Disallowed"
	// X509StoreName1My ...
	X509StoreName1My X509StoreName1 = "My"
	// X509StoreName1Root ...
	X509StoreName1Root X509StoreName1 = "Root"
	// X509StoreName1TrustedPeople ...
	X509StoreName1TrustedPeople X509StoreName1 = "TrustedPeople"
	// X509StoreName1TrustedPublisher ...
	X509StoreName1TrustedPublisher X509StoreName1 = "TrustedPublisher"
)

// PossibleX509StoreName1Values returns an array of possible values for the X509StoreName1 const type.
func PossibleX509StoreName1Values() []X509StoreName1 {
	return []X509StoreName1{X509StoreName1AddressBook, X509StoreName1AuthRoot, X509StoreName1CertificateAuthority, X509StoreName1Disallowed, X509StoreName1My, X509StoreName1Root, X509StoreName1TrustedPeople, X509StoreName1TrustedPublisher}
}
