// Code generated by protoc-gen-connect-go. DO NOT EDIT.
//
// Source: svc/ingest/v1/service.proto

package ingestv1connect

import (
	connect "connectrpc.com/connect"
	context "context"
	errors "errors"
	v1 "github.com/humanlogio/api/go/svc/ingest/v1"
	http "net/http"
	strings "strings"
)

// This is a compile-time assertion to ensure that this generated file and the connect package are
// compatible. If you get a compiler error that this constant is not defined, this code was
// generated with a version of connect newer than the one compiled into your binary. You can fix the
// problem by either regenerating this code with an older version of connect or updating the connect
// version compiled into your binary.
const _ = connect.IsAtLeastVersion1_13_0

const (
	// IngestServiceName is the fully-qualified name of the IngestService service.
	IngestServiceName = "svc.ingest.v1.IngestService"
)

// These constants are the fully-qualified names of the RPCs defined in this package. They're
// exposed at runtime as Spec.Procedure and as the final two segments of the HTTP route.
//
// Note that these are different from the fully-qualified method names used by
// google.golang.org/protobuf/reflect/protoreflect. To convert from these constants to
// reflection-formatted method names, remove the leading slash and convert the remaining slash to a
// period.
const (
	// IngestServiceGetHeartbeatProcedure is the fully-qualified name of the IngestService's
	// GetHeartbeat RPC.
	IngestServiceGetHeartbeatProcedure = "/svc.ingest.v1.IngestService/GetHeartbeat"
	// IngestServiceIngestProcedure is the fully-qualified name of the IngestService's Ingest RPC.
	IngestServiceIngestProcedure = "/svc.ingest.v1.IngestService/Ingest"
	// IngestServiceIngestStreamProcedure is the fully-qualified name of the IngestService's
	// IngestStream RPC.
	IngestServiceIngestStreamProcedure = "/svc.ingest.v1.IngestService/IngestStream"
	// IngestServiceIngestBidiStreamProcedure is the fully-qualified name of the IngestService's
	// IngestBidiStream RPC.
	IngestServiceIngestBidiStreamProcedure = "/svc.ingest.v1.IngestService/IngestBidiStream"
)

// IngestServiceClient is a client for the svc.ingest.v1.IngestService service.
type IngestServiceClient interface {
	GetHeartbeat(context.Context, *connect.Request[v1.GetHeartbeatRequest]) (*connect.Response[v1.GetHeartbeatResponse], error)
	Ingest(context.Context, *connect.Request[v1.IngestRequest]) (*connect.Response[v1.IngestResponse], error)
	IngestStream(context.Context) *connect.ClientStreamForClient[v1.IngestStreamRequest, v1.IngestStreamResponse]
	IngestBidiStream(context.Context) *connect.BidiStreamForClient[v1.IngestBidiStreamRequest, v1.IngestBidiStreamResponse]
}

// NewIngestServiceClient constructs a client for the svc.ingest.v1.IngestService service. By
// default, it uses the Connect protocol with the binary Protobuf Codec, asks for gzipped responses,
// and sends uncompressed requests. To use the gRPC or gRPC-Web protocols, supply the
// connect.WithGRPC() or connect.WithGRPCWeb() options.
//
// The URL supplied here should be the base URL for the Connect or gRPC server (for example,
// http://api.acme.com or https://acme.com/grpc).
func NewIngestServiceClient(httpClient connect.HTTPClient, baseURL string, opts ...connect.ClientOption) IngestServiceClient {
	baseURL = strings.TrimRight(baseURL, "/")
	ingestServiceMethods := v1.File_svc_ingest_v1_service_proto.Services().ByName("IngestService").Methods()
	return &ingestServiceClient{
		getHeartbeat: connect.NewClient[v1.GetHeartbeatRequest, v1.GetHeartbeatResponse](
			httpClient,
			baseURL+IngestServiceGetHeartbeatProcedure,
			connect.WithSchema(ingestServiceMethods.ByName("GetHeartbeat")),
			connect.WithClientOptions(opts...),
		),
		ingest: connect.NewClient[v1.IngestRequest, v1.IngestResponse](
			httpClient,
			baseURL+IngestServiceIngestProcedure,
			connect.WithSchema(ingestServiceMethods.ByName("Ingest")),
			connect.WithClientOptions(opts...),
		),
		ingestStream: connect.NewClient[v1.IngestStreamRequest, v1.IngestStreamResponse](
			httpClient,
			baseURL+IngestServiceIngestStreamProcedure,
			connect.WithSchema(ingestServiceMethods.ByName("IngestStream")),
			connect.WithClientOptions(opts...),
		),
		ingestBidiStream: connect.NewClient[v1.IngestBidiStreamRequest, v1.IngestBidiStreamResponse](
			httpClient,
			baseURL+IngestServiceIngestBidiStreamProcedure,
			connect.WithSchema(ingestServiceMethods.ByName("IngestBidiStream")),
			connect.WithClientOptions(opts...),
		),
	}
}

// ingestServiceClient implements IngestServiceClient.
type ingestServiceClient struct {
	getHeartbeat     *connect.Client[v1.GetHeartbeatRequest, v1.GetHeartbeatResponse]
	ingest           *connect.Client[v1.IngestRequest, v1.IngestResponse]
	ingestStream     *connect.Client[v1.IngestStreamRequest, v1.IngestStreamResponse]
	ingestBidiStream *connect.Client[v1.IngestBidiStreamRequest, v1.IngestBidiStreamResponse]
}

// GetHeartbeat calls svc.ingest.v1.IngestService.GetHeartbeat.
func (c *ingestServiceClient) GetHeartbeat(ctx context.Context, req *connect.Request[v1.GetHeartbeatRequest]) (*connect.Response[v1.GetHeartbeatResponse], error) {
	return c.getHeartbeat.CallUnary(ctx, req)
}

// Ingest calls svc.ingest.v1.IngestService.Ingest.
func (c *ingestServiceClient) Ingest(ctx context.Context, req *connect.Request[v1.IngestRequest]) (*connect.Response[v1.IngestResponse], error) {
	return c.ingest.CallUnary(ctx, req)
}

// IngestStream calls svc.ingest.v1.IngestService.IngestStream.
func (c *ingestServiceClient) IngestStream(ctx context.Context) *connect.ClientStreamForClient[v1.IngestStreamRequest, v1.IngestStreamResponse] {
	return c.ingestStream.CallClientStream(ctx)
}

// IngestBidiStream calls svc.ingest.v1.IngestService.IngestBidiStream.
func (c *ingestServiceClient) IngestBidiStream(ctx context.Context) *connect.BidiStreamForClient[v1.IngestBidiStreamRequest, v1.IngestBidiStreamResponse] {
	return c.ingestBidiStream.CallBidiStream(ctx)
}

// IngestServiceHandler is an implementation of the svc.ingest.v1.IngestService service.
type IngestServiceHandler interface {
	GetHeartbeat(context.Context, *connect.Request[v1.GetHeartbeatRequest]) (*connect.Response[v1.GetHeartbeatResponse], error)
	Ingest(context.Context, *connect.Request[v1.IngestRequest]) (*connect.Response[v1.IngestResponse], error)
	IngestStream(context.Context, *connect.ClientStream[v1.IngestStreamRequest]) (*connect.Response[v1.IngestStreamResponse], error)
	IngestBidiStream(context.Context, *connect.BidiStream[v1.IngestBidiStreamRequest, v1.IngestBidiStreamResponse]) error
}

// NewIngestServiceHandler builds an HTTP handler from the service implementation. It returns the
// path on which to mount the handler and the handler itself.
//
// By default, handlers support the Connect, gRPC, and gRPC-Web protocols with the binary Protobuf
// and JSON codecs. They also support gzip compression.
func NewIngestServiceHandler(svc IngestServiceHandler, opts ...connect.HandlerOption) (string, http.Handler) {
	ingestServiceMethods := v1.File_svc_ingest_v1_service_proto.Services().ByName("IngestService").Methods()
	ingestServiceGetHeartbeatHandler := connect.NewUnaryHandler(
		IngestServiceGetHeartbeatProcedure,
		svc.GetHeartbeat,
		connect.WithSchema(ingestServiceMethods.ByName("GetHeartbeat")),
		connect.WithHandlerOptions(opts...),
	)
	ingestServiceIngestHandler := connect.NewUnaryHandler(
		IngestServiceIngestProcedure,
		svc.Ingest,
		connect.WithSchema(ingestServiceMethods.ByName("Ingest")),
		connect.WithHandlerOptions(opts...),
	)
	ingestServiceIngestStreamHandler := connect.NewClientStreamHandler(
		IngestServiceIngestStreamProcedure,
		svc.IngestStream,
		connect.WithSchema(ingestServiceMethods.ByName("IngestStream")),
		connect.WithHandlerOptions(opts...),
	)
	ingestServiceIngestBidiStreamHandler := connect.NewBidiStreamHandler(
		IngestServiceIngestBidiStreamProcedure,
		svc.IngestBidiStream,
		connect.WithSchema(ingestServiceMethods.ByName("IngestBidiStream")),
		connect.WithHandlerOptions(opts...),
	)
	return "/svc.ingest.v1.IngestService/", http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		switch r.URL.Path {
		case IngestServiceGetHeartbeatProcedure:
			ingestServiceGetHeartbeatHandler.ServeHTTP(w, r)
		case IngestServiceIngestProcedure:
			ingestServiceIngestHandler.ServeHTTP(w, r)
		case IngestServiceIngestStreamProcedure:
			ingestServiceIngestStreamHandler.ServeHTTP(w, r)
		case IngestServiceIngestBidiStreamProcedure:
			ingestServiceIngestBidiStreamHandler.ServeHTTP(w, r)
		default:
			http.NotFound(w, r)
		}
	})
}

// UnimplementedIngestServiceHandler returns CodeUnimplemented from all methods.
type UnimplementedIngestServiceHandler struct{}

func (UnimplementedIngestServiceHandler) GetHeartbeat(context.Context, *connect.Request[v1.GetHeartbeatRequest]) (*connect.Response[v1.GetHeartbeatResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("svc.ingest.v1.IngestService.GetHeartbeat is not implemented"))
}

func (UnimplementedIngestServiceHandler) Ingest(context.Context, *connect.Request[v1.IngestRequest]) (*connect.Response[v1.IngestResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("svc.ingest.v1.IngestService.Ingest is not implemented"))
}

func (UnimplementedIngestServiceHandler) IngestStream(context.Context, *connect.ClientStream[v1.IngestStreamRequest]) (*connect.Response[v1.IngestStreamResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("svc.ingest.v1.IngestService.IngestStream is not implemented"))
}

func (UnimplementedIngestServiceHandler) IngestBidiStream(context.Context, *connect.BidiStream[v1.IngestBidiStreamRequest, v1.IngestBidiStreamResponse]) error {
	return connect.NewError(connect.CodeUnimplemented, errors.New("svc.ingest.v1.IngestService.IngestBidiStream is not implemented"))
}
