<?php

// This doc comment block generated by idl/sysdoc.php
/**
 * ( excerpt from
 * http://docs.hhvm.com/manual/en/class.sessionhandlerinterface.php )
 *
 * SessionHandlerInterface is an interface which defines a prototype for
 * creating a custom session handler. In order to pass a custom session
 * handler to session_set_save_handler() using its OOP invocation, the
 * class must implement this interface.
 *
 * Please note the callback methods of this class are designed to be
 * called internally by PHP and are not meant to be called from user-space
 * code.
 *
 */
interface SessionHandlerInterface {
  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from
   * http://docs.hhvm.com/manual/en/sessionhandlerinterface.close.php )
   *
   * Closes the current session. This function is automatically executed
   * when closing the session, or explicitly via session_write_close().
   *
   * @return     mixed   The return value (usually TRUE on success, FALSE on
   *                     failure). Note this value is returned internally to
   *                     PHP for processing.
   */
  public function close();
  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from
   * http://docs.hhvm.com/manual/en/sessionhandlerinterface.destroy.php )
   *
   * Destroys a session. Called by session_regenerate_id() (with $destroy =
   * TRUE), session_destroy() and when session_decode() fails.
   *
   * @session_id mixed   The session ID being destroyed.
   *
   * @return     mixed   The return value (usually TRUE on success, FALSE on
   *                     failure). Note this value is returned internally to
   *                     PHP for processing.
   */
  public function destroy($session_id);
  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://docs.hhvm.com/manual/en/sessionhandlerinterface.gc.php )
   *
   * Cleans up expired sessions. Called by session_start(), based on
   * session.gc_divisor, session.gc_probability and session.gc_lifetime
   * settings.
   *
   * @maxlifetime
   *             mixed   Sessions that have not updated for the last
   *                     maxlifetime seconds will be removed.
   *
   * @return     mixed   The return value (usually TRUE on success, FALSE on
   *                     failure). Note this value is returned internally to
   *                     PHP for processing.
   */
  public function gc($maxlifetime);
  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://docs.hhvm.com/manual/en/sessionhandlerinterface.open.php
   * )
   *
   * Re-initialize existing session, or creates a new one. Called when a
   * session starts or when session_start() is invoked.
   *
   * @save_path  mixed   The path where to store/retrieve the session.
   * @name       mixed   The session name.
   *
   * @return     mixed   The return value (usually TRUE on success, FALSE on
   *                     failure). Note this value is returned internally to
   *                     PHP for processing.
   */
  public function open($save_path, $name);
  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from http://docs.hhvm.com/manual/en/sessionhandlerinterface.read.php
   * )
   *
   * Reads the session data from the session storage, and returns the
   * results. Called right after the session starts or when session_start()
   * is called. Please note that before this method is called
   * SessionHandlerInterface::open() is invoked.
   *
   * This method is called by PHP itself when the session is started. This
   * method should retrieve the session data from storage by the session ID
   * provided. The returned by this method must be in the same
   * serialized format as when originally passed to the
   * SessionHandlerInterface::write() If the record was not found, return an
   * empty string.
   *
   * The data returned by this method will be decoded internally by PHP
   * using the unserialization method specified in session.serialize_handler.
   * The resultig data will be used to populate the $_SESSION superglobal.
   *
   * Note that the serialization scheme is not the same as unserialize() and
   * can be accessed by session_decode().
   *
   * @session_id mixed   The session id.
   *
   * @return     mixed   Returns an encoded of the read data. If
   *                     nothing was read, it must return an empty string.
   *                     Note this value is returned internally to PHP for
   *                     processing.
   */
  public function read($session_id);
  // This doc comment block generated by idl/sysdoc.php
  /**
   * ( excerpt from
   * http://docs.hhvm.com/manual/en/sessionhandlerinterface.write.php )
   *
   * Writes the session data to the session storage. Called by
   * session_write_close(), when session_register_shutdown() fails, or during
   * a normal shutdown. Note: SessionHandlerInterface::close() is called
   * immediately after this function.
   *
   * PHP will call this method when the session is ready to be saved and
   * closed. It encodes the session data from the $_SESSION superglobal to a
   * serialized and passes this along with the session ID to this
   * method for storage. The serialization method used is specified in the
   * session.serialize_handler setting.
   *
   * Note this method is normally called by PHP after the output buffers
   * have been closed unless explicitly called by session_write_close()
   *
   * @session_id mixed   The session id.
   * @session_data
   *             mixed   The encoded session data. This data is the result of
   *                     the PHP internally encoding the $_SESSION
   *                     superglobal to a serialized and passing it as
   *                     this parameter. Please note sessions use an
   *                     alternative serialization method.
   *
   * @return     mixed   The return value (usually TRUE on success, FALSE on
   *                     failure). Note this value is returned internally to
   *                     PHP for processing.
   */
  public function write($session_id, $session_data);
}

