/*
 * $RCSfile: Edge.java,v $
 *
 * Copyright (c) 2007 Sun Microsystems, Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistribution of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * - Redistribution in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in
 *   the documentation and/or other materials provided with the
 *   distribution.
 *
 * Neither the name of Sun Microsystems, Inc. or the names of
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * This software is provided "AS IS," without a warranty of any
 * kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
 * WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
 * EXCLUDED. SUN MICROSYSTEMS, INC. ("SUN") AND ITS LICENSORS SHALL
 * NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF
 * USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
 * DERIVATIVES. IN NO EVENT WILL SUN OR ITS LICENSORS BE LIABLE FOR
 * ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL,
 * CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND
 * REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR
 * INABILITY TO USE THIS SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * You acknowledge that this software is not designed, licensed or
 * intended for use in the design, construction, operation or
 * maintenance of any nuclear facility.
 *
 * $Revision: 1.4 $
 * $Date: 2007/02/09 17:20:18 $
 * $State: Exp $
 */

package com.sun.j3d.utils.geometry;

// Class created so that the two vertex indices that make up an
// edge can be hashed.
class Edge {

  public int v1;
  public int v2;
  private static final int HASHCONST = 0xEDCBA987;

  public int hashCode()
  {
    return ((v1 * HASHCONST) << 2) ^ (v2 * HASHCONST);
  } // end of Edge.hashCode

  public boolean equals(Object x)
  {
    if (!(x instanceof Edge)) return false;
    Edge e = (Edge)x;
    return (v1 == e.v1) && (v2 == e.v2);
  } // End of Edge.equals

  public String toString()
  {
    return "(" + v1 + ", " + v2 + ")";
  } // End of toString

  public Edge(int a, int b)
  {
    v1 = a;
    v2 = b;
  }

  public Edge(Edge e)
  {
    v1 = e.v1;
    v2 = e.v2;
  }

  public Edge()
  {
  }
} // end of class Edge

// End of file Edge.java
