# - Find INIPARSER
# Find the INIPARSER includes and libraries.
# This module defines:
#  INIPARSER_FOUND
#  INIPARSER_INCLUDE_DIRS
#  INIPARSER_LIBRARIES

find_package(PkgConfig QUIET)
pkg_check_modules(INIPARSER QUIET iniparser)

find_path(INIPARSER_INCLUDE_DIR
  NAMES iniparser.h
  PATHS ${INIPARSER_INCLUDE_DIRS}
  PATH_SUFFIXES iniparser
)

if((NOT INIPARSER_INCLUDE_DIRS) AND (INIPARSER_INCLUDE_DIR))
  set(INIPARSER_INCLUDE_DIRS ${INIPARSER_INCLUDE_DIR})
elseif(INIPARSER_INCLUDE_DIRS AND INIPARSER_INCLUDE_DIR)
  list(APPEND INIPARSER_INCLUDE_DIRS ${INIPARSER_INCLUDE_DIR})
endif()

find_library(INIPARSER_LIBRARY
  NAMES ${INIPARSER_LIBRARIES} iniparser
)

if((NOT INIPARSER_LIBRARIES) AND (INIPARSER_LIBRARY))
  set(INIPARSER_LIBRARIES ${INIPARSER_LIBRARY})
elseif(INIPARSER_LIBRARIES AND INIPARSER_LIBRARY)
  list(APPEND INIPARSER_LIBRARIES ${INIPARSER_LIBRARY})
endif()

message(VERBOSE "INIPARSER_INCLUDE_DIRS=${INIPARSER_INCLUDE_DIRS}")
message(VERBOSE "INIPARSER_INCLUDE_DIR=${INIPARSER_INCLUDE_DIR}")
message(VERBOSE "INIPARSER_LIBRARIES=${INIPARSER_LIBRARIES}")
message(VERBOSE "INIPARSER_LIBRARY=${INIPARSER_LIBRARY}")

if((NOT INIPARSER_FOUND) AND (INIPARSER_INCLUDE_DIRS) AND (INIPARSER_LIBRARIES))
  set(INIPARSER_FOUND True)
endif()

include(FindPackageHandleStandardArgs)

if(INIPARSER_FOUND)
  find_package_handle_standard_args(INIPARSER
    REQUIRED_VARS INIPARSER_FOUND INIPARSER_INCLUDE_DIRS INIPARSER_LIBRARIES
  )
else()
  find_package_handle_standard_args(INIPARSER
    REQUIRED_VARS INIPARSER_FOUND
  )
endif()

mark_as_advanced(INIPARSER_INCLUDE_DIR INIPARSER_LIBRARY)
