/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gjt.jclasslib.structures.CPInfo;
import org.gjt.jclasslib.structures.InvalidByteCodeException;

public class ConstantStringInfo
extends CPInfo {
    public static final int SIZE = 2;
    private int stringIndex;

    public byte getTag() {
        return 8;
    }

    public String getTagVerbose() {
        return "CONSTANT_String_info";
    }

    public String getVerbose() throws InvalidByteCodeException {
        return this.classFile.getConstantPoolEntryName(this.stringIndex);
    }

    public int getStringIndex() {
        return this.stringIndex;
    }

    public void setStringIndex(int n) {
        this.stringIndex = n;
    }

    public void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
        this.stringIndex = dataInput.readUnsignedShort();
        if (this.debug) {
            this.debug("read ");
        }
    }

    public void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        dataOutput.writeByte(8);
        dataOutput.writeShort(this.stringIndex);
        if (this.debug) {
            this.debug("wrote ");
        }
    }

    protected void debug(String string) {
        super.debug(string + this.getTagVerbose() + " with string_index " + this.stringIndex);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ConstantStringInfo)) {
            return false;
        }
        ConstantStringInfo constantStringInfo = (ConstantStringInfo)object;
        return super.equals(object) && constantStringInfo.stringIndex == this.stringIndex;
    }

    public int hashCode() {
        return super.hashCode() ^ this.stringIndex;
    }
}

