
/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__ARGUMENTCONTEXT_HPP)
#include <ArgumentContext.hpp>
#endif

using namespace corelinux;

// Default assertion

ArgumentContext::ArgumentContext( void )
   throw ( Assertion )
   : 
   ThreadContext()
{
   NEVER_GET_HERE;
}

// Reasonable constructor

ArgumentContext::ArgumentContext( ArgumentFunctionPtr aFunction, int arg )
   throw ( Assertion )
   :
   ThreadContext( CallerFunctionPtr(aFunction) ),
   theArgument( arg )
{
   ThreadContext::setFrameFunction( argumentFrame );
   ThreadContext::setContextFunctions
      ( 
         argumentContextCreate, 
         argumentContextDestroy 
      );
}

// Reasonable constructor with stack

ArgumentContext::ArgumentContext
   ( 
      ArgumentFunctionPtr aFunction, 
      Size  stackSize,
      int arg 
   )
   throw ( Assertion )
   :
   ThreadContext( CallerFunctionPtr(aFunction), stackSize ),
   theArgument( arg )
{
   ThreadContext::setFrameFunction( argumentFrame );
   ThreadContext::setContextFunctions
      ( 
         argumentContextCreate, 
         argumentContextDestroy 
      );
}

// Copy constructor

ArgumentContext::ArgumentContext( ArgumentContextCref aContext )
   throw ( Assertion )
   :
   ThreadContext( aContext ),
   theArgument( aContext.getArgument() )
{
   ;  // do nothing
}

// Destructor

ArgumentContext::~ArgumentContext( void )
{
   ;  // do nothing
}

// Assignment operator

ArgumentContextRef   ArgumentContext::operator=
   ( 
      ArgumentContextCref aContext 
   )
   throw ( Assertion )
{
   ThreadContext::operator==(aContext);
   setArgument( aContext.getArgument() );
   return ( *this );
}

// Equality operator

bool  ArgumentContext::operator==( ArgumentContextCref aContext ) const
{
   return ThreadContext::operator==(aContext);
}

// Get the argument

const int & ArgumentContext::getArgument( void ) const
{
   return theArgument;
}

ArgumentFunctionPtr  ArgumentContext::getArgumentFunction( void )
{
   return ArgumentFunctionPtr( ThreadContext::getCallerFunction() );
}

// Set the argument

void ArgumentContext::setArgument( const int &arg )
{
   theArgument = arg;
}

// Factory method redirect to insure we create a ArgumentContext object

ThreadContextPtr  ArgumentContext::argumentContextCreate
   ( 
      ThreadContextRef aContext 
   )
{
   ArgumentContextPtr   aArgumentPtr( NULLPTR );

   aArgumentPtr = new ArgumentContext
      ( 
         dynamic_cast<ArgumentContextRef>(aContext) 
      );

   return aArgumentPtr;
}

// Factory method redirect to insure we destroy a ArgumentContext object

void  ArgumentContext::argumentContextDestroy( ThreadContextPtr aContext )
{
   ArgumentContextPtr   myArg( NULLPTR );

   myArg = dynamic_cast<ArgumentContextPtr>(aContext);
   if( myArg != NULLPTR )
   {
      delete myArg;
   }
   else
   {
      ; // TBD
   }

}

// Our thread frame which allows us to call the single argument method

Int   ArgumentContext::argumentFrame( ThreadContextPtr aContext )
{
   ArgumentContextPtr   aArgumentContext
      ( 
         dynamic_cast<ArgumentContextPtr>(aContext) 
      );

   return (aArgumentContext->getArgumentFunction())(aArgumentContext->getArgument());
}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.4 $
   $Date: 2000/04/06 12:41:12 $
   $Locker:  $
*/

