/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.exml;

/**
 * Tags for matching regions;  these are all character arrays to assist
 * in the matching algorithm.
 */
interface XmlTags
{
	char [] ATTLIST_DECL_BEGIN  = "<!ATTLIST".toCharArray();
	char [] BAR                 = "|".toCharArray();
	char [] CDATA_BEGIN         = "<![CDATA[".toCharArray();
	char [] CDATA_END           = "]]>".toCharArray();
	char [] COMMA               = ",".toCharArray();
	char [] COMMENT_BEGIN       = "<!--".toCharArray();
	char [] COMMENT_DASH        = "--".toCharArray();
	char [] COMMENT_END         = "-->".toCharArray();
	char [] CONDITIONAL_BEGIN   = "<![".toCharArray();
	char [] CONTENTSPEC_ANY     = "ANY".toCharArray();
	char [] CONTENTSPEC_EMPTY   = "EMPTY".toCharArray();
	char [] DOCTYPE_BEGIN       = "<!DOCTYPE".toCharArray();
	char [] ELEMENT_DECL_BEGIN  = "<!ELEMENT".toCharArray();
	char [] ENCODING_BEGIN      = "encoding".toCharArray();
	char [] ENTITY_DECL_BEGIN   = "<!ENTITY".toCharArray();
	char [] ETAG_BEGIN          = "</".toCharArray();
	char [] FIXED_BEGIN         = "#FIXED".toCharArray();
	char [] IMPLIED_BEGIN       = "#IMPLIED".toCharArray();
	char [] NDATA_BEGIN         = "NDATA".toCharArray();
	char [] NOTATION_DECL_BEGIN = "<!NOTATION".toCharArray();
	char [] PAREN_BEGIN         = "(".toCharArray();
	char [] PAREN_END_STAR      = ")*".toCharArray();
	char [] PAREN_END           = ")".toCharArray();
	char [] PCDATA_TAG          = "#PCDATA".toCharArray();
	char [] PI_BEGIN            = "<?".toCharArray();
	char [] PI_END              = "?>".toCharArray();
	char [] PUBLIC_BEGIN        = "PUBLIC".toCharArray();
	char [] REQUIRED_BEGIN      = "#REQUIRED".toCharArray();
	char [] STANDALONE_BEGIN    = "standalone".toCharArray();
	char [] SYSTEM_BEGIN        = "SYSTEM".toCharArray();
	char [] VERSION_BEGIN       = "version".toCharArray();
	char [] XML_DECL            = "<?xml".toCharArray();
	String INCLUDE_BEGIN = "INCLUDE";
	String IGNORE_BEGIN  = "IGNORE";
	/** String type */
	String ST_CDATA  = "CDATA";
	/** Tokenized type */
	String TT_ID  = "ID";
	/** Tokenized type */
	String TT_IDREF  = "IDREF";
	/** Tokenized type */
	String TT_IDREFS = "IDREFS";
	/** Tokenized type */
	String TT_ENTITY = "ENTITY";
	/** Tokenized type */
	String TT_ENTITIES = "ENTITIES";
	/** Tokenized type */
	String TT_NMTOKEN = "NMTOKEN";
	/** Tokenized type */
	String TT_NMTOKENS = "NMTOKENS";
	/** Enumerated type */
	String ET_NOTATION = "NOTATION";

	/** XMLNS prefix or name */
	String XMLNS = "xmlns";

	/*
	 * Quick lookup to see if a character is a FirstNameChar.
	 * <pre>
	 * char c = 'f';
	 * if (c &lt; 127) return FIRST_NAME_CHAR[c];
	 * </pre>
	boolean FIRST_NAME_CHAR[] = {
		false,false,false,false,false,false,false,false,
		false,false,false,false,false,false,false,false,
		false,false,false,false,false,false,false,false,
		false,false,false,false,false,false,false,false,
		false,false,false,false,false,false,false,false,
		false,false,false,false,false,false,false,false,
		false,false,false,false,false,false,false,false,
		false,false,true ,false,false,false,false,false,
		false,true ,true ,true ,true ,true ,true ,true ,
		true ,true ,true ,true ,true ,true ,true ,true ,
		true ,true ,true ,true ,true ,true ,true ,true ,
		true ,true ,true ,false,false,false,false,true ,
		false,true ,true ,true ,true ,true ,true ,true ,
		true ,true ,true ,true ,true ,true ,true ,true ,
		true ,true ,true ,true ,true ,true ,true ,true ,
		true ,true ,true ,false,false,false,false,false};
	/*
	 * Quick lookup to see if a character is a NameChar.
	 * <pre>
	 * char c = '_';
	 * if (c &lt; 127) return NAME_CHAR[c];
	 * </pre>
	boolean NAME_CHAR[] = {
		false,false,false,false,false,false,false,false,
		false,false,false,false,false,false,false,false,
		false,false,false,false,false,false,false,false,
		false,false,false,false,false,false,false,false,
		false,false,false,false,false,false,false,false,
		false,false,false,false,false,true ,true ,false,
		true ,true ,true ,true ,true ,true ,true ,true ,
		true ,true ,true ,false,false,false,false,false,
		false,true ,true ,true ,true ,true ,true ,true ,
		true ,true ,true ,true ,true ,true ,true ,true ,
		true ,true ,true ,true ,true ,true ,true ,true ,
		true ,true ,true ,false,false,false,false,true ,
		false,true ,true ,true ,true ,true ,true ,true ,
		true ,true ,true ,true ,true ,true ,true ,true ,
		true ,true ,true ,true ,true ,true ,true ,true ,
		true ,true ,true ,false,false,false,false,false};
	 */
}
