/*
 * @(#)SingletonStoreUTest.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.util.classes.v1;

import org.easymock.EasyMock;
import org.easymock.MockControl;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;


/**
 * Tests the SingletonStore class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2003/02/10 22:52:39 $
 * @since     March 1, 2002
 */
public class SingletonStoreUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = SingletonStoreUTest.class;
    
    public SingletonStoreUTest( String name )
    {
        super( name );
    }

    
    //-------------------------------------------------------------------------
    // setup
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }


    //-------------------------------------------------------------------------
    // Tests
    
    
    public void testConstructor1()
    {
        new SingletonStore( null, null, null );
    }
    
    
    public void testConstructor2()
    {
        new SingletonStore( this.getClass(), null, null );
    }
    
    
    public void testConstructor3()
    {
        new SingletonStore( null, this.getClass(), null );
    }
    
    
    public void testConstructor4()
    {
        new SingletonStore( null, null, "a" );
    }
    
    
    public void testConstructor5()
    {
        new SingletonStore( this.getClass(), this.getClass(), null );
    }
    
    
    public void testConstructor6()
    {
        new SingletonStore( this.getClass(), null, "a" );
    }
    
    
    public void testConstructor7()
    {
        new SingletonStore( null, this.getClass(), "a" );
    }
    
    
    public void testConstructor8()
    {
        new SingletonStore( this.getClass(), this.getClass(), "a" );
    }
    
    
    public void testSetSingleton1()
    {
        SingletonStore ss = new SingletonStore( null, null, null );
        Object o = "a";
        ss.setSingleton( o );
        assertEquals(
            "did not return the same set singleton",
            o,
            ss.getSingleton() );
    }
    
    
    public void testSetSingleton2()
    {
        SingletonStore ss = new SingletonStore( String.class, null, null );
        Object o = "a";
        ss.setSingleton( o );
        assertEquals(
            "did not return the same set singleton",
            o,
            ss.getSingleton() );
    }
    
    
    public void testSetSingleton3()
    {
        SingletonStore ss = new SingletonStore( String.class, null, null );
        try
        {
            ss.setSingleton( null );
        }
        catch (IllegalArgumentException iae)
        {
            // test exception?
        }
    }
    
    
    public void testSetSingleton4()
    {
        SingletonStore ss = new SingletonStore( String.class, null, null );
        Object o = new Object();
        try
        {
            ss.setSingleton( o );
        }
        catch (IllegalArgumentException iae)
        {
            // test exception?
        }
    }
    
    
    public void testGetSingleton1()
    {
        SingletonStore ss = new SingletonStore( null, null, null );
        try
        {
            ss.getSingleton();
        }
        catch (IllegalArgumentException iae)
        {
            // test exception?
        }
    }
    
    
    public void testGetSingleton2()
    {
        // create a non-existent property name.
        String propertyName = "-";
        while (System.getProperty( propertyName ) != null)
        {
            propertyName += "-";
        }
        SingletonStore ss = new SingletonStore( null, null, propertyName );
        try
        {
            ss.getSingleton();
        }
        catch (IllegalArgumentException iae)
        {
            // test exception?
        }
    }
    
    
    public void testGetSingleton3()
    {
        // create a non-existent property name.
        String propertyName = "-";
        while (System.getProperty( propertyName ) != null)
        {
            propertyName += "-";
        }
        SingletonStore ss = new SingletonStore( null, Object.class, propertyName );
        Object o = ss.getSingleton();
        assertEquals(
            "Did not create a singleton of the correct type.",
            Object.class,
            o.getClass() );
    }
    
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite( THIS_CLASS );
        
        // Test the implementation's interface conformity.
        /*
        suite.addTest( IxUTestI.suite(
            new ImplementationCreator[] {
                new ImplementationCreator() {
                    public Object createImplementedObject() {
                        // XXXXXXXXXXXXXXXXXXXXXXXX
                    }
                },
            } ) );
        */
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

