"use strict";

var helpers = require("../../helpers/helpers");

exports["Pacific/Norfolk"] = {

	"guess:by:offset" : helpers.makeTestGuess("Pacific/Norfolk", { offset: true }),

	"guess:by:abbr" : helpers.makeTestGuess("Pacific/Norfolk", { abbr: true }),

	"1950" : helpers.makeTestYear("Pacific/Norfolk", [
		["1950-12-31T12:47:59+00:00", "23:59:59", "+1112", -672],
		["1950-12-31T12:48:00+00:00", "00:18:00", "+1130", -690]
	]),

	"1974" : helpers.makeTestYear("Pacific/Norfolk", [
		["1974-10-26T14:29:59+00:00", "01:59:59", "+1130", -690],
		["1974-10-26T14:30:00+00:00", "03:00:00", "+1230", -750]
	]),

	"1975" : helpers.makeTestYear("Pacific/Norfolk", [
		["1975-03-01T14:29:59+00:00", "02:59:59", "+1230", -750],
		["1975-03-01T14:30:00+00:00", "02:00:00", "+1130", -690]
	]),

	"2015" : helpers.makeTestYear("Pacific/Norfolk", [
		["2015-10-03T14:29:59+00:00", "01:59:59", "+1130", -690],
		["2015-10-03T14:30:00+00:00", "01:30:00", "+11", -660]
	]),

	"2019" : helpers.makeTestYear("Pacific/Norfolk", [
		["2019-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2019-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2020" : helpers.makeTestYear("Pacific/Norfolk", [
		["2020-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2020-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2020-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2020-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2021" : helpers.makeTestYear("Pacific/Norfolk", [
		["2021-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2021-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2021-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2021-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2022" : helpers.makeTestYear("Pacific/Norfolk", [
		["2022-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2022-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2022-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2022-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2023" : helpers.makeTestYear("Pacific/Norfolk", [
		["2023-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2023-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2023-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2023-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2024" : helpers.makeTestYear("Pacific/Norfolk", [
		["2024-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2024-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2024-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2024-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2025" : helpers.makeTestYear("Pacific/Norfolk", [
		["2025-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2025-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2025-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2025-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2026" : helpers.makeTestYear("Pacific/Norfolk", [
		["2026-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2026-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2026-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2026-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2027" : helpers.makeTestYear("Pacific/Norfolk", [
		["2027-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2027-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2027-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2027-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2028" : helpers.makeTestYear("Pacific/Norfolk", [
		["2028-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2028-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2028-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2028-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2029" : helpers.makeTestYear("Pacific/Norfolk", [
		["2029-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2029-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2029-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2029-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2030" : helpers.makeTestYear("Pacific/Norfolk", [
		["2030-04-06T14:59:59+00:00", "02:59:59", "+12", -720],
		["2030-04-06T15:00:00+00:00", "02:00:00", "+11", -660],
		["2030-10-05T14:59:59+00:00", "01:59:59", "+11", -660],
		["2030-10-05T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2031" : helpers.makeTestYear("Pacific/Norfolk", [
		["2031-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2031-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2031-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2031-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2032" : helpers.makeTestYear("Pacific/Norfolk", [
		["2032-04-03T14:59:59+00:00", "02:59:59", "+12", -720],
		["2032-04-03T15:00:00+00:00", "02:00:00", "+11", -660],
		["2032-10-02T14:59:59+00:00", "01:59:59", "+11", -660],
		["2032-10-02T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2033" : helpers.makeTestYear("Pacific/Norfolk", [
		["2033-04-02T14:59:59+00:00", "02:59:59", "+12", -720],
		["2033-04-02T15:00:00+00:00", "02:00:00", "+11", -660],
		["2033-10-01T14:59:59+00:00", "01:59:59", "+11", -660],
		["2033-10-01T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2034" : helpers.makeTestYear("Pacific/Norfolk", [
		["2034-04-01T14:59:59+00:00", "02:59:59", "+12", -720],
		["2034-04-01T15:00:00+00:00", "02:00:00", "+11", -660],
		["2034-09-30T14:59:59+00:00", "01:59:59", "+11", -660],
		["2034-09-30T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2035" : helpers.makeTestYear("Pacific/Norfolk", [
		["2035-03-31T14:59:59+00:00", "02:59:59", "+12", -720],
		["2035-03-31T15:00:00+00:00", "02:00:00", "+11", -660],
		["2035-10-06T14:59:59+00:00", "01:59:59", "+11", -660],
		["2035-10-06T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2036" : helpers.makeTestYear("Pacific/Norfolk", [
		["2036-04-05T14:59:59+00:00", "02:59:59", "+12", -720],
		["2036-04-05T15:00:00+00:00", "02:00:00", "+11", -660],
		["2036-10-04T14:59:59+00:00", "01:59:59", "+11", -660],
		["2036-10-04T15:00:00+00:00", "03:00:00", "+12", -720]
	]),

	"2037" : helpers.makeTestYear("Pacific/Norfolk", [
		["2037-04-04T14:59:59+00:00", "02:59:59", "+12", -720],
		["2037-04-04T15:00:00+00:00", "02:00:00", "+11", -660],
		["2037-10-03T14:59:59+00:00", "01:59:59", "+11", -660],
		["2037-10-03T15:00:00+00:00", "03:00:00", "+12", -720]
	])
};