"use strict";

var helpers = require("../../helpers/helpers");

exports["Atlantic/Bermuda"] = {

	"guess:by:offset" : helpers.makeTestGuess("Atlantic/Bermuda", { offset: true, expect: "America/Halifax" }),

	"guess:by:abbr" : helpers.makeTestGuess("Atlantic/Bermuda", { abbr: true, expect: "America/Halifax" }),

	"1890" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1890-01-01T04:19:18+00:00", "00:00:00", "BMT", 15558 / 60]
	]),

	"1917" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1917-04-06T04:19:17+00:00", "23:59:59", "BMT", 15558 / 60],
		["1917-04-06T04:19:18+00:00", "01:00:00", "BST", 11958 / 60],
		["1917-10-01T03:19:17+00:00", "23:59:59", "BST", 11958 / 60],
		["1917-10-01T03:19:18+00:00", "23:00:00", "BMT", 15558 / 60]
	]),

	"1918" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1918-04-14T04:19:17+00:00", "23:59:59", "BMT", 15558 / 60],
		["1918-04-14T04:19:18+00:00", "01:00:00", "BST", 11958 / 60],
		["1918-09-16T03:19:17+00:00", "23:59:59", "BST", 11958 / 60],
		["1918-09-16T03:19:18+00:00", "23:00:00", "BMT", 15558 / 60]
	]),

	"1930" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1930-01-01T06:19:17+00:00", "01:59:59", "BMT", 15558 / 60],
		["1930-01-01T06:19:18+00:00", "02:19:18", "AST", 240]
	]),

	"1942" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1942-01-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["1942-01-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1942-10-18T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1942-10-18T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1943" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1943-03-21T05:59:59+00:00", "01:59:59", "AST", 240],
		["1943-03-21T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1943-10-31T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1943-10-31T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1944" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1944-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["1944-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1944-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1944-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1945" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1945-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["1945-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1945-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1945-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1947" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1947-05-18T05:59:59+00:00", "01:59:59", "AST", 240],
		["1947-05-18T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1947-09-14T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1947-09-14T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1948" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1948-05-23T05:59:59+00:00", "01:59:59", "AST", 240],
		["1948-05-23T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1948-09-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1948-09-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1949" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1949-05-22T05:59:59+00:00", "01:59:59", "AST", 240],
		["1949-05-22T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1949-09-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1949-09-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1950" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1950-05-28T05:59:59+00:00", "01:59:59", "AST", 240],
		["1950-05-28T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1950-09-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1950-09-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1951" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1951-05-27T05:59:59+00:00", "01:59:59", "AST", 240],
		["1951-05-27T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1951-09-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1951-09-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1952" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1952-05-25T05:59:59+00:00", "01:59:59", "AST", 240],
		["1952-05-25T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1952-09-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1952-09-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1956" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1956-05-27T05:59:59+00:00", "01:59:59", "AST", 240],
		["1956-05-27T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1956-10-28T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1956-10-28T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1974" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1974-04-28T05:59:59+00:00", "01:59:59", "AST", 240],
		["1974-04-28T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1974-10-27T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1974-10-27T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1975" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1975-04-27T05:59:59+00:00", "01:59:59", "AST", 240],
		["1975-04-27T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1975-10-26T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1975-10-26T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1976" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1976-04-25T05:59:59+00:00", "01:59:59", "AST", 240],
		["1976-04-25T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1976-10-31T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1976-10-31T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1977" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1977-04-24T05:59:59+00:00", "01:59:59", "AST", 240],
		["1977-04-24T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1977-10-30T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1977-10-30T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1978" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1978-04-30T05:59:59+00:00", "01:59:59", "AST", 240],
		["1978-04-30T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1978-10-29T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1978-10-29T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1979" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1979-04-29T05:59:59+00:00", "01:59:59", "AST", 240],
		["1979-04-29T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1979-10-28T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1979-10-28T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1980" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1980-04-27T05:59:59+00:00", "01:59:59", "AST", 240],
		["1980-04-27T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1980-10-26T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1980-10-26T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1981" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1981-04-26T05:59:59+00:00", "01:59:59", "AST", 240],
		["1981-04-26T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1981-10-25T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1981-10-25T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1982" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1982-04-25T05:59:59+00:00", "01:59:59", "AST", 240],
		["1982-04-25T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1982-10-31T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1982-10-31T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1983" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1983-04-24T05:59:59+00:00", "01:59:59", "AST", 240],
		["1983-04-24T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1983-10-30T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1983-10-30T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1984" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1984-04-29T05:59:59+00:00", "01:59:59", "AST", 240],
		["1984-04-29T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1984-10-28T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1984-10-28T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1985" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1985-04-28T05:59:59+00:00", "01:59:59", "AST", 240],
		["1985-04-28T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1985-10-27T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1985-10-27T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1986" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1986-04-27T05:59:59+00:00", "01:59:59", "AST", 240],
		["1986-04-27T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1986-10-26T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1986-10-26T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1987" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1987-04-05T05:59:59+00:00", "01:59:59", "AST", 240],
		["1987-04-05T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1987-10-25T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1987-10-25T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1988" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1988-04-03T05:59:59+00:00", "01:59:59", "AST", 240],
		["1988-04-03T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1988-10-30T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1988-10-30T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1989" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1989-04-02T05:59:59+00:00", "01:59:59", "AST", 240],
		["1989-04-02T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1989-10-29T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1989-10-29T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1990" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1990-04-01T05:59:59+00:00", "01:59:59", "AST", 240],
		["1990-04-01T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1990-10-28T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1990-10-28T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1991" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1991-04-07T05:59:59+00:00", "01:59:59", "AST", 240],
		["1991-04-07T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1991-10-27T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1991-10-27T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1992" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1992-04-05T05:59:59+00:00", "01:59:59", "AST", 240],
		["1992-04-05T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1992-10-25T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1992-10-25T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1993" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1993-04-04T05:59:59+00:00", "01:59:59", "AST", 240],
		["1993-04-04T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1993-10-31T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1993-10-31T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1994" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1994-04-03T05:59:59+00:00", "01:59:59", "AST", 240],
		["1994-04-03T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1994-10-30T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1994-10-30T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1995" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1995-04-02T05:59:59+00:00", "01:59:59", "AST", 240],
		["1995-04-02T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1995-10-29T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1995-10-29T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1996" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1996-04-07T05:59:59+00:00", "01:59:59", "AST", 240],
		["1996-04-07T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1996-10-27T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1996-10-27T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1997" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1997-04-06T05:59:59+00:00", "01:59:59", "AST", 240],
		["1997-04-06T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1997-10-26T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1997-10-26T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1998" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1998-04-05T05:59:59+00:00", "01:59:59", "AST", 240],
		["1998-04-05T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1998-10-25T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1998-10-25T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1999" : helpers.makeTestYear("Atlantic/Bermuda", [
		["1999-04-04T05:59:59+00:00", "01:59:59", "AST", 240],
		["1999-04-04T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1999-10-31T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1999-10-31T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2000" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2000-04-02T05:59:59+00:00", "01:59:59", "AST", 240],
		["2000-04-02T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2000-10-29T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2000-10-29T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2001" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2001-04-01T05:59:59+00:00", "01:59:59", "AST", 240],
		["2001-04-01T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2001-10-28T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2001-10-28T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2002" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2002-04-07T05:59:59+00:00", "01:59:59", "AST", 240],
		["2002-04-07T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2002-10-27T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2002-10-27T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2003" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2003-04-06T05:59:59+00:00", "01:59:59", "AST", 240],
		["2003-04-06T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2003-10-26T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2003-10-26T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2004" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2004-04-04T05:59:59+00:00", "01:59:59", "AST", 240],
		["2004-04-04T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2004-10-31T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2004-10-31T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2005" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2005-04-03T05:59:59+00:00", "01:59:59", "AST", 240],
		["2005-04-03T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2005-10-30T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2005-10-30T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2006" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2006-04-02T05:59:59+00:00", "01:59:59", "AST", 240],
		["2006-04-02T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2006-10-29T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2006-10-29T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2007" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2007-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2007-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2007-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2007-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2008" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2008-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2008-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2008-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2008-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2009" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2009-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2009-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2009-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2009-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2010" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2010-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2010-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2010-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2010-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2011" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2011-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2011-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2011-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2011-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2012" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2012-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2012-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2012-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2012-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2013" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2013-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2013-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2013-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2013-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2014" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2014-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2014-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2014-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2014-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2015" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2015-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2015-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2015-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2015-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2016" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2016-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2016-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2016-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2016-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2017" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2017-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2017-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2017-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2017-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2018" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2018-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2018-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2018-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2018-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2019" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2019-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2019-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2019-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2019-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2020" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2020-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2020-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2020-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2020-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2021" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2021-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2021-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2021-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2021-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2022" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2022-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2022-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2022-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2022-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2023" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2023-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2023-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2023-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2023-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2024" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2024-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2024-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2024-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2024-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2025" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2025-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2025-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2025-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2025-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2026" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2026-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2026-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2026-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2026-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2027" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2027-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2027-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2027-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2027-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2028" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2028-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2028-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2028-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2028-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2029" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2029-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2029-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2029-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2029-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2030" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2030-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2030-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2030-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2030-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2031" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2031-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2031-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2031-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2031-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2032" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2032-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2032-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2032-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2032-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2033" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2033-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2033-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2033-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2033-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2034" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2034-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2034-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2034-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2034-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2035" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2035-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2035-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2035-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2035-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2036" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2036-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2036-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2036-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2036-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2037" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2037-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2037-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2037-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2037-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2038" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2038-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2038-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2038-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2038-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2039" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2039-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2039-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2039-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2039-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2040" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2040-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2040-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2040-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2040-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2041" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2041-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2041-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2041-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2041-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2042" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2042-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2042-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2042-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2042-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2043" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2043-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2043-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2043-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2043-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2044" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2044-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2044-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2044-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2044-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2045" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2045-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2045-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2045-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2045-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2046" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2046-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2046-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2046-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2046-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2047" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2047-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2047-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2047-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2047-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2048" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2048-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2048-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2048-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2048-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2049" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2049-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2049-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2049-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2049-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2050" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2050-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2050-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2050-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2050-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2051" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2051-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2051-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2051-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2051-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2052" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2052-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2052-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2052-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2052-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2053" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2053-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2053-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2053-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2053-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2054" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2054-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2054-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2054-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2054-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2055" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2055-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2055-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2055-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2055-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2056" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2056-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2056-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2056-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2056-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2057" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2057-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2057-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2057-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2057-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2058" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2058-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2058-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2058-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2058-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2059" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2059-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2059-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2059-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2059-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2060" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2060-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2060-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2060-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2060-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2061" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2061-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2061-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2061-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2061-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2062" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2062-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2062-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2062-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2062-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2063" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2063-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2063-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2063-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2063-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2064" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2064-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2064-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2064-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2064-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2065" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2065-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2065-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2065-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2065-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2066" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2066-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2066-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2066-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2066-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2067" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2067-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2067-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2067-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2067-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2068" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2068-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2068-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2068-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2068-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2069" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2069-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2069-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2069-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2069-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2070" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2070-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2070-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2070-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2070-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2071" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2071-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2071-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2071-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2071-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2072" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2072-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2072-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2072-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2072-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2073" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2073-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2073-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2073-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2073-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2074" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2074-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2074-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2074-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2074-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2075" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2075-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2075-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2075-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2075-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2076" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2076-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2076-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2076-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2076-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2077" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2077-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2077-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2077-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2077-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2078" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2078-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2078-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2078-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2078-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2079" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2079-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2079-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2079-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2079-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2080" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2080-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2080-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2080-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2080-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2081" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2081-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2081-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2081-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2081-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2082" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2082-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2082-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2082-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2082-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2083" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2083-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2083-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2083-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2083-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2084" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2084-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2084-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2084-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2084-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2085" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2085-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2085-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2085-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2085-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2086" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2086-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2086-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2086-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2086-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2087" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2087-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2087-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2087-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2087-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2088" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2088-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2088-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2088-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2088-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2089" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2089-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2089-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2089-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2089-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2090" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2090-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2090-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2090-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2090-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2091" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2091-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2091-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2091-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2091-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2092" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2092-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2092-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2092-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2092-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2093" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2093-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2093-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2093-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2093-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2094" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2094-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2094-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2094-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2094-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2095" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2095-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2095-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2095-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2095-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2096" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2096-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2096-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2096-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2096-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2097" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2097-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2097-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2097-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2097-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2098" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2098-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2098-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2098-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2098-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2099" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2099-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2099-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2099-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2099-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2100" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2100-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2100-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2100-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2100-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2101" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2101-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2101-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2101-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2101-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2102" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2102-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2102-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2102-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2102-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2103" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2103-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2103-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2103-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2103-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2104" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2104-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2104-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2104-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2104-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2105" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2105-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2105-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2105-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2105-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2106" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2106-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2106-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2106-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2106-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2107" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2107-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2107-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2107-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2107-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2108" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2108-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2108-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2108-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2108-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2109" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2109-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2109-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2109-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2109-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2110" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2110-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2110-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2110-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2110-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2111" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2111-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2111-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2111-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2111-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2112" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2112-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2112-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2112-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2112-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2113" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2113-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2113-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2113-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2113-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2114" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2114-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2114-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2114-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2114-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2115" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2115-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2115-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2115-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2115-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2116" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2116-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2116-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2116-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2116-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2117" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2117-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2117-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2117-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2117-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2118" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2118-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2118-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2118-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2118-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2119" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2119-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2119-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2119-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2119-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2120" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2120-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2120-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2120-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2120-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2121" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2121-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2121-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2121-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2121-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2122" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2122-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2122-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2122-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2122-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2123" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2123-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2123-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2123-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2123-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2124" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2124-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2124-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2124-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2124-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2125" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2125-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2125-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2125-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2125-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2126" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2126-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2126-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2126-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2126-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2127" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2127-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2127-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2127-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2127-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2128" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2128-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2128-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2128-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2128-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2129" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2129-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2129-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2129-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2129-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2130" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2130-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2130-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2130-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2130-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2131" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2131-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2131-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2131-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2131-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2132" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2132-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2132-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2132-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2132-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2133" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2133-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2133-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2133-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2133-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2134" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2134-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2134-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2134-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2134-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2135" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2135-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2135-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2135-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2135-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2136" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2136-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2136-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2136-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2136-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2137" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2137-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2137-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2137-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2137-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2138" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2138-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2138-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2138-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2138-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2139" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2139-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2139-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2139-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2139-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2140" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2140-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2140-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2140-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2140-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2141" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2141-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2141-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2141-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2141-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2142" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2142-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2142-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2142-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2142-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2143" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2143-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2143-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2143-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2143-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2144" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2144-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2144-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2144-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2144-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2145" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2145-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2145-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2145-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2145-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2146" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2146-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2146-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2146-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2146-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2147" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2147-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2147-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2147-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2147-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2148" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2148-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2148-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2148-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2148-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2149" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2149-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2149-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2149-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2149-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2150" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2150-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2150-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2150-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2150-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2151" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2151-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2151-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2151-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2151-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2152" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2152-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2152-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2152-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2152-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2153" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2153-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2153-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2153-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2153-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2154" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2154-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2154-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2154-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2154-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2155" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2155-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2155-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2155-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2155-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2156" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2156-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2156-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2156-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2156-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2157" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2157-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2157-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2157-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2157-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2158" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2158-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2158-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2158-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2158-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2159" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2159-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2159-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2159-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2159-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2160" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2160-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2160-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2160-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2160-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2161" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2161-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2161-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2161-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2161-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2162" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2162-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2162-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2162-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2162-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2163" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2163-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2163-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2163-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2163-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2164" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2164-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2164-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2164-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2164-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2165" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2165-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2165-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2165-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2165-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2166" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2166-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2166-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2166-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2166-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2167" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2167-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2167-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2167-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2167-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2168" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2168-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2168-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2168-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2168-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2169" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2169-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2169-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2169-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2169-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2170" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2170-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2170-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2170-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2170-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2171" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2171-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2171-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2171-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2171-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2172" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2172-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2172-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2172-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2172-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2173" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2173-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2173-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2173-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2173-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2174" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2174-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2174-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2174-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2174-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2175" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2175-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2175-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2175-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2175-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2176" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2176-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2176-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2176-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2176-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2177" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2177-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2177-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2177-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2177-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2178" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2178-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2178-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2178-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2178-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2179" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2179-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2179-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2179-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2179-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2180" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2180-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2180-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2180-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2180-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2181" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2181-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2181-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2181-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2181-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2182" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2182-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2182-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2182-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2182-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2183" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2183-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2183-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2183-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2183-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2184" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2184-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2184-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2184-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2184-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2185" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2185-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2185-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2185-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2185-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2186" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2186-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2186-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2186-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2186-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2187" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2187-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2187-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2187-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2187-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2188" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2188-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2188-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2188-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2188-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2189" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2189-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2189-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2189-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2189-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2190" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2190-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2190-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2190-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2190-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2191" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2191-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2191-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2191-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2191-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2192" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2192-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2192-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2192-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2192-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2193" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2193-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2193-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2193-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2193-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2194" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2194-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2194-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2194-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2194-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2195" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2195-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2195-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2195-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2195-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2196" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2196-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2196-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2196-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2196-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2197" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2197-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2197-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2197-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2197-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2198" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2198-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2198-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2198-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2198-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2199" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2199-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2199-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2199-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2199-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2200" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2200-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2200-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2200-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2200-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2201" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2201-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2201-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2201-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2201-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2202" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2202-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2202-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2202-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2202-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2203" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2203-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2203-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2203-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2203-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2204" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2204-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2204-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2204-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2204-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2205" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2205-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2205-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2205-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2205-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2206" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2206-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2206-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2206-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2206-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2207" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2207-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2207-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2207-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2207-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2208" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2208-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2208-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2208-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2208-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2209" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2209-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2209-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2209-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2209-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2210" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2210-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2210-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2210-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2210-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2211" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2211-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2211-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2211-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2211-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2212" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2212-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2212-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2212-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2212-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2213" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2213-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2213-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2213-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2213-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2214" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2214-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2214-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2214-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2214-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2215" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2215-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2215-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2215-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2215-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2216" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2216-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2216-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2216-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2216-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2217" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2217-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2217-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2217-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2217-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2218" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2218-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2218-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2218-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2218-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2219" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2219-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2219-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2219-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2219-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2220" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2220-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2220-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2220-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2220-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2221" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2221-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2221-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2221-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2221-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2222" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2222-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2222-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2222-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2222-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2223" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2223-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2223-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2223-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2223-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2224" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2224-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2224-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2224-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2224-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2225" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2225-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2225-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2225-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2225-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2226" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2226-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2226-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2226-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2226-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2227" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2227-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2227-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2227-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2227-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2228" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2228-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2228-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2228-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2228-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2229" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2229-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2229-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2229-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2229-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2230" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2230-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2230-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2230-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2230-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2231" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2231-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2231-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2231-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2231-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2232" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2232-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2232-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2232-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2232-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2233" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2233-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2233-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2233-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2233-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2234" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2234-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2234-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2234-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2234-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2235" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2235-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2235-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2235-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2235-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2236" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2236-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2236-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2236-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2236-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2237" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2237-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2237-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2237-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2237-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2238" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2238-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2238-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2238-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2238-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2239" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2239-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2239-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2239-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2239-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2240" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2240-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2240-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2240-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2240-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2241" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2241-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2241-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2241-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2241-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2242" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2242-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2242-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2242-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2242-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2243" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2243-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2243-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2243-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2243-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2244" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2244-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2244-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2244-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2244-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2245" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2245-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2245-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2245-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2245-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2246" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2246-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2246-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2246-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2246-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2247" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2247-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2247-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2247-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2247-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2248" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2248-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2248-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2248-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2248-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2249" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2249-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2249-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2249-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2249-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2250" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2250-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2250-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2250-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2250-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2251" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2251-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2251-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2251-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2251-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2252" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2252-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2252-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2252-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2252-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2253" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2253-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2253-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2253-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2253-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2254" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2254-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2254-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2254-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2254-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2255" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2255-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2255-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2255-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2255-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2256" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2256-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2256-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2256-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2256-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2257" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2257-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2257-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2257-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2257-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2258" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2258-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2258-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2258-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2258-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2259" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2259-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2259-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2259-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2259-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2260" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2260-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2260-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2260-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2260-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2261" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2261-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2261-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2261-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2261-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2262" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2262-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2262-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2262-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2262-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2263" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2263-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2263-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2263-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2263-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2264" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2264-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2264-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2264-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2264-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2265" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2265-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2265-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2265-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2265-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2266" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2266-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2266-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2266-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2266-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2267" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2267-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2267-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2267-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2267-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2268" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2268-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2268-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2268-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2268-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2269" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2269-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2269-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2269-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2269-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2270" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2270-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2270-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2270-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2270-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2271" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2271-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2271-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2271-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2271-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2272" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2272-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2272-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2272-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2272-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2273" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2273-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2273-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2273-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2273-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2274" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2274-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2274-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2274-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2274-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2275" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2275-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2275-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2275-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2275-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2276" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2276-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2276-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2276-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2276-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2277" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2277-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2277-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2277-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2277-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2278" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2278-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2278-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2278-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2278-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2279" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2279-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2279-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2279-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2279-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2280" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2280-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2280-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2280-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2280-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2281" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2281-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2281-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2281-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2281-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2282" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2282-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2282-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2282-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2282-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2283" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2283-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2283-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2283-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2283-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2284" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2284-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2284-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2284-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2284-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2285" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2285-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2285-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2285-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2285-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2286" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2286-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2286-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2286-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2286-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2287" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2287-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2287-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2287-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2287-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2288" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2288-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2288-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2288-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2288-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2289" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2289-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2289-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2289-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2289-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2290" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2290-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2290-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2290-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2290-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2291" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2291-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2291-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2291-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2291-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2292" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2292-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2292-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2292-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2292-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2293" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2293-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2293-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2293-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2293-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2294" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2294-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2294-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2294-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2294-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2295" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2295-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2295-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2295-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2295-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2296" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2296-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2296-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2296-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2296-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2297" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2297-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2297-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2297-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2297-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2298" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2298-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2298-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2298-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2298-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2299" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2299-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2299-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2299-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2299-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2300" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2300-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2300-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2300-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2300-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2301" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2301-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2301-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2301-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2301-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2302" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2302-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2302-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2302-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2302-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2303" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2303-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2303-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2303-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2303-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2304" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2304-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2304-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2304-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2304-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2305" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2305-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2305-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2305-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2305-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2306" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2306-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2306-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2306-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2306-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2307" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2307-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2307-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2307-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2307-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2308" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2308-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2308-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2308-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2308-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2309" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2309-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2309-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2309-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2309-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2310" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2310-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2310-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2310-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2310-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2311" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2311-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2311-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2311-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2311-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2312" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2312-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2312-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2312-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2312-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2313" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2313-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2313-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2313-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2313-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2314" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2314-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2314-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2314-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2314-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2315" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2315-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2315-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2315-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2315-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2316" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2316-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2316-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2316-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2316-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2317" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2317-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2317-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2317-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2317-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2318" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2318-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2318-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2318-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2318-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2319" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2319-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2319-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2319-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2319-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2320" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2320-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2320-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2320-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2320-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2321" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2321-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2321-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2321-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2321-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2322" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2322-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2322-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2322-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2322-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2323" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2323-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2323-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2323-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2323-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2324" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2324-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2324-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2324-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2324-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2325" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2325-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2325-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2325-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2325-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2326" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2326-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2326-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2326-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2326-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2327" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2327-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2327-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2327-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2327-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2328" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2328-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2328-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2328-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2328-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2329" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2329-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2329-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2329-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2329-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2330" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2330-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2330-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2330-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2330-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2331" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2331-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2331-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2331-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2331-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2332" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2332-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2332-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2332-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2332-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2333" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2333-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2333-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2333-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2333-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2334" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2334-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2334-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2334-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2334-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2335" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2335-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2335-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2335-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2335-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2336" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2336-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2336-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2336-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2336-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2337" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2337-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2337-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2337-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2337-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2338" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2338-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2338-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2338-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2338-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2339" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2339-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2339-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2339-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2339-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2340" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2340-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2340-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2340-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2340-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2341" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2341-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2341-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2341-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2341-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2342" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2342-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2342-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2342-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2342-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2343" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2343-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2343-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2343-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2343-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2344" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2344-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2344-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2344-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2344-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2345" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2345-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2345-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2345-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2345-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2346" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2346-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2346-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2346-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2346-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2347" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2347-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2347-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2347-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2347-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2348" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2348-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2348-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2348-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2348-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2349" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2349-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2349-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2349-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2349-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2350" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2350-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2350-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2350-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2350-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2351" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2351-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2351-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2351-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2351-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2352" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2352-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2352-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2352-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2352-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2353" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2353-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2353-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2353-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2353-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2354" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2354-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2354-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2354-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2354-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2355" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2355-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2355-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2355-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2355-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2356" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2356-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2356-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2356-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2356-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2357" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2357-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2357-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2357-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2357-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2358" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2358-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2358-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2358-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2358-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2359" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2359-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2359-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2359-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2359-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2360" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2360-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2360-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2360-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2360-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2361" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2361-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2361-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2361-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2361-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2362" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2362-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2362-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2362-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2362-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2363" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2363-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2363-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2363-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2363-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2364" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2364-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2364-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2364-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2364-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2365" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2365-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2365-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2365-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2365-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2366" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2366-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2366-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2366-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2366-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2367" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2367-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2367-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2367-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2367-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2368" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2368-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2368-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2368-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2368-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2369" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2369-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2369-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2369-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2369-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2370" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2370-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2370-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2370-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2370-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2371" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2371-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2371-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2371-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2371-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2372" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2372-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2372-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2372-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2372-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2373" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2373-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2373-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2373-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2373-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2374" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2374-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2374-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2374-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2374-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2375" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2375-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2375-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2375-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2375-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2376" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2376-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2376-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2376-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2376-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2377" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2377-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2377-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2377-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2377-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2378" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2378-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2378-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2378-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2378-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2379" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2379-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2379-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2379-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2379-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2380" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2380-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2380-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2380-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2380-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2381" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2381-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2381-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2381-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2381-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2382" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2382-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2382-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2382-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2382-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2383" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2383-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2383-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2383-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2383-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2384" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2384-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2384-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2384-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2384-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2385" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2385-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2385-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2385-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2385-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2386" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2386-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2386-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2386-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2386-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2387" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2387-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2387-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2387-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2387-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2388" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2388-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2388-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2388-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2388-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2389" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2389-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2389-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2389-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2389-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2390" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2390-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2390-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2390-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2390-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2391" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2391-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2391-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2391-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2391-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2392" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2392-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2392-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2392-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2392-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2393" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2393-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2393-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2393-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2393-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2394" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2394-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2394-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2394-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2394-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2395" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2395-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2395-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2395-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2395-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2396" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2396-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2396-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2396-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2396-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2397" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2397-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2397-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2397-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2397-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2398" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2398-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2398-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2398-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2398-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2399" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2399-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2399-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2399-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2399-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2400" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2400-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2400-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2400-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2400-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2401" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2401-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2401-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2401-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2401-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2402" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2402-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2402-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2402-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2402-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2403" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2403-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2403-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2403-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2403-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2404" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2404-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2404-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2404-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2404-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2405" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2405-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2405-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2405-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2405-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2406" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2406-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2406-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2406-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2406-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2407" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2407-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2407-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2407-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2407-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2408" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2408-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2408-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2408-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2408-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2409" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2409-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2409-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2409-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2409-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2410" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2410-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2410-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2410-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2410-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2411" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2411-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2411-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2411-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2411-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2412" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2412-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2412-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2412-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2412-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2413" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2413-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2413-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2413-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2413-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2414" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2414-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2414-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2414-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2414-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2415" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2415-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2415-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2415-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2415-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2416" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2416-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2416-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2416-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2416-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2417" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2417-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2417-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2417-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2417-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2418" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2418-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2418-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2418-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2418-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2419" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2419-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2419-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2419-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2419-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2420" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2420-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2420-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2420-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2420-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2421" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2421-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2421-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2421-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2421-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2422" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2422-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2422-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2422-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2422-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2423" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2423-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2423-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2423-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2423-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2424" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2424-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2424-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2424-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2424-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2425" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2425-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2425-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2425-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2425-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2426" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2426-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2426-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2426-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2426-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2427" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2427-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2427-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2427-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2427-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2428" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2428-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2428-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2428-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2428-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2429" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2429-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2429-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2429-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2429-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2430" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2430-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2430-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2430-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2430-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2431" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2431-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2431-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2431-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2431-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2432" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2432-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2432-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2432-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2432-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2433" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2433-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2433-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2433-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2433-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2434" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2434-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2434-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2434-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2434-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2435" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2435-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2435-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2435-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2435-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2436" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2436-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2436-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2436-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2436-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2437" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2437-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2437-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2437-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2437-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2438" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2438-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2438-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2438-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2438-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2439" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2439-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2439-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2439-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2439-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2440" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2440-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2440-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2440-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2440-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2441" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2441-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2441-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2441-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2441-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2442" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2442-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2442-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2442-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2442-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2443" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2443-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2443-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2443-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2443-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2444" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2444-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2444-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2444-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2444-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2445" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2445-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2445-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2445-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2445-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2446" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2446-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2446-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2446-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2446-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2447" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2447-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2447-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2447-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2447-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2448" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2448-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2448-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2448-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2448-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2449" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2449-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2449-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2449-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2449-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2450" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2450-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2450-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2450-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2450-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2451" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2451-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2451-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2451-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2451-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2452" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2452-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2452-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2452-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2452-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2453" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2453-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2453-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2453-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2453-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2454" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2454-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2454-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2454-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2454-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2455" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2455-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2455-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2455-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2455-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2456" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2456-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2456-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2456-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2456-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2457" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2457-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2457-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2457-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2457-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2458" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2458-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2458-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2458-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2458-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2459" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2459-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2459-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2459-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2459-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2460" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2460-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2460-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2460-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2460-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2461" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2461-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2461-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2461-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2461-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2462" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2462-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2462-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2462-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2462-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2463" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2463-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2463-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2463-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2463-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2464" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2464-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2464-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2464-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2464-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2465" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2465-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2465-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2465-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2465-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2466" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2466-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2466-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2466-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2466-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2467" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2467-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2467-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2467-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2467-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2468" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2468-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2468-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2468-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2468-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2469" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2469-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2469-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2469-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2469-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2470" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2470-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2470-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2470-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2470-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2471" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2471-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2471-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2471-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2471-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2472" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2472-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2472-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2472-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2472-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2473" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2473-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2473-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2473-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2473-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2474" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2474-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2474-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2474-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2474-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2475" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2475-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2475-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2475-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2475-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2476" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2476-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2476-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2476-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2476-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2477" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2477-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2477-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2477-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2477-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2478" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2478-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2478-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2478-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2478-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2479" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2479-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2479-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2479-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2479-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2480" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2480-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2480-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2480-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2480-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2481" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2481-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2481-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2481-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2481-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2482" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2482-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2482-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2482-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2482-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2483" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2483-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2483-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2483-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2483-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2484" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2484-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2484-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2484-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2484-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2485" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2485-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2485-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2485-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2485-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2486" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2486-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2486-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2486-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2486-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2487" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2487-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2487-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2487-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2487-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2488" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2488-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2488-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2488-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2488-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2489" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2489-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2489-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2489-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2489-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2490" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2490-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2490-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2490-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2490-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2491" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2491-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2491-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2491-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2491-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2492" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2492-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2492-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2492-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2492-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2493" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2493-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2493-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2493-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2493-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2494" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2494-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2494-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2494-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2494-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2495" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2495-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2495-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2495-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2495-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2496" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2496-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2496-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2496-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2496-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2497" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2497-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2497-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2497-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2497-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2498" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2498-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2498-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2498-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2498-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2499" : helpers.makeTestYear("Atlantic/Bermuda", [
		["2499-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2499-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2499-11-01T04:59:59+00:00", "01:59:59", "ADT", 180]
	])
};