/*###############################################################################
# Linux Management Providers (LMP), Power Supply provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_POWERSUPPLYACCESS_H_
#define OPENDRIM_POWERSUPPLYACCESS_H_

#include "PowerSupply_Common.h"

#include "OpenDRIM_PowerSupply.h"

int PowerSupply_OpenDRIM_PowerSupply_load(const CMPIBroker* broker, string& errorMessage);

int PowerSupply_OpenDRIM_PowerSupply_unload(string& errorMessage);

int PowerSupply_OpenDRIM_PowerSupply_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_PowerSupply>& instances, const char** properties, string& errorMessage, const string& discriminant);

int PowerSupply_OpenDRIM_PowerSupply_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_PowerSupply& instance, const char** properties, string& errorMessage);

int PowerSupply_OpenDRIM_PowerSupply_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerSupply& newInstance, const OpenDRIM_PowerSupply& oldInstance, const char** properties, string& errorMessage);

int PowerSupply_OpenDRIM_PowerSupply_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerSupply& instance, string& errorMessage);

int PowerSupply_OpenDRIM_PowerSupply_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerSupply& instance, string& errorMessage);

int PowerSupply_OpenDRIM_PowerSupply_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerSupply& instance, unsigned int& returnValue, const OpenDRIM_PowerSupply_RequestStateChange_In& in, OpenDRIM_PowerSupply_RequestStateChange_Out& out, string& errorMessage);

int PowerSupply_OpenDRIM_PowerSupply_SetPowerState(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerSupply& instance, unsigned int& returnValue, const OpenDRIM_PowerSupply_SetPowerState_In& in, string& errorMessage);

int PowerSupply_OpenDRIM_PowerSupply_Reset(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerSupply& instance, unsigned int& returnValue, string& errorMessage);

int PowerSupply_OpenDRIM_PowerSupply_EnableDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerSupply& instance, unsigned int& returnValue, const OpenDRIM_PowerSupply_EnableDevice_In& in, string& errorMessage);

int PowerSupply_OpenDRIM_PowerSupply_OnlineDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerSupply& instance, unsigned int& returnValue, const OpenDRIM_PowerSupply_OnlineDevice_In& in, string& errorMessage);

int PowerSupply_OpenDRIM_PowerSupply_QuiesceDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerSupply& instance, unsigned int& returnValue, const OpenDRIM_PowerSupply_QuiesceDevice_In& in, string& errorMessage);

int PowerSupply_OpenDRIM_PowerSupply_SaveProperties(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerSupply& instance, unsigned int& returnValue, string& errorMessage);

int PowerSupply_OpenDRIM_PowerSupply_RestoreProperties(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerSupply& instance, unsigned int& returnValue, string& errorMessage);

int PowerSupply_OpenDRIM_PowerSupply_populate(OpenDRIM_PowerSupply& instance, int num, string& errorMessage);

#endif /*OPENDRIM_POWERSUPPLYACCESS_H_*/
