<?php

namespace Sabberworm\CSS\Property;

use Sabberworm\CSS\Value\URL;

/**
* Class representing an @import rule.
*/
class Import implements AtRule {
    private $oLocation;
    private $sMediaQuery;

    public function __construct(URL $oLocation, $sMediaQuery) {
        $this->oLocation = $oLocation;
        $this->sMediaQuery = $sMediaQuery;
    }

    public function setLocation($oLocation) {
            $this->oLocation = $oLocation;
    }

    public function getLocation() {
            return $this->oLocation;
    }

    public function __toString() {
        return "@import ".$this->oLocation->__toString().($this->sMediaQuery === null ? '' : ' '.$this->sMediaQuery).';';
    }

    public function atRuleName() {
        return 'import';
    }

    public function atRuleArgs() {
        $aResult = array($this->oLocation);
        if($this->sMediaQuery) {
            array_push($aResult, $this->sMediaQuery);
        }
        return $aResult;
    }
}