# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AppliedReservationList(msrest.serialization.Model):
    """AppliedReservationList.

    :param value:
    :type value: list[str]
    :param next_link: Url to get the next page of reservations.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[str]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AppliedReservationList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class AppliedReservations(msrest.serialization.Model):
    """AppliedReservations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Identifier of the applied reservations.
    :vartype id: str
    :ivar name: Name of resource.
    :vartype name: str
    :ivar type: Type of resource. "Microsoft.Capacity/AppliedReservations".
    :vartype type: str
    :param reservation_order_ids:
    :type reservation_order_ids: ~azure.mgmt.reservations.models.AppliedReservationList
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'reservation_order_ids': {'key': 'properties.reservationOrderIds', 'type': 'AppliedReservationList'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AppliedReservations, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.reservation_order_ids = kwargs.get('reservation_order_ids', None)


class AvailableScopeProperties(msrest.serialization.Model):
    """AvailableScopeProperties.

    :param properties:
    :type properties: ~azure.mgmt.reservations.models.SubscriptionScopeProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'SubscriptionScopeProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailableScopeProperties, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class AvailableScopeRequest(msrest.serialization.Model):
    """Available scope.

    :param properties: Available scope request properties.
    :type properties: ~azure.mgmt.reservations.models.AvailableScopeRequestProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'AvailableScopeRequestProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailableScopeRequest, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class AvailableScopeRequestProperties(msrest.serialization.Model):
    """Available scope request properties.

    :param scopes:
    :type scopes: list[str]
    """

    _attribute_map = {
        'scopes': {'key': 'scopes', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailableScopeRequestProperties, self).__init__(**kwargs)
        self.scopes = kwargs.get('scopes', None)


class BillingInformation(msrest.serialization.Model):
    """billing information.

    :param billing_currency_total_paid_amount:
    :type billing_currency_total_paid_amount: ~azure.mgmt.reservations.models.Price
    :param billing_currency_prorated_amount:
    :type billing_currency_prorated_amount: ~azure.mgmt.reservations.models.Price
    :param billing_currency_remaining_commitment_amount:
    :type billing_currency_remaining_commitment_amount: ~azure.mgmt.reservations.models.Price
    """

    _attribute_map = {
        'billing_currency_total_paid_amount': {'key': 'billingCurrencyTotalPaidAmount', 'type': 'Price'},
        'billing_currency_prorated_amount': {'key': 'billingCurrencyProratedAmount', 'type': 'Price'},
        'billing_currency_remaining_commitment_amount': {'key': 'billingCurrencyRemainingCommitmentAmount', 'type': 'Price'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BillingInformation, self).__init__(**kwargs)
        self.billing_currency_total_paid_amount = kwargs.get('billing_currency_total_paid_amount', None)
        self.billing_currency_prorated_amount = kwargs.get('billing_currency_prorated_amount', None)
        self.billing_currency_remaining_commitment_amount = kwargs.get('billing_currency_remaining_commitment_amount', None)


class CalculateExchangeOperationResultResponse(msrest.serialization.Model):
    """CalculateExchange operation result.

    :param id: It should match what is used to GET the operation result.
    :type id: str
    :param name: It must match the last segment of the id field, and will typically be a GUID /
     system generated value.
    :type name: str
    :param status: Status of the operation. Possible values include: "Succeeded", "Failed",
     "Cancelled", "Pending".
    :type status: str or ~azure.mgmt.reservations.models.CalculateExchangeOperationResultStatus
    :param properties: CalculateExchange response properties.
    :type properties: ~azure.mgmt.reservations.models.CalculateExchangeResponseProperties
    :param error: Required if status == failed or status == canceled.
    :type error: ~azure.mgmt.reservations.models.OperationResultError
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'CalculateExchangeResponseProperties'},
        'error': {'key': 'error', 'type': 'OperationResultError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CalculateExchangeOperationResultResponse, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.status = kwargs.get('status', None)
        self.properties = kwargs.get('properties', None)
        self.error = kwargs.get('error', None)


class CalculateExchangeRequest(msrest.serialization.Model):
    """Calculate exchange request.

    :param properties: Calculate exchange request properties.
    :type properties: ~azure.mgmt.reservations.models.CalculateExchangeRequestProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'CalculateExchangeRequestProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CalculateExchangeRequest, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class CalculateExchangeRequestProperties(msrest.serialization.Model):
    """Calculate exchange request properties.

    :param reservations_to_purchase: List of reservations that are being purchased in this
     exchange.
    :type reservations_to_purchase: list[~azure.mgmt.reservations.models.PurchaseRequest]
    :param reservations_to_exchange: List of reservations that are being returned in this exchange.
    :type reservations_to_exchange: list[~azure.mgmt.reservations.models.ReservationToReturn]
    """

    _attribute_map = {
        'reservations_to_purchase': {'key': 'reservationsToPurchase', 'type': '[PurchaseRequest]'},
        'reservations_to_exchange': {'key': 'reservationsToExchange', 'type': '[ReservationToReturn]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CalculateExchangeRequestProperties, self).__init__(**kwargs)
        self.reservations_to_purchase = kwargs.get('reservations_to_purchase', None)
        self.reservations_to_exchange = kwargs.get('reservations_to_exchange', None)


class CalculateExchangeResponseProperties(msrest.serialization.Model):
    """CalculateExchange response properties.

    :param session_id: Exchange session identifier.
    :type session_id: str
    :param net_payable:
    :type net_payable: ~azure.mgmt.reservations.models.Price
    :param refunds_total:
    :type refunds_total: ~azure.mgmt.reservations.models.Price
    :param purchases_total:
    :type purchases_total: ~azure.mgmt.reservations.models.Price
    :param reservations_to_purchase: Details of the reservations being purchased.
    :type reservations_to_purchase:
     list[~azure.mgmt.reservations.models.ReservationToPurchaseCalculateExchange]
    :param reservations_to_exchange: Details of the reservations being returned.
    :type reservations_to_exchange: list[~azure.mgmt.reservations.models.ReservationToExchange]
    :param policy_result: Exchange policy errors.
    :type policy_result: ~azure.mgmt.reservations.models.ExchangePolicyErrors
    """

    _attribute_map = {
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'net_payable': {'key': 'netPayable', 'type': 'Price'},
        'refunds_total': {'key': 'refundsTotal', 'type': 'Price'},
        'purchases_total': {'key': 'purchasesTotal', 'type': 'Price'},
        'reservations_to_purchase': {'key': 'reservationsToPurchase', 'type': '[ReservationToPurchaseCalculateExchange]'},
        'reservations_to_exchange': {'key': 'reservationsToExchange', 'type': '[ReservationToExchange]'},
        'policy_result': {'key': 'policyResult', 'type': 'ExchangePolicyErrors'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CalculateExchangeResponseProperties, self).__init__(**kwargs)
        self.session_id = kwargs.get('session_id', None)
        self.net_payable = kwargs.get('net_payable', None)
        self.refunds_total = kwargs.get('refunds_total', None)
        self.purchases_total = kwargs.get('purchases_total', None)
        self.reservations_to_purchase = kwargs.get('reservations_to_purchase', None)
        self.reservations_to_exchange = kwargs.get('reservations_to_exchange', None)
        self.policy_result = kwargs.get('policy_result', None)


class CalculatePriceResponse(msrest.serialization.Model):
    """CalculatePriceResponse.

    :param properties:
    :type properties: ~azure.mgmt.reservations.models.CalculatePriceResponseProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'CalculatePriceResponseProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CalculatePriceResponse, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class CalculatePriceResponseProperties(msrest.serialization.Model):
    """CalculatePriceResponseProperties.

    :param billing_currency_total: Currency and amount that customer will be charged in customer's
     local currency. Tax is not included.
    :type billing_currency_total:
     ~azure.mgmt.reservations.models.CalculatePriceResponsePropertiesBillingCurrencyTotal
    :param is_billing_partner_managed: True if billing is managed by Microsoft Partner. Used only
     for CSP accounts.
    :type is_billing_partner_managed: bool
    :param reservation_order_id: GUID that represents reservation order that can be placed after
     calculating price.
    :type reservation_order_id: str
    :param sku_title: Title of SKU that is being purchased.
    :type sku_title: str
    :param sku_description: Description of SKU that is being purchased.
    :type sku_description: str
    :param pricing_currency_total: Amount that Microsoft uses for record. Used during refund for
     calculating refund limit. Tax is not included.
    :type pricing_currency_total:
     ~azure.mgmt.reservations.models.CalculatePriceResponsePropertiesPricingCurrencyTotal
    :param payment_schedule:
    :type payment_schedule: list[~azure.mgmt.reservations.models.PaymentDetail]
    """

    _attribute_map = {
        'billing_currency_total': {'key': 'billingCurrencyTotal', 'type': 'CalculatePriceResponsePropertiesBillingCurrencyTotal'},
        'is_billing_partner_managed': {'key': 'isBillingPartnerManaged', 'type': 'bool'},
        'reservation_order_id': {'key': 'reservationOrderId', 'type': 'str'},
        'sku_title': {'key': 'skuTitle', 'type': 'str'},
        'sku_description': {'key': 'skuDescription', 'type': 'str'},
        'pricing_currency_total': {'key': 'pricingCurrencyTotal', 'type': 'CalculatePriceResponsePropertiesPricingCurrencyTotal'},
        'payment_schedule': {'key': 'paymentSchedule', 'type': '[PaymentDetail]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CalculatePriceResponseProperties, self).__init__(**kwargs)
        self.billing_currency_total = kwargs.get('billing_currency_total', None)
        self.is_billing_partner_managed = kwargs.get('is_billing_partner_managed', None)
        self.reservation_order_id = kwargs.get('reservation_order_id', None)
        self.sku_title = kwargs.get('sku_title', None)
        self.sku_description = kwargs.get('sku_description', None)
        self.pricing_currency_total = kwargs.get('pricing_currency_total', None)
        self.payment_schedule = kwargs.get('payment_schedule', None)


class CalculatePriceResponsePropertiesBillingCurrencyTotal(msrest.serialization.Model):
    """Currency and amount that customer will be charged in customer's local currency. Tax is not included.

    :param currency_code:
    :type currency_code: str
    :param amount:
    :type amount: float
    """

    _attribute_map = {
        'currency_code': {'key': 'currencyCode', 'type': 'str'},
        'amount': {'key': 'amount', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CalculatePriceResponsePropertiesBillingCurrencyTotal, self).__init__(**kwargs)
        self.currency_code = kwargs.get('currency_code', None)
        self.amount = kwargs.get('amount', None)


class CalculatePriceResponsePropertiesPricingCurrencyTotal(msrest.serialization.Model):
    """Amount that Microsoft uses for record. Used during refund for calculating refund limit. Tax is not included.

    :param currency_code:
    :type currency_code: str
    :param amount:
    :type amount: float
    """

    _attribute_map = {
        'currency_code': {'key': 'currencyCode', 'type': 'str'},
        'amount': {'key': 'amount', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CalculatePriceResponsePropertiesPricingCurrencyTotal, self).__init__(**kwargs)
        self.currency_code = kwargs.get('currency_code', None)
        self.amount = kwargs.get('amount', None)


class Catalog(msrest.serialization.Model):
    """Catalog.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: The type of resource the SKU applies to.
    :vartype resource_type: str
    :ivar name: The name of SKU.
    :vartype name: str
    :param billing_plans: The billing plan options available for this SKU.
    :type billing_plans: dict[str, list[str or
     ~azure.mgmt.reservations.models.ReservationBillingPlan]]
    :ivar terms: Available reservation terms for this resource.
    :vartype terms: list[str or ~azure.mgmt.reservations.models.ReservationTerm]
    :ivar locations:
    :vartype locations: list[str]
    :ivar sku_properties:
    :vartype sku_properties: list[~azure.mgmt.reservations.models.SkuProperty]
    :ivar restrictions:
    :vartype restrictions: list[~azure.mgmt.reservations.models.SkuRestriction]
    """

    _validation = {
        'resource_type': {'readonly': True},
        'name': {'readonly': True},
        'terms': {'readonly': True},
        'locations': {'readonly': True},
        'sku_properties': {'readonly': True},
        'restrictions': {'readonly': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'billing_plans': {'key': 'billingPlans', 'type': '{[str]}'},
        'terms': {'key': 'terms', 'type': '[str]'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'sku_properties': {'key': 'skuProperties', 'type': '[SkuProperty]'},
        'restrictions': {'key': 'restrictions', 'type': '[SkuRestriction]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Catalog, self).__init__(**kwargs)
        self.resource_type = None
        self.name = None
        self.billing_plans = kwargs.get('billing_plans', None)
        self.terms = None
        self.locations = None
        self.sku_properties = None
        self.restrictions = None


class CreateGenericQuotaRequestParameters(msrest.serialization.Model):
    """Quota change requests information.

    :param value: Quota change requests.
    :type value: list[~azure.mgmt.reservations.models.CurrentQuotaLimitBase]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CurrentQuotaLimitBase]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreateGenericQuotaRequestParameters, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class CurrentQuotaLimit(msrest.serialization.Model):
    """Current quota limits.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The details of the quota request status. Possible values include:
     "Accepted", "Invalid", "Succeeded", "Failed", "InProgress".
    :vartype provisioning_state: str or ~azure.mgmt.reservations.models.QuotaRequestState
    :ivar message: A user friendly message.
    :vartype message: str
    :param properties: Quota properties for the resource.
    :type properties: ~azure.mgmt.reservations.models.QuotaProperties
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'message': {'key': 'properties.message', 'type': 'str'},
        'properties': {'key': 'quotaInformation.properties', 'type': 'QuotaProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CurrentQuotaLimit, self).__init__(**kwargs)
        self.provisioning_state = None
        self.message = None
        self.properties = kwargs.get('properties', None)


class CurrentQuotaLimitBase(msrest.serialization.Model):
    """Quota properties.

    :param properties: Quota properties for the resource.
    :type properties: ~azure.mgmt.reservations.models.QuotaProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'QuotaProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CurrentQuotaLimitBase, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class Error(msrest.serialization.Model):
    """Error.

    :param error:
    :type error: ~azure.mgmt.reservations.models.ExtendedErrorInfo
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ExtendedErrorInfo'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Error, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class ExceptionResponse(msrest.serialization.Model):
    """The API error.

    :param error: The API error details.
    :type error: ~azure.mgmt.reservations.models.ServiceError
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ServiceError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExceptionResponse, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class ExchangeOperationResultResponse(msrest.serialization.Model):
    """Exchange operation result.

    :param id: It should match what is used to GET the operation result.
    :type id: str
    :param name: It must match the last segment of the id field, and will typically be a GUID /
     system generated value.
    :type name: str
    :param status: Status of the operation. Possible values include: "Succeeded", "Failed",
     "Cancelled", "PendingRefunds", "PendingPurchases".
    :type status: str or ~azure.mgmt.reservations.models.ExchangeOperationResultStatus
    :param properties: Exchange response properties.
    :type properties: ~azure.mgmt.reservations.models.ExchangeResponseProperties
    :param error: Required if status == failed or status == canceled.
    :type error: ~azure.mgmt.reservations.models.OperationResultError
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ExchangeResponseProperties'},
        'error': {'key': 'error', 'type': 'OperationResultError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExchangeOperationResultResponse, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.status = kwargs.get('status', None)
        self.properties = kwargs.get('properties', None)
        self.error = kwargs.get('error', None)


class ExchangePolicyError(msrest.serialization.Model):
    """error details.

    :param code:
    :type code: str
    :param message:
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExchangePolicyError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class ExchangePolicyErrors(msrest.serialization.Model):
    """Exchange policy errors.

    :param policy_errors: Exchange Policy errors.
    :type policy_errors: list[~azure.mgmt.reservations.models.ExchangePolicyError]
    """

    _attribute_map = {
        'policy_errors': {'key': 'policyErrors', 'type': '[ExchangePolicyError]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExchangePolicyErrors, self).__init__(**kwargs)
        self.policy_errors = kwargs.get('policy_errors', None)


class ExchangeRequest(msrest.serialization.Model):
    """Exchange request.

    :param properties: Exchange request properties.
    :type properties: ~azure.mgmt.reservations.models.ExchangeRequestProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'ExchangeRequestProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExchangeRequest, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class ExchangeRequestProperties(msrest.serialization.Model):
    """Exchange request properties.

    :param session_id: SessionId that was returned by CalculateExchange API.
    :type session_id: str
    """

    _attribute_map = {
        'session_id': {'key': 'sessionId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExchangeRequestProperties, self).__init__(**kwargs)
        self.session_id = kwargs.get('session_id', None)


class ExchangeResponseProperties(msrest.serialization.Model):
    """Exchange response properties.

    :param session_id: Exchange session identifier.
    :type session_id: str
    :param net_payable:
    :type net_payable: ~azure.mgmt.reservations.models.Price
    :param refunds_total:
    :type refunds_total: ~azure.mgmt.reservations.models.Price
    :param purchases_total:
    :type purchases_total: ~azure.mgmt.reservations.models.Price
    :param reservations_to_purchase: Details of the reservations being purchased.
    :type reservations_to_purchase:
     list[~azure.mgmt.reservations.models.ReservationToPurchaseExchange]
    :param reservations_to_exchange: Details of the reservations being returned.
    :type reservations_to_exchange:
     list[~azure.mgmt.reservations.models.ReservationToReturnForExchange]
    :param policy_result: Exchange policy errors.
    :type policy_result: ~azure.mgmt.reservations.models.ExchangePolicyErrors
    """

    _attribute_map = {
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'net_payable': {'key': 'netPayable', 'type': 'Price'},
        'refunds_total': {'key': 'refundsTotal', 'type': 'Price'},
        'purchases_total': {'key': 'purchasesTotal', 'type': 'Price'},
        'reservations_to_purchase': {'key': 'reservationsToPurchase', 'type': '[ReservationToPurchaseExchange]'},
        'reservations_to_exchange': {'key': 'reservationsToExchange', 'type': '[ReservationToReturnForExchange]'},
        'policy_result': {'key': 'policyResult', 'type': 'ExchangePolicyErrors'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExchangeResponseProperties, self).__init__(**kwargs)
        self.session_id = kwargs.get('session_id', None)
        self.net_payable = kwargs.get('net_payable', None)
        self.refunds_total = kwargs.get('refunds_total', None)
        self.purchases_total = kwargs.get('purchases_total', None)
        self.reservations_to_purchase = kwargs.get('reservations_to_purchase', None)
        self.reservations_to_exchange = kwargs.get('reservations_to_exchange', None)
        self.policy_result = kwargs.get('policy_result', None)


class ExtendedErrorInfo(msrest.serialization.Model):
    """ExtendedErrorInfo.

    :param code:  Possible values include: "NotSpecified", "InternalServerError", "ServerTimeout",
     "AuthorizationFailed", "BadRequest", "ClientCertificateThumbprintNotSet",
     "InvalidRequestContent", "OperationFailed", "HttpMethodNotSupported", "InvalidRequestUri",
     "MissingTenantId", "InvalidTenantId", "InvalidReservationOrderId", "InvalidReservationId",
     "ReservationIdNotInReservationOrder", "ReservationOrderNotFound", "InvalidSubscriptionId",
     "InvalidAccessToken", "InvalidLocationId", "UnauthenticatedRequestsThrottled",
     "InvalidHealthCheckType", "Forbidden", "BillingScopeIdCannotBeChanged",
     "AppliedScopesNotAssociatedWithCommerceAccount", "PatchValuesSameAsExisting",
     "RoleAssignmentCreationFailed", "ReservationOrderCreationFailed", "ReservationOrderNotEnabled",
     "CapacityUpdateScopesFailed", "UnsupportedReservationTerm", "ReservationOrderIdAlreadyExists",
     "RiskCheckFailed", "CreateQuoteFailed", "ActivateQuoteFailed", "NonsupportedAccountId",
     "PaymentInstrumentNotFound", "MissingAppliedScopesForSingle", "NoValidReservationsToReRate",
     "ReRateOnlyAllowedForEA", "OperationCannotBePerformedInCurrentState",
     "InvalidSingleAppliedScopesCount", "InvalidFulfillmentRequestParameters",
     "NotSupportedCountry", "InvalidRefundQuantity", "PurchaseError", "BillingCustomerInputError",
     "BillingPaymentInstrumentSoftError", "BillingPaymentInstrumentHardError",
     "BillingTransientError", "BillingError", "FulfillmentConfigurationError",
     "FulfillmentOutOfStockError", "FulfillmentTransientError", "FulfillmentError",
     "CalculatePriceFailed".
    :type code: str or ~azure.mgmt.reservations.models.ErrorResponseCode
    :param message:
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExtendedErrorInfo, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class ExtendedStatusInfo(msrest.serialization.Model):
    """ExtendedStatusInfo.

    :param status_code:  Possible values include: "None", "Pending", "Active", "PurchaseError",
     "PaymentInstrumentError", "Split", "Merged", "Expired", "Succeeded".
    :type status_code: str or ~azure.mgmt.reservations.models.ReservationStatusCode
    :param message: The message giving detailed information about the status code.
    :type message: str
    """

    _attribute_map = {
        'status_code': {'key': 'statusCode', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExtendedStatusInfo, self).__init__(**kwargs)
        self.status_code = kwargs.get('status_code', None)
        self.message = kwargs.get('message', None)


class MergeRequest(msrest.serialization.Model):
    """MergeRequest.

    :param sources: Format of the resource id should be
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}.
    :type sources: list[str]
    """

    _attribute_map = {
        'sources': {'key': 'properties.sources', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MergeRequest, self).__init__(**kwargs)
        self.sources = kwargs.get('sources', None)


class OperationDisplay(msrest.serialization.Model):
    """OperationDisplay.

    :param provider:
    :type provider: str
    :param resource:
    :type resource: str
    :param operation:
    :type operation: str
    :param description:
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class OperationList(msrest.serialization.Model):
    """OperationList.

    :param value:
    :type value: list[~azure.mgmt.reservations.models.OperationResponse]
    :param next_link: Url to get the next page of items.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OperationResponse]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class OperationResponse(msrest.serialization.Model):
    """OperationResponse.

    :param name:
    :type name: str
    :param display:
    :type display: ~azure.mgmt.reservations.models.OperationDisplay
    :param origin:
    :type origin: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationResponse, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)
        self.origin = kwargs.get('origin', None)


class OperationResultError(msrest.serialization.Model):
    """Required if status == failed or status == canceled.

    :param code: Required if status == failed or status == cancelled. If status == failed, provide
     an invariant error code used for error troubleshooting, aggregation, and analysis.
    :type code: str
    :param message: Required if status == failed. Localized. If status == failed, provide an
     actionable error message indicating what error occurred, and what the user can do to address
     the issue.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationResultError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class Patch(msrest.serialization.Model):
    """Patch.

    :param applied_scope_type: Type of the Applied Scope. Possible values include: "Single",
     "Shared".
    :type applied_scope_type: str or ~azure.mgmt.reservations.models.AppliedScopeType
    :param applied_scopes: List of the subscriptions that the benefit will be applied. Do not
     specify if AppliedScopeType is Shared.
    :type applied_scopes: list[str]
    :param instance_flexibility: Turning this on will apply the reservation discount to other VMs
     in the same VM size group. Only specify for VirtualMachines reserved resource type. Possible
     values include: "On", "Off".
    :type instance_flexibility: str or ~azure.mgmt.reservations.models.InstanceFlexibility
    :param name: Name of the Reservation.
    :type name: str
    :param renew: Setting this to true will automatically purchase a new reservation on the
     expiration date time.
    :type renew: bool
    :param renew_properties:
    :type renew_properties: ~azure.mgmt.reservations.models.PatchPropertiesRenewProperties
    """

    _attribute_map = {
        'applied_scope_type': {'key': 'properties.appliedScopeType', 'type': 'str'},
        'applied_scopes': {'key': 'properties.appliedScopes', 'type': '[str]'},
        'instance_flexibility': {'key': 'properties.instanceFlexibility', 'type': 'str'},
        'name': {'key': 'properties.name', 'type': 'str'},
        'renew': {'key': 'properties.renew', 'type': 'bool'},
        'renew_properties': {'key': 'properties.renewProperties', 'type': 'PatchPropertiesRenewProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Patch, self).__init__(**kwargs)
        self.applied_scope_type = kwargs.get('applied_scope_type', None)
        self.applied_scopes = kwargs.get('applied_scopes', None)
        self.instance_flexibility = kwargs.get('instance_flexibility', None)
        self.name = kwargs.get('name', None)
        self.renew = kwargs.get('renew', False)
        self.renew_properties = kwargs.get('renew_properties', None)


class PatchPropertiesRenewProperties(msrest.serialization.Model):
    """PatchPropertiesRenewProperties.

    :param purchase_properties:
    :type purchase_properties: ~azure.mgmt.reservations.models.PurchaseRequest
    """

    _attribute_map = {
        'purchase_properties': {'key': 'purchaseProperties', 'type': 'PurchaseRequest'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PatchPropertiesRenewProperties, self).__init__(**kwargs)
        self.purchase_properties = kwargs.get('purchase_properties', None)


class PaymentDetail(msrest.serialization.Model):
    """Information about payment related to a reservation order.

    :param due_date: Date when the payment needs to be done.
    :type due_date: ~datetime.date
    :param payment_date: Date when the transaction is completed. Is null when it is scheduled.
    :type payment_date: ~datetime.date
    :param pricing_currency_total: Amount in pricing currency. Tax not included.
    :type pricing_currency_total: ~azure.mgmt.reservations.models.Price
    :param billing_currency_total: Amount charged in Billing currency. Tax not included. Is null
     for future payments.
    :type billing_currency_total: ~azure.mgmt.reservations.models.Price
    :param billing_account: Shows the Account that is charged for this payment.
    :type billing_account: str
    :param status: Describes whether the payment is completed, failed, cancelled or scheduled in
     the future. Possible values include: "Succeeded", "Failed", "Scheduled", "Cancelled".
    :type status: str or ~azure.mgmt.reservations.models.PaymentStatus
    :param extended_status_info:
    :type extended_status_info: ~azure.mgmt.reservations.models.ExtendedStatusInfo
    """

    _attribute_map = {
        'due_date': {'key': 'dueDate', 'type': 'date'},
        'payment_date': {'key': 'paymentDate', 'type': 'date'},
        'pricing_currency_total': {'key': 'pricingCurrencyTotal', 'type': 'Price'},
        'billing_currency_total': {'key': 'billingCurrencyTotal', 'type': 'Price'},
        'billing_account': {'key': 'billingAccount', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'extended_status_info': {'key': 'extendedStatusInfo', 'type': 'ExtendedStatusInfo'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PaymentDetail, self).__init__(**kwargs)
        self.due_date = kwargs.get('due_date', None)
        self.payment_date = kwargs.get('payment_date', None)
        self.pricing_currency_total = kwargs.get('pricing_currency_total', None)
        self.billing_currency_total = kwargs.get('billing_currency_total', None)
        self.billing_account = kwargs.get('billing_account', None)
        self.status = kwargs.get('status', None)
        self.extended_status_info = kwargs.get('extended_status_info', None)


class Price(msrest.serialization.Model):
    """Price.

    :param currency_code: The ISO 4217 3-letter currency code for the currency used by this
     purchase record.
    :type currency_code: str
    :param amount:
    :type amount: float
    """

    _attribute_map = {
        'currency_code': {'key': 'currencyCode', 'type': 'str'},
        'amount': {'key': 'amount', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Price, self).__init__(**kwargs)
        self.currency_code = kwargs.get('currency_code', None)
        self.amount = kwargs.get('amount', None)


class PurchaseRequest(msrest.serialization.Model):
    """PurchaseRequest.

    :param sku:
    :type sku: ~azure.mgmt.reservations.models.SkuName
    :param location: The Azure Region where the reserved resource lives.
    :type location: str
    :param reserved_resource_type: The type of the resource that is being reserved. Possible values
     include: "VirtualMachines", "SqlDatabases", "SuseLinux", "CosmosDb", "RedHat",
     "SqlDataWarehouse", "VMwareCloudSimple", "RedHatOsa", "Databricks", "AppService",
     "ManagedDisk", "BlockBlob", "RedisCache", "AzureDataExplorer", "MySql", "MariaDb",
     "PostgreSql", "DedicatedHost", "SapHana", "SqlAzureHybridBenefit".
    :type reserved_resource_type: str or ~azure.mgmt.reservations.models.ReservedResourceType
    :param billing_scope_id: Subscription that will be charged for purchasing Reservation.
    :type billing_scope_id: str
    :param term: Represent the term of Reservation. Possible values include: "P1Y", "P3Y".
    :type term: str or ~azure.mgmt.reservations.models.ReservationTerm
    :param billing_plan: Represent the billing plans. Possible values include: "Upfront",
     "Monthly".
    :type billing_plan: str or ~azure.mgmt.reservations.models.ReservationBillingPlan
    :param quantity: Quantity of the SKUs that are part of the Reservation. Must be greater than
     zero.
    :type quantity: int
    :param display_name: Friendly name of the Reservation.
    :type display_name: str
    :param applied_scope_type: Type of the Applied Scope. Possible values include: "Single",
     "Shared".
    :type applied_scope_type: str or ~azure.mgmt.reservations.models.AppliedScopeType
    :param applied_scopes: List of the subscriptions that the benefit will be applied. Do not
     specify if AppliedScopeType is Shared.
    :type applied_scopes: list[str]
    :param renew: Setting this to true will automatically purchase a new reservation on the
     expiration date time.
    :type renew: bool
    :param reserved_resource_properties: Properties specific to each reserved resource type. Not
     required if not applicable.
    :type reserved_resource_properties:
     ~azure.mgmt.reservations.models.PurchaseRequestPropertiesReservedResourceProperties
    """

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'SkuName'},
        'location': {'key': 'location', 'type': 'str'},
        'reserved_resource_type': {'key': 'properties.reservedResourceType', 'type': 'str'},
        'billing_scope_id': {'key': 'properties.billingScopeId', 'type': 'str'},
        'term': {'key': 'properties.term', 'type': 'str'},
        'billing_plan': {'key': 'properties.billingPlan', 'type': 'str'},
        'quantity': {'key': 'properties.quantity', 'type': 'int'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'applied_scope_type': {'key': 'properties.appliedScopeType', 'type': 'str'},
        'applied_scopes': {'key': 'properties.appliedScopes', 'type': '[str]'},
        'renew': {'key': 'properties.renew', 'type': 'bool'},
        'reserved_resource_properties': {'key': 'properties.reservedResourceProperties', 'type': 'PurchaseRequestPropertiesReservedResourceProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PurchaseRequest, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.location = kwargs.get('location', None)
        self.reserved_resource_type = kwargs.get('reserved_resource_type', None)
        self.billing_scope_id = kwargs.get('billing_scope_id', None)
        self.term = kwargs.get('term', None)
        self.billing_plan = kwargs.get('billing_plan', None)
        self.quantity = kwargs.get('quantity', None)
        self.display_name = kwargs.get('display_name', None)
        self.applied_scope_type = kwargs.get('applied_scope_type', None)
        self.applied_scopes = kwargs.get('applied_scopes', None)
        self.renew = kwargs.get('renew', False)
        self.reserved_resource_properties = kwargs.get('reserved_resource_properties', None)


class PurchaseRequestPropertiesReservedResourceProperties(msrest.serialization.Model):
    """Properties specific to each reserved resource type. Not required if not applicable.

    :param instance_flexibility: Turning this on will apply the reservation discount to other VMs
     in the same VM size group. Only specify for VirtualMachines reserved resource type. Possible
     values include: "On", "Off".
    :type instance_flexibility: str or ~azure.mgmt.reservations.models.InstanceFlexibility
    """

    _attribute_map = {
        'instance_flexibility': {'key': 'instanceFlexibility', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PurchaseRequestPropertiesReservedResourceProperties, self).__init__(**kwargs)
        self.instance_flexibility = kwargs.get('instance_flexibility', None)


class QuotaLimits(msrest.serialization.Model):
    """Quota limits.

    :param value: List of quotas (service limits).
    :type value: list[~azure.mgmt.reservations.models.CurrentQuotaLimitBase]
    :param next_link: The URI for fetching the next page of quotas (service limits). When no more
     pages exist, the value is null.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CurrentQuotaLimitBase]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QuotaLimits, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class QuotaLimitsResponse(msrest.serialization.Model):
    """Quotas (service limits) in the request response.

    :param value: List of quotas with the quota request status.
    :type value: list[~azure.mgmt.reservations.models.CurrentQuotaLimit]
    :param next_link: The URI for fetching the next page of quota limits. When no more pages exist,
     the value is null.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CurrentQuotaLimit]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QuotaLimitsResponse, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class QuotaProperties(msrest.serialization.Model):
    """Quota properties for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param limit: Quota properties.
    :type limit: int
    :ivar current_value: Current usage value for the resource.
    :vartype current_value: int
    :param unit: The limit units, such as **count** and **bytes**. Use the unit field provided in
     the response of the GET quota operation.
    :type unit: str
    :param name: Name of the resource provide by the resource provider. Use this property for
     quotaRequests resource operations.
    :type name: ~azure.mgmt.reservations.models.ResourceName
    :param resource_type: The name of the resource type. Possible values include: "standard",
     "dedicated", "lowPriority", "shared", "serviceSpecific".
    :type resource_type: str or ~azure.mgmt.reservations.models.ResourceType
    :ivar quota_period: The time period over which the quota usage values are summarized. For
     example, P1D (per one day), PT1M (per one minute), and PT1S (per one second). This parameter is
     optional because, for some resources such as compute, the time period is irrelevant.
    :vartype quota_period: str
    :param properties: Additional properties for the specified resource provider.
    :type properties: any
    """

    _validation = {
        'current_value': {'readonly': True},
        'quota_period': {'readonly': True},
    }

    _attribute_map = {
        'limit': {'key': 'limit', 'type': 'int'},
        'current_value': {'key': 'currentValue', 'type': 'int'},
        'unit': {'key': 'unit', 'type': 'str'},
        'name': {'key': 'name', 'type': 'ResourceName'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'quota_period': {'key': 'quotaPeriod', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QuotaProperties, self).__init__(**kwargs)
        self.limit = kwargs.get('limit', None)
        self.current_value = None
        self.unit = kwargs.get('unit', None)
        self.name = kwargs.get('name', None)
        self.resource_type = kwargs.get('resource_type', None)
        self.quota_period = None
        self.properties = kwargs.get('properties', None)


class QuotaRequestDetails(msrest.serialization.Model):
    """Quota request details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Quota request ID.
    :vartype id: str
    :ivar name: Quota request name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param provisioning_state: The quota request status. Possible values include: "Accepted",
     "Invalid", "Succeeded", "Failed", "InProgress".
    :type provisioning_state: str or ~azure.mgmt.reservations.models.QuotaRequestState
    :ivar message: User friendly status message.
    :vartype message: str
    :ivar request_submit_time: The time when the quota request was submitted using format:
     yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
    :vartype request_submit_time: ~datetime.datetime
    :param value: The quotaRequests.
    :type value: list[~azure.mgmt.reservations.models.SubRequest]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'message': {'readonly': True},
        'request_submit_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'message': {'key': 'properties.message', 'type': 'str'},
        'request_submit_time': {'key': 'properties.requestSubmitTime', 'type': 'iso-8601'},
        'value': {'key': 'properties.value', 'type': '[SubRequest]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QuotaRequestDetails, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.message = None
        self.request_submit_time = None
        self.value = kwargs.get('value', None)


class QuotaRequestDetailsList(msrest.serialization.Model):
    """Quota request details.

    :param value: The quota requests.
    :type value: list[~azure.mgmt.reservations.models.QuotaRequestDetails]
    :param next_link: The URI to fetch the next page of quota limits. When there are no more pages,
     this is null.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[QuotaRequestDetails]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QuotaRequestDetailsList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class QuotaRequestOneResourceSubmitResponse(msrest.serialization.Model):
    """Response for the quota submission request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The quota request ID.
    :vartype id: str
    :ivar name: The name of the quota request.
    :vartype name: str
    :ivar type: Type of resource. "Microsoft.Capacity/ServiceLimits".
    :vartype type: str
    :ivar provisioning_state: The quota request status. Possible values include: "Accepted",
     "Invalid", "Succeeded", "Failed", "InProgress".
    :vartype provisioning_state: str or ~azure.mgmt.reservations.models.QuotaRequestState
    :ivar message: User friendly status message.
    :vartype message: str
    :ivar request_submit_time: The time when the quota request was submitted using format:
     yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
    :vartype request_submit_time: ~datetime.datetime
    :param properties: Quota properties for the resource.
    :type properties: ~azure.mgmt.reservations.models.QuotaProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'message': {'readonly': True},
        'request_submit_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'message': {'key': 'properties.message', 'type': 'str'},
        'request_submit_time': {'key': 'properties.requestSubmitTime', 'type': 'iso-8601'},
        'properties': {'key': 'properties.properties.properties', 'type': 'QuotaProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QuotaRequestOneResourceSubmitResponse, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.provisioning_state = None
        self.message = None
        self.request_submit_time = None
        self.properties = kwargs.get('properties', None)


class QuotaRequestProperties(msrest.serialization.Model):
    """The details of quota request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param provisioning_state: The quota request status. Possible values include: "Accepted",
     "Invalid", "Succeeded", "Failed", "InProgress".
    :type provisioning_state: str or ~azure.mgmt.reservations.models.QuotaRequestState
    :ivar message: User friendly status message.
    :vartype message: str
    :ivar request_submit_time: The time when the quota request was submitted using format:
     yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
    :vartype request_submit_time: ~datetime.datetime
    :param value: The quotaRequests.
    :type value: list[~azure.mgmt.reservations.models.SubRequest]
    """

    _validation = {
        'message': {'readonly': True},
        'request_submit_time': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'request_submit_time': {'key': 'requestSubmitTime', 'type': 'iso-8601'},
        'value': {'key': 'value', 'type': '[SubRequest]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QuotaRequestProperties, self).__init__(**kwargs)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.message = None
        self.request_submit_time = None
        self.value = kwargs.get('value', None)


class QuotaRequestSubmitResponse(msrest.serialization.Model):
    """Response for the quota submission request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The quota request ID.
    :vartype id: str
    :ivar name: The name of the quota request.
    :vartype name: str
    :param properties: The quota request details.
    :type properties: ~azure.mgmt.reservations.models.QuotaRequestProperties
    :ivar type: Type of resource. "Microsoft.Capacity/serviceLimits".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'QuotaRequestProperties'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QuotaRequestSubmitResponse, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.properties = kwargs.get('properties', None)
        self.type = None


class QuotaRequestSubmitResponse201(msrest.serialization.Model):
    """Response with request ID that the quota request was accepted.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The quota request ID. Use the requestId parameter to check the request status.
    :vartype id: str
    :ivar name: Operation ID.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state: The details of the quota request status. Possible values include:
     "Accepted", "Invalid", "Succeeded", "Failed", "InProgress".
    :vartype provisioning_state: str or ~azure.mgmt.reservations.models.QuotaRequestState
    :ivar message: A user friendly message.
    :vartype message: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'message': {'key': 'properties.message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QuotaRequestSubmitResponse201, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.provisioning_state = None
        self.message = None


class RenewPropertiesResponse(msrest.serialization.Model):
    """RenewPropertiesResponse.

    :param purchase_properties:
    :type purchase_properties: ~azure.mgmt.reservations.models.PurchaseRequest
    :param pricing_currency_total: Amount that Microsoft uses for record. Used during refund for
     calculating refund limit. Tax is not included. This is locked price 30 days before expiry.
    :type pricing_currency_total:
     ~azure.mgmt.reservations.models.RenewPropertiesResponsePricingCurrencyTotal
    :param billing_currency_total: Currency and amount that customer will be charged in customer's
     local currency for renewal purchase. Tax is not included.
    :type billing_currency_total:
     ~azure.mgmt.reservations.models.RenewPropertiesResponseBillingCurrencyTotal
    """

    _attribute_map = {
        'purchase_properties': {'key': 'purchaseProperties', 'type': 'PurchaseRequest'},
        'pricing_currency_total': {'key': 'pricingCurrencyTotal', 'type': 'RenewPropertiesResponsePricingCurrencyTotal'},
        'billing_currency_total': {'key': 'billingCurrencyTotal', 'type': 'RenewPropertiesResponseBillingCurrencyTotal'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RenewPropertiesResponse, self).__init__(**kwargs)
        self.purchase_properties = kwargs.get('purchase_properties', None)
        self.pricing_currency_total = kwargs.get('pricing_currency_total', None)
        self.billing_currency_total = kwargs.get('billing_currency_total', None)


class RenewPropertiesResponseBillingCurrencyTotal(msrest.serialization.Model):
    """Currency and amount that customer will be charged in customer's local currency for renewal purchase. Tax is not included.

    :param currency_code:
    :type currency_code: str
    :param amount:
    :type amount: float
    """

    _attribute_map = {
        'currency_code': {'key': 'currencyCode', 'type': 'str'},
        'amount': {'key': 'amount', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RenewPropertiesResponseBillingCurrencyTotal, self).__init__(**kwargs)
        self.currency_code = kwargs.get('currency_code', None)
        self.amount = kwargs.get('amount', None)


class RenewPropertiesResponsePricingCurrencyTotal(msrest.serialization.Model):
    """Amount that Microsoft uses for record. Used during refund for calculating refund limit. Tax is not included. This is locked price 30 days before expiry.

    :param currency_code:
    :type currency_code: str
    :param amount:
    :type amount: float
    """

    _attribute_map = {
        'currency_code': {'key': 'currencyCode', 'type': 'str'},
        'amount': {'key': 'amount', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RenewPropertiesResponsePricingCurrencyTotal, self).__init__(**kwargs)
        self.currency_code = kwargs.get('currency_code', None)
        self.amount = kwargs.get('amount', None)


class ReservationList(msrest.serialization.Model):
    """ReservationList.

    :param value:
    :type value: list[~azure.mgmt.reservations.models.ReservationResponse]
    :param next_link: Url to get the next page of reservations.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ReservationResponse]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReservationList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ReservationMergeProperties(msrest.serialization.Model):
    """ReservationMergeProperties.

    :param merge_destination: Reservation Resource Id Created due to the merge. Format of the
     resource Id is
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}.
    :type merge_destination: str
    :param merge_sources: Resource Ids of the Source Reservation's merged to form this Reservation.
     Format of the resource Id is
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}.
    :type merge_sources: list[str]
    """

    _attribute_map = {
        'merge_destination': {'key': 'mergeDestination', 'type': 'str'},
        'merge_sources': {'key': 'mergeSources', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReservationMergeProperties, self).__init__(**kwargs)
        self.merge_destination = kwargs.get('merge_destination', None)
        self.merge_sources = kwargs.get('merge_sources', None)


class ReservationOrderBillingPlanInformation(msrest.serialization.Model):
    """Information describing the type of billing plan for this reservation.

    :param pricing_currency_total: Amount of money to be paid for the Order. Tax is not included.
    :type pricing_currency_total: ~azure.mgmt.reservations.models.Price
    :param start_date: Date when the billing plan has started.
    :type start_date: ~datetime.date
    :param next_payment_due_date: For recurring billing plans, indicates the date when next payment
     will be processed. Null when total is paid off.
    :type next_payment_due_date: ~datetime.date
    :param transactions:
    :type transactions: list[~azure.mgmt.reservations.models.PaymentDetail]
    """

    _attribute_map = {
        'pricing_currency_total': {'key': 'pricingCurrencyTotal', 'type': 'Price'},
        'start_date': {'key': 'startDate', 'type': 'date'},
        'next_payment_due_date': {'key': 'nextPaymentDueDate', 'type': 'date'},
        'transactions': {'key': 'transactions', 'type': '[PaymentDetail]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReservationOrderBillingPlanInformation, self).__init__(**kwargs)
        self.pricing_currency_total = kwargs.get('pricing_currency_total', None)
        self.start_date = kwargs.get('start_date', None)
        self.next_payment_due_date = kwargs.get('next_payment_due_date', None)
        self.transactions = kwargs.get('transactions', None)


class ReservationOrderList(msrest.serialization.Model):
    """ReservationOrderList.

    :param value:
    :type value: list[~azure.mgmt.reservations.models.ReservationOrderResponse]
    :param next_link: Url to get the next page of reservationOrders.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ReservationOrderResponse]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReservationOrderList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class ReservationOrderResponse(msrest.serialization.Model):
    """ReservationOrderResponse.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param etag:
    :type etag: int
    :ivar id: Identifier of the reservation.
    :vartype id: str
    :ivar name: Name of the reservation.
    :vartype name: str
    :ivar type: Type of resource. "Microsoft.Capacity/reservations".
    :vartype type: str
    :param display_name: Friendly name for user to easily identified the reservation.
    :type display_name: str
    :param request_date_time: This is the DateTime when the reservation was initially requested for
     purchase.
    :type request_date_time: ~datetime.datetime
    :param created_date_time: This is the DateTime when the reservation was created.
    :type created_date_time: ~datetime.datetime
    :param expiry_date: This is the date when the Reservation will expire.
    :type expiry_date: ~datetime.date
    :param original_quantity: Quantity of the SKUs that are part of the Reservation. Must be
     greater than zero.
    :type original_quantity: int
    :param term: Represent the term of Reservation. Possible values include: "P1Y", "P3Y".
    :type term: str or ~azure.mgmt.reservations.models.ReservationTerm
    :param provisioning_state: Current state of the reservation.
    :type provisioning_state: str
    :param billing_plan: Represent the billing plans. Possible values include: "Upfront",
     "Monthly".
    :type billing_plan: str or ~azure.mgmt.reservations.models.ReservationBillingPlan
    :param plan_information: Information describing the type of billing plan for this reservation.
    :type plan_information: ~azure.mgmt.reservations.models.ReservationOrderBillingPlanInformation
    :param reservations:
    :type reservations: list[~azure.mgmt.reservations.models.ReservationResponse]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'etag': {'key': 'etag', 'type': 'int'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'request_date_time': {'key': 'properties.requestDateTime', 'type': 'iso-8601'},
        'created_date_time': {'key': 'properties.createdDateTime', 'type': 'iso-8601'},
        'expiry_date': {'key': 'properties.expiryDate', 'type': 'date'},
        'original_quantity': {'key': 'properties.originalQuantity', 'type': 'int'},
        'term': {'key': 'properties.term', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'billing_plan': {'key': 'properties.billingPlan', 'type': 'str'},
        'plan_information': {'key': 'properties.planInformation', 'type': 'ReservationOrderBillingPlanInformation'},
        'reservations': {'key': 'properties.reservations', 'type': '[ReservationResponse]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReservationOrderResponse, self).__init__(**kwargs)
        self.etag = kwargs.get('etag', None)
        self.id = None
        self.name = None
        self.type = None
        self.display_name = kwargs.get('display_name', None)
        self.request_date_time = kwargs.get('request_date_time', None)
        self.created_date_time = kwargs.get('created_date_time', None)
        self.expiry_date = kwargs.get('expiry_date', None)
        self.original_quantity = kwargs.get('original_quantity', None)
        self.term = kwargs.get('term', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.billing_plan = kwargs.get('billing_plan', None)
        self.plan_information = kwargs.get('plan_information', None)
        self.reservations = kwargs.get('reservations', None)


class ReservationProperties(msrest.serialization.Model):
    """ReservationProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param reserved_resource_type: The type of the resource that is being reserved. Possible values
     include: "VirtualMachines", "SqlDatabases", "SuseLinux", "CosmosDb", "RedHat",
     "SqlDataWarehouse", "VMwareCloudSimple", "RedHatOsa", "Databricks", "AppService",
     "ManagedDisk", "BlockBlob", "RedisCache", "AzureDataExplorer", "MySql", "MariaDb",
     "PostgreSql", "DedicatedHost", "SapHana", "SqlAzureHybridBenefit".
    :type reserved_resource_type: str or ~azure.mgmt.reservations.models.ReservedResourceType
    :param instance_flexibility: Turning this on will apply the reservation discount to other VMs
     in the same VM size group. Only specify for VirtualMachines reserved resource type. Possible
     values include: "On", "Off".
    :type instance_flexibility: str or ~azure.mgmt.reservations.models.InstanceFlexibility
    :param display_name: Friendly name for user to easily identify the reservation.
    :type display_name: str
    :param applied_scopes: List of the subscriptions that the benefit will be applied. Do not
     specify if AppliedScopeType is Shared.
    :type applied_scopes: list[str]
    :param applied_scope_type: Type of the Applied Scope. Possible values include: "Single",
     "Shared".
    :type applied_scope_type: str or ~azure.mgmt.reservations.models.AppliedScopeType
    :param quantity: Quantity of the SKUs that are part of the Reservation. Must be greater than
     zero.
    :type quantity: int
    :param provisioning_state: Current state of the reservation.
    :type provisioning_state: str
    :param effective_date_time: DateTime of the Reservation starting when this version is effective
     from.
    :type effective_date_time: ~datetime.datetime
    :ivar last_updated_date_time: DateTime of the last time the Reservation was updated.
    :vartype last_updated_date_time: ~datetime.datetime
    :param expiry_date: This is the date when the Reservation will expire.
    :type expiry_date: ~datetime.date
    :param sku_description: Description of the SKU in english.
    :type sku_description: str
    :param extended_status_info:
    :type extended_status_info: ~azure.mgmt.reservations.models.ExtendedStatusInfo
    :param billing_plan: Represent the billing plans. Possible values include: "Upfront",
     "Monthly".
    :type billing_plan: str or ~azure.mgmt.reservations.models.ReservationBillingPlan
    :param split_properties:
    :type split_properties: ~azure.mgmt.reservations.models.ReservationSplitProperties
    :param merge_properties:
    :type merge_properties: ~azure.mgmt.reservations.models.ReservationMergeProperties
    :param billing_scope_id: Subscription that will be charged for purchasing Reservation.
    :type billing_scope_id: str
    :param renew: Setting this to true will automatically purchase a new reservation on the
     expiration date time.
    :type renew: bool
    :param renew_source: Reservation Id of the reservation from which this reservation is renewed.
     Format of the resource Id is
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}.
    :type renew_source: str
    :param renew_destination: Reservation Id of the reservation which is purchased because of
     renew. Format of the resource Id is
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}.
    :type renew_destination: str
    :param renew_properties:
    :type renew_properties: ~azure.mgmt.reservations.models.RenewPropertiesResponse
    :param term: Represent the term of Reservation. Possible values include: "P1Y", "P3Y".
    :type term: str or ~azure.mgmt.reservations.models.ReservationTerm
    """

    _validation = {
        'last_updated_date_time': {'readonly': True},
    }

    _attribute_map = {
        'reserved_resource_type': {'key': 'reservedResourceType', 'type': 'str'},
        'instance_flexibility': {'key': 'instanceFlexibility', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'applied_scopes': {'key': 'appliedScopes', 'type': '[str]'},
        'applied_scope_type': {'key': 'appliedScopeType', 'type': 'str'},
        'quantity': {'key': 'quantity', 'type': 'int'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'effective_date_time': {'key': 'effectiveDateTime', 'type': 'iso-8601'},
        'last_updated_date_time': {'key': 'lastUpdatedDateTime', 'type': 'iso-8601'},
        'expiry_date': {'key': 'expiryDate', 'type': 'date'},
        'sku_description': {'key': 'skuDescription', 'type': 'str'},
        'extended_status_info': {'key': 'extendedStatusInfo', 'type': 'ExtendedStatusInfo'},
        'billing_plan': {'key': 'billingPlan', 'type': 'str'},
        'split_properties': {'key': 'splitProperties', 'type': 'ReservationSplitProperties'},
        'merge_properties': {'key': 'mergeProperties', 'type': 'ReservationMergeProperties'},
        'billing_scope_id': {'key': 'billingScopeId', 'type': 'str'},
        'renew': {'key': 'renew', 'type': 'bool'},
        'renew_source': {'key': 'renewSource', 'type': 'str'},
        'renew_destination': {'key': 'renewDestination', 'type': 'str'},
        'renew_properties': {'key': 'renewProperties', 'type': 'RenewPropertiesResponse'},
        'term': {'key': 'term', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReservationProperties, self).__init__(**kwargs)
        self.reserved_resource_type = kwargs.get('reserved_resource_type', None)
        self.instance_flexibility = kwargs.get('instance_flexibility', None)
        self.display_name = kwargs.get('display_name', None)
        self.applied_scopes = kwargs.get('applied_scopes', None)
        self.applied_scope_type = kwargs.get('applied_scope_type', None)
        self.quantity = kwargs.get('quantity', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.effective_date_time = kwargs.get('effective_date_time', None)
        self.last_updated_date_time = None
        self.expiry_date = kwargs.get('expiry_date', None)
        self.sku_description = kwargs.get('sku_description', None)
        self.extended_status_info = kwargs.get('extended_status_info', None)
        self.billing_plan = kwargs.get('billing_plan', None)
        self.split_properties = kwargs.get('split_properties', None)
        self.merge_properties = kwargs.get('merge_properties', None)
        self.billing_scope_id = kwargs.get('billing_scope_id', None)
        self.renew = kwargs.get('renew', False)
        self.renew_source = kwargs.get('renew_source', None)
        self.renew_destination = kwargs.get('renew_destination', None)
        self.renew_properties = kwargs.get('renew_properties', None)
        self.term = kwargs.get('term', None)


class ReservationResponse(msrest.serialization.Model):
    """ReservationResponse.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: The Azure Region where the reserved resource lives.
    :vartype location: str
    :param etag:
    :type etag: int
    :ivar id: Identifier of the reservation.
    :vartype id: str
    :ivar name: Name of the reservation.
    :vartype name: str
    :param sku:
    :type sku: ~azure.mgmt.reservations.models.SkuName
    :param properties:
    :type properties: ~azure.mgmt.reservations.models.ReservationProperties
    :ivar type: Type of resource. "Microsoft.Capacity/reservationOrders/reservations".
    :vartype type: str
    """

    _validation = {
        'location': {'readonly': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'int'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'SkuName'},
        'properties': {'key': 'properties', 'type': 'ReservationProperties'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReservationResponse, self).__init__(**kwargs)
        self.location = None
        self.etag = kwargs.get('etag', None)
        self.id = None
        self.name = None
        self.sku = kwargs.get('sku', None)
        self.properties = kwargs.get('properties', None)
        self.type = None


class ReservationSplitProperties(msrest.serialization.Model):
    """ReservationSplitProperties.

    :param split_destinations: List of destination Resource Id that are created due to split.
     Format of the resource Id is
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}.
    :type split_destinations: list[str]
    :param split_source: Resource Id of the Reservation from which this is split. Format of the
     resource Id is
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}.
    :type split_source: str
    """

    _attribute_map = {
        'split_destinations': {'key': 'splitDestinations', 'type': '[str]'},
        'split_source': {'key': 'splitSource', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReservationSplitProperties, self).__init__(**kwargs)
        self.split_destinations = kwargs.get('split_destinations', None)
        self.split_source = kwargs.get('split_source', None)


class ReservationToExchange(msrest.serialization.Model):
    """Reservation refund details.

    :param reservation_id: Fully qualified id of the Reservation being returned.
    :type reservation_id: str
    :param quantity: Quantity to be returned.
    :type quantity: int
    :param billing_refund_amount:
    :type billing_refund_amount: ~azure.mgmt.reservations.models.Price
    :param billing_information: billing information.
    :type billing_information: ~azure.mgmt.reservations.models.BillingInformation
    """

    _attribute_map = {
        'reservation_id': {'key': 'reservationId', 'type': 'str'},
        'quantity': {'key': 'quantity', 'type': 'int'},
        'billing_refund_amount': {'key': 'billingRefundAmount', 'type': 'Price'},
        'billing_information': {'key': 'billingInformation', 'type': 'BillingInformation'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReservationToExchange, self).__init__(**kwargs)
        self.reservation_id = kwargs.get('reservation_id', None)
        self.quantity = kwargs.get('quantity', None)
        self.billing_refund_amount = kwargs.get('billing_refund_amount', None)
        self.billing_information = kwargs.get('billing_information', None)


class ReservationToPurchaseCalculateExchange(msrest.serialization.Model):
    """Reservation purchase details.

    :param properties:
    :type properties: ~azure.mgmt.reservations.models.PurchaseRequest
    :param billing_currency_total:
    :type billing_currency_total: ~azure.mgmt.reservations.models.Price
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'PurchaseRequest'},
        'billing_currency_total': {'key': 'billingCurrencyTotal', 'type': 'Price'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReservationToPurchaseCalculateExchange, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)
        self.billing_currency_total = kwargs.get('billing_currency_total', None)


class ReservationToPurchaseExchange(msrest.serialization.Model):
    """Reservation purchase details.

    :param reservation_order_id: Fully qualified id of the ReservationOrder being purchased.
    :type reservation_order_id: str
    :param reservation_id: Fully qualified id of the Reservation being purchased. This value is
     only guaranteed to be non-null if the purchase is successful.
    :type reservation_id: str
    :param properties:
    :type properties: ~azure.mgmt.reservations.models.PurchaseRequest
    :param billing_currency_total:
    :type billing_currency_total: ~azure.mgmt.reservations.models.Price
    :param status: Status of the individual operation. Possible values include: "Succeeded",
     "Failed", "Cancelled", "Pending".
    :type status: str or ~azure.mgmt.reservations.models.OperationStatus
    """

    _attribute_map = {
        'reservation_order_id': {'key': 'reservationOrderId', 'type': 'str'},
        'reservation_id': {'key': 'reservationId', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PurchaseRequest'},
        'billing_currency_total': {'key': 'billingCurrencyTotal', 'type': 'Price'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReservationToPurchaseExchange, self).__init__(**kwargs)
        self.reservation_order_id = kwargs.get('reservation_order_id', None)
        self.reservation_id = kwargs.get('reservation_id', None)
        self.properties = kwargs.get('properties', None)
        self.billing_currency_total = kwargs.get('billing_currency_total', None)
        self.status = kwargs.get('status', None)


class ReservationToReturn(msrest.serialization.Model):
    """Reservation to return.

    :param reservation_id: Fully qualified identifier of the Reservation being returned.
    :type reservation_id: str
    :param quantity: Quantity to be returned. Must be greater than zero.
    :type quantity: int
    """

    _attribute_map = {
        'reservation_id': {'key': 'reservationId', 'type': 'str'},
        'quantity': {'key': 'quantity', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReservationToReturn, self).__init__(**kwargs)
        self.reservation_id = kwargs.get('reservation_id', None)
        self.quantity = kwargs.get('quantity', None)


class ReservationToReturnForExchange(msrest.serialization.Model):
    """Reservation refund details.

    :param reservation_id: Fully qualified id of the Reservation being returned.
    :type reservation_id: str
    :param quantity: Quantity to be returned.
    :type quantity: int
    :param billing_refund_amount:
    :type billing_refund_amount: ~azure.mgmt.reservations.models.Price
    :param billing_information: billing information.
    :type billing_information: ~azure.mgmt.reservations.models.BillingInformation
    :param status: Status of the individual operation. Possible values include: "Succeeded",
     "Failed", "Cancelled", "Pending".
    :type status: str or ~azure.mgmt.reservations.models.OperationStatus
    """

    _attribute_map = {
        'reservation_id': {'key': 'reservationId', 'type': 'str'},
        'quantity': {'key': 'quantity', 'type': 'int'},
        'billing_refund_amount': {'key': 'billingRefundAmount', 'type': 'Price'},
        'billing_information': {'key': 'billingInformation', 'type': 'BillingInformation'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReservationToReturnForExchange, self).__init__(**kwargs)
        self.reservation_id = kwargs.get('reservation_id', None)
        self.quantity = kwargs.get('quantity', None)
        self.billing_refund_amount = kwargs.get('billing_refund_amount', None)
        self.billing_information = kwargs.get('billing_information', None)
        self.status = kwargs.get('status', None)


class ResourceName(msrest.serialization.Model):
    """Resource name provided by the resource provider. Use this property for quotaRequest parameter.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: Resource name.
    :type value: str
    :ivar localized_value: Resource display localized name.
    :vartype localized_value: str
    """

    _validation = {
        'localized_value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceName, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.localized_value = None


class ScopeProperties(msrest.serialization.Model):
    """ScopeProperties.

    :param scope:
    :type scope: str
    :param valid:
    :type valid: bool
    """

    _attribute_map = {
        'scope': {'key': 'scope', 'type': 'str'},
        'valid': {'key': 'valid', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScopeProperties, self).__init__(**kwargs)
        self.scope = kwargs.get('scope', None)
        self.valid = kwargs.get('valid', None)


class ServiceError(msrest.serialization.Model):
    """The API error details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param code: The error code.
    :type code: str
    :param message: The error message text.
    :type message: str
    :ivar details: The list of error details.
    :vartype details: list[~azure.mgmt.reservations.models.ServiceErrorDetail]
    """

    _validation = {
        'details': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ServiceErrorDetail]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.details = None


class ServiceErrorDetail(msrest.serialization.Model):
    """The error details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None


class SkuName(msrest.serialization.Model):
    """SkuName.

    :param name:
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuName, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class SkuProperty(msrest.serialization.Model):
    """SkuProperty.

    :param name: An invariant to describe the feature.
    :type name: str
    :param value: An invariant if the feature is measured by quantity.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuProperty, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class SkuRestriction(msrest.serialization.Model):
    """SkuRestriction.

    :param type: The type of restrictions.
    :type type: str
    :param values: The value of restrictions. If the restriction type is set to location. This
     would be different locations where the SKU is restricted.
    :type values: list[str]
    :param reason_code: The reason for restriction.
    :type reason_code: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
        'reason_code': {'key': 'reasonCode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuRestriction, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.values = kwargs.get('values', None)
        self.reason_code = kwargs.get('reason_code', None)


class SplitRequest(msrest.serialization.Model):
    """SplitRequest.

    :param quantities: List of the quantities in the new reservations to create.
    :type quantities: list[int]
    :param reservation_id: Resource id of the reservation to be split. Format of the resource id
     should be
     /providers/Microsoft.Capacity/reservationOrders/{reservationOrderId}/reservations/{reservationId}.
    :type reservation_id: str
    """

    _attribute_map = {
        'quantities': {'key': 'properties.quantities', 'type': '[int]'},
        'reservation_id': {'key': 'properties.reservationId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SplitRequest, self).__init__(**kwargs)
        self.quantities = kwargs.get('quantities', None)
        self.reservation_id = kwargs.get('reservation_id', None)


class SubRequest(msrest.serialization.Model):
    """The sub-request submitted with the quota request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar limit: Quota (resource limit).
    :vartype limit: int
    :param name: The resource name.
    :type name: ~azure.mgmt.reservations.models.ResourceName
    :ivar resource_type: Resource type for which the quota check was made.
    :vartype resource_type: str
    :param unit: The limit units, such as **count** and **bytes**. Use the unit field provided in
     the response of the GET quota operation.
    :type unit: str
    :param provisioning_state: The quota request status. Possible values include: "Accepted",
     "Invalid", "Succeeded", "Failed", "InProgress".
    :type provisioning_state: str or ~azure.mgmt.reservations.models.QuotaRequestState
    :ivar message: User-friendly status message.
    :vartype message: str
    :ivar sub_request_id: Sub request ID for individual request.
    :vartype sub_request_id: str
    """

    _validation = {
        'limit': {'readonly': True},
        'resource_type': {'readonly': True},
        'message': {'readonly': True},
        'sub_request_id': {'readonly': True},
    }

    _attribute_map = {
        'limit': {'key': 'limit', 'type': 'int'},
        'name': {'key': 'name', 'type': 'ResourceName'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'sub_request_id': {'key': 'subRequestId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubRequest, self).__init__(**kwargs)
        self.limit = None
        self.name = kwargs.get('name', None)
        self.resource_type = None
        self.unit = kwargs.get('unit', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.message = None
        self.sub_request_id = None


class SubscriptionScopeProperties(msrest.serialization.Model):
    """SubscriptionScopeProperties.

    :param scopes:
    :type scopes: list[~azure.mgmt.reservations.models.ScopeProperties]
    """

    _attribute_map = {
        'scopes': {'key': 'scopes', 'type': '[ScopeProperties]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubscriptionScopeProperties, self).__init__(**kwargs)
        self.scopes = kwargs.get('scopes', None)
