# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, TYPE_CHECKING

from msrest import Deserializer, Serializer

from azure.core import AsyncPipelineClient
from azure.core.rest import AsyncHttpResponse, HttpRequest

from .. import models
from ._configuration import FormRecognizerClientConfiguration
from .operations import DocumentClassifiersOperations, DocumentModelsOperations, MiscellaneousOperations

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential

class FormRecognizerClient:
    """Extracts content, layout, and structured data from documents.

    :ivar document_models: DocumentModelsOperations operations
    :vartype document_models:
     azure.ai.formrecognizer.v2023_02_28_preview.aio.operations.DocumentModelsOperations
    :ivar miscellaneous: MiscellaneousOperations operations
    :vartype miscellaneous:
     azure.ai.formrecognizer.v2023_02_28_preview.aio.operations.MiscellaneousOperations
    :ivar document_classifiers: DocumentClassifiersOperations operations
    :vartype document_classifiers:
     azure.ai.formrecognizer.v2023_02_28_preview.aio.operations.DocumentClassifiersOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param endpoint: Supported Cognitive Services endpoints (protocol and hostname, for
     example: https://westus2.api.cognitive.microsoft.com).
    :type endpoint: str
    :keyword api_version: Api Version. Default value is "2023-02-28-preview". Note that overriding
     this default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        endpoint: str,
        **kwargs: Any
    ) -> None:
        _base_url = '{endpoint}/formrecognizer'
        self._config = FormRecognizerClientConfiguration(credential=credential, endpoint=endpoint, **kwargs)
        self._client = AsyncPipelineClient(base_url=_base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.document_models = DocumentModelsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.miscellaneous = MiscellaneousOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.document_classifiers = DocumentClassifiersOperations(
            self._client, self._config, self._serialize, self._deserialize
        )


    def _send_request(
        self,
        request: HttpRequest,
        **kwargs: Any
    ) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client._send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/python/protocol/quickstart

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }

        request_copy.url = self._client.format_url(request_copy.url, **path_format_arguments)
        return self._client.send_request(request_copy, **kwargs)

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "FormRecognizerClient":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details) -> None:
        await self._client.__aexit__(*exc_details)
