# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class AzureMonitorMetricsDestination(_serialization.Model):
    """Azure Monitor Metrics destination.

    :ivar name: A friendly name for the destination.
     This name should be unique across all destinations (regardless of type) within the data
     collection rule.
    :vartype name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: A friendly name for the destination.
         This name should be unique across all destinations (regardless of type) within the data
         collection rule.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class DataCollectionRule(_serialization.Model):
    """Definition of what monitoring data to collect and where that data should be sent.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: Description of the data collection rule.
    :vartype description: str
    :ivar immutable_id: The immutable ID of this data collection rule. This property is READ-ONLY.
    :vartype immutable_id: str
    :ivar data_sources: The specification of data sources.
     This property is optional and can be omitted if the rule is meant to be used via direct calls
     to the provisioned endpoint.
    :vartype data_sources:
     ~azure.mgmt.monitor.v2019_11_01_preview.models.DataCollectionRuleDataSources
    :ivar destinations: The specification of destinations.
    :vartype destinations:
     ~azure.mgmt.monitor.v2019_11_01_preview.models.DataCollectionRuleDestinations
    :ivar data_flows: The specification of data flows.
    :vartype data_flows: list[~azure.mgmt.monitor.v2019_11_01_preview.models.DataFlow]
    :ivar provisioning_state: The resource provisioning state. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownDataCollectionRuleProvisioningState
    """

    _validation = {
        "immutable_id": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "immutable_id": {"key": "immutableId", "type": "str"},
        "data_sources": {"key": "dataSources", "type": "DataCollectionRuleDataSources"},
        "destinations": {"key": "destinations", "type": "DataCollectionRuleDestinations"},
        "data_flows": {"key": "dataFlows", "type": "[DataFlow]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        data_sources: Optional["_models.DataCollectionRuleDataSources"] = None,
        destinations: Optional["_models.DataCollectionRuleDestinations"] = None,
        data_flows: Optional[List["_models.DataFlow"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: Description of the data collection rule.
        :paramtype description: str
        :keyword data_sources: The specification of data sources.
         This property is optional and can be omitted if the rule is meant to be used via direct calls
         to the provisioned endpoint.
        :paramtype data_sources:
         ~azure.mgmt.monitor.v2019_11_01_preview.models.DataCollectionRuleDataSources
        :keyword destinations: The specification of destinations.
        :paramtype destinations:
         ~azure.mgmt.monitor.v2019_11_01_preview.models.DataCollectionRuleDestinations
        :keyword data_flows: The specification of data flows.
        :paramtype data_flows: list[~azure.mgmt.monitor.v2019_11_01_preview.models.DataFlow]
        """
        super().__init__(**kwargs)
        self.description = description
        self.immutable_id = None
        self.data_sources = data_sources
        self.destinations = destinations
        self.data_flows = data_flows
        self.provisioning_state = None


class DataCollectionRuleAssociation(_serialization.Model):
    """Definition of association of a data collection rule with a monitored Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: Description of the association.
    :vartype description: str
    :ivar data_collection_rule_id: The resource ID of the data collection rule that is to be
     associated.
    :vartype data_collection_rule_id: str
    :ivar provisioning_state: The resource provisioning state. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownDataCollectionRuleAssociationProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "data_collection_rule_id": {"key": "dataCollectionRuleId", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self, *, description: Optional[str] = None, data_collection_rule_id: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword description: Description of the association.
        :paramtype description: str
        :keyword data_collection_rule_id: The resource ID of the data collection rule that is to be
         associated.
        :paramtype data_collection_rule_id: str
        """
        super().__init__(**kwargs)
        self.description = description
        self.data_collection_rule_id = data_collection_rule_id
        self.provisioning_state = None


class DataCollectionRuleAssociationProxyOnlyResource(_serialization.Model):
    """Definition of generic ARM proxy resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: Resource entity tag (ETag).
    :vartype etag: str
    :ivar description: Description of the association.
    :vartype description: str
    :ivar data_collection_rule_id: The resource ID of the data collection rule that is to be
     associated.
    :vartype data_collection_rule_id: str
    :ivar provisioning_state: The resource provisioning state. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownDataCollectionRuleAssociationProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "data_collection_rule_id": {"key": "properties.dataCollectionRuleId", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self, *, description: Optional[str] = None, data_collection_rule_id: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword description: Description of the association.
        :paramtype description: str
        :keyword data_collection_rule_id: The resource ID of the data collection rule that is to be
         associated.
        :paramtype data_collection_rule_id: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.etag = None
        self.description = description
        self.data_collection_rule_id = data_collection_rule_id
        self.provisioning_state = None


class DataCollectionRuleAssociationProxyOnlyResourceListResult(_serialization.Model):
    """A pageable list of resources.

    All required parameters must be populated in order to send to Azure.

    :ivar value: A list of resources. Required.
    :vartype value:
     list[~azure.mgmt.monitor.v2019_11_01_preview.models.DataCollectionRuleAssociationProxyOnlyResource]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DataCollectionRuleAssociationProxyOnlyResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: List["_models.DataCollectionRuleAssociationProxyOnlyResource"],
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of resources. Required.
        :paramtype value:
         list[~azure.mgmt.monitor.v2019_11_01_preview.models.DataCollectionRuleAssociationProxyOnlyResource]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DataCollectionRuleAssociationProxyOnlyResourceProperties(DataCollectionRuleAssociation):
    """Resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: Description of the association.
    :vartype description: str
    :ivar data_collection_rule_id: The resource ID of the data collection rule that is to be
     associated.
    :vartype data_collection_rule_id: str
    :ivar provisioning_state: The resource provisioning state. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownDataCollectionRuleAssociationProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "data_collection_rule_id": {"key": "dataCollectionRuleId", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self, *, description: Optional[str] = None, data_collection_rule_id: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword description: Description of the association.
        :paramtype description: str
        :keyword data_collection_rule_id: The resource ID of the data collection rule that is to be
         associated.
        :paramtype data_collection_rule_id: str
        """
        super().__init__(description=description, data_collection_rule_id=data_collection_rule_id, **kwargs)


class DataSourcesSpec(_serialization.Model):
    """Specification of data sources that will be collected.

    :ivar performance_counters: The list of performance counter data source configurations.
    :vartype performance_counters:
     list[~azure.mgmt.monitor.v2019_11_01_preview.models.PerfCounterDataSource]
    :ivar windows_event_logs: The list of Windows Event Log data source configurations.
    :vartype windows_event_logs:
     list[~azure.mgmt.monitor.v2019_11_01_preview.models.WindowsEventLogDataSource]
    :ivar syslog: The list of Syslog data source configurations.
    :vartype syslog: list[~azure.mgmt.monitor.v2019_11_01_preview.models.SyslogDataSource]
    :ivar extensions: The list of Azure VM extension data source configurations.
    :vartype extensions: list[~azure.mgmt.monitor.v2019_11_01_preview.models.ExtensionDataSource]
    """

    _attribute_map = {
        "performance_counters": {"key": "performanceCounters", "type": "[PerfCounterDataSource]"},
        "windows_event_logs": {"key": "windowsEventLogs", "type": "[WindowsEventLogDataSource]"},
        "syslog": {"key": "syslog", "type": "[SyslogDataSource]"},
        "extensions": {"key": "extensions", "type": "[ExtensionDataSource]"},
    }

    def __init__(
        self,
        *,
        performance_counters: Optional[List["_models.PerfCounterDataSource"]] = None,
        windows_event_logs: Optional[List["_models.WindowsEventLogDataSource"]] = None,
        syslog: Optional[List["_models.SyslogDataSource"]] = None,
        extensions: Optional[List["_models.ExtensionDataSource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword performance_counters: The list of performance counter data source configurations.
        :paramtype performance_counters:
         list[~azure.mgmt.monitor.v2019_11_01_preview.models.PerfCounterDataSource]
        :keyword windows_event_logs: The list of Windows Event Log data source configurations.
        :paramtype windows_event_logs:
         list[~azure.mgmt.monitor.v2019_11_01_preview.models.WindowsEventLogDataSource]
        :keyword syslog: The list of Syslog data source configurations.
        :paramtype syslog: list[~azure.mgmt.monitor.v2019_11_01_preview.models.SyslogDataSource]
        :keyword extensions: The list of Azure VM extension data source configurations.
        :paramtype extensions: list[~azure.mgmt.monitor.v2019_11_01_preview.models.ExtensionDataSource]
        """
        super().__init__(**kwargs)
        self.performance_counters = performance_counters
        self.windows_event_logs = windows_event_logs
        self.syslog = syslog
        self.extensions = extensions


class DataCollectionRuleDataSources(DataSourcesSpec):
    """The specification of data sources.
    This property is optional and can be omitted if the rule is meant to be used via direct calls
    to the provisioned endpoint.

    :ivar performance_counters: The list of performance counter data source configurations.
    :vartype performance_counters:
     list[~azure.mgmt.monitor.v2019_11_01_preview.models.PerfCounterDataSource]
    :ivar windows_event_logs: The list of Windows Event Log data source configurations.
    :vartype windows_event_logs:
     list[~azure.mgmt.monitor.v2019_11_01_preview.models.WindowsEventLogDataSource]
    :ivar syslog: The list of Syslog data source configurations.
    :vartype syslog: list[~azure.mgmt.monitor.v2019_11_01_preview.models.SyslogDataSource]
    :ivar extensions: The list of Azure VM extension data source configurations.
    :vartype extensions: list[~azure.mgmt.monitor.v2019_11_01_preview.models.ExtensionDataSource]
    """

    _attribute_map = {
        "performance_counters": {"key": "performanceCounters", "type": "[PerfCounterDataSource]"},
        "windows_event_logs": {"key": "windowsEventLogs", "type": "[WindowsEventLogDataSource]"},
        "syslog": {"key": "syslog", "type": "[SyslogDataSource]"},
        "extensions": {"key": "extensions", "type": "[ExtensionDataSource]"},
    }

    def __init__(
        self,
        *,
        performance_counters: Optional[List["_models.PerfCounterDataSource"]] = None,
        windows_event_logs: Optional[List["_models.WindowsEventLogDataSource"]] = None,
        syslog: Optional[List["_models.SyslogDataSource"]] = None,
        extensions: Optional[List["_models.ExtensionDataSource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword performance_counters: The list of performance counter data source configurations.
        :paramtype performance_counters:
         list[~azure.mgmt.monitor.v2019_11_01_preview.models.PerfCounterDataSource]
        :keyword windows_event_logs: The list of Windows Event Log data source configurations.
        :paramtype windows_event_logs:
         list[~azure.mgmt.monitor.v2019_11_01_preview.models.WindowsEventLogDataSource]
        :keyword syslog: The list of Syslog data source configurations.
        :paramtype syslog: list[~azure.mgmt.monitor.v2019_11_01_preview.models.SyslogDataSource]
        :keyword extensions: The list of Azure VM extension data source configurations.
        :paramtype extensions: list[~azure.mgmt.monitor.v2019_11_01_preview.models.ExtensionDataSource]
        """
        super().__init__(
            performance_counters=performance_counters,
            windows_event_logs=windows_event_logs,
            syslog=syslog,
            extensions=extensions,
            **kwargs
        )


class DestinationsSpec(_serialization.Model):
    """Specification of destinations that can be used in data flows.

    :ivar log_analytics: List of Log Analytics destinations.
    :vartype log_analytics:
     list[~azure.mgmt.monitor.v2019_11_01_preview.models.LogAnalyticsDestination]
    :ivar azure_monitor_metrics: Azure Monitor Metrics destination.
    :vartype azure_monitor_metrics:
     ~azure.mgmt.monitor.v2019_11_01_preview.models.DestinationsSpecAzureMonitorMetrics
    """

    _attribute_map = {
        "log_analytics": {"key": "logAnalytics", "type": "[LogAnalyticsDestination]"},
        "azure_monitor_metrics": {"key": "azureMonitorMetrics", "type": "DestinationsSpecAzureMonitorMetrics"},
    }

    def __init__(
        self,
        *,
        log_analytics: Optional[List["_models.LogAnalyticsDestination"]] = None,
        azure_monitor_metrics: Optional["_models.DestinationsSpecAzureMonitorMetrics"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword log_analytics: List of Log Analytics destinations.
        :paramtype log_analytics:
         list[~azure.mgmt.monitor.v2019_11_01_preview.models.LogAnalyticsDestination]
        :keyword azure_monitor_metrics: Azure Monitor Metrics destination.
        :paramtype azure_monitor_metrics:
         ~azure.mgmt.monitor.v2019_11_01_preview.models.DestinationsSpecAzureMonitorMetrics
        """
        super().__init__(**kwargs)
        self.log_analytics = log_analytics
        self.azure_monitor_metrics = azure_monitor_metrics


class DataCollectionRuleDestinations(DestinationsSpec):
    """The specification of destinations.

    :ivar log_analytics: List of Log Analytics destinations.
    :vartype log_analytics:
     list[~azure.mgmt.monitor.v2019_11_01_preview.models.LogAnalyticsDestination]
    :ivar azure_monitor_metrics: Azure Monitor Metrics destination.
    :vartype azure_monitor_metrics:
     ~azure.mgmt.monitor.v2019_11_01_preview.models.DestinationsSpecAzureMonitorMetrics
    """

    _attribute_map = {
        "log_analytics": {"key": "logAnalytics", "type": "[LogAnalyticsDestination]"},
        "azure_monitor_metrics": {"key": "azureMonitorMetrics", "type": "DestinationsSpecAzureMonitorMetrics"},
    }

    def __init__(
        self,
        *,
        log_analytics: Optional[List["_models.LogAnalyticsDestination"]] = None,
        azure_monitor_metrics: Optional["_models.DestinationsSpecAzureMonitorMetrics"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword log_analytics: List of Log Analytics destinations.
        :paramtype log_analytics:
         list[~azure.mgmt.monitor.v2019_11_01_preview.models.LogAnalyticsDestination]
        :keyword azure_monitor_metrics: Azure Monitor Metrics destination.
        :paramtype azure_monitor_metrics:
         ~azure.mgmt.monitor.v2019_11_01_preview.models.DestinationsSpecAzureMonitorMetrics
        """
        super().__init__(log_analytics=log_analytics, azure_monitor_metrics=azure_monitor_metrics, **kwargs)


class DataCollectionRuleResource(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Definition of ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar kind: The kind of the resource. Known values are: "Linux" and "Windows".
    :vartype kind: str or
     ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownDataCollectionRuleResourceKind
    :ivar id: Fully qualified ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: Resource entity tag (ETag).
    :vartype etag: str
    :ivar description: Description of the data collection rule.
    :vartype description: str
    :ivar immutable_id: The immutable ID of this data collection rule. This property is READ-ONLY.
    :vartype immutable_id: str
    :ivar data_sources: The specification of data sources.
     This property is optional and can be omitted if the rule is meant to be used via direct calls
     to the provisioned endpoint.
    :vartype data_sources:
     ~azure.mgmt.monitor.v2019_11_01_preview.models.DataCollectionRuleDataSources
    :ivar destinations: The specification of destinations.
    :vartype destinations:
     ~azure.mgmt.monitor.v2019_11_01_preview.models.DataCollectionRuleDestinations
    :ivar data_flows: The specification of data flows.
    :vartype data_flows: list[~azure.mgmt.monitor.v2019_11_01_preview.models.DataFlow]
    :ivar provisioning_state: The resource provisioning state. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownDataCollectionRuleProvisioningState
    """

    _validation = {
        "location": {"required": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "immutable_id": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "kind": {"key": "kind", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "immutable_id": {"key": "properties.immutableId", "type": "str"},
        "data_sources": {"key": "properties.dataSources", "type": "DataCollectionRuleDataSources"},
        "destinations": {"key": "properties.destinations", "type": "DataCollectionRuleDestinations"},
        "data_flows": {"key": "properties.dataFlows", "type": "[DataFlow]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        kind: Optional[Union[str, "_models.KnownDataCollectionRuleResourceKind"]] = None,
        description: Optional[str] = None,
        data_sources: Optional["_models.DataCollectionRuleDataSources"] = None,
        destinations: Optional["_models.DataCollectionRuleDestinations"] = None,
        data_flows: Optional[List["_models.DataFlow"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword kind: The kind of the resource. Known values are: "Linux" and "Windows".
        :paramtype kind: str or
         ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownDataCollectionRuleResourceKind
        :keyword description: Description of the data collection rule.
        :paramtype description: str
        :keyword data_sources: The specification of data sources.
         This property is optional and can be omitted if the rule is meant to be used via direct calls
         to the provisioned endpoint.
        :paramtype data_sources:
         ~azure.mgmt.monitor.v2019_11_01_preview.models.DataCollectionRuleDataSources
        :keyword destinations: The specification of destinations.
        :paramtype destinations:
         ~azure.mgmt.monitor.v2019_11_01_preview.models.DataCollectionRuleDestinations
        :keyword data_flows: The specification of data flows.
        :paramtype data_flows: list[~azure.mgmt.monitor.v2019_11_01_preview.models.DataFlow]
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.kind = kind
        self.id = None
        self.name = None
        self.type = None
        self.etag = None
        self.description = description
        self.immutable_id = None
        self.data_sources = data_sources
        self.destinations = destinations
        self.data_flows = data_flows
        self.provisioning_state = None


class DataCollectionRuleResourceListResult(_serialization.Model):
    """A pageable list of resources.

    All required parameters must be populated in order to send to Azure.

    :ivar value: A list of resources. Required.
    :vartype value: list[~azure.mgmt.monitor.v2019_11_01_preview.models.DataCollectionRuleResource]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DataCollectionRuleResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.DataCollectionRuleResource"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of resources. Required.
        :paramtype value:
         list[~azure.mgmt.monitor.v2019_11_01_preview.models.DataCollectionRuleResource]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DataCollectionRuleResourceProperties(DataCollectionRule):
    """Resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: Description of the data collection rule.
    :vartype description: str
    :ivar immutable_id: The immutable ID of this data collection rule. This property is READ-ONLY.
    :vartype immutable_id: str
    :ivar data_sources: The specification of data sources.
     This property is optional and can be omitted if the rule is meant to be used via direct calls
     to the provisioned endpoint.
    :vartype data_sources:
     ~azure.mgmt.monitor.v2019_11_01_preview.models.DataCollectionRuleDataSources
    :ivar destinations: The specification of destinations.
    :vartype destinations:
     ~azure.mgmt.monitor.v2019_11_01_preview.models.DataCollectionRuleDestinations
    :ivar data_flows: The specification of data flows.
    :vartype data_flows: list[~azure.mgmt.monitor.v2019_11_01_preview.models.DataFlow]
    :ivar provisioning_state: The resource provisioning state. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownDataCollectionRuleProvisioningState
    """

    _validation = {
        "immutable_id": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "immutable_id": {"key": "immutableId", "type": "str"},
        "data_sources": {"key": "dataSources", "type": "DataCollectionRuleDataSources"},
        "destinations": {"key": "destinations", "type": "DataCollectionRuleDestinations"},
        "data_flows": {"key": "dataFlows", "type": "[DataFlow]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        data_sources: Optional["_models.DataCollectionRuleDataSources"] = None,
        destinations: Optional["_models.DataCollectionRuleDestinations"] = None,
        data_flows: Optional[List["_models.DataFlow"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: Description of the data collection rule.
        :paramtype description: str
        :keyword data_sources: The specification of data sources.
         This property is optional and can be omitted if the rule is meant to be used via direct calls
         to the provisioned endpoint.
        :paramtype data_sources:
         ~azure.mgmt.monitor.v2019_11_01_preview.models.DataCollectionRuleDataSources
        :keyword destinations: The specification of destinations.
        :paramtype destinations:
         ~azure.mgmt.monitor.v2019_11_01_preview.models.DataCollectionRuleDestinations
        :keyword data_flows: The specification of data flows.
        :paramtype data_flows: list[~azure.mgmt.monitor.v2019_11_01_preview.models.DataFlow]
        """
        super().__init__(
            description=description,
            data_sources=data_sources,
            destinations=destinations,
            data_flows=data_flows,
            **kwargs
        )


class DataFlow(_serialization.Model):
    """Definition of which streams are sent to which destinations.

    :ivar streams: List of streams for this data flow.
    :vartype streams: list[str or
     ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownDataFlowStreams]
    :ivar destinations: List of destinations for this data flow.
    :vartype destinations: list[str]
    """

    _attribute_map = {
        "streams": {"key": "streams", "type": "[str]"},
        "destinations": {"key": "destinations", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        streams: Optional[List[Union[str, "_models.KnownDataFlowStreams"]]] = None,
        destinations: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword streams: List of streams for this data flow.
        :paramtype streams: list[str or
         ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownDataFlowStreams]
        :keyword destinations: List of destinations for this data flow.
        :paramtype destinations: list[str]
        """
        super().__init__(**kwargs)
        self.streams = streams
        self.destinations = destinations


class DestinationsSpecAzureMonitorMetrics(AzureMonitorMetricsDestination):
    """Azure Monitor Metrics destination.

    :ivar name: A friendly name for the destination.
     This name should be unique across all destinations (regardless of type) within the data
     collection rule.
    :vartype name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: A friendly name for the destination.
         This name should be unique across all destinations (regardless of type) within the data
         collection rule.
        :paramtype name: str
        """
        super().__init__(name=name, **kwargs)


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.monitor.v2019_11_01_preview.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.monitor.v2019_11_01_preview.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.monitor.v2019_11_01_preview.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.monitor.v2019_11_01_preview.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class ExtensionDataSource(_serialization.Model):
    """Definition of which data will be collected from a separate VM extension that integrates with
    the Azure Monitor Agent.
    Collected from either Windows and Linux machines, depending on which extension is defined.

    All required parameters must be populated in order to send to Azure.

    :ivar streams: List of streams that this data source will be sent to.
     A stream indicates what schema will be used for this data and usually what table in Log
     Analytics the data will be sent to.
    :vartype streams: list[str or
     ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownExtensionDataSourceStreams]
    :ivar extension_name: The name of the VM extension. Required.
    :vartype extension_name: str
    :ivar extension_settings: The extension settings. The format is specific for particular
     extension.
    :vartype extension_settings: JSON
    :ivar input_data_sources: The list of data sources this extension needs data from.
    :vartype input_data_sources: list[str]
    :ivar name: A friendly name for the data source.
     This name should be unique across all data sources (regardless of type) within the data
     collection rule.
    :vartype name: str
    """

    _validation = {
        "extension_name": {"required": True},
    }

    _attribute_map = {
        "streams": {"key": "streams", "type": "[str]"},
        "extension_name": {"key": "extensionName", "type": "str"},
        "extension_settings": {"key": "extensionSettings", "type": "object"},
        "input_data_sources": {"key": "inputDataSources", "type": "[str]"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        extension_name: str,
        streams: Optional[List[Union[str, "_models.KnownExtensionDataSourceStreams"]]] = None,
        extension_settings: Optional[JSON] = None,
        input_data_sources: Optional[List[str]] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword streams: List of streams that this data source will be sent to.
         A stream indicates what schema will be used for this data and usually what table in Log
         Analytics the data will be sent to.
        :paramtype streams: list[str or
         ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownExtensionDataSourceStreams]
        :keyword extension_name: The name of the VM extension. Required.
        :paramtype extension_name: str
        :keyword extension_settings: The extension settings. The format is specific for particular
         extension.
        :paramtype extension_settings: JSON
        :keyword input_data_sources: The list of data sources this extension needs data from.
        :paramtype input_data_sources: list[str]
        :keyword name: A friendly name for the data source.
         This name should be unique across all data sources (regardless of type) within the data
         collection rule.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.streams = streams
        self.extension_name = extension_name
        self.extension_settings = extension_settings
        self.input_data_sources = input_data_sources
        self.name = name


class LogAnalyticsDestination(_serialization.Model):
    """Log Analytics destination.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar workspace_resource_id: The resource ID of the Log Analytics workspace.
    :vartype workspace_resource_id: str
    :ivar workspace_id: The Customer ID of the Log Analytics workspace.
    :vartype workspace_id: str
    :ivar name: A friendly name for the destination.
     This name should be unique across all destinations (regardless of type) within the data
     collection rule.
    :vartype name: str
    """

    _validation = {
        "workspace_id": {"readonly": True},
    }

    _attribute_map = {
        "workspace_resource_id": {"key": "workspaceResourceId", "type": "str"},
        "workspace_id": {"key": "workspaceId", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self, *, workspace_resource_id: Optional[str] = None, name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword workspace_resource_id: The resource ID of the Log Analytics workspace.
        :paramtype workspace_resource_id: str
        :keyword name: A friendly name for the destination.
         This name should be unique across all destinations (regardless of type) within the data
         collection rule.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.workspace_resource_id = workspace_resource_id
        self.workspace_id = None
        self.name = name


class PerfCounterDataSource(_serialization.Model):
    """Definition of which performance counters will be collected and how they will be collected by
    this data collection rule.
    Collected from both Windows and Linux machines where the counter is present.

    :ivar streams: List of streams that this data source will be sent to.
     A stream indicates what schema will be used for this data and usually what table in Log
     Analytics the data will be sent to.
    :vartype streams: list[str or
     ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownPerfCounterDataSourceStreams]
    :ivar sampling_frequency_in_seconds: The number of seconds between consecutive counter
     measurements (samples).
    :vartype sampling_frequency_in_seconds: int
    :ivar counter_specifiers: A list of specifier names of the performance counters you want to
     collect.
     Use a wildcard (*) to collect a counter for all instances.
     To get a list of performance counters on Windows, run the command 'typeperf'.
    :vartype counter_specifiers: list[str]
    :ivar name: A friendly name for the data source.
     This name should be unique across all data sources (regardless of type) within the data
     collection rule.
    :vartype name: str
    """

    _attribute_map = {
        "streams": {"key": "streams", "type": "[str]"},
        "sampling_frequency_in_seconds": {"key": "samplingFrequencyInSeconds", "type": "int"},
        "counter_specifiers": {"key": "counterSpecifiers", "type": "[str]"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        streams: Optional[List[Union[str, "_models.KnownPerfCounterDataSourceStreams"]]] = None,
        sampling_frequency_in_seconds: Optional[int] = None,
        counter_specifiers: Optional[List[str]] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword streams: List of streams that this data source will be sent to.
         A stream indicates what schema will be used for this data and usually what table in Log
         Analytics the data will be sent to.
        :paramtype streams: list[str or
         ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownPerfCounterDataSourceStreams]
        :keyword sampling_frequency_in_seconds: The number of seconds between consecutive counter
         measurements (samples).
        :paramtype sampling_frequency_in_seconds: int
        :keyword counter_specifiers: A list of specifier names of the performance counters you want to
         collect.
         Use a wildcard (*) to collect a counter for all instances.
         To get a list of performance counters on Windows, run the command 'typeperf'.
        :paramtype counter_specifiers: list[str]
        :keyword name: A friendly name for the data source.
         This name should be unique across all data sources (regardless of type) within the data
         collection rule.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.streams = streams
        self.sampling_frequency_in_seconds = sampling_frequency_in_seconds
        self.counter_specifiers = counter_specifiers
        self.name = name


class ResourceForUpdate(_serialization.Model):
    """Definition of ARM tracked top level resource properties for update operation.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class SyslogDataSource(_serialization.Model):
    """Definition of which syslog data will be collected and how it will be collected.
    Only collected from Linux machines.

    :ivar streams: List of streams that this data source will be sent to.
     A stream indicates what schema will be used for this data and usually what table in Log
     Analytics the data will be sent to.
    :vartype streams: list[str or
     ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownSyslogDataSourceStreams]
    :ivar facility_names: The list of facility names.
    :vartype facility_names: list[str or
     ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownSyslogDataSourceFacilityNames]
    :ivar log_levels: The log levels to collect.
    :vartype log_levels: list[str or
     ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownSyslogDataSourceLogLevels]
    :ivar name: A friendly name for the data source.
     This name should be unique across all data sources (regardless of type) within the data
     collection rule.
    :vartype name: str
    """

    _attribute_map = {
        "streams": {"key": "streams", "type": "[str]"},
        "facility_names": {"key": "facilityNames", "type": "[str]"},
        "log_levels": {"key": "logLevels", "type": "[str]"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        streams: Optional[List[Union[str, "_models.KnownSyslogDataSourceStreams"]]] = None,
        facility_names: Optional[List[Union[str, "_models.KnownSyslogDataSourceFacilityNames"]]] = None,
        log_levels: Optional[List[Union[str, "_models.KnownSyslogDataSourceLogLevels"]]] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword streams: List of streams that this data source will be sent to.
         A stream indicates what schema will be used for this data and usually what table in Log
         Analytics the data will be sent to.
        :paramtype streams: list[str or
         ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownSyslogDataSourceStreams]
        :keyword facility_names: The list of facility names.
        :paramtype facility_names: list[str or
         ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownSyslogDataSourceFacilityNames]
        :keyword log_levels: The log levels to collect.
        :paramtype log_levels: list[str or
         ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownSyslogDataSourceLogLevels]
        :keyword name: A friendly name for the data source.
         This name should be unique across all data sources (regardless of type) within the data
         collection rule.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.streams = streams
        self.facility_names = facility_names
        self.log_levels = log_levels
        self.name = name


class WindowsEventLogDataSource(_serialization.Model):
    """Definition of which Windows Event Log events will be collected and how they will be collected.
    Only collected from Windows machines.

    :ivar streams: List of streams that this data source will be sent to.
     A stream indicates what schema will be used for this data and usually what table in Log
     Analytics the data will be sent to.
    :vartype streams: list[str or
     ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownWindowsEventLogDataSourceStreams]
    :ivar x_path_queries: A list of Windows Event Log queries in XPATH format.
    :vartype x_path_queries: list[str]
    :ivar name: A friendly name for the data source.
     This name should be unique across all data sources (regardless of type) within the data
     collection rule.
    :vartype name: str
    """

    _attribute_map = {
        "streams": {"key": "streams", "type": "[str]"},
        "x_path_queries": {"key": "xPathQueries", "type": "[str]"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        streams: Optional[List[Union[str, "_models.KnownWindowsEventLogDataSourceStreams"]]] = None,
        x_path_queries: Optional[List[str]] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword streams: List of streams that this data source will be sent to.
         A stream indicates what schema will be used for this data and usually what table in Log
         Analytics the data will be sent to.
        :paramtype streams: list[str or
         ~azure.mgmt.monitor.v2019_11_01_preview.models.KnownWindowsEventLogDataSourceStreams]
        :keyword x_path_queries: A list of Windows Event Log queries in XPATH format.
        :paramtype x_path_queries: list[str]
        :keyword name: A friendly name for the data source.
         This name should be unique across all data sources (regardless of type) within the data
         collection rule.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.streams = streams
        self.x_path_queries = x_path_queries
        self.name = name
