# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.resource import ResourceManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestResourceManagementTagsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ResourceManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tags_delete_value(self, resource_group):
        response = self.client.tags.delete_value(
            tag_name="str",
            tag_value="str",
            api_version="2022-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tags_create_or_update_value(self, resource_group):
        response = self.client.tags.create_or_update_value(
            tag_name="str",
            tag_value="str",
            api_version="2022-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tags_create_or_update(self, resource_group):
        response = self.client.tags.create_or_update(
            tag_name="str",
            api_version="2022-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tags_delete(self, resource_group):
        response = self.client.tags.delete(
            tag_name="str",
            api_version="2022-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tags_list(self, resource_group):
        response = self.client.tags.list(
            api_version="2022-09-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tags_begin_create_or_update_at_scope(self, resource_group):
        response = self.client.tags.begin_create_or_update_at_scope(
            scope="str",
            parameters={"properties": {"tags": {"str": "str"}}, "id": "str", "name": "str", "type": "str"},
            api_version="2022-09-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tags_begin_update_at_scope(self, resource_group):
        response = self.client.tags.begin_update_at_scope(
            scope="str",
            parameters={"operation": "str", "properties": {"tags": {"str": "str"}}},
            api_version="2022-09-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tags_get_at_scope(self, resource_group):
        response = self.client.tags.get_at_scope(
            scope="str",
            api_version="2022-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tags_begin_delete_at_scope(self, resource_group):
        response = self.client.tags.begin_delete_at_scope(
            scope="str",
            api_version="2022-09-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
