# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    from .. import models as _models


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.applicationinsights.v2024_02_01_preview.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.applicationinsights.v2024_02_01_preview.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class DeletedWorkbookResource(TrackedResource):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.applicationinsights.v2024_02_01_preview.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar kind: The kind of workbook. Only valid value is shared. "shared"
    :vartype kind: str or
     ~azure.mgmt.applicationinsights.v2024_02_01_preview.models.WorkbookSharedTypeKind
    :ivar etag: Resource etag.
    :vartype etag: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        kind: Optional[Union[str, "_models.WorkbookSharedTypeKind"]] = None,
        etag: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword kind: The kind of workbook. Only valid value is shared. "shared"
        :paramtype kind: str or
         ~azure.mgmt.applicationinsights.v2024_02_01_preview.models.WorkbookSharedTypeKind
        :keyword etag: Resource etag.
        :paramtype etag: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.kind = kind
        self.etag = etag


class DeletedWorkbook(DeletedWorkbookResource):
    """A workbook definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.applicationinsights.v2024_02_01_preview.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar kind: The kind of workbook. Only valid value is shared. "shared"
    :vartype kind: str or
     ~azure.mgmt.applicationinsights.v2024_02_01_preview.models.WorkbookSharedTypeKind
    :ivar etag: Resource etag.
    :vartype etag: str
    :ivar display_name: The user-defined name (display name) of the workbook.
    :vartype display_name: str
    :ivar serialized_data: Configuration of this particular workbook. Configuration data is a
     string containing valid JSON.
    :vartype serialized_data: str
    :ivar version: Workbook schema version format, like 'Notebook/1.0', which should match the
     workbook in serializedData.
    :vartype version: str
    :ivar time_modified: Date and time in UTC of the last modification that was made to this
     workbook definition.
    :vartype time_modified: ~datetime.datetime
    :ivar category: Workbook category, as defined by the user at creation time.
    :vartype category: str
    :ivar tags_properties_tags: Being deprecated, please use the other tags field.
    :vartype tags_properties_tags: list[str]
    :ivar user_id: Unique user id of the specific user that owns this workbook.
    :vartype user_id: str
    :ivar source_id: ResourceId for a source resource.
    :vartype source_id: str
    :ivar storage_uri: The resourceId to the storage account when bring your own storage is used.
    :vartype storage_uri: str
    :ivar description: The description of the workbook.
    :vartype description: str
    :ivar revision: The unique revision id for this workbook definition.
    :vartype revision: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "time_modified": {"readonly": True},
        "user_id": {"readonly": True},
        "revision": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "serialized_data": {"key": "properties.serializedData", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "time_modified": {"key": "properties.timeModified", "type": "iso-8601"},
        "category": {"key": "properties.category", "type": "str"},
        "tags_properties_tags": {"key": "properties.tags", "type": "[str]"},
        "user_id": {"key": "properties.userId", "type": "str"},
        "source_id": {"key": "properties.sourceId", "type": "str"},
        "storage_uri": {"key": "properties.storageUri", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "revision": {"key": "properties.revision", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        kind: Optional[Union[str, "_models.WorkbookSharedTypeKind"]] = None,
        etag: Optional[str] = None,
        display_name: Optional[str] = None,
        serialized_data: Optional[str] = None,
        version: Optional[str] = None,
        category: Optional[str] = None,
        tags_properties_tags: Optional[List[str]] = None,
        source_id: Optional[str] = None,
        storage_uri: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword kind: The kind of workbook. Only valid value is shared. "shared"
        :paramtype kind: str or
         ~azure.mgmt.applicationinsights.v2024_02_01_preview.models.WorkbookSharedTypeKind
        :keyword etag: Resource etag.
        :paramtype etag: str
        :keyword display_name: The user-defined name (display name) of the workbook.
        :paramtype display_name: str
        :keyword serialized_data: Configuration of this particular workbook. Configuration data is a
         string containing valid JSON.
        :paramtype serialized_data: str
        :keyword version: Workbook schema version format, like 'Notebook/1.0', which should match the
         workbook in serializedData.
        :paramtype version: str
        :keyword category: Workbook category, as defined by the user at creation time.
        :paramtype category: str
        :keyword tags_properties_tags: Being deprecated, please use the other tags field.
        :paramtype tags_properties_tags: list[str]
        :keyword source_id: ResourceId for a source resource.
        :paramtype source_id: str
        :keyword storage_uri: The resourceId to the storage account when bring your own storage is
         used.
        :paramtype storage_uri: str
        :keyword description: The description of the workbook.
        :paramtype description: str
        """
        super().__init__(tags=tags, location=location, kind=kind, etag=etag, **kwargs)
        self.display_name = display_name
        self.serialized_data = serialized_data
        self.version = version
        self.time_modified = None
        self.category = category
        self.tags_properties_tags = tags_properties_tags
        self.user_id = None
        self.source_id = source_id
        self.storage_uri = storage_uri
        self.description = description
        self.revision = None


class DeletedWorkbookError(_serialization.Model):
    """Error response.

    :ivar error: The error details.
    :vartype error:
     ~azure.mgmt.applicationinsights.v2024_02_01_preview.models.DeletedWorkbookErrorDefinition
    """

    _attribute_map = {
        "error": {"key": "error", "type": "DeletedWorkbookErrorDefinition"},
    }

    def __init__(self, *, error: Optional["_models.DeletedWorkbookErrorDefinition"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error details.
        :paramtype error:
         ~azure.mgmt.applicationinsights.v2024_02_01_preview.models.DeletedWorkbookErrorDefinition
        """
        super().__init__(**kwargs)
        self.error = error


class DeletedWorkbookErrorDefinition(_serialization.Model):
    """Error definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Service specific error code which serves as the substatus for the HTTP error code.
    :vartype code: str
    :ivar message: Description of the error.
    :vartype message: str
    :ivar innererror: Internal error details.
    :vartype innererror:
     ~azure.mgmt.applicationinsights.v2024_02_01_preview.models.DeletedWorkbookInnerErrorTrace
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "innererror": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "innererror": {"key": "innererror", "type": "DeletedWorkbookInnerErrorTrace"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.innererror = None


class DeletedWorkbookInnerErrorTrace(_serialization.Model):
    """Error details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar trace: detailed error trace.
    :vartype trace: list[str]
    """

    _validation = {
        "trace": {"readonly": True},
    }

    _attribute_map = {
        "trace": {"key": "trace", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.trace = None


class DeletedWorkbooksListResult(_serialization.Model):
    """Workbook list result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of workbooks.
    :vartype value:
     list[~azure.mgmt.applicationinsights.v2024_02_01_preview.models.DeletedWorkbook]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DeletedWorkbook]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link:
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or
     ~azure.mgmt.applicationinsights.v2024_02_01_preview.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.applicationinsights.v2024_02_01_preview.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or
         ~azure.mgmt.applicationinsights.v2024_02_01_preview.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.applicationinsights.v2024_02_01_preview.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at
