# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class ActionableRemediation(_serialization.Model):
    """Configuration payload for PR Annotations.

    :ivar state: ActionableRemediation Setting.
     None - the setting was never set.
     Enabled - ActionableRemediation is enabled.
     Disabled - ActionableRemediation is disabled. Known values are: "None", "Disabled", and
     "Enabled".
    :vartype state: str or ~azure.mgmt.security.v2024_04_01.models.ActionableRemediationState
    :ivar category_configurations: Gets or sets list of categories and severity levels.
    :vartype category_configurations:
     list[~azure.mgmt.security.v2024_04_01.models.CategoryConfiguration]
    :ivar branch_configuration: Repository branch configuration for PR Annotations.
    :vartype branch_configuration:
     ~azure.mgmt.security.v2024_04_01.models.TargetBranchConfiguration
    :ivar inherit_from_parent_state: Update Settings.

     Enabled - Resource should inherit configurations from parent.
     Disabled - Resource should not inherit configurations from parent. Known values are:
     "Disabled" and "Enabled".
    :vartype inherit_from_parent_state: str or
     ~azure.mgmt.security.v2024_04_01.models.InheritFromParentState
    """

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
        "category_configurations": {"key": "categoryConfigurations", "type": "[CategoryConfiguration]"},
        "branch_configuration": {"key": "branchConfiguration", "type": "TargetBranchConfiguration"},
        "inherit_from_parent_state": {"key": "inheritFromParentState", "type": "str"},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.ActionableRemediationState"]] = None,
        category_configurations: Optional[List["_models.CategoryConfiguration"]] = None,
        branch_configuration: Optional["_models.TargetBranchConfiguration"] = None,
        inherit_from_parent_state: Optional[Union[str, "_models.InheritFromParentState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword state: ActionableRemediation Setting.
         None - the setting was never set.
         Enabled - ActionableRemediation is enabled.
         Disabled - ActionableRemediation is disabled. Known values are: "None", "Disabled", and
         "Enabled".
        :paramtype state: str or ~azure.mgmt.security.v2024_04_01.models.ActionableRemediationState
        :keyword category_configurations: Gets or sets list of categories and severity levels.
        :paramtype category_configurations:
         list[~azure.mgmt.security.v2024_04_01.models.CategoryConfiguration]
        :keyword branch_configuration: Repository branch configuration for PR Annotations.
        :paramtype branch_configuration:
         ~azure.mgmt.security.v2024_04_01.models.TargetBranchConfiguration
        :keyword inherit_from_parent_state: Update Settings.

         Enabled - Resource should inherit configurations from parent.
         Disabled - Resource should not inherit configurations from parent. Known values are:
         "Disabled" and "Enabled".
        :paramtype inherit_from_parent_state: str or
         ~azure.mgmt.security.v2024_04_01.models.InheritFromParentState
        """
        super().__init__(**kwargs)
        self.state = state
        self.category_configurations = category_configurations
        self.branch_configuration = branch_configuration
        self.inherit_from_parent_state = inherit_from_parent_state


class Authorization(_serialization.Model):
    """Authorization payload.

    :ivar code: Gets or sets one-time OAuth code to exchange for refresh and access tokens.

     Only used during PUT/PATCH operations. The secret is cleared during GET.
    :vartype code: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: Gets or sets one-time OAuth code to exchange for refresh and access tokens.

         Only used during PUT/PATCH operations. The secret is cleared during GET.
        :paramtype code: str
        """
        super().__init__(**kwargs)
        self.code = code


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """


class AzureDevOpsOrg(ProxyResource):
    """Azure DevOps Organization resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.security.v2024_04_01.models.SystemData
    :ivar properties: Azure DevOps Organization properties.
    :vartype properties: ~azure.mgmt.security.v2024_04_01.models.AzureDevOpsOrgProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "AzureDevOpsOrgProperties"},
    }

    def __init__(self, *, properties: Optional["_models.AzureDevOpsOrgProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Azure DevOps Organization properties.
        :paramtype properties: ~azure.mgmt.security.v2024_04_01.models.AzureDevOpsOrgProperties
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.properties = properties


class AzureDevOpsOrganizationConfiguration(_serialization.Model):
    """AzureDevOps Org Inventory Configuration.

    :ivar auto_discovery: AutoDiscovery states. Known values are: "Disabled", "Enabled", and
     "NotApplicable".
    :vartype auto_discovery: str or ~azure.mgmt.security.v2024_04_01.models.AutoDiscovery
    :ivar project_configs: AzureDevOps Project Inventory Configuration.
     Dictionary of AzureDevOps project name to desired project configuration.
     If AutoDiscovery is Enabled, this field should be empty or null.
    :vartype project_configs: dict[str,
     ~azure.mgmt.security.v2024_04_01.models.AzureDevOpsProjectConfiguration]
    """

    _attribute_map = {
        "auto_discovery": {"key": "autoDiscovery", "type": "str"},
        "project_configs": {"key": "projectConfigs", "type": "{AzureDevOpsProjectConfiguration}"},
    }

    def __init__(
        self,
        *,
        auto_discovery: Optional[Union[str, "_models.AutoDiscovery"]] = None,
        project_configs: Optional[Dict[str, "_models.AzureDevOpsProjectConfiguration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword auto_discovery: AutoDiscovery states. Known values are: "Disabled", "Enabled", and
         "NotApplicable".
        :paramtype auto_discovery: str or ~azure.mgmt.security.v2024_04_01.models.AutoDiscovery
        :keyword project_configs: AzureDevOps Project Inventory Configuration.
         Dictionary of AzureDevOps project name to desired project configuration.
         If AutoDiscovery is Enabled, this field should be empty or null.
        :paramtype project_configs: dict[str,
         ~azure.mgmt.security.v2024_04_01.models.AzureDevOpsProjectConfiguration]
        """
        super().__init__(**kwargs)
        self.auto_discovery = auto_discovery
        self.project_configs = project_configs


class AzureDevOpsOrgListResponse(_serialization.Model):
    """List of RP resources which supports pagination.

    :ivar value: Gets or sets list of resources.
    :vartype value: list[~azure.mgmt.security.v2024_04_01.models.AzureDevOpsOrg]
    :ivar next_link: Gets or sets next link to scroll over the results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AzureDevOpsOrg]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.AzureDevOpsOrg"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets or sets list of resources.
        :paramtype value: list[~azure.mgmt.security.v2024_04_01.models.AzureDevOpsOrg]
        :keyword next_link: Gets or sets next link to scroll over the results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AzureDevOpsOrgProperties(_serialization.Model):
    """Azure DevOps Organization properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_status_message: Gets or sets resource status message.
    :vartype provisioning_status_message: str
    :ivar provisioning_status_update_time_utc: Gets or sets time when resource was last checked.
    :vartype provisioning_status_update_time_utc: ~datetime.datetime
    :ivar provisioning_state: The provisioning state of the resource.

     Pending - Provisioning pending.
     Failed - Provisioning failed.
     Succeeded - Successful provisioning.
     Canceled - Provisioning canceled.
     PendingDeletion - Deletion pending.
     DeletionSuccess - Deletion successful.
     DeletionFailure - Deletion failure. Known values are: "Succeeded", "Failed", "Canceled",
     "Pending", "PendingDeletion", "DeletionSuccess", and "DeletionFailure".
    :vartype provisioning_state: str or
     ~azure.mgmt.security.v2024_04_01.models.DevOpsProvisioningState
    :ivar onboarding_state: Details about resource onboarding status across all connectors.

     OnboardedByOtherConnector - this resource has already been onboarded to another connector.
     This is only applicable to top-level resources.
     Onboarded - this resource has already been onboarded by the specified connector.
     NotOnboarded - this resource has not been onboarded to any connector.
     NotApplicable - the onboarding state is not applicable to the current endpoint. Known values
     are: "NotApplicable", "OnboardedByOtherConnector", "Onboarded", and "NotOnboarded".
    :vartype onboarding_state: str or ~azure.mgmt.security.v2024_04_01.models.OnboardingState
    :ivar actionable_remediation: Configuration payload for PR Annotations.
    :vartype actionable_remediation: ~azure.mgmt.security.v2024_04_01.models.ActionableRemediation
    """

    _validation = {
        "provisioning_status_message": {"readonly": True},
        "provisioning_status_update_time_utc": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_status_message": {"key": "provisioningStatusMessage", "type": "str"},
        "provisioning_status_update_time_utc": {"key": "provisioningStatusUpdateTimeUtc", "type": "iso-8601"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "onboarding_state": {"key": "onboardingState", "type": "str"},
        "actionable_remediation": {"key": "actionableRemediation", "type": "ActionableRemediation"},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "_models.DevOpsProvisioningState"]] = None,
        onboarding_state: Optional[Union[str, "_models.OnboardingState"]] = None,
        actionable_remediation: Optional["_models.ActionableRemediation"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provisioning_state: The provisioning state of the resource.

         Pending - Provisioning pending.
         Failed - Provisioning failed.
         Succeeded - Successful provisioning.
         Canceled - Provisioning canceled.
         PendingDeletion - Deletion pending.
         DeletionSuccess - Deletion successful.
         DeletionFailure - Deletion failure. Known values are: "Succeeded", "Failed", "Canceled",
         "Pending", "PendingDeletion", "DeletionSuccess", and "DeletionFailure".
        :paramtype provisioning_state: str or
         ~azure.mgmt.security.v2024_04_01.models.DevOpsProvisioningState
        :keyword onboarding_state: Details about resource onboarding status across all connectors.

         OnboardedByOtherConnector - this resource has already been onboarded to another connector.
         This is only applicable to top-level resources.
         Onboarded - this resource has already been onboarded by the specified connector.
         NotOnboarded - this resource has not been onboarded to any connector.
         NotApplicable - the onboarding state is not applicable to the current endpoint. Known values
         are: "NotApplicable", "OnboardedByOtherConnector", "Onboarded", and "NotOnboarded".
        :paramtype onboarding_state: str or ~azure.mgmt.security.v2024_04_01.models.OnboardingState
        :keyword actionable_remediation: Configuration payload for PR Annotations.
        :paramtype actionable_remediation:
         ~azure.mgmt.security.v2024_04_01.models.ActionableRemediation
        """
        super().__init__(**kwargs)
        self.provisioning_status_message = None
        self.provisioning_status_update_time_utc = None
        self.provisioning_state = provisioning_state
        self.onboarding_state = onboarding_state
        self.actionable_remediation = actionable_remediation


class AzureDevOpsProject(ProxyResource):
    """Azure DevOps Project resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.security.v2024_04_01.models.SystemData
    :ivar properties: Azure DevOps Project properties.
    :vartype properties: ~azure.mgmt.security.v2024_04_01.models.AzureDevOpsProjectProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "AzureDevOpsProjectProperties"},
    }

    def __init__(self, *, properties: Optional["_models.AzureDevOpsProjectProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Azure DevOps Project properties.
        :paramtype properties: ~azure.mgmt.security.v2024_04_01.models.AzureDevOpsProjectProperties
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.properties = properties


class AzureDevOpsProjectConfiguration(_serialization.Model):
    """AzureDevOps Project Inventory Configuration.

    :ivar auto_discovery: AutoDiscovery states. Known values are: "Disabled", "Enabled", and
     "NotApplicable".
    :vartype auto_discovery: str or ~azure.mgmt.security.v2024_04_01.models.AutoDiscovery
    :ivar repository_configs: AzureDevOps Repository Inventory Configuration.
     Dictionary of AzureDevOps repository name to desired repository configuration.
     If AutoDiscovery is Enabled, this field should be null or empty.
    :vartype repository_configs: dict[str,
     ~azure.mgmt.security.v2024_04_01.models.BaseResourceConfiguration]
    """

    _attribute_map = {
        "auto_discovery": {"key": "autoDiscovery", "type": "str"},
        "repository_configs": {"key": "repositoryConfigs", "type": "{BaseResourceConfiguration}"},
    }

    def __init__(
        self,
        *,
        auto_discovery: Optional[Union[str, "_models.AutoDiscovery"]] = None,
        repository_configs: Optional[Dict[str, "_models.BaseResourceConfiguration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword auto_discovery: AutoDiscovery states. Known values are: "Disabled", "Enabled", and
         "NotApplicable".
        :paramtype auto_discovery: str or ~azure.mgmt.security.v2024_04_01.models.AutoDiscovery
        :keyword repository_configs: AzureDevOps Repository Inventory Configuration.
         Dictionary of AzureDevOps repository name to desired repository configuration.
         If AutoDiscovery is Enabled, this field should be null or empty.
        :paramtype repository_configs: dict[str,
         ~azure.mgmt.security.v2024_04_01.models.BaseResourceConfiguration]
        """
        super().__init__(**kwargs)
        self.auto_discovery = auto_discovery
        self.repository_configs = repository_configs


class AzureDevOpsProjectListResponse(_serialization.Model):
    """List of RP resources which supports pagination.

    :ivar value: Gets or sets list of resources.
    :vartype value: list[~azure.mgmt.security.v2024_04_01.models.AzureDevOpsProject]
    :ivar next_link: Gets or sets next link to scroll over the results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AzureDevOpsProject]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.AzureDevOpsProject"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets or sets list of resources.
        :paramtype value: list[~azure.mgmt.security.v2024_04_01.models.AzureDevOpsProject]
        :keyword next_link: Gets or sets next link to scroll over the results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AzureDevOpsProjectProperties(_serialization.Model):
    """Azure DevOps Project properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_status_message: Gets or sets resource status message.
    :vartype provisioning_status_message: str
    :ivar provisioning_status_update_time_utc: Gets or sets time when resource was last checked.
    :vartype provisioning_status_update_time_utc: ~datetime.datetime
    :ivar provisioning_state: The provisioning state of the resource.

     Pending - Provisioning pending.
     Failed - Provisioning failed.
     Succeeded - Successful provisioning.
     Canceled - Provisioning canceled.
     PendingDeletion - Deletion pending.
     DeletionSuccess - Deletion successful.
     DeletionFailure - Deletion failure. Known values are: "Succeeded", "Failed", "Canceled",
     "Pending", "PendingDeletion", "DeletionSuccess", and "DeletionFailure".
    :vartype provisioning_state: str or
     ~azure.mgmt.security.v2024_04_01.models.DevOpsProvisioningState
    :ivar parent_org_name: Gets or sets parent Azure DevOps Organization name.
    :vartype parent_org_name: str
    :ivar project_id: Gets or sets Azure DevOps Project id.
    :vartype project_id: str
    :ivar onboarding_state: Details about resource onboarding status across all connectors.

     OnboardedByOtherConnector - this resource has already been onboarded to another connector.
     This is only applicable to top-level resources.
     Onboarded - this resource has already been onboarded by the specified connector.
     NotOnboarded - this resource has not been onboarded to any connector.
     NotApplicable - the onboarding state is not applicable to the current endpoint. Known values
     are: "NotApplicable", "OnboardedByOtherConnector", "Onboarded", and "NotOnboarded".
    :vartype onboarding_state: str or ~azure.mgmt.security.v2024_04_01.models.OnboardingState
    :ivar actionable_remediation: Configuration payload for PR Annotations.
    :vartype actionable_remediation: ~azure.mgmt.security.v2024_04_01.models.ActionableRemediation
    """

    _validation = {
        "provisioning_status_message": {"readonly": True},
        "provisioning_status_update_time_utc": {"readonly": True},
        "project_id": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_status_message": {"key": "provisioningStatusMessage", "type": "str"},
        "provisioning_status_update_time_utc": {"key": "provisioningStatusUpdateTimeUtc", "type": "iso-8601"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "parent_org_name": {"key": "parentOrgName", "type": "str"},
        "project_id": {"key": "projectId", "type": "str"},
        "onboarding_state": {"key": "onboardingState", "type": "str"},
        "actionable_remediation": {"key": "actionableRemediation", "type": "ActionableRemediation"},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "_models.DevOpsProvisioningState"]] = None,
        parent_org_name: Optional[str] = None,
        onboarding_state: Optional[Union[str, "_models.OnboardingState"]] = None,
        actionable_remediation: Optional["_models.ActionableRemediation"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provisioning_state: The provisioning state of the resource.

         Pending - Provisioning pending.
         Failed - Provisioning failed.
         Succeeded - Successful provisioning.
         Canceled - Provisioning canceled.
         PendingDeletion - Deletion pending.
         DeletionSuccess - Deletion successful.
         DeletionFailure - Deletion failure. Known values are: "Succeeded", "Failed", "Canceled",
         "Pending", "PendingDeletion", "DeletionSuccess", and "DeletionFailure".
        :paramtype provisioning_state: str or
         ~azure.mgmt.security.v2024_04_01.models.DevOpsProvisioningState
        :keyword parent_org_name: Gets or sets parent Azure DevOps Organization name.
        :paramtype parent_org_name: str
        :keyword onboarding_state: Details about resource onboarding status across all connectors.

         OnboardedByOtherConnector - this resource has already been onboarded to another connector.
         This is only applicable to top-level resources.
         Onboarded - this resource has already been onboarded by the specified connector.
         NotOnboarded - this resource has not been onboarded to any connector.
         NotApplicable - the onboarding state is not applicable to the current endpoint. Known values
         are: "NotApplicable", "OnboardedByOtherConnector", "Onboarded", and "NotOnboarded".
        :paramtype onboarding_state: str or ~azure.mgmt.security.v2024_04_01.models.OnboardingState
        :keyword actionable_remediation: Configuration payload for PR Annotations.
        :paramtype actionable_remediation:
         ~azure.mgmt.security.v2024_04_01.models.ActionableRemediation
        """
        super().__init__(**kwargs)
        self.provisioning_status_message = None
        self.provisioning_status_update_time_utc = None
        self.provisioning_state = provisioning_state
        self.parent_org_name = parent_org_name
        self.project_id = None
        self.onboarding_state = onboarding_state
        self.actionable_remediation = actionable_remediation


class AzureDevOpsRepository(ProxyResource):
    """Azure DevOps Repository resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.security.v2024_04_01.models.SystemData
    :ivar properties: Azure DevOps Repository properties.
    :vartype properties: ~azure.mgmt.security.v2024_04_01.models.AzureDevOpsRepositoryProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "AzureDevOpsRepositoryProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.AzureDevOpsRepositoryProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Azure DevOps Repository properties.
        :paramtype properties: ~azure.mgmt.security.v2024_04_01.models.AzureDevOpsRepositoryProperties
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.properties = properties


class AzureDevOpsRepositoryListResponse(_serialization.Model):
    """List of RP resources which supports pagination.

    :ivar value: Gets or sets list of resources.
    :vartype value: list[~azure.mgmt.security.v2024_04_01.models.AzureDevOpsRepository]
    :ivar next_link: Gets or sets next link to scroll over the results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AzureDevOpsRepository]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.AzureDevOpsRepository"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets or sets list of resources.
        :paramtype value: list[~azure.mgmt.security.v2024_04_01.models.AzureDevOpsRepository]
        :keyword next_link: Gets or sets next link to scroll over the results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AzureDevOpsRepositoryProperties(_serialization.Model):
    """Azure DevOps Repository properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_status_message: Gets or sets resource status message.
    :vartype provisioning_status_message: str
    :ivar provisioning_status_update_time_utc: Gets or sets time when resource was last checked.
    :vartype provisioning_status_update_time_utc: ~datetime.datetime
    :ivar provisioning_state: The provisioning state of the resource.

     Pending - Provisioning pending.
     Failed - Provisioning failed.
     Succeeded - Successful provisioning.
     Canceled - Provisioning canceled.
     PendingDeletion - Deletion pending.
     DeletionSuccess - Deletion successful.
     DeletionFailure - Deletion failure. Known values are: "Succeeded", "Failed", "Canceled",
     "Pending", "PendingDeletion", "DeletionSuccess", and "DeletionFailure".
    :vartype provisioning_state: str or
     ~azure.mgmt.security.v2024_04_01.models.DevOpsProvisioningState
    :ivar parent_org_name: Gets or sets parent Azure DevOps Organization name.
    :vartype parent_org_name: str
    :ivar parent_project_name: Gets or sets parent Azure DevOps Project name.
    :vartype parent_project_name: str
    :ivar repo_id: Gets or sets Azure DevOps Repository id.
    :vartype repo_id: str
    :ivar repo_url: Gets or sets Azure DevOps Repository url.
    :vartype repo_url: str
    :ivar visibility: Gets or sets Azure DevOps repository visibility, whether it is public or
     private etc.
    :vartype visibility: str
    :ivar onboarding_state: Details about resource onboarding status across all connectors.

     OnboardedByOtherConnector - this resource has already been onboarded to another connector.
     This is only applicable to top-level resources.
     Onboarded - this resource has already been onboarded by the specified connector.
     NotOnboarded - this resource has not been onboarded to any connector.
     NotApplicable - the onboarding state is not applicable to the current endpoint. Known values
     are: "NotApplicable", "OnboardedByOtherConnector", "Onboarded", and "NotOnboarded".
    :vartype onboarding_state: str or ~azure.mgmt.security.v2024_04_01.models.OnboardingState
    :ivar actionable_remediation: Configuration payload for PR Annotations.
    :vartype actionable_remediation: ~azure.mgmt.security.v2024_04_01.models.ActionableRemediation
    """

    _validation = {
        "provisioning_status_message": {"readonly": True},
        "provisioning_status_update_time_utc": {"readonly": True},
        "repo_id": {"readonly": True},
        "repo_url": {"readonly": True},
        "visibility": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_status_message": {"key": "provisioningStatusMessage", "type": "str"},
        "provisioning_status_update_time_utc": {"key": "provisioningStatusUpdateTimeUtc", "type": "iso-8601"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "parent_org_name": {"key": "parentOrgName", "type": "str"},
        "parent_project_name": {"key": "parentProjectName", "type": "str"},
        "repo_id": {"key": "repoId", "type": "str"},
        "repo_url": {"key": "repoUrl", "type": "str"},
        "visibility": {"key": "visibility", "type": "str"},
        "onboarding_state": {"key": "onboardingState", "type": "str"},
        "actionable_remediation": {"key": "actionableRemediation", "type": "ActionableRemediation"},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "_models.DevOpsProvisioningState"]] = None,
        parent_org_name: Optional[str] = None,
        parent_project_name: Optional[str] = None,
        onboarding_state: Optional[Union[str, "_models.OnboardingState"]] = None,
        actionable_remediation: Optional["_models.ActionableRemediation"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provisioning_state: The provisioning state of the resource.

         Pending - Provisioning pending.
         Failed - Provisioning failed.
         Succeeded - Successful provisioning.
         Canceled - Provisioning canceled.
         PendingDeletion - Deletion pending.
         DeletionSuccess - Deletion successful.
         DeletionFailure - Deletion failure. Known values are: "Succeeded", "Failed", "Canceled",
         "Pending", "PendingDeletion", "DeletionSuccess", and "DeletionFailure".
        :paramtype provisioning_state: str or
         ~azure.mgmt.security.v2024_04_01.models.DevOpsProvisioningState
        :keyword parent_org_name: Gets or sets parent Azure DevOps Organization name.
        :paramtype parent_org_name: str
        :keyword parent_project_name: Gets or sets parent Azure DevOps Project name.
        :paramtype parent_project_name: str
        :keyword onboarding_state: Details about resource onboarding status across all connectors.

         OnboardedByOtherConnector - this resource has already been onboarded to another connector.
         This is only applicable to top-level resources.
         Onboarded - this resource has already been onboarded by the specified connector.
         NotOnboarded - this resource has not been onboarded to any connector.
         NotApplicable - the onboarding state is not applicable to the current endpoint. Known values
         are: "NotApplicable", "OnboardedByOtherConnector", "Onboarded", and "NotOnboarded".
        :paramtype onboarding_state: str or ~azure.mgmt.security.v2024_04_01.models.OnboardingState
        :keyword actionable_remediation: Configuration payload for PR Annotations.
        :paramtype actionable_remediation:
         ~azure.mgmt.security.v2024_04_01.models.ActionableRemediation
        """
        super().__init__(**kwargs)
        self.provisioning_status_message = None
        self.provisioning_status_update_time_utc = None
        self.provisioning_state = provisioning_state
        self.parent_org_name = parent_org_name
        self.parent_project_name = parent_project_name
        self.repo_id = None
        self.repo_url = None
        self.visibility = None
        self.onboarding_state = onboarding_state
        self.actionable_remediation = actionable_remediation


class BaseResourceConfiguration(_serialization.Model):
    """Base Resource Inventory configuration changes.

    :ivar desired_onboarding_state: Onboarding states. Known values are: "Disabled" and "Enabled".
    :vartype desired_onboarding_state: str or
     ~azure.mgmt.security.v2024_04_01.models.DesiredOnboardingState
    """

    _attribute_map = {
        "desired_onboarding_state": {"key": "desiredOnboardingState", "type": "str"},
    }

    def __init__(
        self, *, desired_onboarding_state: Optional[Union[str, "_models.DesiredOnboardingState"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword desired_onboarding_state: Onboarding states. Known values are: "Disabled" and
         "Enabled".
        :paramtype desired_onboarding_state: str or
         ~azure.mgmt.security.v2024_04_01.models.DesiredOnboardingState
        """
        super().__init__(**kwargs)
        self.desired_onboarding_state = desired_onboarding_state


class CategoryConfiguration(_serialization.Model):
    """Severity level per category configuration for PR Annotations.

    :ivar minimum_severity_level: Gets or sets minimum severity level for a given category.
    :vartype minimum_severity_level: str
    :ivar category: Rule categories.
     Code - code scanning results.
     Artifact scanning results.
     Dependencies scanning results.
     IaC results.
     Secrets scanning results.
     Container scanning results. Known values are: "Code", "Artifacts", "Dependencies", "Secrets",
     "IaC", and "Containers".
    :vartype category: str or ~azure.mgmt.security.v2024_04_01.models.RuleCategory
    """

    _attribute_map = {
        "minimum_severity_level": {"key": "minimumSeverityLevel", "type": "str"},
        "category": {"key": "category", "type": "str"},
    }

    def __init__(
        self,
        *,
        minimum_severity_level: Optional[str] = None,
        category: Optional[Union[str, "_models.RuleCategory"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword minimum_severity_level: Gets or sets minimum severity level for a given category.
        :paramtype minimum_severity_level: str
        :keyword category: Rule categories.
         Code - code scanning results.
         Artifact scanning results.
         Dependencies scanning results.
         IaC results.
         Secrets scanning results.
         Container scanning results. Known values are: "Code", "Artifacts", "Dependencies", "Secrets",
         "IaC", and "Containers".
        :paramtype category: str or ~azure.mgmt.security.v2024_04_01.models.RuleCategory
        """
        super().__init__(**kwargs)
        self.minimum_severity_level = minimum_severity_level
        self.category = category


class DevOpsCapability(_serialization.Model):
    """Details about DevOps capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Gets the name of the DevOps capability.
    :vartype name: str
    :ivar value: Gets the value of the DevOps capability.
    :vartype value: str
    """

    _validation = {
        "name": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.value = None


class DevOpsConfiguration(ProxyResource):
    """DevOps Configuration resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.security.v2024_04_01.models.SystemData
    :ivar properties: DevOps Configuration properties.
    :vartype properties: ~azure.mgmt.security.v2024_04_01.models.DevOpsConfigurationProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "DevOpsConfigurationProperties"},
    }

    def __init__(self, *, properties: Optional["_models.DevOpsConfigurationProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: DevOps Configuration properties.
        :paramtype properties: ~azure.mgmt.security.v2024_04_01.models.DevOpsConfigurationProperties
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.properties = properties


class DevOpsConfigurationListResponse(_serialization.Model):
    """List of RP resources which supports pagination.

    :ivar value: Gets or sets list of resources.
    :vartype value: list[~azure.mgmt.security.v2024_04_01.models.DevOpsConfiguration]
    :ivar next_link: Gets or sets next link to scroll over the results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[DevOpsConfiguration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.DevOpsConfiguration"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets or sets list of resources.
        :paramtype value: list[~azure.mgmt.security.v2024_04_01.models.DevOpsConfiguration]
        :keyword next_link: Gets or sets next link to scroll over the results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DevOpsConfigurationProperties(_serialization.Model):
    """DevOps Configuration properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_status_message: Gets or sets resource status message.
    :vartype provisioning_status_message: str
    :ivar provisioning_status_update_time_utc: Gets or sets time when resource was last checked.
    :vartype provisioning_status_update_time_utc: ~datetime.datetime
    :ivar provisioning_state: The provisioning state of the resource.

     Pending - Provisioning pending.
     Failed - Provisioning failed.
     Succeeded - Successful provisioning.
     Canceled - Provisioning canceled.
     PendingDeletion - Deletion pending.
     DeletionSuccess - Deletion successful.
     DeletionFailure - Deletion failure. Known values are: "Succeeded", "Failed", "Canceled",
     "Pending", "PendingDeletion", "DeletionSuccess", and "DeletionFailure".
    :vartype provisioning_state: str or
     ~azure.mgmt.security.v2024_04_01.models.DevOpsProvisioningState
    :ivar authorization: Authorization payload.
    :vartype authorization: ~azure.mgmt.security.v2024_04_01.models.Authorization
    :ivar auto_discovery: AutoDiscovery states. Known values are: "Disabled", "Enabled", and
     "NotApplicable".
    :vartype auto_discovery: str or ~azure.mgmt.security.v2024_04_01.models.AutoDiscovery
    :ivar top_level_inventory_list: List of top-level inventory to select when AutoDiscovery is
     disabled.
     This field is ignored when AutoDiscovery is enabled.
    :vartype top_level_inventory_list: list[str]
    :ivar capabilities: List of capabilities assigned to the DevOps configuration during the
     discovery process.
    :vartype capabilities: list[~azure.mgmt.security.v2024_04_01.models.DevOpsCapability]
    """

    _validation = {
        "provisioning_status_message": {"readonly": True},
        "provisioning_status_update_time_utc": {"readonly": True},
        "capabilities": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_status_message": {"key": "provisioningStatusMessage", "type": "str"},
        "provisioning_status_update_time_utc": {"key": "provisioningStatusUpdateTimeUtc", "type": "iso-8601"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "authorization": {"key": "authorization", "type": "Authorization"},
        "auto_discovery": {"key": "autoDiscovery", "type": "str"},
        "top_level_inventory_list": {"key": "topLevelInventoryList", "type": "[str]"},
        "capabilities": {"key": "capabilities", "type": "[DevOpsCapability]"},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "_models.DevOpsProvisioningState"]] = None,
        authorization: Optional["_models.Authorization"] = None,
        auto_discovery: Optional[Union[str, "_models.AutoDiscovery"]] = None,
        top_level_inventory_list: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provisioning_state: The provisioning state of the resource.

         Pending - Provisioning pending.
         Failed - Provisioning failed.
         Succeeded - Successful provisioning.
         Canceled - Provisioning canceled.
         PendingDeletion - Deletion pending.
         DeletionSuccess - Deletion successful.
         DeletionFailure - Deletion failure. Known values are: "Succeeded", "Failed", "Canceled",
         "Pending", "PendingDeletion", "DeletionSuccess", and "DeletionFailure".
        :paramtype provisioning_state: str or
         ~azure.mgmt.security.v2024_04_01.models.DevOpsProvisioningState
        :keyword authorization: Authorization payload.
        :paramtype authorization: ~azure.mgmt.security.v2024_04_01.models.Authorization
        :keyword auto_discovery: AutoDiscovery states. Known values are: "Disabled", "Enabled", and
         "NotApplicable".
        :paramtype auto_discovery: str or ~azure.mgmt.security.v2024_04_01.models.AutoDiscovery
        :keyword top_level_inventory_list: List of top-level inventory to select when AutoDiscovery is
         disabled.
         This field is ignored when AutoDiscovery is enabled.
        :paramtype top_level_inventory_list: list[str]
        """
        super().__init__(**kwargs)
        self.provisioning_status_message = None
        self.provisioning_status_update_time_utc = None
        self.provisioning_state = provisioning_state
        self.authorization = authorization
        self.auto_discovery = auto_discovery
        self.top_level_inventory_list = top_level_inventory_list
        self.capabilities = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.security.v2024_04_01.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.security.v2024_04_01.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.security.v2024_04_01.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.security.v2024_04_01.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class GitHubOwner(ProxyResource):
    """GitHub Owner resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.security.v2024_04_01.models.SystemData
    :ivar properties: GitHub Owner properties.
    :vartype properties: ~azure.mgmt.security.v2024_04_01.models.GitHubOwnerProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "GitHubOwnerProperties"},
    }

    def __init__(self, *, properties: Optional["_models.GitHubOwnerProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: GitHub Owner properties.
        :paramtype properties: ~azure.mgmt.security.v2024_04_01.models.GitHubOwnerProperties
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.properties = properties


class GitHubOwnerConfiguration(_serialization.Model):
    """GitHub Owner Inventory Configuration.

    :ivar auto_discovery: AutoDiscovery states. Known values are: "Disabled", "Enabled", and
     "NotApplicable".
    :vartype auto_discovery: str or ~azure.mgmt.security.v2024_04_01.models.AutoDiscovery
    :ivar repository_configs: GitHub Repository Inventory Configuration.
     Dictionary of GitHub repository name to desired repository configuration.
     If AutoDiscovery is Enabled, this field should be null or empty.
    :vartype repository_configs: dict[str,
     ~azure.mgmt.security.v2024_04_01.models.BaseResourceConfiguration]
    """

    _attribute_map = {
        "auto_discovery": {"key": "autoDiscovery", "type": "str"},
        "repository_configs": {"key": "repositoryConfigs", "type": "{BaseResourceConfiguration}"},
    }

    def __init__(
        self,
        *,
        auto_discovery: Optional[Union[str, "_models.AutoDiscovery"]] = None,
        repository_configs: Optional[Dict[str, "_models.BaseResourceConfiguration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword auto_discovery: AutoDiscovery states. Known values are: "Disabled", "Enabled", and
         "NotApplicable".
        :paramtype auto_discovery: str or ~azure.mgmt.security.v2024_04_01.models.AutoDiscovery
        :keyword repository_configs: GitHub Repository Inventory Configuration.
         Dictionary of GitHub repository name to desired repository configuration.
         If AutoDiscovery is Enabled, this field should be null or empty.
        :paramtype repository_configs: dict[str,
         ~azure.mgmt.security.v2024_04_01.models.BaseResourceConfiguration]
        """
        super().__init__(**kwargs)
        self.auto_discovery = auto_discovery
        self.repository_configs = repository_configs


class GitHubOwnerListResponse(_serialization.Model):
    """List of RP resources which supports pagination.

    :ivar value: Gets or sets list of resources.
    :vartype value: list[~azure.mgmt.security.v2024_04_01.models.GitHubOwner]
    :ivar next_link: Gets or sets next link to scroll over the results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[GitHubOwner]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.GitHubOwner"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets or sets list of resources.
        :paramtype value: list[~azure.mgmt.security.v2024_04_01.models.GitHubOwner]
        :keyword next_link: Gets or sets next link to scroll over the results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GitHubOwnerProperties(_serialization.Model):
    """GitHub Owner properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_status_message: Gets or sets resource status message.
    :vartype provisioning_status_message: str
    :ivar provisioning_status_update_time_utc: Gets or sets time when resource was last checked.
    :vartype provisioning_status_update_time_utc: ~datetime.datetime
    :ivar provisioning_state: The provisioning state of the resource.

     Pending - Provisioning pending.
     Failed - Provisioning failed.
     Succeeded - Successful provisioning.
     Canceled - Provisioning canceled.
     PendingDeletion - Deletion pending.
     DeletionSuccess - Deletion successful.
     DeletionFailure - Deletion failure. Known values are: "Succeeded", "Failed", "Canceled",
     "Pending", "PendingDeletion", "DeletionSuccess", and "DeletionFailure".
    :vartype provisioning_state: str or
     ~azure.mgmt.security.v2024_04_01.models.DevOpsProvisioningState
    :ivar owner_url: Gets or sets GitHub Owner url.
    :vartype owner_url: str
    :ivar git_hub_internal_id: Gets or sets internal GitHub id.
    :vartype git_hub_internal_id: str
    :ivar onboarding_state: Details about resource onboarding status across all connectors.

     OnboardedByOtherConnector - this resource has already been onboarded to another connector.
     This is only applicable to top-level resources.
     Onboarded - this resource has already been onboarded by the specified connector.
     NotOnboarded - this resource has not been onboarded to any connector.
     NotApplicable - the onboarding state is not applicable to the current endpoint. Known values
     are: "NotApplicable", "OnboardedByOtherConnector", "Onboarded", and "NotOnboarded".
    :vartype onboarding_state: str or ~azure.mgmt.security.v2024_04_01.models.OnboardingState
    """

    _validation = {
        "provisioning_status_message": {"readonly": True},
        "provisioning_status_update_time_utc": {"readonly": True},
        "owner_url": {"readonly": True},
        "git_hub_internal_id": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_status_message": {"key": "provisioningStatusMessage", "type": "str"},
        "provisioning_status_update_time_utc": {"key": "provisioningStatusUpdateTimeUtc", "type": "iso-8601"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "owner_url": {"key": "ownerUrl", "type": "str"},
        "git_hub_internal_id": {"key": "gitHubInternalId", "type": "str"},
        "onboarding_state": {"key": "onboardingState", "type": "str"},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "_models.DevOpsProvisioningState"]] = None,
        onboarding_state: Optional[Union[str, "_models.OnboardingState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provisioning_state: The provisioning state of the resource.

         Pending - Provisioning pending.
         Failed - Provisioning failed.
         Succeeded - Successful provisioning.
         Canceled - Provisioning canceled.
         PendingDeletion - Deletion pending.
         DeletionSuccess - Deletion successful.
         DeletionFailure - Deletion failure. Known values are: "Succeeded", "Failed", "Canceled",
         "Pending", "PendingDeletion", "DeletionSuccess", and "DeletionFailure".
        :paramtype provisioning_state: str or
         ~azure.mgmt.security.v2024_04_01.models.DevOpsProvisioningState
        :keyword onboarding_state: Details about resource onboarding status across all connectors.

         OnboardedByOtherConnector - this resource has already been onboarded to another connector.
         This is only applicable to top-level resources.
         Onboarded - this resource has already been onboarded by the specified connector.
         NotOnboarded - this resource has not been onboarded to any connector.
         NotApplicable - the onboarding state is not applicable to the current endpoint. Known values
         are: "NotApplicable", "OnboardedByOtherConnector", "Onboarded", and "NotOnboarded".
        :paramtype onboarding_state: str or ~azure.mgmt.security.v2024_04_01.models.OnboardingState
        """
        super().__init__(**kwargs)
        self.provisioning_status_message = None
        self.provisioning_status_update_time_utc = None
        self.provisioning_state = provisioning_state
        self.owner_url = None
        self.git_hub_internal_id = None
        self.onboarding_state = onboarding_state


class GitHubRepository(ProxyResource):
    """GitHub Repository resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.security.v2024_04_01.models.SystemData
    :ivar properties: GitHub Repository properties.
    :vartype properties: ~azure.mgmt.security.v2024_04_01.models.GitHubRepositoryProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "GitHubRepositoryProperties"},
    }

    def __init__(self, *, properties: Optional["_models.GitHubRepositoryProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: GitHub Repository properties.
        :paramtype properties: ~azure.mgmt.security.v2024_04_01.models.GitHubRepositoryProperties
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.properties = properties


class GitHubRepositoryListResponse(_serialization.Model):
    """List of RP resources which supports pagination.

    :ivar value: Gets or sets list of resources.
    :vartype value: list[~azure.mgmt.security.v2024_04_01.models.GitHubRepository]
    :ivar next_link: Gets or sets next link to scroll over the results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[GitHubRepository]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.GitHubRepository"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets or sets list of resources.
        :paramtype value: list[~azure.mgmt.security.v2024_04_01.models.GitHubRepository]
        :keyword next_link: Gets or sets next link to scroll over the results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GitHubRepositoryProperties(_serialization.Model):
    """GitHub Repository properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_status_message: Gets or sets resource status message.
    :vartype provisioning_status_message: str
    :ivar provisioning_status_update_time_utc: Gets or sets time when resource was last checked.
    :vartype provisioning_status_update_time_utc: ~datetime.datetime
    :ivar provisioning_state: The provisioning state of the resource.

     Pending - Provisioning pending.
     Failed - Provisioning failed.
     Succeeded - Successful provisioning.
     Canceled - Provisioning canceled.
     PendingDeletion - Deletion pending.
     DeletionSuccess - Deletion successful.
     DeletionFailure - Deletion failure. Known values are: "Succeeded", "Failed", "Canceled",
     "Pending", "PendingDeletion", "DeletionSuccess", and "DeletionFailure".
    :vartype provisioning_state: str or
     ~azure.mgmt.security.v2024_04_01.models.DevOpsProvisioningState
    :ivar repo_id: Gets or sets GitHub Repository id.

     This is a numeric id defined by Github.
     Eg: "123456".
    :vartype repo_id: str
    :ivar repo_name: Gets or sets GitHub Repository name.
     Eg: "new-repo-1".
    :vartype repo_name: str
    :ivar repo_full_name: Gets or sets GitHub Full Name.
     Repository name, prefixed with Owner name.
     Eg: "my-org/new-repo-1".
    :vartype repo_full_name: str
    :ivar onboarding_state: Details about resource onboarding status across all connectors.

     OnboardedByOtherConnector - this resource has already been onboarded to another connector.
     This is only applicable to top-level resources.
     Onboarded - this resource has already been onboarded by the specified connector.
     NotOnboarded - this resource has not been onboarded to any connector.
     NotApplicable - the onboarding state is not applicable to the current endpoint. Known values
     are: "NotApplicable", "OnboardedByOtherConnector", "Onboarded", and "NotOnboarded".
    :vartype onboarding_state: str or ~azure.mgmt.security.v2024_04_01.models.OnboardingState
    :ivar repo_url: Gets or sets GitHub Repository url.
    :vartype repo_url: str
    :ivar parent_owner_name: Gets or sets parent GitHub Owner name.
    :vartype parent_owner_name: str
    """

    _validation = {
        "provisioning_status_message": {"readonly": True},
        "provisioning_status_update_time_utc": {"readonly": True},
        "repo_id": {"readonly": True},
        "repo_name": {"readonly": True},
        "repo_full_name": {"readonly": True},
        "repo_url": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_status_message": {"key": "provisioningStatusMessage", "type": "str"},
        "provisioning_status_update_time_utc": {"key": "provisioningStatusUpdateTimeUtc", "type": "iso-8601"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "repo_id": {"key": "repoId", "type": "str"},
        "repo_name": {"key": "repoName", "type": "str"},
        "repo_full_name": {"key": "repoFullName", "type": "str"},
        "onboarding_state": {"key": "onboardingState", "type": "str"},
        "repo_url": {"key": "repoUrl", "type": "str"},
        "parent_owner_name": {"key": "parentOwnerName", "type": "str"},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "_models.DevOpsProvisioningState"]] = None,
        onboarding_state: Optional[Union[str, "_models.OnboardingState"]] = None,
        parent_owner_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provisioning_state: The provisioning state of the resource.

         Pending - Provisioning pending.
         Failed - Provisioning failed.
         Succeeded - Successful provisioning.
         Canceled - Provisioning canceled.
         PendingDeletion - Deletion pending.
         DeletionSuccess - Deletion successful.
         DeletionFailure - Deletion failure. Known values are: "Succeeded", "Failed", "Canceled",
         "Pending", "PendingDeletion", "DeletionSuccess", and "DeletionFailure".
        :paramtype provisioning_state: str or
         ~azure.mgmt.security.v2024_04_01.models.DevOpsProvisioningState
        :keyword onboarding_state: Details about resource onboarding status across all connectors.

         OnboardedByOtherConnector - this resource has already been onboarded to another connector.
         This is only applicable to top-level resources.
         Onboarded - this resource has already been onboarded by the specified connector.
         NotOnboarded - this resource has not been onboarded to any connector.
         NotApplicable - the onboarding state is not applicable to the current endpoint. Known values
         are: "NotApplicable", "OnboardedByOtherConnector", "Onboarded", and "NotOnboarded".
        :paramtype onboarding_state: str or ~azure.mgmt.security.v2024_04_01.models.OnboardingState
        :keyword parent_owner_name: Gets or sets parent GitHub Owner name.
        :paramtype parent_owner_name: str
        """
        super().__init__(**kwargs)
        self.provisioning_status_message = None
        self.provisioning_status_update_time_utc = None
        self.provisioning_state = provisioning_state
        self.repo_id = None
        self.repo_name = None
        self.repo_full_name = None
        self.onboarding_state = onboarding_state
        self.repo_url = None
        self.parent_owner_name = parent_owner_name


class GitLabGroup(ProxyResource):
    """GitLab Group resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.security.v2024_04_01.models.SystemData
    :ivar properties: GitLab Group properties.
    :vartype properties: ~azure.mgmt.security.v2024_04_01.models.GitLabGroupProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "GitLabGroupProperties"},
    }

    def __init__(self, *, properties: Optional["_models.GitLabGroupProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: GitLab Group properties.
        :paramtype properties: ~azure.mgmt.security.v2024_04_01.models.GitLabGroupProperties
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.properties = properties


class GitLabGroupConfiguration(_serialization.Model):
    """GitLab Group Inventory Configuration.

    :ivar auto_discovery: AutoDiscovery states. Known values are: "Disabled", "Enabled", and
     "NotApplicable".
    :vartype auto_discovery: str or ~azure.mgmt.security.v2024_04_01.models.AutoDiscovery
    :ivar project_configs: GitLab Project Inventory Configuration.
     Dictionary of GitLab fully-qualified project name to desired project configuration.
     If AutoDiscovery is Enabled, this field should be null or empty.
    :vartype project_configs: dict[str,
     ~azure.mgmt.security.v2024_04_01.models.BaseResourceConfiguration]
    """

    _attribute_map = {
        "auto_discovery": {"key": "autoDiscovery", "type": "str"},
        "project_configs": {"key": "projectConfigs", "type": "{BaseResourceConfiguration}"},
    }

    def __init__(
        self,
        *,
        auto_discovery: Optional[Union[str, "_models.AutoDiscovery"]] = None,
        project_configs: Optional[Dict[str, "_models.BaseResourceConfiguration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword auto_discovery: AutoDiscovery states. Known values are: "Disabled", "Enabled", and
         "NotApplicable".
        :paramtype auto_discovery: str or ~azure.mgmt.security.v2024_04_01.models.AutoDiscovery
        :keyword project_configs: GitLab Project Inventory Configuration.
         Dictionary of GitLab fully-qualified project name to desired project configuration.
         If AutoDiscovery is Enabled, this field should be null or empty.
        :paramtype project_configs: dict[str,
         ~azure.mgmt.security.v2024_04_01.models.BaseResourceConfiguration]
        """
        super().__init__(**kwargs)
        self.auto_discovery = auto_discovery
        self.project_configs = project_configs


class GitLabGroupListResponse(_serialization.Model):
    """List of RP resources which supports pagination.

    :ivar value: Gets or sets list of resources.
    :vartype value: list[~azure.mgmt.security.v2024_04_01.models.GitLabGroup]
    :ivar next_link: Gets or sets next link to scroll over the results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[GitLabGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.GitLabGroup"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets or sets list of resources.
        :paramtype value: list[~azure.mgmt.security.v2024_04_01.models.GitLabGroup]
        :keyword next_link: Gets or sets next link to scroll over the results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GitLabGroupProperties(_serialization.Model):
    """GitLab Group properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_status_message: Gets or sets resource status message.
    :vartype provisioning_status_message: str
    :ivar provisioning_status_update_time_utc: Gets or sets time when resource was last checked.
    :vartype provisioning_status_update_time_utc: ~datetime.datetime
    :ivar provisioning_state: The provisioning state of the resource.

     Pending - Provisioning pending.
     Failed - Provisioning failed.
     Succeeded - Successful provisioning.
     Canceled - Provisioning canceled.
     PendingDeletion - Deletion pending.
     DeletionSuccess - Deletion successful.
     DeletionFailure - Deletion failure. Known values are: "Succeeded", "Failed", "Canceled",
     "Pending", "PendingDeletion", "DeletionSuccess", and "DeletionFailure".
    :vartype provisioning_state: str or
     ~azure.mgmt.security.v2024_04_01.models.DevOpsProvisioningState
    :ivar fully_qualified_name: Gets or sets the fully-qualified name of the Group object.

     This contains the entire namespace hierarchy where namespaces are separated by the '$'
     character.
    :vartype fully_qualified_name: str
    :ivar fully_qualified_friendly_name: Gets or sets the human readable fully-qualified name of
     the Group object.

     This contains the entire namespace hierarchy as seen on GitLab UI where namespaces are
     separated by the '/' character.
    :vartype fully_qualified_friendly_name: str
    :ivar url: Gets or sets the url of the GitLab Group.
    :vartype url: str
    :ivar onboarding_state: Details about resource onboarding status across all connectors.

     OnboardedByOtherConnector - this resource has already been onboarded to another connector.
     This is only applicable to top-level resources.
     Onboarded - this resource has already been onboarded by the specified connector.
     NotOnboarded - this resource has not been onboarded to any connector.
     NotApplicable - the onboarding state is not applicable to the current endpoint. Known values
     are: "NotApplicable", "OnboardedByOtherConnector", "Onboarded", and "NotOnboarded".
    :vartype onboarding_state: str or ~azure.mgmt.security.v2024_04_01.models.OnboardingState
    """

    _validation = {
        "provisioning_status_message": {"readonly": True},
        "provisioning_status_update_time_utc": {"readonly": True},
        "fully_qualified_name": {"readonly": True},
        "fully_qualified_friendly_name": {"readonly": True},
        "url": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_status_message": {"key": "provisioningStatusMessage", "type": "str"},
        "provisioning_status_update_time_utc": {"key": "provisioningStatusUpdateTimeUtc", "type": "iso-8601"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "fully_qualified_name": {"key": "fullyQualifiedName", "type": "str"},
        "fully_qualified_friendly_name": {"key": "fullyQualifiedFriendlyName", "type": "str"},
        "url": {"key": "url", "type": "str"},
        "onboarding_state": {"key": "onboardingState", "type": "str"},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "_models.DevOpsProvisioningState"]] = None,
        onboarding_state: Optional[Union[str, "_models.OnboardingState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provisioning_state: The provisioning state of the resource.

         Pending - Provisioning pending.
         Failed - Provisioning failed.
         Succeeded - Successful provisioning.
         Canceled - Provisioning canceled.
         PendingDeletion - Deletion pending.
         DeletionSuccess - Deletion successful.
         DeletionFailure - Deletion failure. Known values are: "Succeeded", "Failed", "Canceled",
         "Pending", "PendingDeletion", "DeletionSuccess", and "DeletionFailure".
        :paramtype provisioning_state: str or
         ~azure.mgmt.security.v2024_04_01.models.DevOpsProvisioningState
        :keyword onboarding_state: Details about resource onboarding status across all connectors.

         OnboardedByOtherConnector - this resource has already been onboarded to another connector.
         This is only applicable to top-level resources.
         Onboarded - this resource has already been onboarded by the specified connector.
         NotOnboarded - this resource has not been onboarded to any connector.
         NotApplicable - the onboarding state is not applicable to the current endpoint. Known values
         are: "NotApplicable", "OnboardedByOtherConnector", "Onboarded", and "NotOnboarded".
        :paramtype onboarding_state: str or ~azure.mgmt.security.v2024_04_01.models.OnboardingState
        """
        super().__init__(**kwargs)
        self.provisioning_status_message = None
        self.provisioning_status_update_time_utc = None
        self.provisioning_state = provisioning_state
        self.fully_qualified_name = None
        self.fully_qualified_friendly_name = None
        self.url = None
        self.onboarding_state = onboarding_state


class GitLabProject(ProxyResource):
    """GitLab Project resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.security.v2024_04_01.models.SystemData
    :ivar properties: GitLab Project properties.
    :vartype properties: ~azure.mgmt.security.v2024_04_01.models.GitLabProjectProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "GitLabProjectProperties"},
    }

    def __init__(self, *, properties: Optional["_models.GitLabProjectProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: GitLab Project properties.
        :paramtype properties: ~azure.mgmt.security.v2024_04_01.models.GitLabProjectProperties
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.properties = properties


class GitLabProjectListResponse(_serialization.Model):
    """List of RP resources which supports pagination.

    :ivar value: Gets or sets list of resources.
    :vartype value: list[~azure.mgmt.security.v2024_04_01.models.GitLabProject]
    :ivar next_link: Gets or sets next link to scroll over the results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[GitLabProject]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.GitLabProject"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets or sets list of resources.
        :paramtype value: list[~azure.mgmt.security.v2024_04_01.models.GitLabProject]
        :keyword next_link: Gets or sets next link to scroll over the results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GitLabProjectProperties(_serialization.Model):
    """GitLab Project properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_status_message: Gets or sets resource status message.
    :vartype provisioning_status_message: str
    :ivar provisioning_status_update_time_utc: Gets or sets time when resource was last checked.
    :vartype provisioning_status_update_time_utc: ~datetime.datetime
    :ivar provisioning_state: The provisioning state of the resource.

     Pending - Provisioning pending.
     Failed - Provisioning failed.
     Succeeded - Successful provisioning.
     Canceled - Provisioning canceled.
     PendingDeletion - Deletion pending.
     DeletionSuccess - Deletion successful.
     DeletionFailure - Deletion failure. Known values are: "Succeeded", "Failed", "Canceled",
     "Pending", "PendingDeletion", "DeletionSuccess", and "DeletionFailure".
    :vartype provisioning_state: str or
     ~azure.mgmt.security.v2024_04_01.models.DevOpsProvisioningState
    :ivar fully_qualified_name: Gets or sets the fully-qualified name of the project object.

     This contains the entire hierarchy where entities are separated by the '$' character.
    :vartype fully_qualified_name: str
    :ivar fully_qualified_friendly_name: Gets or sets the human readable fully-qualified name of
     the Project object.

     This contains the entire namespace hierarchy as seen on GitLab UI where entities are separated
     by the '/' character.
    :vartype fully_qualified_friendly_name: str
    :ivar fully_qualified_parent_group_name: Gets or sets the fully-qualified name of the project's
     parent group object.

     This contains the entire hierarchy where namespaces are separated by the '$' character.
    :vartype fully_qualified_parent_group_name: str
    :ivar url: Gets or sets the url of the GitLab Project.
    :vartype url: str
    :ivar onboarding_state: Details about resource onboarding status across all connectors.

     OnboardedByOtherConnector - this resource has already been onboarded to another connector.
     This is only applicable to top-level resources.
     Onboarded - this resource has already been onboarded by the specified connector.
     NotOnboarded - this resource has not been onboarded to any connector.
     NotApplicable - the onboarding state is not applicable to the current endpoint. Known values
     are: "NotApplicable", "OnboardedByOtherConnector", "Onboarded", and "NotOnboarded".
    :vartype onboarding_state: str or ~azure.mgmt.security.v2024_04_01.models.OnboardingState
    """

    _validation = {
        "provisioning_status_message": {"readonly": True},
        "provisioning_status_update_time_utc": {"readonly": True},
        "fully_qualified_name": {"readonly": True},
        "fully_qualified_friendly_name": {"readonly": True},
        "fully_qualified_parent_group_name": {"readonly": True},
        "url": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_status_message": {"key": "provisioningStatusMessage", "type": "str"},
        "provisioning_status_update_time_utc": {"key": "provisioningStatusUpdateTimeUtc", "type": "iso-8601"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "fully_qualified_name": {"key": "fullyQualifiedName", "type": "str"},
        "fully_qualified_friendly_name": {"key": "fullyQualifiedFriendlyName", "type": "str"},
        "fully_qualified_parent_group_name": {"key": "fullyQualifiedParentGroupName", "type": "str"},
        "url": {"key": "url", "type": "str"},
        "onboarding_state": {"key": "onboardingState", "type": "str"},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "_models.DevOpsProvisioningState"]] = None,
        onboarding_state: Optional[Union[str, "_models.OnboardingState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provisioning_state: The provisioning state of the resource.

         Pending - Provisioning pending.
         Failed - Provisioning failed.
         Succeeded - Successful provisioning.
         Canceled - Provisioning canceled.
         PendingDeletion - Deletion pending.
         DeletionSuccess - Deletion successful.
         DeletionFailure - Deletion failure. Known values are: "Succeeded", "Failed", "Canceled",
         "Pending", "PendingDeletion", "DeletionSuccess", and "DeletionFailure".
        :paramtype provisioning_state: str or
         ~azure.mgmt.security.v2024_04_01.models.DevOpsProvisioningState
        :keyword onboarding_state: Details about resource onboarding status across all connectors.

         OnboardedByOtherConnector - this resource has already been onboarded to another connector.
         This is only applicable to top-level resources.
         Onboarded - this resource has already been onboarded by the specified connector.
         NotOnboarded - this resource has not been onboarded to any connector.
         NotApplicable - the onboarding state is not applicable to the current endpoint. Known values
         are: "NotApplicable", "OnboardedByOtherConnector", "Onboarded", and "NotOnboarded".
        :paramtype onboarding_state: str or ~azure.mgmt.security.v2024_04_01.models.OnboardingState
        """
        super().__init__(**kwargs)
        self.provisioning_status_message = None
        self.provisioning_status_update_time_utc = None
        self.provisioning_state = provisioning_state
        self.fully_qualified_name = None
        self.fully_qualified_friendly_name = None
        self.fully_qualified_parent_group_name = None
        self.url = None
        self.onboarding_state = onboarding_state


class OperationStatusResult(_serialization.Model):
    """The current status of an async operation.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified ID for the async operation.
    :vartype id: str
    :ivar name: Name of the async operation.
    :vartype name: str
    :ivar status: Operation status. Required.
    :vartype status: str
    :ivar percent_complete: Percent of the operation that is complete.
    :vartype percent_complete: float
    :ivar start_time: The start time of the operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the operation.
    :vartype end_time: ~datetime.datetime
    :ivar operations: The operations list.
    :vartype operations: list[~azure.mgmt.security.v2024_04_01.models.OperationStatusResult]
    :ivar error: If present, details of the operation error.
    :vartype error: ~azure.mgmt.security.v2024_04_01.models.ErrorDetail
    """

    _validation = {
        "status": {"required": True},
        "percent_complete": {"maximum": 100, "minimum": 0},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "percent_complete": {"key": "percentComplete", "type": "float"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "operations": {"key": "operations", "type": "[OperationStatusResult]"},
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(
        self,
        *,
        status: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        percent_complete: Optional[float] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        operations: Optional[List["_models.OperationStatusResult"]] = None,
        error: Optional["_models.ErrorDetail"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Fully qualified ID for the async operation.
        :paramtype id: str
        :keyword name: Name of the async operation.
        :paramtype name: str
        :keyword status: Operation status. Required.
        :paramtype status: str
        :keyword percent_complete: Percent of the operation that is complete.
        :paramtype percent_complete: float
        :keyword start_time: The start time of the operation.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time of the operation.
        :paramtype end_time: ~datetime.datetime
        :keyword operations: The operations list.
        :paramtype operations: list[~azure.mgmt.security.v2024_04_01.models.OperationStatusResult]
        :keyword error: If present, details of the operation error.
        :paramtype error: ~azure.mgmt.security.v2024_04_01.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.status = status
        self.percent_complete = percent_complete
        self.start_time = start_time
        self.end_time = end_time
        self.operations = operations
        self.error = error


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.security.v2024_04_01.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.security.v2024_04_01.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.security.v2024_04_01.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.security.v2024_04_01.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TargetBranchConfiguration(_serialization.Model):
    """Repository branch configuration for PR Annotations.

    :ivar branch_names: Gets or sets branches that should have annotations.
    :vartype branch_names: list[str]
    :ivar annotate_default_branch: Configuration of PR Annotations on default branch.

     Enabled - PR Annotations are enabled on the resource's default branch.
     Disabled - PR Annotations are disabled on the resource's default branch. Known values are:
     "Disabled" and "Enabled".
    :vartype annotate_default_branch: str or
     ~azure.mgmt.security.v2024_04_01.models.AnnotateDefaultBranchState
    """

    _attribute_map = {
        "branch_names": {"key": "branchNames", "type": "[str]"},
        "annotate_default_branch": {"key": "annotateDefaultBranch", "type": "str"},
    }

    def __init__(
        self,
        *,
        branch_names: Optional[List[str]] = None,
        annotate_default_branch: Optional[Union[str, "_models.AnnotateDefaultBranchState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword branch_names: Gets or sets branches that should have annotations.
        :paramtype branch_names: list[str]
        :keyword annotate_default_branch: Configuration of PR Annotations on default branch.

         Enabled - PR Annotations are enabled on the resource's default branch.
         Disabled - PR Annotations are disabled on the resource's default branch. Known values are:
         "Disabled" and "Enabled".
        :paramtype annotate_default_branch: str or
         ~azure.mgmt.security.v2024_04_01.models.AnnotateDefaultBranchState
        """
        super().__init__(**kwargs)
        self.branch_names = branch_names
        self.annotate_default_branch = annotate_default_branch
