% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NanoStringQualityMetrics.R
\docType{methods}
\name{flagSamplesCount,RccSet-method}
\alias{flagSamplesCount,RccSet-method}
\alias{flagSamplesCount}
\title{flagSamplesCount}
\usage{
\S4method{flagSamplesCount}{RccSet}(rccSet, method = c("cutoffByMMAD",
  "cutoffByVar"), stringency = 4, maxMiss = 0.2)
}
\arguments{
\item{rccSet}{An RccSet object}

\item{method}{Character string specifying the method for outlier detection: either
"cutoffByMMAD" or "cutoffByVar".}

\item{stringency}{Numeric value passed to the cutoff function specified by the method
argument (see the 'd' argument of cutoffByMMAD and cutoffByVar).}

\item{maxMiss}{Numeric specifying the allowable fraction of genes below the lower limit
of detection in a sample.}
}
\value{
A numeric vector giving the indices of samples with outlier values
according to the criteria described above.
}
\description{
Flag samples based on overall counts
}
\details{
The method and stringency arguments deterine a cutoff value used to flag
samples as outliers: samples will be flagged if the sum of counts of their
endogeneous genes exceeds the cutoff or if the ratio of the sums of their
positive controls to the sums of their endogenous genes exceeds three
times the cutoff. Samples will also be flagged if the fraction of
genes below the lower limit of detection exceeds the maxMiss value.
}
\author{
Dorothee Nickles
}
