% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{theme_map}
\alias{theme_map}
\title{Create a theme for map plotting}
\usage{
theme_map(
  font_size = 14,
  font_family = "",
  line_size = 0.5,
  rel_small = 12/14,
  rel_tiny = 11/14,
  rel_large = 16/14
)
}
\arguments{
\item{font_size}{Overall font size. Default is 14.}

\item{font_family}{Base font family.}

\item{line_size}{Line size for axis lines.}

\item{rel_small}{Relative size of small text (e.g., axis tick labels)}

\item{rel_tiny}{Relative size of tiny text (e.g., caption)}

\item{rel_large}{Relative size of large text (e.g., title)}
}
\value{
The theme.
}
\description{
The theme created by this function is useful for plotting maps with cowplot default sizing.
}
\examples{
library(ggplot2)
library(maps)

usa_data = map_data("usa")
ggplot(usa_data, aes(long, lat, fill = region)) +
  geom_polygon() + theme_map()
ggplot(usa_data, aes(long, lat, fill = region)) +
  facet_wrap(~region, scales = "free") +
  geom_polygon() + theme_map()
}
