% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional_coerce_expr_to_function.R
\name{expr_to_fun}
\alias{expr_to_fun}
\title{Convert expression into function object.}
\usage{
expr_to_fun(expr_, order = NULL, vec_arg = FALSE)
}
\arguments{
\item{expr_}{R expression.}

\item{order}{desired order of function argument.}

\item{vec_arg}{should the function take vector valued argument.}
}
\description{
Convert expression into function object.
}
\examples{

ee  <- expression(b1 + (b0 - b1)*exp(-k*x) + b2*x)
ff1 <- expr_to_fun(ee)
formals(ff1)

ff2 <- expr_to_fun(ee, vec_arg=TRUE)
formals(ff2)
formals(ff2)$length_parm
formals(ff2)$names_parm |> eval()

ee <- expression(matrix(c(x1+x2, x1-x2, x1^2+x2^2, x1^3+x2^3), nrow=2))
ff1 <- expr_to_fun(ee)
ff2 <- expr_to_fun(ee, vec_arg=TRUE)

formals(ff2)
formals(ff2)$length_parm
formals(ff2)$names_parm |> eval()

}
