% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dribble.R
\name{dribble}
\alias{dribble}
\title{dribble object}
\description{
googledrive stores the metadata for one or more Drive files or
shared drives as a \code{dribble}. It is a "Drive
\link[tibble:tibble-package]{tibble}" with one row per file or shared drive
and, at a minimum, these columns:
\itemize{
\item \code{name}: a character column containing file or shared drive names
\item \code{id}: a character column of file or shared drive ids
\item \code{drive_resource}: a list-column, each element of which is either a
\href{https://developers.google.com/drive/api/v3/reference/files#resource-representations}{Files resource}
or a \href{https://developers.google.com/drive/api/v3/reference/drives#resource-representations}{Drives resource}
object. Note there is no guarantee that all documented fields are always
present. We do check if the \code{kind} field is present and equal to one of
\code{drive#file} or \code{drive#drive}.
}

The \code{dribble} format is handy because it exposes the file name,
which is good for humans, but keeps it bundled with the file's unique id
and other metadata, which are needed for API calls.

In general, the \code{dribble} class will be retained even after
manipulation, as long as the required variables are present and of the
correct type. This works best for manipulations via the dplyr and vctrs
packages.
}
\seealso{
\code{\link[=as_dribble]{as_dribble()}}
}
