% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topology.R
\name{isomorphism_class}
\alias{isomorphism_class}
\alias{graph.isoclass}
\alias{graph.isoclass.subgraph}
\title{Isomorphism class of a graph}
\usage{
isomorphism_class(graph, v)
}
\arguments{
\item{graph}{The input graph.}

\item{v}{Optionally a vertex sequence. If not missing, then an induced
subgraph of the input graph, consisting of this vertices, is used.}
}
\value{
An integer number.
}
\description{
The isomorphism class is a non-negative integer number.
Graphs (with the same number of vertices) having the same isomorphism
class are isomorphic and isomorphic graphs always have the same
isomorphism class. Currently it can handle only graphs with 3 or 4
vertices.
}
\examples{
# create some non-isomorphic graphs
g1 <- graph_from_isomorphism_class(3, 10)
g2 <- graph_from_isomorphism_class(3, 11)
isomorphism_class(g1)
isomorphism_class(g2)
isomorphic(g1, g2)
}
\seealso{
Other graph isomorphism: \code{\link{count_isomorphisms}},
  \code{\link{count_subgraph_isomorphisms}},
  \code{\link{graph_from_isomorphism_class}},
  \code{\link{isomorphic}}, \code{\link{isomorphisms}},
  \code{\link{subgraph_isomorphic}},
  \code{\link{subgraph_isomorphisms}}
}
