% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_SG2MG.R
\name{convert_SG2MG}
\alias{convert_SG2MG}
\title{Converts Single-Grain Data to Multiple-Grain Data}
\usage{
convert_SG2MG(object, write_file = FALSE, ...)
}
\arguments{
\item{object}{\linkS4class{Risoe.BINfileData} \link{character} (\strong{required}): \linkS4class{Risoe.BINfileData}
object or BIN/BINX-file name}

\item{write_file}{\link{logical} (\emph{with default}): if the input was a path to a file, the
output can be written to a file if \code{TRUE}. The multiple grain file will be written into the
same folder and with extension \code{-SG} to the file name.}

\item{...}{further arguments passed down to \link{read_BIN2R} if input is file path}
}
\value{
\linkS4class{Risoe.BINfileData} object and if \code{write_file = TRUE} and the input
was a file path, a file is written to origin folder.
}
\description{
Conversion of single-grain data to multiple-grain data by adding signals
from grains belonging to one disc (unique pairs of position, set and run).
}
\section{Function version}{
 0.1.0
}

\examples{
## simple run
## (please not that the example is not using SG data)
data(ExampleData.BINfileData, envir = environment())
convert_SG2MG(CWOSL.SAR.Data)

}
\seealso{
\linkS4class{Risoe.BINfileData}, \link{read_BIN2R}, \link{write_R2BIN}
}
\author{
Sebastian Kreutzer, Geography & Earth Sciences, Aberystwyth University (United Kingdom), Norbert Mercier, IRAMAT-CRP2A, UMR 5060, CNRS-Université Bordeaux Montaigne (France);
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., Mercier, N., 2022. convert_SG2MG(): Converts Single-Grain Data to Multiple-Grain Data. Function version 0.1.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., 2022. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.18. https://CRAN.R-project.org/package=Luminescence
}

\keyword{IO}
