% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circleCub.R
\name{circleCub.Gauss}
\alias{circleCub.Gauss}
\title{Integration of the Isotropic Gaussian Density over Circular Domains}
\usage{
circleCub.Gauss(center, r, mean, sd)
}
\arguments{
\item{center}{numeric vector of length 2 (center of the circle).}

\item{r}{numeric (radius of the circle). Several radii may be supplied.}

\item{mean}{numeric vector of length 2
(mean of the bivariate Gaussian density).}

\item{sd}{numeric (common standard deviation of the isotropic
Gaussian density in both dimensions).}
}
\value{
The integral value (one for each supplied radius).
}
\description{
This function calculates the integral of the bivariate, isotropic Gaussian
density (i.e., \eqn{\Sigma} = \code{sd^2*diag(2)}) over a circular domain
via the cumulative distribution function \code{pchisq} of the (non-central)
Chi-Squared distribution (Abramowitz and Stegun, 1972, Formula 26.3.24).
}
\note{
The non-centrality parameter of the evaluated chi-squared distribution
equals the squared distance between the \code{mean} and the
\code{center}. If this becomes too large, the result becomes inaccurate, see
\code{\link{pchisq}}.
}
\examples{
circleCub.Gauss(center=c(1,2), r=3, mean=c(4,5), sd=6)

if (requireNamespace("mvtnorm") && gpclibPermit() && requireNamespace("spatstat")) {
  ## compare with cubature over a polygonal approximation of a circle
  disc.poly <- spatstat::disc(radius=3, centre=c(1,2), npoly=32)
  polyCub.exact.Gauss(disc.poly, mean=c(4,5), Sigma=6^2*diag(2))
}
}
\references{
Abramowitz, M. and Stegun, I. A. (1972).
Handbook of Mathematical Functions with Formulas, Graphs, and Mathematical
Tables. New York: Dover Publications.
}
\keyword{math}
\keyword{spatial}
