% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nse-defuse.R
\name{expr}
\alias{expr}
\title{Defuse an R expression}
\arguments{
\item{expr}{An expression to defuse.}
}
\description{
\code{expr()} \link[=topic-defuse]{defuses} an R expression with
\link[=injection-operator]{injection} support.

It is equivalent to \code{\link[base:bquote]{base::bquote()}}.
}
\examples{
# R normally returns the result of an expression
1 + 1

# `expr()` defuses the expression that you have supplied and
# returns it instead of its value
expr(1 + 1)

expr(toupper(letters))

# It supports _injection_ with `!!` and `!!!`. This is a convenient
# way of modifying part of an expression by injecting other
# objects.
var <- "cyl"
expr(with(mtcars, mean(!!sym(var))))

vars <- c("cyl", "am")
expr(with(mtcars, c(!!!syms(vars))))

# Compare to the normal way of building expressions
call("with", call("mean", sym(var)))

call("with", call2("c", !!!syms(vars)))

}
\seealso{
\itemize{
\item \ifelse{html}{\link[=topic-defuse]{Defusing R expressions}}{\link[=topic-defuse]{Defusing R expressions}} for an overview.
\item \code{\link[=enquo]{enquo()}} to defuse non-local expressions from function
arguments.
\item \link[=defusing-advanced]{Advanced defusal operators}.
\item \code{\link[=sym]{sym()}} and \code{\link[=call2]{call2()}} for building expressions (symbols and calls
respectively) programmatically.
\item \code{\link[base:eval]{base::eval()}} and \code{\link[=eval_bare]{eval_bare()}} for resuming evaluation
of a defused expression.
}
}
