% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag-metadata.R
\name{tags-rd}
\alias{tags-rd}
\alias{@description}
\alias{@details}
\alias{@example}
\alias{@examples}
\alias{@examplesIf}
\alias{@noRd}
\alias{@param}
\alias{@rawRd}
\alias{@return}
\alias{@returns}
\alias{@title}
\alias{@usage}
\title{Tags for documenting functions}
\usage{
#' @description${1:A short description...}

#' @details${1:Additional details...}

#' @example ${1:path}.R
#' @examples${1:# example code}

#' @examplesIf ${1:condition}${2:# example code}

#' @noRd
#' @param ${1:name} ${2:description}
#' @rawRd ${1:rd}
#' @return ${1:description}
#' @returns ${1:description}
#' @title ${1:title}
#' @usage ${1:fun}(${2:arg1, arg2 = default, ...})
}
\description{
Learn the full details in \code{vignette('rd')}.

Key tags:
\itemize{
\item \verb{@description$\{1:A short description...\} }: A short description of the purpose of the function. Usually around a paragraph, but can be longer if needed.
\item \verb{@example $\{1:path\}.R}: Embed examples stored in another file.
\item \verb{@examples$\{1:# example code\} }: Executable R code that demonstrates how the function works. Code must run without error.
\item \verb{@examplesIf $\{1:condition\}$\{2:# example code\} }: Run examples only when \code{condition} is \code{TRUE}.
\item \verb{@noRd}: Suppress \code{.Rd} generation for a block. Use for documentation blocks that should only be visible in the source code.
\item \verb{@param $\{1:name\} $\{2:description\}}: Describe a function input. Should describe acceptable input types and how it affects the output. \code{description} is usually one or two sentences but can be as long as needed.
Document multiple arguments by separating their names with commas without spaces.
\item \verb{@returns $\{1:description\}}: Describe the function's output. Typically will be a 1-2 sentence description of the output type, but might also include discussion of important errors or warnings.
\item \verb{@title $\{1:title\}}: A one-line description of the function shown in various indexes. An explicit \verb{@title} is not usually needed as by default it is taken from the first paragraph in the roxygen block.
\item \verb{@usage $\{1:fun\}($\{2:arg1, arg2 = default, ...\})}: Override the default usage generated by roxygen2. Only needed when roxygen2 fails to correctly derive the usage of your function.
}

Other less frequently used tags:
\itemize{
\item \verb{@details$\{1:Additional details...\} }: Additional details about the function. Generally superseded by instead using a level 1 heading.
\item \verb{@rawRd $\{1:rd\}}: Insert literal text directly into the \code{.Rd} file.
\item \verb{@return $\{1:description\}}: Describe the function's output. Superseded in favour of \verb{@returns}.
}
}
\seealso{
Other documentation tags: 
\code{\link{tags-index-crossref}},
\code{\link{tags-rd-other}},
\code{\link{tags-reuse}}
}
\concept{documentation tags}
