% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select-helpers.R
\name{select_helpers}
\alias{select_helpers}
\alias{starts_with}
\alias{ends_with}
\alias{contains}
\alias{matches}
\alias{num_range}
\alias{all_of}
\alias{any_of}
\alias{everything}
\alias{last_col}
\title{Select helpers}
\usage{
starts_with(match, ignore.case = TRUE, vars = peek_vars(fn = "starts_with"))

ends_with(match, ignore.case = TRUE, vars = peek_vars(fn = "ends_with"))

contains(match, ignore.case = TRUE, vars = peek_vars(fn = "contains"))

matches(
  match,
  ignore.case = TRUE,
  perl = FALSE,
  vars = peek_vars(fn = "matches")
)

num_range(prefix, range, width = NULL, vars = peek_vars(fn = "num_range"))

all_of(x)

any_of(x, ..., vars = peek_vars(fn = "any_of"))

everything(vars = peek_vars(fn = "everything"))

last_col(offset = 0L, vars = peek_vars(fn = "last_col"))
}
\arguments{
\item{match}{A character vector. If length > 1, the union of the
matches is taken.}

\item{ignore.case}{If \code{TRUE}, the default, ignores case when matching
names.}

\item{vars}{A character vector of variable names. When called
from inside selecting functions like \code{\link[dplyr:select]{dplyr::select()}} these are
automatically set to the names of the table.}

\item{perl}{Should Perl-compatible regexps be used?}

\item{prefix}{A prefix that starts the numeric range.}

\item{range}{A sequence of integers, like \code{1:5}.}

\item{width}{Optionally, the "width" of the numeric range. For example,
a range of 2 gives "01", a range of three "001", etc.}

\item{x}{An index vector of names or locations.}

\item{...}{These dots are for future extensions and must be empty.}

\item{offset}{Set it to \code{n} to select the nth var from the end.}
}
\value{
An integer vector giving the position of the matched variables.
}
\description{
These functions allow you to select variables based on their names.
\itemize{
\item \code{starts_with()}: Starts with a prefix.
\item \code{ends_with()}: Ends with a suffix.
\item \code{contains()}: Contains a literal string.
\item \code{matches()}: Matches a regular expression.
\item \code{num_range()}: Matches a numerical range like x01, x02, x03.
\item \code{all_of()}: Matches variable names in a character vector. All
names must be present, otherwise an out-of-bounds error is
thrown.
\item \code{any_of()}: Same as \code{all_of()}, except that no error is thrown
for names that don't exist.
\item \code{everything()}: Matches all variables.
\item \code{last_col()}: Select last variable, possibly with an offset.
}
}
\details{
In selection context you can also use these operators:
\itemize{
\item \code{"/"} for taking the difference between two sets of variables.
\item \code{":"} for selecting a range of consecutive variables.
\item \code{"c"} for selecting the union of sets of variables.
}

The boolean operators were more recently overloaded to operate on
selections:
\itemize{
\item \code{"!"} for taking the complement of a set of variables.
\item \code{"&"} and \code{"|"} for selecting the intersection or the union of two
sets of variables.
}

The order of selected columns is determined by the inputs.
\itemize{
\item \code{one_of(c("foo", "bar"))} selects \code{"foo"} first.
\item \code{c(starts_with("c"), starts_with("d"))} selects all columns
starting with \code{"c"} first, then all columns starting with \code{"d"}.
}
}
\examples{
nms <- names(iris)
vars_select(nms, starts_with("Petal"))
vars_select(nms, ends_with("Width"))
vars_select(nms, contains("etal"))
vars_select(nms, matches(".t."))
vars_select(nms, Petal.Length, Petal.Width)
vars_select(nms, everything())
vars_select(nms, last_col())
vars_select(nms, last_col(offset = 2))

# With multiple matchers, the union of the matches is selected:
vars_select(nms, starts_with(c("Petal", "Sepal")))

# `!` negates a selection:
vars_select(nms, !ends_with("Width"))

# `&` and `|` take the intersection or the union of two selections:
vars_select(nms, starts_with("Petal") & ends_with("Width"))
vars_select(nms, starts_with("Petal") | ends_with("Width"))

# `/` takes the difference of two selections
vars_select(nms, starts_with("Petal") / ends_with("Width"))

# `all_of()` selects the variables in a character vector:
vars <- c("Petal.Length", "Petal.Width")
vars_select(nms, all_of(vars))

# Whereas `all_of()` is strict, `any_of()` allows missing
# variables.
try(vars_select(nms, all_of(c("Species", "Genres"))))
vars_select(nms, any_of(c("Species", "Genres")))

# The lax variant is especially useful to make sure a variable is
# selected out:
vars_select(nms, -any_of(c("Species", "Genres")))

# The order of selected columns is determined from the inputs
vars_select(names(mtcars), starts_with("c"), starts_with("d"))
vars_select(names(mtcars), one_of(c("carb", "mpg")))
}
