      SUBROUTINE HPINS(NMAX,NWDS,DATA,N,T,XNODE,HPFUN)
C
C   PURPOSE
C         THIS ROUTINE INSERTS A NODE INTO AN ALREADY EXISTING HEAP.
C             THE RESULTING TREE IS RE-HEAPED.
C
C   INPUT
C         NMAX = MAXIMUM NUMBER OF NODES ALLOWED BY USER.
C         NWDS = NUMBER OF WORDS PER NODE.
C         DATA = WORK AREA FOR STORING NODES.
C         N = CURRENT NUMBER OF NODES IN THE TREE.
C         T = INTEGER ARRAY OF POINTERS TO HEAP NODES.
C         XNODE = A REAL ARRAY, NWDS WORDS LONG, WHICH
C                CONTAINS THE NODAL INFORMATION TO BE INSERTED.
C         HPFUN = NAME OF USER WRITTEN FUNCTION TO DETERMINE
C                THE TOP NODE.
C   OUTPUT
C         DATA = WORK AREA WITH NEW NODE INSERTED.
C         N = UPDATED NUMBER OF NODES.
C         T = UPDATED INTEGER POINTER ARRAY.
C
      DOUBLE PRECISION XNODE(1),DATA(1)
      INTEGER T(1)
      LOGICAL HPFUN
      EXTERNAL HPFUN
      IF(N .EQ. NMAX) RETURN
      N=N+1
      J= T(N)-1
      DO 1 I= 1,NWDS
         IPJ=I+J
    1    DATA(IPJ) = XNODE(I)
      J=N
    2 CONTINUE
      IF(J .EQ. 1) RETURN
      JR=T(J)
      J2=J/2
      JL=T(J2)
      IF(HPFUN(DATA(JL),DATA(JR),NWDS)) RETURN
      T(J2)=T(J)
      T(J)=JL
      J=J2
      GO TO 2
      END
