/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg" on Wed Aug  1 15:15:05 2012

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_34 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 28463, "epsg", 28463,
        "Pulkovo 1942 / Gauss-Kruger 3N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 3N (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28463\"]]");
    p = add_epsg_def (filter, first, last, 28464, "epsg", 28464,
        "Pulkovo 1942 / Gauss-Kruger 4N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 4N (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 9,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28464\"]]");
    p = add_epsg_def (filter, first, last, 28465, "epsg", 28465,
        "Pulkovo 1942 / Gauss-Kruger 5N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 5N (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 9,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28465\"]]");
    p = add_epsg_def (filter, first, last, 28466, "epsg", 28466,
        "Pulkovo 1942 / Gauss-Kruger 6N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 6N (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 9,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28466\"]]");
    p = add_epsg_def (filter, first, last, 28467, "epsg", 28467,
        "Pulkovo 1942 / Gauss-Kruger 7N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 7N (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 9,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28467\"]]");
    p = add_epsg_def (filter, first, last, 28468, "epsg", 28468,
        "Pulkovo 1942 / Gauss-Kruger 8N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 8N (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",4");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28468\"]]");
    p = add_epsg_def (filter, first, last, 28469, "epsg", 28469,
        "Pulkovo 1942 / Gauss-Kruger 9N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 9N (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 7,
        "284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 9,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28469\"]]");
    p = add_epsg_def (filter, first, last, 28470, "epsg", 28470,
        "Pulkovo 1942 / Gauss-Kruger 10N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 10N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 9,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28470\"]]");
    p = add_epsg_def (filter, first, last, 28471, "epsg", 28471,
        "Pulkovo 1942 / Gauss-Kruger 11N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 11N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 9,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28471\"]]");
    p = add_epsg_def (filter, first, last, 28472, "epsg", 28472,
        "Pulkovo 1942 / Gauss-Kruger 12N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 12N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 9,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28472\"]]");
    p = add_epsg_def (filter, first, last, 28473, "epsg", 28473,
        "Pulkovo 1942 / Gauss-Kruger 13N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 13N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",7");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28473\"]]");
    p = add_epsg_def (filter, first, last, 28474, "epsg", 28474,
        "Pulkovo 1942 / Gauss-Kruger 14N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 14N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 9,
        "1],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28474\"]]");
    p = add_epsg_def (filter, first, last, 28475, "epsg", 28475,
        "Pulkovo 1942 / Gauss-Kruger 15N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 15N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",8");
    add_srs_wkt (p, 9,
        "7],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28475\"]]");
    p = add_epsg_def (filter, first, last, 28476, "epsg", 28476,
        "Pulkovo 1942 / Gauss-Kruger 16N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 16N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 9,
        "3],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28476\"]]");
    p = add_epsg_def (filter, first, last, 28477, "epsg", 28477,
        "Pulkovo 1942 / Gauss-Kruger 17N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0");
    add_proj4text (p, 2,
        ".12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 17N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",9");
    add_srs_wkt (p, 9,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28477\"]]");
    p = add_epsg_def (filter, first, last, 28478, "epsg", 28478,
        "Pulkovo 1942 / Gauss-Kruger 18N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 18N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "05],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12,
        "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28478\"]]");
    p = add_epsg_def (filter, first, last, 28479, "epsg", 28479,
        "Pulkovo 1942 / Gauss-Kruger 19N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 19N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "11],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12,
        "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28479\"]]");
    p = add_epsg_def (filter, first, last, 28480, "epsg", 28480,
        "Pulkovo 1942 / Gauss-Kruger 20N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 20N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "17],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12,
        "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28480\"]]");
    p = add_epsg_def (filter, first, last, 28481, "epsg", 28481,
        "Pulkovo 1942 / Gauss-Kruger 21N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 21N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "23],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12,
        "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28481\"]]");
    p = add_epsg_def (filter, first, last, 28482, "epsg", 28482,
        "Pulkovo 1942 / Gauss-Kruger 22N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 22N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "29],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12,
        "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28482\"]]");
    p = add_epsg_def (filter, first, last, 28483, "epsg", 28483,
        "Pulkovo 1942 / Gauss-Kruger 23N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 23N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "35],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12,
        "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28483\"]]");
    p = add_epsg_def (filter, first, last, 28484, "epsg", 28484,
        "Pulkovo 1942 / Gauss-Kruger 24N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 24N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "41],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12,
        "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28484\"]]");
    p = add_epsg_def (filter, first, last, 28485, "epsg", 28485,
        "Pulkovo 1942 / Gauss-Kruger 25N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 25N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "47],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12,
        "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28485\"]]");
    p = add_epsg_def (filter, first, last, 28486, "epsg", 28486,
        "Pulkovo 1942 / Gauss-Kruger 26N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 26N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "53],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12,
        "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28486\"]]");
    p = add_epsg_def (filter, first, last, 28487, "epsg", 28487,
        "Pulkovo 1942 / Gauss-Kruger 27N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 27N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "59],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12,
        "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28487\"]]");
    p = add_epsg_def (filter, first, last, 28488, "epsg", 28488,
        "Pulkovo 1942 / Gauss-Kruger 28N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 28N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "65],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12,
        "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28488\"]]");
    p = add_epsg_def (filter, first, last, 28489, "epsg", 28489,
        "Pulkovo 1942 / Gauss-Kruger 29N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 29N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "71],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12,
        "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28489\"]]");
    p = add_epsg_def (filter, first, last, 28490, "epsg", 28490,
        "Pulkovo 1942 / Gauss-Kruger 30N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-");
    add_proj4text (p, 2,
        "0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 30N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",1");
    add_srs_wkt (p, 9,
        "77],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],A");
    add_srs_wkt (p, 12,
        "XIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28490\"]]");
    p = add_epsg_def (filter, first, last, 28491, "epsg", 28491,
        "Pulkovo 1942 / Gauss-Kruger 31N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 31N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "177],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12,
        "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28491\"]]");
    p = add_epsg_def (filter, first, last, 28492, "epsg", 28492,
        "Pulkovo 1942 / Gauss-Kruger 32N (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,");
    add_proj4text (p, 2,
        "-0.12 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942 / Gauss-Kruger 32N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1942\",DATUM[\"Pulkovo_1942\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[23.92,-141.27,-80.9,-0,0.35,0.82,-0.12],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6284\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4284\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 9,
        "171],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],");
    add_srs_wkt (p, 12,
        "AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"28492\"]]");
    p = add_epsg_def (filter, first, last, 28600, "epsg", 28600,
        "Qatar 1974 / Qatar National Grid");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=24.45 +lon_0=51.21666666666667 +k=0.9");
    add_proj4text (p, 1,
        "9999 +x_0=200000 +y_0=300000 +ellps=intl +towgs84=-128.1");
    add_proj4text (p, 2,
        "6,-282.42,21.93,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Qatar 1974 / Qatar National Grid\",GEOGCS[\"Qat");
    add_srs_wkt (p, 1,
        "ar 1974\",DATUM[\"Qatar_1974\",SPHEROID[\"International ");
    add_srs_wkt (p, 2,
        "1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[-128.16,-282.42,21.93,0,0,0,0],AUTHORITY[\"EPSG\",\"628");
    add_srs_wkt (p, 4,
        "5\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4285\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",2");
    add_srs_wkt (p, 8,
        "4.45],PARAMETER[\"central_meridian\",51.21666666666667],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",0.99999],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",200000],PARAMETER[\"false_northing\",300000],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "28600\"]]");
    p = add_epsg_def (filter, first, last, 28991, "epsg", 28991,
        "Amersfoort / RD Old");
    add_proj4text (p, 0,
        "+proj=sterea +lat_0=52.15616055555555 +lon_0=5.387638888");
    add_proj4text (p, 1,
        "88889 +k=0.9999079 +x_0=0 +y_0=0 +ellps=bessel +towgs84=");
    add_proj4text (p, 2,
        "565.417,50.3319,465.552,-0.398957,0.343988,-1.8774,4.072");
    add_proj4text (p, 3,
        "5 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Amersfoort / RD Old\",GEOGCS[\"Amersfoort\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Amersfoort\",SPHEROID[\"Bessel 1841\",6377397.155,2");
    add_srs_wkt (p, 2,
        "99.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[565.417");
    add_srs_wkt (p, 3,
        ",50.3319,465.552,-0.398957,0.343988,-1.8774,4.0725],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6289\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"428");
    add_srs_wkt (p, 7,
        "9\"]],PROJECTION[\"Oblique_Stereographic\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",52.15616055555555],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",5.38763888888889],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",0.9999079],PARAMETER[\"false_easting\",0],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"28991\"]]");
    p = add_epsg_def (filter, first, last, 28992, "epsg", 28992,
        "Amersfoort / RD New");
    add_proj4text (p, 0,
        "+proj=sterea +lat_0=52.15616055555555 +lon_0=5.387638888");
    add_proj4text (p, 1,
        "88889 +k=0.9999079 +x_0=155000 +y_0=463000 +ellps=bessel");
    add_proj4text (p, 2,
        " +towgs84=565.417,50.3319,465.552,-0.398957,0.343988,-1.");
    add_proj4text (p, 3,
        "8774,4.0725 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Amersfoort / RD New\",GEOGCS[\"Amersfoort\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Amersfoort\",SPHEROID[\"Bessel 1841\",6377397.155,2");
    add_srs_wkt (p, 2,
        "99.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[565.417");
    add_srs_wkt (p, 3,
        ",50.3319,465.552,-0.398957,0.343988,-1.8774,4.0725],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6289\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"428");
    add_srs_wkt (p, 7,
        "9\"]],PROJECTION[\"Oblique_Stereographic\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",52.15616055555555],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",5.38763888888889],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",0.9999079],PARAMETER[\"false_easting\",155000],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",463000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"28992\"]]");
    p = add_epsg_def (filter, first, last, 29100, "epsg", 29100,
        "SAD69 / Brazil Polyconic (deprecated)");
    add_proj4text (p, 0,
        "+proj=poly +lat_0=0 +lon_0=-54 +x_0=5000000 +y_0=1000000");
    add_proj4text (p, 1,
        "0 +ellps=GRS67 +towgs84=-57,1,-41,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / Brazil Polyconic (deprecated)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"SAD69\",DATUM[\"South_American_Datum_1969\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "GRS 1967\",6378160,298.247167427,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "36\"]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "291\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9108\"]],AUTHORITY[\"EPSG\",\"4291\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Polyconic\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",-54],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",5000000],PARAMETER[\"false_northing\",10000000],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"29100\"]]");
    p = add_epsg_def (filter, first, last, 29101, "epsg", 29101,
        "SAD69 / Brazil Polyconic");
    add_proj4text (p, 0,
        "+proj=poly +lat_0=0 +lon_0=-54 +x_0=5000000 +y_0=1000000");
    add_proj4text (p, 1,
        "0 +ellps=aust_SA +towgs84=-57,1,-41,0,0,0,0 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / Brazil Polyconic\",GEOGCS[\"SAD69\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"South_American_Datum_1969\",SPHEROID[\"GRS 1967 Mod");
    add_srs_wkt (p, 2,
        "ified\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Polyconic\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-54],PARAMETER[\"false_easting\",5000000],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_northing\",10000000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 10,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 11,
        ",NORTH],AUTHORITY[\"EPSG\",\"29101\"]]");
    p = add_epsg_def (filter, first, last, 29118, "epsg", 29118,
        "SAD69 / UTM zone 18N (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=GRS67 +towgs84=-57,1,-41,0,0,0");
    add_proj4text (p, 1,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 18N (deprecated)\",GEOGCS[\"SA");
    add_srs_wkt (p, 1,
        "D69\",DATUM[\"South_American_Datum_1969\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1967\",6378160,298.247167427,AUTHORITY[\"EPSG\",\"7036\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6291\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9108\"]],AUTHORITY[\"EPSG\",\"4291\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-75],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"29118\"]]");
    p = add_epsg_def (filter, first, last, 29119, "epsg", 29119,
        "SAD69 / UTM zone 19N (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=GRS67 +towgs84=-57,1,-41,0,0,0");
    add_proj4text (p, 1,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 19N (deprecated)\",GEOGCS[\"SA");
    add_srs_wkt (p, 1,
        "D69\",DATUM[\"South_American_Datum_1969\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1967\",6378160,298.247167427,AUTHORITY[\"EPSG\",\"7036\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6291\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9108\"]],AUTHORITY[\"EPSG\",\"4291\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-69],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"29119\"]]");
    p = add_epsg_def (filter, first, last, 29120, "epsg", 29120,
        "SAD69 / UTM zone 20N (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=GRS67 +towgs84=-57,1,-41,0,0,0");
    add_proj4text (p, 1,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 20N (deprecated)\",GEOGCS[\"SA");
    add_srs_wkt (p, 1,
        "D69\",DATUM[\"South_American_Datum_1969\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1967\",6378160,298.247167427,AUTHORITY[\"EPSG\",\"7036\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6291\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9108\"]],AUTHORITY[\"EPSG\",\"4291\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-63],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"29120\"]]");
    p = add_epsg_def (filter, first, last, 29121, "epsg", 29121,
        "SAD69 / UTM zone 21N (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +ellps=GRS67 +towgs84=-57,1,-41,0,0,0");
    add_proj4text (p, 1,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 21N (deprecated)\",GEOGCS[\"SA");
    add_srs_wkt (p, 1,
        "D69\",DATUM[\"South_American_Datum_1969\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1967\",6378160,298.247167427,AUTHORITY[\"EPSG\",\"7036\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6291\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9108\"]],AUTHORITY[\"EPSG\",\"4291\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-57],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"29121\"]]");
    p = add_epsg_def (filter, first, last, 29122, "epsg", 29122,
        "SAD69 / UTM zone 22N (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +ellps=GRS67 +towgs84=-57,1,-41,0,0,0");
    add_proj4text (p, 1,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 22N (deprecated)\",GEOGCS[\"SA");
    add_srs_wkt (p, 1,
        "D69\",DATUM[\"South_American_Datum_1969\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1967\",6378160,298.247167427,AUTHORITY[\"EPSG\",\"7036\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6291\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9108\"]],AUTHORITY[\"EPSG\",\"4291\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-51],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"29122\"]]");
    p = add_epsg_def (filter, first, last, 29168, "epsg", 29168,
        "SAD69 / UTM zone 18N");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=aust_SA +towgs84=-57,1,-41,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 18N\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-75],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"29168\"]]");
    p = add_epsg_def (filter, first, last, 29169, "epsg", 29169,
        "SAD69 / UTM zone 19N");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=aust_SA +towgs84=-57,1,-41,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 19N\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-69],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"29169\"]]");
    p = add_epsg_def (filter, first, last, 29170, "epsg", 29170,
        "SAD69 / UTM zone 20N");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=aust_SA +towgs84=-57,1,-41,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 20N\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-63],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"29170\"]]");
    p = add_epsg_def (filter, first, last, 29171, "epsg", 29171,
        "SAD69 / UTM zone 21N");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +ellps=aust_SA +towgs84=-57,1,-41,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 21N\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-57],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"29171\"]]");
    p = add_epsg_def (filter, first, last, 29172, "epsg", 29172,
        "SAD69 / UTM zone 22N");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +ellps=aust_SA +towgs84=-57,1,-41,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 22N\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-51],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 11,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"29172\"]]");
    p = add_epsg_def (filter, first, last, 29177, "epsg", 29177,
        "SAD69 / UTM zone 17S (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +south +ellps=GRS67 +towgs84=-57,1,-4");
    add_proj4text (p, 1,
        "1,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 17S (deprecated)\",GEOGCS[\"SA");
    add_srs_wkt (p, 1,
        "D69\",DATUM[\"South_American_Datum_1969\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1967\",6378160,298.247167427,AUTHORITY[\"EPSG\",\"7036\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6291\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9108\"]],AUTHORITY[\"EPSG\",\"4291\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-81],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"29177\"]]");
    p = add_epsg_def (filter, first, last, 29178, "epsg", 29178,
        "SAD69 / UTM zone 18S (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +south +ellps=GRS67 +towgs84=-57,1,-4");
    add_proj4text (p, 1,
        "1,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 18S (deprecated)\",GEOGCS[\"SA");
    add_srs_wkt (p, 1,
        "D69\",DATUM[\"South_American_Datum_1969\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1967\",6378160,298.247167427,AUTHORITY[\"EPSG\",\"7036\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6291\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9108\"]],AUTHORITY[\"EPSG\",\"4291\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-75],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"29178\"]]");
    p = add_epsg_def (filter, first, last, 29179, "epsg", 29179,
        "SAD69 / UTM zone 19S (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=GRS67 +towgs84=-57,1,-4");
    add_proj4text (p, 1,
        "1,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 19S (deprecated)\",GEOGCS[\"SA");
    add_srs_wkt (p, 1,
        "D69\",DATUM[\"South_American_Datum_1969\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1967\",6378160,298.247167427,AUTHORITY[\"EPSG\",\"7036\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6291\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9108\"]],AUTHORITY[\"EPSG\",\"4291\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-69],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"29179\"]]");
    p = add_epsg_def (filter, first, last, 29180, "epsg", 29180,
        "SAD69 / UTM zone 20S (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +south +ellps=GRS67 +towgs84=-57,1,-4");
    add_proj4text (p, 1,
        "1,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 20S (deprecated)\",GEOGCS[\"SA");
    add_srs_wkt (p, 1,
        "D69\",DATUM[\"South_American_Datum_1969\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1967\",6378160,298.247167427,AUTHORITY[\"EPSG\",\"7036\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6291\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9108\"]],AUTHORITY[\"EPSG\",\"4291\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-63],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"29180\"]]");
    p = add_epsg_def (filter, first, last, 29181, "epsg", 29181,
        "SAD69 / UTM zone 21S (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=GRS67 +towgs84=-57,1,-4");
    add_proj4text (p, 1,
        "1,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 21S (deprecated)\",GEOGCS[\"SA");
    add_srs_wkt (p, 1,
        "D69\",DATUM[\"South_American_Datum_1969\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1967\",6378160,298.247167427,AUTHORITY[\"EPSG\",\"7036\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6291\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9108\"]],AUTHORITY[\"EPSG\",\"4291\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-57],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"29181\"]]");
    p = add_epsg_def (filter, first, last, 29182, "epsg", 29182,
        "SAD69 / UTM zone 22S (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=GRS67 +towgs84=-57,1,-4");
    add_proj4text (p, 1,
        "1,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 22S (deprecated)\",GEOGCS[\"SA");
    add_srs_wkt (p, 1,
        "D69\",DATUM[\"South_American_Datum_1969\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1967\",6378160,298.247167427,AUTHORITY[\"EPSG\",\"7036\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6291\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9108\"]],AUTHORITY[\"EPSG\",\"4291\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-51],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"29182\"]]");
    p = add_epsg_def (filter, first, last, 29183, "epsg", 29183,
        "SAD69 / UTM zone 23S (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +south +ellps=GRS67 +towgs84=-57,1,-4");
    add_proj4text (p, 1,
        "1,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 23S (deprecated)\",GEOGCS[\"SA");
    add_srs_wkt (p, 1,
        "D69\",DATUM[\"South_American_Datum_1969\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1967\",6378160,298.247167427,AUTHORITY[\"EPSG\",\"7036\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6291\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9108\"]],AUTHORITY[\"EPSG\",\"4291\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-45],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"29183\"]]");
    p = add_epsg_def (filter, first, last, 29184, "epsg", 29184,
        "SAD69 / UTM zone 24S (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +south +ellps=GRS67 +towgs84=-57,1,-4");
    add_proj4text (p, 1,
        "1,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 24S (deprecated)\",GEOGCS[\"SA");
    add_srs_wkt (p, 1,
        "D69\",DATUM[\"South_American_Datum_1969\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1967\",6378160,298.247167427,AUTHORITY[\"EPSG\",\"7036\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6291\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9108\"]],AUTHORITY[\"EPSG\",\"4291\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-39],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"29184\"]]");
    p = add_epsg_def (filter, first, last, 29185, "epsg", 29185,
        "SAD69 / UTM zone 25S (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +south +ellps=GRS67 +towgs84=-57,1,-4");
    add_proj4text (p, 1,
        "1,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 25S (deprecated)\",GEOGCS[\"SA");
    add_srs_wkt (p, 1,
        "D69\",DATUM[\"South_American_Datum_1969\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1967\",6378160,298.247167427,AUTHORITY[\"EPSG\",\"7036\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6291\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9108\"]],AUTHORITY[\"EPSG\",\"4291\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-33],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 12,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"29185\"]]");
    p = add_epsg_def (filter, first, last, 29187, "epsg", 29187,
        "SAD69 / UTM zone 17S");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +south +ellps=aust_SA +towgs84=-57,1,");
    add_proj4text (p, 1,
        "-41,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 17S\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-81],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"29187\"]]");
    p = add_epsg_def (filter, first, last, 29188, "epsg", 29188,
        "SAD69 / UTM zone 18S");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +south +ellps=aust_SA +towgs84=-57,1,");
    add_proj4text (p, 1,
        "-41,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 18S\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-75],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"29188\"]]");
    p = add_epsg_def (filter, first, last, 29189, "epsg", 29189,
        "SAD69 / UTM zone 19S");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=aust_SA +towgs84=-57,1,");
    add_proj4text (p, 1,
        "-41,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 19S\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-69],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"29189\"]]");
    p = add_epsg_def (filter, first, last, 29190, "epsg", 29190,
        "SAD69 / UTM zone 20S");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +south +ellps=aust_SA +towgs84=-57,1,");
    add_proj4text (p, 1,
        "-41,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 20S\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-63],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"29190\"]]");
    p = add_epsg_def (filter, first, last, 29191, "epsg", 29191,
        "SAD69 / UTM zone 21S");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=aust_SA +towgs84=-57,1,");
    add_proj4text (p, 1,
        "-41,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 21S\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-57],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"29191\"]]");
    p = add_epsg_def (filter, first, last, 29192, "epsg", 29192,
        "SAD69 / UTM zone 22S");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=aust_SA +towgs84=-57,1,");
    add_proj4text (p, 1,
        "-41,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 22S\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-51],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"29192\"]]");
    p = add_epsg_def (filter, first, last, 29193, "epsg", 29193,
        "SAD69 / UTM zone 23S");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +south +ellps=aust_SA +towgs84=-57,1,");
    add_proj4text (p, 1,
        "-41,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 23S\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-45],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"29193\"]]");
    p = add_epsg_def (filter, first, last, 29194, "epsg", 29194,
        "SAD69 / UTM zone 24S");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +south +ellps=aust_SA +towgs84=-57,1,");
    add_proj4text (p, 1,
        "-41,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 24S\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-39],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"29194\"]]");
    p = add_epsg_def (filter, first, last, 29195, "epsg", 29195,
        "SAD69 / UTM zone 25S");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +south +ellps=aust_SA +towgs84=-57,1,");
    add_proj4text (p, 1,
        "-41,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SAD69 / UTM zone 25S\",GEOGCS[\"SAD69\",DATUM[\"");
    add_srs_wkt (p, 1,
        "South_American_Datum_1969\",SPHEROID[\"GRS 1967 Modified");
    add_srs_wkt (p, 2,
        "\",6378160,298.25,AUTHORITY[\"EPSG\",\"7050\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "-57,1,-41,0,0,0,0],AUTHORITY[\"EPSG\",\"6618\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4618\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 7,
        "cator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-33],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"29195\"]]");
    p = add_epsg_def (filter, first, last, 29220, "epsg", 29220,
        "Sapper Hill 1943 / UTM zone 20S");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +south +ellps=intl +towgs84=-355,21,7");
    add_proj4text (p, 1,
        "2,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Sapper Hill 1943 / UTM zone 20S\",GEOGCS[\"Sapp");
    add_srs_wkt (p, 1,
        "er Hill 1943\",DATUM[\"Sapper_Hill_1943\",SPHEROID[\"Int");
    add_srs_wkt (p, 2,
        "ernational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-355,21,72,0,0,0,0],AUTHORITY[\"EPSG\",\"6292");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4292\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-63],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"29220\"]]");
    p = add_epsg_def (filter, first, last, 29221, "epsg", 29221,
        "Sapper Hill 1943 / UTM zone 21S");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=intl +towgs84=-355,21,7");
    add_proj4text (p, 1,
        "2,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Sapper Hill 1943 / UTM zone 21S\",GEOGCS[\"Sapp");
    add_srs_wkt (p, 1,
        "er Hill 1943\",DATUM[\"Sapper_Hill_1943\",SPHEROID[\"Int");
    add_srs_wkt (p, 2,
        "ernational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-355,21,72,0,0,0,0],AUTHORITY[\"EPSG\",\"6292");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AUTHORITY[\"EPSG\",\"4292\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 7,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"central_meridian\",-57],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"29221\"]]");
    p = add_epsg_def (filter, first, last, 29333, "epsg", 29333,
        "Schwarzeck / UTM zone 33S");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +south +ellps=bess_nam +towgs84=616,9");
    add_proj4text (p, 1,
        "7,-251,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Schwarzeck / UTM zone 33S\",GEOGCS[\"Schwarzeck");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Schwarzeck\",SPHEROID[\"Bessel Namibia (GLM)\"");
    add_srs_wkt (p, 2,
        ",6377483.865280419,299.1528128,AUTHORITY[\"EPSG\",\"7046");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[616,97,-251,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "293\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AUTHORITY[\"EPSG\",\"4293\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",15],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"29333\"]]");
    p = add_epsg_def (filter, first, last, 29371, "epsg", 29371,
        "Schwarzeck / Lo22/11");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-22 +lon_0=11 +k=1 +x_0=0 +y_0=0 +axi");
    add_proj4text (p, 1,
        "s=wsu +ellps=bess_nam +towgs84=616,97,-251,0,0,0,0 +to_m");
    add_proj4text (p, 2,
        "eter=1.0000135965 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Schwarzeck / Lo22/11\",GEOGCS[\"Schwarzeck\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Schwarzeck\",SPHEROID[\"Bessel Namibia (GLM)\",637");
    add_srs_wkt (p, 2,
        "7483.865280419,299.1528128,AUTHORITY[\"EPSG\",\"7046\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[616,97,-251,0,0,0,0],AUTHORITY[\"EPSG\",\"6293\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4293\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator_South_Orientated\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",-22],PARAMETER[\"central_meridian\",11],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",0");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"German legal me");
    add_srs_wkt (p, 11,
        "tre\",1.0000135965,AUTHORITY[\"EPSG\",\"9031\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"29371\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def (filter, first, last, 29373, "epsg", 29373,
        "Schwarzeck / Lo22/13");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-22 +lon_0=13 +k=1 +x_0=0 +y_0=0 +axi");
    add_proj4text (p, 1,
        "s=wsu +ellps=bess_nam +towgs84=616,97,-251,0,0,0,0 +to_m");
    add_proj4text (p, 2,
        "eter=1.0000135965 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Schwarzeck / Lo22/13\",GEOGCS[\"Schwarzeck\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Schwarzeck\",SPHEROID[\"Bessel Namibia (GLM)\",637");
    add_srs_wkt (p, 2,
        "7483.865280419,299.1528128,AUTHORITY[\"EPSG\",\"7046\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[616,97,-251,0,0,0,0],AUTHORITY[\"EPSG\",\"6293\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4293\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator_South_Orientated\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",-22],PARAMETER[\"central_meridian\",13],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",0");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"German legal me");
    add_srs_wkt (p, 11,
        "tre\",1.0000135965,AUTHORITY[\"EPSG\",\"9031\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"29373\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def (filter, first, last, 29375, "epsg", 29375,
        "Schwarzeck / Lo22/15");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-22 +lon_0=15 +k=1 +x_0=0 +y_0=0 +axi");
    add_proj4text (p, 1,
        "s=wsu +ellps=bess_nam +towgs84=616,97,-251,0,0,0,0 +to_m");
    add_proj4text (p, 2,
        "eter=1.0000135965 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Schwarzeck / Lo22/15\",GEOGCS[\"Schwarzeck\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Schwarzeck\",SPHEROID[\"Bessel Namibia (GLM)\",637");
    add_srs_wkt (p, 2,
        "7483.865280419,299.1528128,AUTHORITY[\"EPSG\",\"7046\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[616,97,-251,0,0,0,0],AUTHORITY[\"EPSG\",\"6293\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4293\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator_South_Orientated\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",-22],PARAMETER[\"central_meridian\",15],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",0");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"German legal me");
    add_srs_wkt (p, 11,
        "tre\",1.0000135965,AUTHORITY[\"EPSG\",\"9031\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"29375\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def (filter, first, last, 29377, "epsg", 29377,
        "Schwarzeck / Lo22/17");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-22 +lon_0=17 +k=1 +x_0=0 +y_0=0 +axi");
    add_proj4text (p, 1,
        "s=wsu +ellps=bess_nam +towgs84=616,97,-251,0,0,0,0 +to_m");
    add_proj4text (p, 2,
        "eter=1.0000135965 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Schwarzeck / Lo22/17\",GEOGCS[\"Schwarzeck\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Schwarzeck\",SPHEROID[\"Bessel Namibia (GLM)\",637");
    add_srs_wkt (p, 2,
        "7483.865280419,299.1528128,AUTHORITY[\"EPSG\",\"7046\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[616,97,-251,0,0,0,0],AUTHORITY[\"EPSG\",\"6293\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4293\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator_South_Orientated\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",-22],PARAMETER[\"central_meridian\",17],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",0");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"German legal me");
    add_srs_wkt (p, 11,
        "tre\",1.0000135965,AUTHORITY[\"EPSG\",\"9031\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"29377\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def (filter, first, last, 29379, "epsg", 29379,
        "Schwarzeck / Lo22/19");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-22 +lon_0=19 +k=1 +x_0=0 +y_0=0 +axi");
    add_proj4text (p, 1,
        "s=wsu +ellps=bess_nam +towgs84=616,97,-251,0,0,0,0 +to_m");
    add_proj4text (p, 2,
        "eter=1.0000135965 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Schwarzeck / Lo22/19\",GEOGCS[\"Schwarzeck\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Schwarzeck\",SPHEROID[\"Bessel Namibia (GLM)\",637");
    add_srs_wkt (p, 2,
        "7483.865280419,299.1528128,AUTHORITY[\"EPSG\",\"7046\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[616,97,-251,0,0,0,0],AUTHORITY[\"EPSG\",\"6293\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4293\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator_South_Orientated\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",-22],PARAMETER[\"central_meridian\",19],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",0");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"German legal me");
    add_srs_wkt (p, 11,
        "tre\",1.0000135965,AUTHORITY[\"EPSG\",\"9031\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"29379\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def (filter, first, last, 29381, "epsg", 29381,
        "Schwarzeck / Lo22/21");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-22 +lon_0=21 +k=1 +x_0=0 +y_0=0 +axi");
    add_proj4text (p, 1,
        "s=wsu +ellps=bess_nam +towgs84=616,97,-251,0,0,0,0 +to_m");
    add_proj4text (p, 2,
        "eter=1.0000135965 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Schwarzeck / Lo22/21\",GEOGCS[\"Schwarzeck\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Schwarzeck\",SPHEROID[\"Bessel Namibia (GLM)\",637");
    add_srs_wkt (p, 2,
        "7483.865280419,299.1528128,AUTHORITY[\"EPSG\",\"7046\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[616,97,-251,0,0,0,0],AUTHORITY[\"EPSG\",\"6293\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4293\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator_South_Orientated\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",-22],PARAMETER[\"central_meridian\",21],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",0");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"German legal me");
    add_srs_wkt (p, 11,
        "tre\",1.0000135965,AUTHORITY[\"EPSG\",\"9031\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"29381\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def (filter, first, last, 29383, "epsg", 29383,
        "Schwarzeck / Lo22/23");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-22 +lon_0=23 +k=1 +x_0=0 +y_0=0 +axi");
    add_proj4text (p, 1,
        "s=wsu +ellps=bess_nam +towgs84=616,97,-251,0,0,0,0 +to_m");
    add_proj4text (p, 2,
        "eter=1.0000135965 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Schwarzeck / Lo22/23\",GEOGCS[\"Schwarzeck\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Schwarzeck\",SPHEROID[\"Bessel Namibia (GLM)\",637");
    add_srs_wkt (p, 2,
        "7483.865280419,299.1528128,AUTHORITY[\"EPSG\",\"7046\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[616,97,-251,0,0,0,0],AUTHORITY[\"EPSG\",\"6293\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4293\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator_South_Orientated\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",-22],PARAMETER[\"central_meridian\",23],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",0");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"German legal me");
    add_srs_wkt (p, 11,
        "tre\",1.0000135965,AUTHORITY[\"EPSG\",\"9031\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"29383\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def (filter, first, last, 29385, "epsg", 29385,
        "Schwarzeck / Lo22/25");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-22 +lon_0=25 +k=1 +x_0=0 +y_0=0 +axi");
    add_proj4text (p, 1,
        "s=wsu +ellps=bess_nam +towgs84=616,97,-251,0,0,0,0 +to_m");
    add_proj4text (p, 2,
        "eter=1.0000135965 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Schwarzeck / Lo22/25\",GEOGCS[\"Schwarzeck\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"Schwarzeck\",SPHEROID[\"Bessel Namibia (GLM)\",637");
    add_srs_wkt (p, 2,
        "7483.865280419,299.1528128,AUTHORITY[\"EPSG\",\"7046\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[616,97,-251,0,0,0,0],AUTHORITY[\"EPSG\",\"6293\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4293\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator_South_Orientated\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",-22],PARAMETER[\"central_meridian\",25],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",0");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"German legal me");
    add_srs_wkt (p, 11,
        "tre\",1.0000135965,AUTHORITY[\"EPSG\",\"9031\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",WEST],AXIS[\"X\",SOUTH],AUTHORITY[\"EPSG\",\"29385\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def (filter, first, last, 29635, "epsg", 29635,
        "Sudan / UTM zone 35N (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +a=6378249.2 +b=6356515 +units=m +no_");
    add_proj4text (p, 1,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Sudan / UTM zone 35N (deprecated)\",GEOGCS[\"Su");
    add_srs_wkt (p, 1,
        "dan\",DATUM[\"Sudan\",SPHEROID[\"Clarke 1880 (IGN)\",637");
    add_srs_wkt (p, 2,
        "8249.2,293.4660212936269,AUTHORITY[\"EPSG\",\"7011\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6296\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4296\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",2");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"296");
    add_srs_wkt (p, 12,
        "35\"]]");
    p = add_epsg_def (filter, first, last, 29636, "epsg", 29636,
        "Sudan / UTM zone 36N (deprecated)");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +a=6378249.2 +b=6356515 +units=m +no_");
    add_proj4text (p, 1,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Sudan / UTM zone 36N (deprecated)\",GEOGCS[\"Su");
    add_srs_wkt (p, 1,
        "dan\",DATUM[\"Sudan\",SPHEROID[\"Clarke 1880 (IGN)\",637");
    add_srs_wkt (p, 2,
        "8249.2,293.4660212936269,AUTHORITY[\"EPSG\",\"7011\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6296\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9108\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4296\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",3");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"296");
    add_srs_wkt (p, 12,
        "36\"]]");
    p = add_epsg_def (filter, first, last, 29700, "epsg", 29700,
        "Tananarive (Paris) / Laborde Grid (deprecated)");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=-18.9 +lonc=44.10000000000001 +alpha=");
    add_proj4text (p, 1,
        "18.9 +k=0.9995000000000001 +x_0=400000 +y_0=800000 +gamm");
    add_proj4text (p, 2,
        "a=18.9 +ellps=intl +towgs84=-189,-242,-91,0,0,0,0 +pm=pa");
    add_proj4text (p, 3,
        "ris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tananarive (Paris) / Laborde Grid (deprecated)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"Tananarive (Paris)\",DATUM[\"Tananarive_1925_P");
    add_srs_wkt (p, 2,
        "aris\",SPHEROID[\"International 1924\",6378388,297,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7022\"]],TOWGS84[-189,-242,-91,0,0,0,0],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6810\"]],PRIMEM[\"Paris\",2.3372291");
    add_srs_wkt (p, 5,
        "7,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",0.01570796");
    add_srs_wkt (p, 6,
        "326794897,AUTHORITY[\"EPSG\",\"9105\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4810\"]],PROJECTION[\"Hotine_Oblique_Mercator\"],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"latitude_of_center\",-21],PARAMETER[\"longitud");
    add_srs_wkt (p, 9,
        "e_of_center\",49],PARAMETER[\"azimuth\",21],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "rectified_grid_angle\",21],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 11,
        "9995],PARAMETER[\"false_easting\",400000],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",800000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"29700\"]]");
    p = add_epsg_def (filter, first, last, 29702, "epsg", 29702,
        "Tananarive (Paris) / Laborde Grid approximation");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=-18.9 +lonc=44.10000000000001 +alpha=");
    add_proj4text (p, 1,
        "18.9 +k=0.9995000000000001 +x_0=400000 +y_0=800000 +gamm");
    add_proj4text (p, 2,
        "a=18.9 +ellps=intl +towgs84=-189,-242,-91,0,0,0,0 +pm=pa");
    add_proj4text (p, 3,
        "ris +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tananarive (Paris) / Laborde Grid approximation");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"Tananarive (Paris)\",DATUM[\"Tananarive_1925");
    add_srs_wkt (p, 2,
        "_Paris\",SPHEROID[\"International 1924\",6378388,297,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7022\"]],TOWGS84[-189,-242,-91,0,0,0,0");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6810\"]],PRIMEM[\"Paris\",2.33722");
    add_srs_wkt (p, 5,
        "917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",0.015707");
    add_srs_wkt (p, 6,
        "96326794897,AUTHORITY[\"EPSG\",\"9105\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4810\"]],PROJECTION[\"Hotine_Oblique_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_center\",-21],PARAMETER[\"longit");
    add_srs_wkt (p, 9,
        "ude_of_center\",49],PARAMETER[\"azimuth\",21],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"rectified_grid_angle\",21],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 11,
        "0.9995],PARAMETER[\"false_easting\",400000],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",800000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"29702\"]]");
    p = add_epsg_def (filter, first, last, 29738, "epsg", 29738,
        "Tananarive / UTM zone 38S");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +south +ellps=intl +towgs84=-189,-242");
    add_proj4text (p, 1,
        ",-91,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tananarive / UTM zone 38S\",GEOGCS[\"Tananarive");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Tananarive_1925\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "189,-242,-91,0,0,0,0],AUTHORITY[\"EPSG\",\"6297\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4297\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",45],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 9,
        "9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"29738\"]]");
    p = add_epsg_def (filter, first, last, 29739, "epsg", 29739,
        "Tananarive / UTM zone 39S");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +south +ellps=intl +towgs84=-189,-242");
    add_proj4text (p, 1,
        ",-91,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tananarive / UTM zone 39S\",GEOGCS[\"Tananarive");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Tananarive_1925\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "189,-242,-91,0,0,0,0],AUTHORITY[\"EPSG\",\"6297\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4297\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"central_meridian\",51],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 9,
        "9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"29739\"]]");
    p = add_epsg_def (filter, first, last, 29849, "epsg", 29849,
        "Timbalai 1948 / UTM zone 49N");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +ellps=evrstSS +towgs84=-533.4,669.2,");
    add_proj4text (p, 1,
        "-52.5,0,0,4.28,9.4 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Timbalai 1948 / UTM zone 49N\",GEOGCS[\"Timbala");
    add_srs_wkt (p, 1,
        "i 1948\",DATUM[\"Timbalai_1948\",SPHEROID[\"Everest 1830");
    add_srs_wkt (p, 2,
        " (1967 Definition)\",6377298.556,300.8017,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7016\"]],TOWGS84[-533.4,669.2,-52.5,0,0,4.28,9.4]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6298\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4298\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",111],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "29849\"]]");
    p = add_epsg_def (filter, first, last, 29850, "epsg", 29850,
        "Timbalai 1948 / UTM zone 50N");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +ellps=evrstSS +towgs84=-533.4,669.2,");
    add_proj4text (p, 1,
        "-52.5,0,0,4.28,9.4 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Timbalai 1948 / UTM zone 50N\",GEOGCS[\"Timbala");
    add_srs_wkt (p, 1,
        "i 1948\",DATUM[\"Timbalai_1948\",SPHEROID[\"Everest 1830");
    add_srs_wkt (p, 2,
        " (1967 Definition)\",6377298.556,300.8017,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7016\"]],TOWGS84[-533.4,669.2,-52.5,0,0,4.28,9.4]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6298\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 7,
        "\"4298\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",117],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "29850\"]]");
    p = add_epsg_def (filter, first, last, 29871, "epsg", 29871,
        "Timbalai 1948 / RSO Borneo (ch)");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=4 +lonc=115 +alpha=53.31582047222222 ");
    add_proj4text (p, 1,
        "+k=0.99984 +x_0=590476.8714630401 +y_0=442857.653094361 ");
    add_proj4text (p, 2,
        "+gamma=53.13010236111111 +ellps=evrstSS +towgs84=-533.4,");
    add_proj4text (p, 3,
        "669.2,-52.5,0,0,4.28,9.4 +to_meter=20.11676512155263 +no");
    add_proj4text (p, 4,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Timbalai 1948 / RSO Borneo (ch)\",GEOGCS[\"Timb");
    add_srs_wkt (p, 1,
        "alai 1948\",DATUM[\"Timbalai_1948\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1967 Definition)\",6377298.556,300.8017,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7016\"]],TOWGS84[-533.4,669.2,-52.5,0,0,4.28,9.");
    add_srs_wkt (p, 4,
        "4],AUTHORITY[\"EPSG\",\"6298\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4298\"]],PROJECTION[\"Hotine_Oblique_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_center\",4],PARAMETER[\"longitude_of");
    add_srs_wkt (p, 9,
        "_center\",115],PARAMETER[\"azimuth\",53.31582047222222],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"rectified_grid_angle\",53.13010236111111],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"scale_factor\",0.99984],PARAMETER[\"false_east");
    add_srs_wkt (p, 12,
        "ing\",29352.4763],PARAMETER[\"false_northing\",22014.357");
    add_srs_wkt (p, 13,
        "2],UNIT[\"British chain (Sears 1922)\",20.11676512155263");
    add_srs_wkt (p, 14,
        ",AUTHORITY[\"EPSG\",\"9042\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 15,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"29871\"]]");
    p = add_epsg_def (filter, first, last, 29872, "epsg", 29872,
        "Timbalai 1948 / RSO Borneo (ft)");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=4 +lonc=115 +alpha=53.31582047222222 ");
    add_proj4text (p, 1,
        "+k=0.99984 +x_0=590476.8727431979 +y_0=442857.6545573985");
    add_proj4text (p, 2,
        " +gamma=53.13010236111111 +ellps=evrstSS +towgs84=-533.4");
    add_proj4text (p, 3,
        ",669.2,-52.5,0,0,4.28,9.4 +to_meter=0.3047994715386762 +");
    add_proj4text (p, 4,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Timbalai 1948 / RSO Borneo (ft)\",GEOGCS[\"Timb");
    add_srs_wkt (p, 1,
        "alai 1948\",DATUM[\"Timbalai_1948\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1967 Definition)\",6377298.556,300.8017,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7016\"]],TOWGS84[-533.4,669.2,-52.5,0,0,4.28,9.");
    add_srs_wkt (p, 4,
        "4],AUTHORITY[\"EPSG\",\"6298\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4298\"]],PROJECTION[\"Hotine_Oblique_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_center\",4],PARAMETER[\"longitude_of");
    add_srs_wkt (p, 9,
        "_center\",115],PARAMETER[\"azimuth\",53.31582047222222],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"rectified_grid_angle\",53.13010236111111],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"scale_factor\",0.99984],PARAMETER[\"false_east");
    add_srs_wkt (p, 12,
        "ing\",1937263.44],PARAMETER[\"false_northing\",1452947.5");
    add_srs_wkt (p, 13,
        "8],UNIT[\"British foot (Sears 1922)\",0.3047994715386762");
    add_srs_wkt (p, 14,
        ",AUTHORITY[\"EPSG\",\"9041\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 15,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"29872\"]]");
    p = add_epsg_def (filter, first, last, 29873, "epsg", 29873,
        "Timbalai 1948 / RSO Borneo (m)");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=4 +lonc=115 +alpha=53.31582047222222 ");
    add_proj4text (p, 1,
        "+k=0.99984 +x_0=590476.87 +y_0=442857.65 +gamma=53.13010");
    add_proj4text (p, 2,
        "236111111 +ellps=evrstSS +towgs84=-533.4,669.2,-52.5,0,0");
    add_proj4text (p, 3,
        ",4.28,9.4 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Timbalai 1948 / RSO Borneo (m)\",GEOGCS[\"Timba");
    add_srs_wkt (p, 1,
        "lai 1948\",DATUM[\"Timbalai_1948\",SPHEROID[\"Everest 18");
    add_srs_wkt (p, 2,
        "30 (1967 Definition)\",6377298.556,300.8017,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7016\"]],TOWGS84[-533.4,669.2,-52.5,0,0,4.28,9.");
    add_srs_wkt (p, 4,
        "4],AUTHORITY[\"EPSG\",\"6298\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4298\"]],PROJECTION[\"Hotine_Oblique_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_center\",4],PARAMETER[\"longitude_of");
    add_srs_wkt (p, 9,
        "_center\",115],PARAMETER[\"azimuth\",53.31582047222222],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"rectified_grid_angle\",53.13010236111111],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"scale_factor\",0.99984],PARAMETER[\"false_east");
    add_srs_wkt (p, 12,
        "ing\",590476.87],PARAMETER[\"false_northing\",442857.65]");
    add_srs_wkt (p, 13,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 14,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 15,
        "\",\"29873\"]]");
    p = add_epsg_def (filter, first, last, 29900, "epsg", 29900,
        "TM65 / Irish National Grid (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=53.5 +lon_0=-8 +k=1.000035 +x_0=20000");
    add_proj4text (p, 1,
        "0 +y_0=250000 +datum=ire65 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TM65 / Irish National Grid (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"TM65\",DATUM[\"TM65\",SPHEROID[\"Airy Modified 1849\"");
    add_srs_wkt (p, 2,
        ",6377340.189,299.3249646,AUTHORITY[\"EPSG\",\"7002\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[482.5,-130.6,564.6,-1.042,-0.214,-0.631,8.15],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6299\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "99\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",53.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-8],PARAMETER[\"scale_factor\",1.000035],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",200000],PARAMETER[\"false_northing\",25000");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"29900\"]]");
    p = add_epsg_def (filter, first, last, 29901, "epsg", 29901,
        "OSNI 1952 / Irish National Grid");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=53.5 +lon_0=-8 +k=1 +x_0=200000 +y_0=");
    add_proj4text (p, 1,
        "250000 +ellps=airy +towgs84=482.5,-130.6,564.6,-1.042,-0");
    add_proj4text (p, 2,
        ".214,-0.631,8.15 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"OSNI 1952 / Irish National Grid\",GEOGCS[\"OSNI");
    add_srs_wkt (p, 1,
        " 1952\",DATUM[\"OSNI_1952\",SPHEROID[\"Airy 1830\",63775");
    add_srs_wkt (p, 2,
        "63.396,299.3249646,AUTHORITY[\"EPSG\",\"7001\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[482.5,-130.6,564.6,-1.042,-0.214,-0.631,8.15],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6188\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4188\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",53.5],PARAMETER[\"central_meridian\",-8],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",200000],PARAMETER[\"false_northing\",250000],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 12,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"29901\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def (filter, first, last, 29902, "epsg", 29902,
        "TM65 / Irish Grid");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=53.5 +lon_0=-8 +k=1.000035 +x_0=20000");
    add_proj4text (p, 1,
        "0 +y_0=250000 +datum=ire65 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TM65 / Irish Grid\",GEOGCS[\"TM65\",DATUM[\"TM6");
    add_srs_wkt (p, 1,
        "5\",SPHEROID[\"Airy Modified 1849\",6377340.189,299.3249");
    add_srs_wkt (p, 2,
        "646,AUTHORITY[\"EPSG\",\"7002\"]],TOWGS84[482.5,-130.6,5");
    add_srs_wkt (p, 3,
        "64.6,-1.042,-0.214,-0.631,8.15],AUTHORITY[\"EPSG\",\"629");
    add_srs_wkt (p, 4,
        "9\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4299\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",5");
    add_srs_wkt (p, 8,
        "3.5],PARAMETER[\"central_meridian\",-8],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1.000035],PARAMETER[\"false_easting\",200000]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",250000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"29902\"]]");
    p = add_epsg_def (filter, first, last, 29903, "epsg", 29903,
        "TM75 / Irish Grid");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=53.5 +lon_0=-8 +k=1.000035 +x_0=20000");
    add_proj4text (p, 1,
        "0 +y_0=250000 +ellps=mod_airy +towgs84=482.5,-130.6,564.");
    add_proj4text (p, 2,
        "6,-1.042,-0.214,-0.631,8.15 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"TM75 / Irish Grid\",GEOGCS[\"TM75\",DATUM[\"Geo");
    add_srs_wkt (p, 1,
        "detic_Datum_of_1965\",SPHEROID[\"Airy Modified 1849\",63");
    add_srs_wkt (p, 2,
        "77340.189,299.3249646,AUTHORITY[\"EPSG\",\"7002\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[482.5,-130.6,564.6,-1.042,-0.214,-0.631,8.15],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"6300\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4300\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",53.5],PARAMETER[\"central_meridian\",-8]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",1.000035],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",200000],PARAMETER[\"false_northing\",250000],U");
    add_srs_wkt (p, 11,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eas");
    add_srs_wkt (p, 12,
        "ting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"29903\"]]");
    p = add_epsg_def (filter, first, last, 30161, "epsg", 30161,
        "Tokyo / Japan Plane Rectangular CS I");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=33 +lon_0=129.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS I\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377397");
    add_srs_wkt (p, 2,
        ".155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"63");
    add_srs_wkt (p, 4,
        "01\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",3");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"central_meridian\",129.5],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",0.9999],PARAMETER[\"false_easting\",0],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"30161\"]]");
    p = add_epsg_def (filter, first, last, 30162, "epsg", 30162,
        "Tokyo / Japan Plane Rectangular CS II");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=33 +lon_0=131 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS II\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",63773");
    add_srs_wkt (p, 2,
        "97.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",33],PARAMETER[\"central_meridian\",131],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",0.9999],PARAMETER[\"false_easting\",0],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"30162\"]]");
    p = add_epsg_def (filter, first, last, 30163, "epsg", 30163,
        "Tokyo / Japan Plane Rectangular CS III");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=132.1666666666667 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=bessel +towgs84=-146.414,507.337,6");
    add_proj4text (p, 2,
        "80.507,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS III\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377");
    add_srs_wkt (p, 2,
        "397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",36],PARAMETER[\"central_meridian\",132.1666666666667],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"30163\"]]");
    p = add_epsg_def (filter, first, last, 30164, "epsg", 30164,
        "Tokyo / Japan Plane Rectangular CS IV");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=33 +lon_0=133.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS IV\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",63773");
    add_srs_wkt (p, 2,
        "97.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",33],PARAMETER[\"central_meridian\",133.5],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "cale_factor\",0.9999],PARAMETER[\"false_easting\",0],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"30164\"]]");
    p = add_epsg_def (filter, first, last, 30165, "epsg", 30165,
        "Tokyo / Japan Plane Rectangular CS V");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=134.3333333333333 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=bessel +towgs84=-146.414,507.337,6");
    add_proj4text (p, 2,
        "80.507,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS V\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377397");
    add_srs_wkt (p, 2,
        ".155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"63");
    add_srs_wkt (p, 4,
        "01\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",3");
    add_srs_wkt (p, 8,
        "6],PARAMETER[\"central_meridian\",134.3333333333333],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",0.9999],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 12,
        "\",EAST],AUTHORITY[\"EPSG\",\"30165\"]]");
    p = add_epsg_def (filter, first, last, 30166, "epsg", 30166,
        "Tokyo / Japan Plane Rectangular CS VI");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=136 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS VI\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",63773");
    add_srs_wkt (p, 2,
        "97.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",36],PARAMETER[\"central_meridian\",136],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",0.9999],PARAMETER[\"false_easting\",0],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"30166\"]]");
    p = add_epsg_def (filter, first, last, 30167, "epsg", 30167,
        "Tokyo / Japan Plane Rectangular CS VII");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=137.1666666666667 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=bessel +towgs84=-146.414,507.337,6");
    add_proj4text (p, 2,
        "80.507,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS VII\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377");
    add_srs_wkt (p, 2,
        "397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",36],PARAMETER[\"central_meridian\",137.1666666666667],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"30167\"]]");
    p = add_epsg_def (filter, first, last, 30168, "epsg", 30168,
        "Tokyo / Japan Plane Rectangular CS VIII");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=138.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS VIII\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",637");
    add_srs_wkt (p, 2,
        "7397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTIO");
    add_srs_wkt (p, 7,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",36],PARAMETER[\"central_meridian\",138.5],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.9999],PARAMETER[\"false_easting\",0],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 11,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 12,
        "],AUTHORITY[\"EPSG\",\"30168\"]]");
    p = add_epsg_def (filter, first, last, 30169, "epsg", 30169,
        "Tokyo / Japan Plane Rectangular CS IX");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=139.8333333333333 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=bessel +towgs84=-146.414,507.337,6");
    add_proj4text (p, 2,
        "80.507,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS IX\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",63773");
    add_srs_wkt (p, 2,
        "97.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",36],PARAMETER[\"central_meridian\",139.8333333333333],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_east");
    add_srs_wkt (p, 10,
        "ing\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 11,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"30169\"]]");
    p = add_epsg_def (filter, first, last, 30170, "epsg", 30170,
        "Tokyo / Japan Plane Rectangular CS X");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=140.8333333333333 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=bessel +towgs84=-146.414,507.337,6");
    add_proj4text (p, 2,
        "80.507,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS X\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377397");
    add_srs_wkt (p, 2,
        ".155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"63");
    add_srs_wkt (p, 4,
        "01\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",4");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",140.8333333333333],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",0.9999],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 11,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 12,
        "\",EAST],AUTHORITY[\"EPSG\",\"30170\"]]");
    p = add_epsg_def (filter, first, last, 30171, "epsg", 30171,
        "Tokyo / Japan Plane Rectangular CS XI");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44 +lon_0=140.25 +k=0.9999 +x_0=0 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS XI\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",63773");
    add_srs_wkt (p, 2,
        "97.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",44],PARAMETER[\"central_meridian\",140.25],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9999],PARAMETER[\"false_easting\",0],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"30171\"]]");
    p = add_epsg_def (filter, first, last, 30172, "epsg", 30172,
        "Tokyo / Japan Plane Rectangular CS XII");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44 +lon_0=142.25 +k=0.9999 +x_0=0 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Tokyo / Japan Plane Rectangular CS XII\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Tokyo\",DATUM[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377");
    add_srs_wkt (p, 2,
        "397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[-146.414,507.337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6301\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4301\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",44],PARAMETER[\"central_meridian\",142.25],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.9999],PARAMETER[\"false_easting\",0],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 11,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"30172\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

