/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg" on Wed Aug  1 15:15:05 2012

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_36 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 31986, "epsg", 31986,
        "SIRGAS 1995 / UTM zone 17N");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 17N\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-81],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"31986\"]]");
    p = add_epsg_def (filter, first, last, 31987, "epsg", 31987,
        "SIRGAS 1995 / UTM zone 18N");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 18N\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-75],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"31987\"]]");
    p = add_epsg_def (filter, first, last, 31988, "epsg", 31988,
        "SIRGAS 1995 / UTM zone 19N");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 19N\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-69],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"31988\"]]");
    p = add_epsg_def (filter, first, last, 31989, "epsg", 31989,
        "SIRGAS 1995 / UTM zone 20N");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 20N\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-63],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"31989\"]]");
    p = add_epsg_def (filter, first, last, 31990, "epsg", 31990,
        "SIRGAS 1995 / UTM zone 21N");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 21N\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-57],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"31990\"]]");
    p = add_epsg_def (filter, first, last, 31991, "epsg", 31991,
        "SIRGAS 1995 / UTM zone 22N");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 22N\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-51],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"31991\"]]");
    p = add_epsg_def (filter, first, last, 31992, "epsg", 31992,
        "SIRGAS 1995 / UTM zone 17S");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 17S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-81],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"31992\"]]");
    p = add_epsg_def (filter, first, last, 31993, "epsg", 31993,
        "SIRGAS 1995 / UTM zone 18S");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 18S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-75],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"31993\"]]");
    p = add_epsg_def (filter, first, last, 31994, "epsg", 31994,
        "SIRGAS 1995 / UTM zone 19S");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 19S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-69],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"31994\"]]");
    p = add_epsg_def (filter, first, last, 31995, "epsg", 31995,
        "SIRGAS 1995 / UTM zone 20S");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 20S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-63],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"31995\"]]");
    p = add_epsg_def (filter, first, last, 31996, "epsg", 31996,
        "SIRGAS 1995 / UTM zone 21S");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 21S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-57],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"31996\"]]");
    p = add_epsg_def (filter, first, last, 31997, "epsg", 31997,
        "SIRGAS 1995 / UTM zone 22S");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 22S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-51],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"31997\"]]");
    p = add_epsg_def (filter, first, last, 31998, "epsg", 31998,
        "SIRGAS 1995 / UTM zone 23S");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 23S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-45],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"31998\"]]");
    p = add_epsg_def (filter, first, last, 31999, "epsg", 31999,
        "SIRGAS 1995 / UTM zone 24S");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 24S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-39],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"31999\"]]");
    p = add_epsg_def (filter, first, last, 32000, "epsg", 32000,
        "SIRGAS 1995 / UTM zone 25S");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"SIRGAS 1995 / UTM zone 25S\",GEOGCS[\"SIRGAS 19");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Sistema_de_Referencia_Geocentrico_para_Amer");
    add_srs_wkt (p, 2,
        "ica_del_Sur_1995\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        ",0],AUTHORITY[\"EPSG\",\"6170\"]],PRIMEM[\"Greenwich\",0");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4170\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-33],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"32000\"]]");
    p = add_epsg_def (filter, first, last, 32001, "epsg", 32001,
        "NAD27 / Montana North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.71666666666667 +lat_2=47.85 +lat_0=4");
    add_proj4text (p, 1,
        "7 +lon_0=-109.5 +x_0=609601.2192024384 +y_0=0 +datum=NAD");
    add_proj4text (p, 2,
        "27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Montana North\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"standard_parallel_1\",48.71666666666667],PARA");
    add_srs_wkt (p, 8,
        "METER[\"standard_parallel_2\",47.85],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",47],PARAMETER[\"central_meridian\",-109.5]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",2000000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"US survey foot\",0.3048006096012192");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"32001\"]]");
    p = add_epsg_def (filter, first, last, 32002, "epsg", 32002,
        "NAD27 / Montana Central");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.88333333333333 +lat_2=46.45 +lat_0=4");
    add_proj4text (p, 1,
        "5.83333333333334 +lon_0=-109.5 +x_0=609601.2192024384 +y");
    add_proj4text (p, 2,
        "_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Montana Central\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",47.88333333333333],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",46.45],PARAMETER[\"latitu");
    add_srs_wkt (p, 9,
        "de_of_origin\",45.83333333333334],PARAMETER[\"central_me");
    add_srs_wkt (p, 10,
        "ridian\",-109.5],PARAMETER[\"false_easting\",2000000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.");
    add_srs_wkt (p, 12,
        "3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32002\"]]");
    p = add_epsg_def (filter, first, last, 32003, "epsg", 32003,
        "NAD27 / Montana South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.4 +lat_2=44.86666666666667 +lat_0=44");
    add_proj4text (p, 1,
        " +lon_0=-109.5 +x_0=609601.2192024384 +y_0=0 +datum=NAD2");
    add_proj4text (p, 2,
        "7 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Montana South\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"standard_parallel_1\",46.4],PARAMETER[\"stand");
    add_srs_wkt (p, 8,
        "ard_parallel_2\",44.86666666666667],PARAMETER[\"latitude");
    add_srs_wkt (p, 9,
        "_of_origin\",44],PARAMETER[\"central_meridian\",-109.5],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",2000000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"US survey foot\",0.3048006096012192,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"32003\"]]");
    p = add_epsg_def (filter, first, last, 32005, "epsg", 32005,
        "NAD27 / Nebraska North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.85 +lat_2=42.81666666666667 +lat_0=4");
    add_proj4text (p, 1,
        "1.33333333333334 +lon_0=-100 +x_0=609601.2192024384 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Nebraska North\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",41.85],PARAMETER[\"sta");
    add_srs_wkt (p, 8,
        "ndard_parallel_2\",42.81666666666667],PARAMETER[\"latitu");
    add_srs_wkt (p, 9,
        "de_of_origin\",41.33333333333334],PARAMETER[\"central_me");
    add_srs_wkt (p, 10,
        "ridian\",-100],PARAMETER[\"false_easting\",2000000],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 12,
        "48006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",");
    add_srs_wkt (p, 13,
        "EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32005\"]]");
    p = add_epsg_def (filter, first, last, 32006, "epsg", 32006,
        "NAD27 / Nebraska South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.28333333333333 +lat_2=41.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=39.66666666666666 +lon_0=-99.5 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Nebraska South\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",40.28333333333333],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",41.71666666666667],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",39.66666666666666],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",-99.5],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "2000000],PARAMETER[\"false_northing\",0],UNIT[\"US surve");
    add_srs_wkt (p, 12,
        "y foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]");
    add_srs_wkt (p, 13,
        "],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"32006\"]]");
    p = add_epsg_def (filter, first, last, 32007, "epsg", 32007,
        "NAD27 / Nevada East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-115.5833333333333 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Nevada East\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",34.75],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-115.5833333333333],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"US survey foot\",0.3048006096012192");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"32007\"]]");
    p = add_epsg_def (filter, first, last, 32008, "epsg", 32008,
        "NAD27 / Nevada Central");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-116.6666666666667 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Nevada Central\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",34.75],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",-116.6666666666667],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 9,
        "9999],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 11,
        "2192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32008\"]]");
    p = add_epsg_def (filter, first, last, 32009, "epsg", 32009,
        "NAD27 / Nevada West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-118.5833333333333 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Nevada West\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",34.75],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-118.5833333333333],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"US survey foot\",0.3048006096012192");
    add_srs_wkt (p, 11,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y");
    add_srs_wkt (p, 12,
        "\",NORTH],AUTHORITY[\"EPSG\",\"32009\"]]");
    p = add_epsg_def (filter, first, last, 32010, "epsg", 32010,
        "NAD27 / New Hampshire");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-71.66666666666667 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New Hampshire\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",42.5],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 8,
        "an\",-71.66666666666667],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "9966667],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 11,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32010\"]]");
    p = add_epsg_def (filter, first, last, 32011, "epsg", 32011,
        "NAD27 / New Jersey");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.66666666");
    add_proj4text (p, 1,
        "666667 +k=0.9999749999999999 +x_0=609601.2192024384 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New Jersey\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",38.83333333333334],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-74.66666666666667],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.999975],PARAMETER[\"false_easting\",2000000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.3");
    add_srs_wkt (p, 11,
        "048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32011\"]]");
    p = add_epsg_def (filter, first, last, 32012, "epsg", 32012,
        "NAD27 / New Mexico East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-104.3333333333333 +k=0.999");
    add_proj4text (p, 1,
        "909091 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units");
    add_proj4text (p, 2,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New Mexico East\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",31],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 8,
        "n\",-104.3333333333333],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "909091],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 11,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32012\"]]");
    p = add_epsg_def (filter, first, last, 32013, "epsg", 32013,
        "NAD27 / New Mexico Central");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-106.25 +k=0.9999 +x_0=1524");
    add_proj4text (p, 1,
        "00.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New Mexico Central\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",31],PARAMETER[\"central_mer");
    add_srs_wkt (p, 8,
        "idian\",-106.25],PARAMETER[\"scale_factor\",0.9999],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"US survey foot\",0.3048006096012192,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"32013\"]]");
    p = add_epsg_def (filter, first, last, 32014, "epsg", 32014,
        "NAD27 / New Mexico West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-107.8333333333333 +k=0.999");
    add_proj4text (p, 1,
        "916667 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units");
    add_proj4text (p, 2,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New Mexico West\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",31],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 8,
        "n\",-107.8333333333333],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "916667],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 11,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32014\"]]");
    p = add_epsg_def (filter, first, last, 32015, "epsg", 32015,
        "NAD27 / New York East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=-74.33333333333333 +k=0.999");
    add_proj4text (p, 1,
        "966667 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units");
    add_proj4text (p, 2,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New York East\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",40],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-74.33333333333333],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "66667],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"US survey foot\",0.30480060960");
    add_srs_wkt (p, 11,
        "12192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXI");
    add_srs_wkt (p, 12,
        "S[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32015\"]]");
    p = add_epsg_def (filter, first, last, 32016, "epsg", 32016,
        "NAD27 / New York Central");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=-76.58333333333333 +k=0.999");
    add_proj4text (p, 1,
        "9375 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New York Central\",GEOGCS[\"NAD27\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",40],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 8,
        "n\",-76.58333333333333],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 9,
        "9375],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",0],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 11,
        "2192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 12,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32016\"]]");
    p = add_epsg_def (filter, first, last, 32017, "epsg", 32017,
        "NAD27 / New York West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=-78.58333333333333 +k=0.999");
    add_proj4text (p, 1,
        "9375 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=u");
    add_proj4text (p, 2,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New York West\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",40],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-78.58333333333333],PARAMETER[\"scale_factor\",0.9999");
    add_srs_wkt (p, 9,
        "375],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"US survey foot\",0.3048006096012");
    add_srs_wkt (p, 11,
        "192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[");
    add_srs_wkt (p, 12,
        "\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32017\"]]");
    p = add_epsg_def (filter, first, last, 32018, "epsg", 32018,
        "NAD27 / New York Long Island (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666");
    add_proj4text (p, 1,
        "666 +lat_0=40.5 +lon_0=-74 +x_0=304800.6096012192 +y_0=0");
    add_proj4text (p, 2,
        " +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / New York Long Island (deprecated)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD27\",DATUM[\"North_American_Datum_1927\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"Clarke 1866\",6378206.4,294.9786982138982,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 7,
        "ormal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",41.");
    add_srs_wkt (p, 8,
        "03333333333333],PARAMETER[\"standard_parallel_2\",40.666");
    add_srs_wkt (p, 9,
        "66666666666],PARAMETER[\"latitude_of_origin\",40.5],PARA");
    add_srs_wkt (p, 10,
        "METER[\"central_meridian\",-74],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",1000000],PARAMETER[\"false_northing\",0],UNIT[\"US s");
    add_srs_wkt (p, 12,
        "urvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 13,
        "3\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"32018\"]]");
    p = add_epsg_def (filter, first, last, 32019, "epsg", 32019,
        "NAD27 / North Carolina");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.33333333333334 +lat_2=36.16666666666");
    add_proj4text (p, 1,
        "666 +lat_0=33.75 +lon_0=-79 +x_0=609601.2192024384 +y_0=");
    add_proj4text (p, 2,
        "0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / North Carolina\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",34.33333333333334],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",36.16666666666666],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",33.75],PARAMETER[\"central_me");
    add_srs_wkt (p, 10,
        "ridian\",-79],PARAMETER[\"false_easting\",2000000],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",0],UNIT[\"US survey foot\",0.304");
    add_srs_wkt (p, 12,
        "8006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32019\"]]");
    p = add_epsg_def (filter, first, last, 32020, "epsg", 32020,
        "NAD27 / North Dakota North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.43333333333333 +lat_2=48.73333333333");
    add_proj4text (p, 1,
        "333 +lat_0=47 +lon_0=-100.5 +x_0=609601.2192024384 +y_0=");
    add_proj4text (p, 2,
        "0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / North Dakota North\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"standard_parallel_1\",47.43333333333333]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"standard_parallel_2\",48.73333333333333],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"latitude_of_origin\",47],PARAMETER[\"central_m");
    add_srs_wkt (p, 10,
        "eridian\",-100.5],PARAMETER[\"false_easting\",2000000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 12,
        ".3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32020\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def (filter, first, last, 32021, "epsg", 32021,
        "NAD27 / North Dakota South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.18333333333333 +lat_2=47.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=45.66666666666666 +lon_0=-100.5 +x_0=609601.2");
    add_proj4text (p, 2,
        "192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / North Dakota South\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"standard_parallel_1\",46.18333333333333]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"standard_parallel_2\",47.48333333333333],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"latitude_of_origin\",45.66666666666666],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"central_meridian\",-100.5],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US ");
    add_srs_wkt (p, 12,
        "survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "03\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EP");
    add_srs_wkt (p, 14,
        "SG\",\"32021\"]]");
    p = add_epsg_def (filter, first, last, 32022, "epsg", 32022,
        "NAD27 / Ohio North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.43333333333333 +lat_2=41.7 +lat_0=39");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-82.5 +x_0=609601.2192024384 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Ohio North\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"standard_parallel_1\",40.43333333333333],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_2\",41.7],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 9,
        "_origin\",39.66666666666666],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 10,
        "n\",-82.5],PARAMETER[\"false_easting\",2000000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 12,
        "6096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32022\"]]");
    p = add_epsg_def (filter, first, last, 32023, "epsg", 32023,
        "NAD27 / Ohio South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.73333333333333 +lat_2=40.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=38 +lon_0=-82.5 +x_0=609601.2192024384 +y_0=0");
    add_proj4text (p, 2,
        " +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Ohio South\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"standard_parallel_1\",38.73333333333333],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_2\",40.03333333333333],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"latitude_of_origin\",38],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",-82.5],PARAMETER[\"false_easting\",2000000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 12,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32023\"]]");
    p = add_epsg_def (filter, first, last, 32024, "epsg", 32024,
        "NAD27 / Oklahoma North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35.56666666666667 +lat_2=36.76666666666");
    add_proj4text (p, 1,
        "667 +lat_0=35 +lon_0=-98 +x_0=609601.2192024384 +y_0=0 +");
    add_proj4text (p, 2,
        "datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Oklahoma North\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",35.56666666666667],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",36.76666666666667],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",35],PARAMETER[\"central_merid");
    add_srs_wkt (p, 10,
        "ian\",-98],PARAMETER[\"false_easting\",2000000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 12,
        "6096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32024\"]]");
    p = add_epsg_def (filter, first, last, 32025, "epsg", 32025,
        "NAD27 / Oklahoma South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.93333333333333 +lat_2=35.23333333333");
    add_proj4text (p, 1,
        "333 +lat_0=33.33333333333334 +lon_0=-98 +x_0=609601.2192");
    add_proj4text (p, 2,
        "024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Oklahoma South\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",33.93333333333333],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",35.23333333333333],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",33.33333333333334],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",-98],PARAMETER[\"false_easting\",20");
    add_srs_wkt (p, 11,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"US survey ");
    add_srs_wkt (p, 12,
        "foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "32025\"]]");
    p = add_epsg_def (filter, first, last, 32026, "epsg", 32026,
        "NAD27 / Oregon North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.33333333333334 +lat_2=46 +lat_0=43.6");
    add_proj4text (p, 1,
        "6666666666666 +lon_0=-120.5 +x_0=609601.2192024384 +y_0=");
    add_proj4text (p, 2,
        "0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Oregon North\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"standard_parallel_1\",44.33333333333334],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"standard_parallel_2\",46],PARAMETER[\"latitude_of_");
    add_srs_wkt (p, 9,
        "origin\",43.66666666666666],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 10,
        "\",-120.5],PARAMETER[\"false_easting\",2000000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 12,
        "6096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32026\"]]");
    p = add_epsg_def (filter, first, last, 32027, "epsg", 32027,
        "NAD27 / Oregon South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.33333333333334 +lat_2=44 +lat_0=41.6");
    add_proj4text (p, 1,
        "6666666666666 +lon_0=-120.5 +x_0=609601.2192024384 +y_0=");
    add_proj4text (p, 2,
        "0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Oregon South\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"standard_parallel_1\",42.33333333333334],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"standard_parallel_2\",44],PARAMETER[\"latitude_of_");
    add_srs_wkt (p, 9,
        "origin\",41.66666666666666],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 10,
        "\",-120.5],PARAMETER[\"false_easting\",2000000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 12,
        "6096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32027\"]]");
    p = add_epsg_def (filter, first, last, 32028, "epsg", 32028,
        "NAD27 / Pennsylvania North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.88333333333333 +lat_2=41.95 +lat_0=4");
    add_proj4text (p, 1,
        "0.16666666666666 +lon_0=-77.75 +x_0=609601.2192024384 +y");
    add_proj4text (p, 2,
        "_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Pennsylvania North\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"standard_parallel_1\",40.88333333333333]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"standard_parallel_2\",41.95],PARAMETER[\"la");
    add_srs_wkt (p, 9,
        "titude_of_origin\",40.16666666666666],PARAMETER[\"centra");
    add_srs_wkt (p, 10,
        "l_meridian\",-77.75],PARAMETER[\"false_easting\",2000000");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 12,
        ",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32028\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def (filter, first, last, 32029, "epsg", 32029,
        "NAD27 / Pennsylvania South (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.93333333333333 +lat_2=40.8 +lat_0=39");
    add_proj4text (p, 1,
        ".33333333333334 +lon_0=-77.75 +x_0=609601.2192024384 +y_");
    add_proj4text (p, 2,
        "0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Pennsylvania South (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD27\",DATUM[\"North_American_Datum_1927\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"Clarke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4267\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",39.9333");
    add_srs_wkt (p, 8,
        "3333333333],PARAMETER[\"standard_parallel_2\",40.8],PARA");
    add_srs_wkt (p, 9,
        "METER[\"latitude_of_origin\",39.33333333333334],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"central_meridian\",-77.75],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US su");
    add_srs_wkt (p, 12,
        "rvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003");
    add_srs_wkt (p, 13,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"32029\"]]");
    p = add_epsg_def (filter, first, last, 32030, "epsg", 32030,
        "NAD27 / Rhode Island");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.08333333333334 +lon_0=-71.5 +k=0.9");
    add_proj4text (p, 1,
        "999938 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units");
    add_proj4text (p, 2,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Rhode Island\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",41.08333333333334],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-71.5],PARAMETER[\"scale_factor\",0.99999");
    add_srs_wkt (p, 9,
        "38],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 11,
        "92,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"32030\"]]");
    p = add_epsg_def (filter, first, last, 32031, "epsg", 32031,
        "NAD27 / South Carolina North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=33.76666666666667 +lat_2=34.96666666666");
    add_proj4text (p, 1,
        "667 +lat_0=33 +lon_0=-81 +x_0=609601.2192024384 +y_0=0 +");
    add_proj4text (p, 2,
        "datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / South Carolina North\",GEOGCS[\"NAD27\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 2,
        "866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 7,
        "SP\"],PARAMETER[\"standard_parallel_1\",33.7666666666666");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"standard_parallel_2\",34.96666666666667],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"latitude_of_origin\",33],PARAMETER[\"central");
    add_srs_wkt (p, 10,
        "_meridian\",-81],PARAMETER[\"false_easting\",2000000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.");
    add_srs_wkt (p, 12,
        "3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32031\"]]");
    p = add_epsg_def (filter, first, last, 32033, "epsg", 32033,
        "NAD27 / South Carolina South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.33333333333334 +lat_2=33.66666666666");
    add_proj4text (p, 1,
        "666 +lat_0=31.83333333333333 +lon_0=-81 +x_0=609601.2192");
    add_proj4text (p, 2,
        "024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / South Carolina South\",GEOGCS[\"NAD27\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 2,
        "866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 7,
        "SP\"],PARAMETER[\"standard_parallel_1\",32.3333333333333");
    add_srs_wkt (p, 8,
        "4],PARAMETER[\"standard_parallel_2\",33.66666666666666],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"latitude_of_origin\",31.83333333333333],PARA");
    add_srs_wkt (p, 10,
        "METER[\"central_meridian\",-81],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US s");
    add_srs_wkt (p, 12,
        "urvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 13,
        "3\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"32033\"]]");
    p = add_epsg_def (filter, first, last, 32034, "epsg", 32034,
        "NAD27 / South Dakota North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.41666666666666 +lat_2=45.68333333333");
    add_proj4text (p, 1,
        "333 +lat_0=43.83333333333334 +lon_0=-100 +x_0=609601.219");
    add_proj4text (p, 2,
        "2024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / South Dakota North\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"standard_parallel_1\",44.41666666666666]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"standard_parallel_2\",45.68333333333333],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"latitude_of_origin\",43.83333333333334],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"central_meridian\",-100],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US su");
    add_srs_wkt (p, 12,
        "rvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003");
    add_srs_wkt (p, 13,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"32034\"]]");
    p = add_epsg_def (filter, first, last, 32035, "epsg", 32035,
        "NAD27 / South Dakota South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.83333333333334 +lat_2=44.4 +lat_0=42");
    add_proj4text (p, 1,
        ".33333333333334 +lon_0=-100.3333333333333 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / South Dakota South\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"standard_parallel_1\",42.83333333333334]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"standard_parallel_2\",44.4],PARAMETER[\"lat");
    add_srs_wkt (p, 9,
        "itude_of_origin\",42.33333333333334],PARAMETER[\"central");
    add_srs_wkt (p, 10,
        "_meridian\",-100.3333333333333],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US s");
    add_srs_wkt (p, 12,
        "urvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 13,
        "3\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"32035\"]]");
    p = add_epsg_def (filter, first, last, 32036, "epsg", 32036,
        "NAD27 / Tennessee (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=35.25 +lat_2=36.41666666666666 +lat_0=3");
    add_proj4text (p, 1,
        "4.66666666666666 +lon_0=-86 +x_0=30480.06096012192 +y_0=");
    add_proj4text (p, 2,
        "0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Tennessee (deprecated)\",GEOGCS[\"NAD27");
    add_srs_wkt (p, 1,
        "\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke");
    add_srs_wkt (p, 2,
        " 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 7,
        "SP\"],PARAMETER[\"standard_parallel_1\",35.25],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"standard_parallel_2\",36.41666666666666],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "latitude_of_origin\",34.66666666666666],PARAMETER[\"cent");
    add_srs_wkt (p, 10,
        "ral_meridian\",-86],PARAMETER[\"false_easting\",100000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",");
    add_srs_wkt (p, 12,
        "0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32036\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def (filter, first, last, 32037, "epsg", 32037,
        "NAD27 / Texas North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.65 +lat_2=36.18333333333333 +lat_0=3");
    add_proj4text (p, 1,
        "4 +lon_0=-101.5 +x_0=609601.2192024384 +y_0=0 +datum=NAD");
    add_proj4text (p, 2,
        "27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Texas North\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"standard_parallel_1\",34.65],PARAMETER[\"standa");
    add_srs_wkt (p, 8,
        "rd_parallel_2\",36.18333333333333],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_origin\",34],PARAMETER[\"central_meridian\",-101.5],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",2000000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",0],UNIT[\"US survey foot\",0.3048006096012192,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"32037\"]]");
    p = add_epsg_def (filter, first, last, 32038, "epsg", 32038,
        "NAD27 / Texas North Central");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.13333333333333 +lat_2=33.96666666666");
    add_proj4text (p, 1,
        "667 +lat_0=31.66666666666667 +lon_0=-97.5 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Texas North Central\",GEOGCS[\"NAD27\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "66\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "08\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"standard_parallel_1\",32.13333333333333]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"standard_parallel_2\",33.96666666666667],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"latitude_of_origin\",31.66666666666667],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"central_meridian\",-97.5],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US s");
    add_srs_wkt (p, 12,
        "urvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 13,
        "3\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"32038\"]]");
    p = add_epsg_def (filter, first, last, 32039, "epsg", 32039,
        "NAD27 / Texas Central");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=30.11666666666667 +lat_2=31.88333333333");
    add_proj4text (p, 1,
        "333 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +");
    add_proj4text (p, 2,
        "x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-ft +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Texas Central\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"standard_parallel_1\",30.11666666666667],PARA");
    add_srs_wkt (p, 8,
        "METER[\"standard_parallel_2\",31.88333333333333],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"latitude_of_origin\",29.66666666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "central_meridian\",-100.3333333333333],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_easting\",2000000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 12,
        "[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"32039\"]]");
    p = add_epsg_def (filter, first, last, 32040, "epsg", 32040,
        "NAD27 / Texas South Central");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=28.38333333333333 +lat_2=30.28333333333");
    add_proj4text (p, 1,
        "333 +lat_0=27.83333333333333 +lon_0=-99 +x_0=609601.2192");
    add_proj4text (p, 2,
        "024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Texas South Central\",GEOGCS[\"NAD27\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "66\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "08\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"standard_parallel_1\",28.38333333333333]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"standard_parallel_2\",30.28333333333333],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"latitude_of_origin\",27.83333333333333],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"central_meridian\",-99],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US surv");
    add_srs_wkt (p, 12,
        "ey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"32040\"]]");
    p = add_epsg_def (filter, first, last, 32041, "epsg", 32041,
        "NAD27 / Texas South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26.16666666666667 +lat_2=27.83333333333");
    add_proj4text (p, 1,
        "333 +lat_0=25.66666666666667 +lon_0=-98.5 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Texas South\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"standard_parallel_1\",26.16666666666667],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"standard_parallel_2\",27.83333333333333],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"latitude_of_origin\",25.66666666666667],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",-98.5],PARAMETER[\"false_easting\",200");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"US survey f");
    add_srs_wkt (p, 12,
        "oot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 13,
        "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 14,
        "2041\"]]");
    p = add_epsg_def (filter, first, last, 32042, "epsg", 32042,
        "NAD27 / Utah North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.71666666666667 +lat_2=41.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=609601.2");
    add_proj4text (p, 2,
        "192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Utah North\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"standard_parallel_1\",40.71666666666667],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_2\",41.78333333333333],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"latitude_of_origin\",40.33333333333334],PARAMETER[\"ce");
    add_srs_wkt (p, 10,
        "ntral_meridian\",-111.5],PARAMETER[\"false_easting\",200");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"US survey f");
    add_srs_wkt (p, 12,
        "oot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 13,
        "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 14,
        "2042\"]]");
    p = add_epsg_def (filter, first, last, 32043, "epsg", 32043,
        "NAD27 / Utah Central");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.01666666666667 +lat_2=40.65 +lat_0=3");
    add_proj4text (p, 1,
        "8.33333333333334 +lon_0=-111.5 +x_0=609601.2192024384 +y");
    add_proj4text (p, 2,
        "_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Utah Central\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 7,
        "AMETER[\"standard_parallel_1\",39.01666666666667],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"standard_parallel_2\",40.65],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_origin\",38.33333333333334],PARAMETER[\"central_merid");
    add_srs_wkt (p, 10,
        "ian\",-111.5],PARAMETER[\"false_easting\",2000000],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",0],UNIT[\"US survey foot\",0.304");
    add_srs_wkt (p, 12,
        "8006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32043\"]]");
    p = add_epsg_def (filter, first, last, 32044, "epsg", 32044,
        "NAD27 / Utah South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.21666666666667 +lat_2=38.35 +lat_0=3");
    add_proj4text (p, 1,
        "6.66666666666666 +lon_0=-111.5 +x_0=609601.2192024384 +y");
    add_proj4text (p, 2,
        "_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Utah South\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"standard_parallel_1\",37.21666666666667],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"standard_parallel_2\",38.35],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 9,
        "f_origin\",36.66666666666666],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 10,
        "an\",-111.5],PARAMETER[\"false_easting\",2000000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 12,
        "006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EA");
    add_srs_wkt (p, 13,
        "ST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32044\"]]");
    p = add_epsg_def (filter, first, last, 32045, "epsg", 32045,
        "NAD27 / Vermont");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-72.5 +k=0.999964286 +x_0");
    add_proj4text (p, 1,
        "=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Vermont\",GEOGCS[\"NAD27\",DATUM[\"Nort");
    add_srs_wkt (p, 1,
        "h_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378206");
    add_srs_wkt (p, 2,
        ".4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4267");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",42.5],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "72.5],PARAMETER[\"scale_factor\",0.999964286],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",500000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 10,
        "],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"32045\"]]");
    p = add_epsg_def (filter, first, last, 32046, "epsg", 32046,
        "NAD27 / Virginia North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.03333333333333 +lat_2=39.2 +lat_0=37");
    add_proj4text (p, 1,
        ".66666666666666 +lon_0=-78.5 +x_0=609601.2192024384 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Virginia North\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",38.03333333333333],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",39.2],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",37.66666666666666],PARAMETER[\"central_mer");
    add_srs_wkt (p, 10,
        "idian\",-78.5],PARAMETER[\"false_easting\",2000000],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 12,
        "48006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",");
    add_srs_wkt (p, 13,
        "EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32046\"]]");
    p = add_epsg_def (filter, first, last, 32047, "epsg", 32047,
        "NAD27 / Virginia South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.76666666666667 +lat_2=37.96666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.33333333333334 +lon_0=-78.5 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Virginia South\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",36.76666666666667],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",37.96666666666667],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",36.33333333333334],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",-78.5],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "2000000],PARAMETER[\"false_northing\",0],UNIT[\"US surve");
    add_srs_wkt (p, 12,
        "y foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]");
    add_srs_wkt (p, 13,
        "],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"32047\"]]");
    p = add_epsg_def (filter, first, last, 32048, "epsg", 32048,
        "NAD27 / Washington North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.5 +lat_2=48.73333333333333 +lat_0=47");
    add_proj4text (p, 1,
        " +lon_0=-120.8333333333333 +x_0=609601.2192024384 +y_0=0");
    add_proj4text (p, 2,
        " +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Washington North\",GEOGCS[\"NAD27\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",47.5],PARAMETER[\"stan");
    add_srs_wkt (p, 8,
        "dard_parallel_2\",48.73333333333333],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",47],PARAMETER[\"central_meridian\",-120.83");
    add_srs_wkt (p, 10,
        "33333333333],PARAMETER[\"false_easting\",2000000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 12,
        "006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EA");
    add_srs_wkt (p, 13,
        "ST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32048\"]]");
    p = add_epsg_def (filter, first, last, 32049, "epsg", 32049,
        "NAD27 / Washington South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.83333333333334 +lat_2=47.33333333333");
    add_proj4text (p, 1,
        "334 +lat_0=45.33333333333334 +lon_0=-120.5 +x_0=609601.2");
    add_proj4text (p, 2,
        "192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Washington South\",GEOGCS[\"NAD27\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",45.83333333333334],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",47.33333333333334],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",45.33333333333334],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",-120.5],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",2000000],PARAMETER[\"false_northing\",0],UNIT[\"US surv");
    add_srs_wkt (p, 12,
        "ey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"32049\"]]");
    p = add_epsg_def (filter, first, last, 32050, "epsg", 32050,
        "NAD27 / West Virginia North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39 +lat_2=40.25 +lat_0=38.5 +lon_0=-79.");
    add_proj4text (p, 1,
        "5 +x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-f");
    add_proj4text (p, 2,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / West Virginia North\",GEOGCS[\"NAD27\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "66\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "08\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"standard_parallel_1\",39],PARAMETER[\"st");
    add_srs_wkt (p, 8,
        "andard_parallel_2\",40.25],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",38.5],PARAMETER[\"central_meridian\",-79.5],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",2000000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"32050\"]]");
    p = add_epsg_def (filter, first, last, 32051, "epsg", 32051,
        "NAD27 / West Virginia South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.48333333333333 +lat_2=38.88333333333");
    add_proj4text (p, 1,
        "333 +lat_0=37 +lon_0=-81 +x_0=609601.2192024384 +y_0=0 +");
    add_proj4text (p, 2,
        "datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / West Virginia South\",GEOGCS[\"NAD27\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "66\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "08\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"standard_parallel_1\",37.48333333333333]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"standard_parallel_2\",38.88333333333333],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"latitude_of_origin\",37],PARAMETER[\"central_m");
    add_srs_wkt (p, 10,
        "eridian\",-81],PARAMETER[\"false_easting\",2000000],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 12,
        "48006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",");
    add_srs_wkt (p, 13,
        "EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32051\"]]");
    p = add_epsg_def (filter, first, last, 32052, "epsg", 32052,
        "NAD27 / Wisconsin North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.56666666666667 +lat_2=46.76666666666");
    add_proj4text (p, 1,
        "667 +lat_0=45.16666666666666 +lon_0=-90 +x_0=609601.2192");
    add_proj4text (p, 2,
        "024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Wisconsin North\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",45.56666666666667],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",46.76666666666667],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",45.16666666666666],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",-90],PARAMETER[\"false_easting\",20");
    add_srs_wkt (p, 11,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"US survey ");
    add_srs_wkt (p, 12,
        "foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "32052\"]]");
    p = add_epsg_def (filter, first, last, 32053, "epsg", 32053,
        "NAD27 / Wisconsin Central");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.25 +lat_2=45.5 +lat_0=43.83333333333");
    add_proj4text (p, 1,
        "334 +lon_0=-90 +x_0=609601.2192024384 +y_0=0 +datum=NAD2");
    add_proj4text (p, 2,
        "7 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Wisconsin Central\",GEOGCS[\"NAD27\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866");
    add_srs_wkt (p, 2,
        "\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"standard_parallel_1\",44.25],PARAMETER[\"s");
    add_srs_wkt (p, 8,
        "tandard_parallel_2\",45.5],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",43.83333333333334],PARAMETER[\"central_meridian\",-9");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_easting\",2000000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 12,
        "92,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"32053\"]]");
    p = add_epsg_def (filter, first, last, 32054, "epsg", 32054,
        "NAD27 / Wisconsin South");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.73333333333333 +lat_2=44.06666666666");
    add_proj4text (p, 1,
        "667 +lat_0=42 +lon_0=-90 +x_0=609601.2192024384 +y_0=0 +");
    add_proj4text (p, 2,
        "datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Wisconsin South\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",42.73333333333333],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_2\",44.06666666666667],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",42],PARAMETER[\"central_merid");
    add_srs_wkt (p, 10,
        "ian\",-90],PARAMETER[\"false_easting\",2000000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",0],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 12,
        "6096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32054\"]]");
    p = add_epsg_def (filter, first, last, 32055, "epsg", 32055,
        "NAD27 / Wyoming East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.66666666666666 +lon_0=-105.1666666");
    add_proj4text (p, 1,
        "666667 +k=0.999941177 +x_0=152400.3048006096 +y_0=0 +dat");
    add_proj4text (p, 2,
        "um=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Wyoming East\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",40.66666666666666],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-105.1666666666667],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.999941177],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 11,
        ".3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32055\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def (filter, first, last, 32056, "epsg", 32056,
        "NAD27 / Wyoming East Central");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.66666666666666 +lon_0=-107.3333333");
    add_proj4text (p, 1,
        "333333 +k=0.999941177 +x_0=152400.3048006096 +y_0=0 +dat");
    add_proj4text (p, 2,
        "um=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Wyoming East Central\",GEOGCS[\"NAD27\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 2,
        "866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",40.66666666666666],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",-107.3333333333333],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",0.999941177],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 10,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"US survey");
    add_srs_wkt (p, 11,
        " foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "32056\"]]");
    p = add_epsg_def (filter, first, last, 32057, "epsg", 32057,
        "NAD27 / Wyoming West Central");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.66666666666666 +lon_0=-108.75 +k=0");
    add_proj4text (p, 1,
        ".999941177 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +u");
    add_proj4text (p, 2,
        "nits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Wyoming West Central\",GEOGCS[\"NAD27\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 2,
        "866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",40.66666666666666],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",-108.75],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 9,
        "or\",0.999941177],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.");
    add_srs_wkt (p, 11,
        "3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32057\"]]");
    p = add_epsg_def (filter, first, last, 32058, "epsg", 32058,
        "NAD27 / Wyoming West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.66666666666666 +lon_0=-110.0833333");
    add_proj4text (p, 1,
        "333333 +k=0.999941177 +x_0=152400.3048006096 +y_0=0 +dat");
    add_proj4text (p, 2,
        "um=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Wyoming West\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",40.66666666666666],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-110.0833333333333],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 9,
        "tor\",0.999941177],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 11,
        ".3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X");
    add_srs_wkt (p, 12,
        "\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32058\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def (filter, first, last, 32061, "epsg", 32061,
        "NAD27 / Guatemala Norte (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=16.81666666666667 +lat_0=16.81666666666");
    add_proj4text (p, 1,
        "667 +lon_0=-90.33333333333333 +k_0=0.99992226 +x_0=50000");
    add_proj4text (p, 2,
        "0 +y_0=292209.579 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Guatemala Norte (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD27\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"C");
    add_srs_wkt (p, 2,
        "larke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 7,
        "onic_1SP\"],PARAMETER[\"latitude_of_origin\",16.81666666");
    add_srs_wkt (p, 8,
        "666667],PARAMETER[\"central_meridian\",-90.3333333333333");
    add_srs_wkt (p, 9,
        "3],PARAMETER[\"scale_factor\",0.99992226],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",500000],PARAMETER[\"false_northing\",29220");
    add_srs_wkt (p, 11,
        "9.579],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32");
    add_srs_wkt (p, 13,
        "061\"]]");
    p = add_epsg_def (filter, first, last, 32062, "epsg", 32062,
        "NAD27 / Guatemala Sur (deprecated)");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=14.9 +lat_0=14.9 +lon_0=-90.33333333333");
    add_proj4text (p, 1,
        "333 +k_0=0.99989906 +x_0=500000 +y_0=325992.681 +datum=N");
    add_proj4text (p, 2,
        "AD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Guatemala Sur (deprecated)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD27\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Cl");
    add_srs_wkt (p, 2,
        "arke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 7,
        "onic_1SP\"],PARAMETER[\"latitude_of_origin\",14.9],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-90.33333333333333],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",0.99989906],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",500000],PARAMETER[\"false_northing\",325992.681],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32062\"]]");
    p = add_epsg_def (filter, first, last, 32064, "epsg", 32064,
        "NAD27 / BLM 14N (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-99 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 14N (ftUS)\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-99],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",1640416.67],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"32064\"]]");
    p = add_epsg_def (filter, first, last, 32065, "epsg", 32065,
        "NAD27 / BLM 15N (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-93 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 15N (ftUS)\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-93],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",1640416.67],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"32065\"]]");
    p = add_epsg_def (filter, first, last, 32066, "epsg", 32066,
        "NAD27 / BLM 16N (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-87 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 16N (ftUS)\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-87],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",1640416.67],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"32066\"]]");
    p = add_epsg_def (filter, first, last, 32067, "epsg", 32067,
        "NAD27 / BLM 17N (ftUS)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-81 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 17N (ftUS)\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",0],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 8,
        "\",-81],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"f");
    add_srs_wkt (p, 9,
        "alse_easting\",1640416.67],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"32067\"]]");
    p = add_epsg_def (filter, first, last, 32074, "epsg", 32074,
        "NAD27 / BLM 14N (feet) (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-99 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 14N (feet) (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD27\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"C");
    add_srs_wkt (p, 2,
        "larke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4267\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-99],PARAMETER[\"scale_factor\",0.9996],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",1640416.67],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 11,
        "2,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"32074\"]]");
    p = add_epsg_def (filter, first, last, 32075, "epsg", 32075,
        "NAD27 / BLM 15N (feet) (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-93 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 15N (feet) (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD27\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"C");
    add_srs_wkt (p, 2,
        "larke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4267\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-93],PARAMETER[\"scale_factor\",0.9996],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",1640416.67],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 11,
        "2,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"32075\"]]");
    p = add_epsg_def (filter, first, last, 32076, "epsg", 32076,
        "NAD27 / BLM 16N (feet) (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-87 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 16N (feet) (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD27\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"C");
    add_srs_wkt (p, 2,
        "larke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4267\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-87],PARAMETER[\"scale_factor\",0.9996],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",1640416.67],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 11,
        "2,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"32076\"]]");
    p = add_epsg_def (filter, first, last, 32077, "epsg", 32077,
        "NAD27 / BLM 17N (feet) (deprecated)");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-81 +k=0.9996 +x_0=500000.00");
    add_proj4text (p, 1,
        "1016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / BLM 17N (feet) (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD27\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"C");
    add_srs_wkt (p, 2,
        "larke 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4267\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-81],PARAMETER[\"scale_factor\",0.9996],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",1640416.67],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",0],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 11,
        "2,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 12,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"32077\"]]");
    p = add_epsg_def (filter, first, last, 32081, "epsg", 32081,
        "NAD27 / MTM zone 1");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-53 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1,
        "_0=0 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / MTM zone 1\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "53],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",304800],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 12,
        "2081\"]]");
    p = add_epsg_def (filter, first, last, 32082, "epsg", 32082,
        "NAD27 / MTM zone 2");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-56 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1,
        "_0=0 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / MTM zone 2\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "56],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",304800],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 12,
        "2082\"]]");
    p = add_epsg_def (filter, first, last, 32083, "epsg", 32083,
        "NAD27 / MTM zone 3");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-58.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / MTM zone 3\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "58.5],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",304800],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32083\"]]");
    p = add_epsg_def (filter, first, last, 32084, "epsg", 32084,
        "NAD27 / MTM zone 4");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-61.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / MTM zone 4\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "61.5],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",304800],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32084\"]]");
    p = add_epsg_def (filter, first, last, 32085, "epsg", 32085,
        "NAD27 / MTM zone 5");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-64.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / MTM zone 5\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "64.5],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",304800],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32085\"]]");
    p = add_epsg_def (filter, first, last, 32086, "epsg", 32086,
        "NAD27 / MTM zone 6");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-67.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / MTM zone 6\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4");
    add_srs_wkt (p, 6,
        "267\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "67.5],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",304800],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32086\"]]");
    p = add_epsg_def (filter, first, last, 32098, "epsg", 32098,
        "NAD27 / Quebec Lambert");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=60 +lat_2=46 +lat_0=44 +lon_0=-68.5 +x_");
    add_proj4text (p, 1,
        "0=0 +y_0=0 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Quebec Lambert\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"standard_parallel_1\",60],PARAMETER[\"standa");
    add_srs_wkt (p, 8,
        "rd_parallel_2\",46],PARAMETER[\"latitude_of_origin\",44]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"central_meridian\",-68.5],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 11,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32098\"]]");
    p = add_epsg_def (filter, first, last, 32099, "epsg", 32099,
        "NAD27 / Louisiana Offshore");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666");
    add_proj4text (p, 1,
        "667 +lat_0=25.66666666666667 +lon_0=-91.33333333333333 +");
    add_proj4text (p, 2,
        "x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-ft +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Louisiana Offshore\",GEOGCS[\"NAD27\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 186");
    add_srs_wkt (p, 2,
        "6\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "8\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"standard_parallel_1\",27.83333333333333]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"standard_parallel_2\",26.16666666666667],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"latitude_of_origin\",25.66666666666667],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"central_meridian\",-91.33333333333333],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",2000000],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 12,
        ",UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 14,
        "HORITY[\"EPSG\",\"32099\"]]");
    p = add_epsg_def (filter, first, last, 32100, "epsg", 32100,
        "NAD83 / Montana");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=49 +lat_2=45 +lat_0=44.25 +lon_0=-109.5");
    add_proj4text (p, 1,
        " +x_0=600000 +y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Montana\",GEOGCS[\"NAD83\",DATUM[\"Nort");
    add_srs_wkt (p, 1,
        "h_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 2,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,");
    add_srs_wkt (p, 3,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic_2");
    add_srs_wkt (p, 7,
        "SP\"],PARAMETER[\"standard_parallel_1\",49],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "standard_parallel_2\",45],PARAMETER[\"latitude_of_origin");
    add_srs_wkt (p, 9,
        "\",44.25],PARAMETER[\"central_meridian\",-109.5],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",600000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"32100");
    add_srs_wkt (p, 13,
        "\"]]");
    p = add_epsg_def (filter, first, last, 32104, "epsg", 32104,
        "NAD83 / Nebraska");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +");
    add_proj4text (p, 1,
        "lon_0=-100 +x_0=500000 +y_0=0 +datum=NAD83 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Nebraska\",GEOGCS[\"NAD83\",DATUM[\"Nor");
    add_srs_wkt (p, 1,
        "th_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 2,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Conic");
    add_srs_wkt (p, 7,
        "_2SP\"],PARAMETER[\"standard_parallel_1\",43],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"standard_parallel_2\",40],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",39.83333333333334],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 10,
        "100],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 12,
        "001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"32104\"]]");
    p = add_epsg_def (filter, first, last, 32107, "epsg", 32107,
        "NAD83 / Nevada East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-115.5833333333333 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=200000 +y_0=8000000 +datum=NAD83 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Nevada East\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",34.75],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",-115.5833333333333],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.9999],PARAMETER[\"false_easting\",200000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",8000000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"32107\"]]");
    p = add_epsg_def (filter, first, last, 32108, "epsg", 32108,
        "NAD83 / Nevada Central");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-116.6666666666667 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=500000 +y_0=6000000 +datum=NAD83 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Nevada Central\",GEOGCS[\"NAD83\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",34.75],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",-116.6666666666667],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",0.9999],PARAMETER[\"false_easting\",500000],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_northing\",6000000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",NORTH],AUTHORITY[\"EPSG\",\"32108\"]]");
    p = add_epsg_def (filter, first, last, 32109, "epsg", 32109,
        "NAD83 / Nevada West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=34.75 +lon_0=-118.5833333333333 +k=0.");
    add_proj4text (p, 1,
        "9999 +x_0=800000 +y_0=4000000 +datum=NAD83 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Nevada West\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",34.75],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",-118.5833333333333],PARAMETER[\"scale_f");
    add_srs_wkt (p, 9,
        "actor\",0.9999],PARAMETER[\"false_easting\",800000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",4000000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"32109\"]]");
    p = add_epsg_def (filter, first, last, 32110, "epsg", 32110,
        "NAD83 / New Hampshire");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-71.66666666666667 +k=0.9");
    add_proj4text (p, 1,
        "99966667 +x_0=300000 +y_0=0 +datum=NAD83 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / New Hampshire\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",42.5],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-71.66666666666667],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.999966667],PARAMETER[\"false_easting\",300000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 12,
        "TH],AUTHORITY[\"EPSG\",\"32110\"]]");
    p = add_epsg_def (filter, first, last, 32111, "epsg", 32111,
        "NAD83 / New Jersey");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=150000 +y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / New Jersey\",GEOGCS[\"NAD83\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 3,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",38.83333333333334],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"central_meridian\",-74.5],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 9,
        "ctor\",0.9999],PARAMETER[\"false_easting\",150000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"32111\"]]");
    p = add_epsg_def (filter, first, last, 32112, "epsg", 32112,
        "NAD83 / New Mexico East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-104.3333333333333 +k=0.999");
    add_proj4text (p, 1,
        "909091 +x_0=165000 +y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / New Mexico East\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",31],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-104.3333333333333],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.999909091],PARAMETER[\"false_easting\",16500");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NO");
    add_srs_wkt (p, 12,
        "RTH],AUTHORITY[\"EPSG\",\"32112\"]]");
    p = add_epsg_def (filter, first, last, 32113, "epsg", 32113,
        "NAD83 / New Mexico Central");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-106.25 +k=0.9999 +x_0=5000");
    add_proj4text (p, 1,
        "00 +y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / New Mexico Central\",GEOGCS[\"NAD83\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",31],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"central_meridian\",-106.25],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 9,
        ",0.9999],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 11,
        "\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"32113\"]]");
    p = add_epsg_def (filter, first, last, 32114, "epsg", 32114,
        "NAD83 / New Mexico West");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31 +lon_0=-107.8333333333333 +k=0.999");
    add_proj4text (p, 1,
        "916667 +x_0=830000 +y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / New Mexico West\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",31],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-107.8333333333333],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.999916667],PARAMETER[\"false_easting\",83000");
    add_srs_wkt (p, 10,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 11,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NO");
    add_srs_wkt (p, 12,
        "RTH],AUTHORITY[\"EPSG\",\"32114\"]]");
    p = add_epsg_def (filter, first, last, 32115, "epsg", 32115,
        "NAD83 / New York East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=150000 +y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / New York East\",GEOGCS[\"NAD83\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",38.83333333333334],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"central_meridian\",-74.5],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",0.9999],PARAMETER[\"false_easting\",150000],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"32115\"]]");
    p = add_epsg_def (filter, first, last, 32116, "epsg", 32116,
        "NAD83 / New York Central");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=-76.58333333333333 +k=0.999");
    add_proj4text (p, 1,
        "9375 +x_0=250000 +y_0=0 +datum=NAD83 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / New York Central\",GEOGCS[\"NAD83\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 2,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",40],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-76.58333333333333],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",0.9999375],PARAMETER[\"false_easting\",250000]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 11,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORT");
    add_srs_wkt (p, 12,
        "H],AUTHORITY[\"EPSG\",\"32116\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

