/* sqlheavy-query.c generated by valac 0.16.0, the Vala compiler
 * generated from sqlheavy-query.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include "SQLHeavy.h"
#include <stdarg.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <stdio.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SqlHeavyQueryExecuteAsyncData SqlHeavyQueryExecuteAsyncData;
typedef struct _SqlHeavyQueryExecuteInsertAsyncData SqlHeavyQueryExecuteInsertAsyncData;
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _SQLHeavyQueryPrivate {
	SQLHeavyQueryable* _queryable;
	gchar* _sql;
	gint _sql_length;
	sqlite3_stmt* stmt;
	GStaticRecMutex __lock_stmt;
	gboolean stmt_in_use;
	SQLHeavyValueArray* bindings;
	gboolean _auto_clear;
	gint _parameter_count;
};

struct _SqlHeavyQueryExecuteAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SQLHeavyQuery* self;
	GCancellable* cancellable;
	SQLHeavyQueryResult* result;
	SQLHeavyQueryResult* _tmp0_;
	SQLHeavyQueryResult* res;
	SQLHeavyQueryResult* _tmp1_;
	GCancellable* _tmp2_;
	GError * _inner_error_;
};

struct _SqlHeavyQueryExecuteInsertAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SQLHeavyQuery* self;
	GCancellable* cancellable;
	gint64 result;
	SQLHeavyQueryResult* _tmp0_;
	SQLHeavyQueryResult* res;
	gint64 insert_id;
	SQLHeavyQueryResult* _tmp1_;
	GCancellable* _tmp2_;
	gint64 _tmp3_;
	GError * _inner_error_;
};


static gpointer sql_heavy_query_parent_class = NULL;
static GInitableIface* sql_heavy_query_g_initable_parent_iface = NULL;

gint sqlite3_prepare_v2 (sqlite3* db, const gchar* sql, gint n_bytes, sqlite3_stmt** stmt, const gchar** tail);
gint sqlite3_finalize (sqlite3_stmt* stmt);
#define SQL_HEAVY_QUERY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SQL_HEAVY_TYPE_QUERY, SQLHeavyQueryPrivate))
enum  {
	SQL_HEAVY_QUERY_DUMMY_PROPERTY,
	SQL_HEAVY_QUERY_QUERYABLE,
	SQL_HEAVY_QUERY_SQL,
	SQL_HEAVY_QUERY_SQL_LENGTH,
	SQL_HEAVY_QUERY_AUTO_CLEAR,
	SQL_HEAVY_QUERY_PARAMETER_COUNT
};
SQLHeavyValueArray* sql_heavy_query_get_bindings (SQLHeavyQuery* self);
sqlite3_stmt* sql_heavy_query_try_to_steal_stmt (SQLHeavyQuery* self);
void sql_heavy_query_return_stmt (SQLHeavyQuery* self);
static gint sql_heavy_query_parameter_check_index (SQLHeavyQuery* self, gint parameter, GError** error);
const gchar* sql_heavy_sqlite_errstr (gint ec);
void sql_heavy_query_set_list (SQLHeavyQuery* self, gboolean has_first_parameter, const gchar* first_parameter, va_list args, GError** error);
static void sql_heavy_query_execute_async_data_free (gpointer _data);
static gboolean sql_heavy_query_execute_async_co (SqlHeavyQueryExecuteAsyncData* _data_);
SQLHeavyQueryResult* sql_heavy_query_result_new_no_exec (SQLHeavyQuery* query, GError** error);
SQLHeavyQueryResult* sql_heavy_query_result_construct_no_exec (GType object_type, SQLHeavyQuery* query, GError** error);
static void sql_heavy_query_execute_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
SQLHeavyQueryResult* sql_heavy_query_result_new_insert (SQLHeavyQuery* query, gint64* insert_id, GError** error);
SQLHeavyQueryResult* sql_heavy_query_result_construct_insert (GType object_type, SQLHeavyQuery* query, gint64* insert_id, GError** error);
static void sql_heavy_query_execute_insert_async_data_free (gpointer _data);
static gboolean sql_heavy_query_execute_insert_async_co (SqlHeavyQueryExecuteInsertAsyncData* _data_);
void sql_heavy_query_result_next_internal_async (SQLHeavyQueryResult* self, GCancellable* cancellable, gint steps, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean sql_heavy_query_result_next_internal_finish (SQLHeavyQueryResult* self, GAsyncResult* _res_, gint64* last_insert_id, GError** error);
static void sql_heavy_query_execute_insert_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean sql_heavy_check_type (GType gtype);
static void _g_ptr_array_unref0_ (gpointer var);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
static GValue* _g_value_dup (GValue* self);
static void _g_free0_ (gpointer var);
static gboolean sql_heavy_query_real_init (SQLHeavyQuery* self, GCancellable* cancellable, GError** error);
sqlite3* sql_heavy_database_get_sqlite_db (SQLHeavyDatabase* self);
gboolean sql_heavy_error_if_not_ok (gint ec, SQLHeavyQueryable* queryable, GError** error);
static gint sql_heavy_query_get_sql_length (SQLHeavyQuery* self);
static void sql_heavy_query_set_parameter_count (SQLHeavyQuery* self, gint value);
static void sql_heavy_query_set_queryable (SQLHeavyQuery* self, SQLHeavyQueryable* value);
static void sql_heavy_query_finalize (GObject* obj);
static void _vala_sql_heavy_query_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sql_heavy_query_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
     * Retrive the bindings for the query
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


SQLHeavyValueArray* sql_heavy_query_get_bindings (SQLHeavyQuery* self) {
	SQLHeavyValueArray* result = NULL;
	SQLHeavyValueArray* _tmp0_;
	SQLHeavyValueArray* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->bindings;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
     * Attempt to steal the {@link stmt}
     *
     * We want to be able to create multiple {@link QueryResult}
     * instances from a single {@link Query}, but compiling a
     * statement is not cheap, so we want to be able to reuse the
     * statement we created for the query.
     *
     * This function will try to steal the statement, but if it is
     * already in use by another {@link QueryResult} it will return
     * null and let the {@link QueryResult} compile a new statement.
     *
     * @return the statement or null
     */
sqlite3_stmt* sql_heavy_query_try_to_steal_stmt (SQLHeavyQuery* self) {
	sqlite3_stmt* result = NULL;
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->stmt_in_use;
	if (!_tmp0_) {
		{
			sqlite3_stmt* _tmp1_;
			_tmp1_ = self->priv->stmt;
			g_static_rec_mutex_lock (&self->priv->__lock_stmt);
			{
				gboolean _tmp2_;
				_tmp2_ = self->priv->stmt_in_use;
				if (!_tmp2_) {
					sqlite3_stmt* _tmp3_;
					self->priv->stmt_in_use = TRUE;
					_tmp3_ = self->priv->stmt;
					result = _tmp3_;
					{
						sqlite3_stmt* _tmp4_;
						_tmp4_ = self->priv->stmt;
						g_static_rec_mutex_unlock (&self->priv->__lock_stmt);
					}
					return result;
				}
			}
			__finally20:
			{
				sqlite3_stmt* _tmp5_;
				_tmp5_ = self->priv->stmt;
				g_static_rec_mutex_unlock (&self->priv->__lock_stmt);
			}
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	result = NULL;
	return result;
}


/**
     * Return ownership of a statement which was acquired from the
     * {@link try_to_steal_stmt} method
     */
void sql_heavy_query_return_stmt (SQLHeavyQuery* self) {
	g_return_if_fail (self != NULL);
	self->priv->stmt_in_use = FALSE;
}


/**
     * Check to make sure that specified parameter is valid
     *
     * @param parameter the parameter to check
     * @return the parameter
     */
static gint sql_heavy_query_parameter_check_index (SQLHeavyQuery* self, gint parameter, GError** error) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gboolean _tmp4_;
	gint _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = parameter;
	if (_tmp1_ < 0) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp2_;
		gint _tmp3_;
		_tmp2_ = parameter;
		_tmp3_ = self->priv->_parameter_count;
		_tmp0_ = _tmp2_ > _tmp3_;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_;
		_tmp5_ = sql_heavy_sqlite_errstr (SQLITE_RANGE);
		_tmp6_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_RANGE, _tmp5_);
		_inner_error_ = _tmp6_;
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_tmp7_ = parameter;
	result = _tmp7_;
	return result;
}


/**
     * Return the name of the specified parameter
     *
     * @param parameter the parameter to look up
     * @return string representation of the parameter
     */
const gchar* sql_heavy_query_parameter_name (SQLHeavyQuery* self, gint parameter, GError** error) {
	const gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	const gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = parameter;
	_tmp1_ = sql_heavy_query_parameter_check_index (self, _tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = self->priv->stmt;
	_tmp4_ = sqlite3_bind_parameter_name (_tmp3_, _tmp2_);
	result = _tmp4_;
	return result;
}


/**
     * Return the numeric offset of the specified parameter
     *
     * @param parameter the parameter to look up
     * @return offset of the parameter
     */
static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


gint sql_heavy_query_parameter_index (SQLHeavyQuery* self, const gchar* parameter, GError** error) {
	gint result = 0;
	gint idx;
	const gchar* _tmp0_;
	gchar _tmp1_ = '\0';
	gchar first_char;
	gboolean _tmp2_ = FALSE;
	gchar _tmp3_;
	gboolean _tmp5_;
	const gchar* _tmp27_;
	GError* _tmp28_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (parameter != NULL, 0);
	idx = 0;
	_tmp0_ = parameter;
	_tmp1_ = string_get (_tmp0_, (glong) 0);
	first_char = _tmp1_;
	_tmp3_ = first_char;
	if (_tmp3_ == ':') {
		_tmp2_ = TRUE;
	} else {
		gchar _tmp4_;
		_tmp4_ = first_char;
		_tmp2_ = _tmp4_ == '@';
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		sqlite3_stmt* _tmp6_;
		const gchar* _tmp7_;
		gint _tmp8_ = 0;
		gint _tmp9_;
		_tmp6_ = self->priv->stmt;
		_tmp7_ = parameter;
		_tmp8_ = sqlite3_bind_parameter_index (_tmp6_, _tmp7_);
		idx = _tmp8_;
		_tmp9_ = idx;
		if (_tmp9_ != 0) {
			gint _tmp10_;
			_tmp10_ = idx;
			result = _tmp10_ - 1;
			return result;
		}
	} else {
		sqlite3_stmt* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gint _tmp15_ = 0;
		gint _tmp16_;
		gboolean _tmp17_;
		_tmp11_ = self->priv->stmt;
		_tmp12_ = parameter;
		_tmp13_ = g_strconcat (":", _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = sqlite3_bind_parameter_index (_tmp11_, _tmp14_);
		idx = _tmp15_;
		_tmp16_ = idx;
		_tmp17_ = _tmp16_ != 0;
		_g_free0 (_tmp14_);
		if (_tmp17_) {
			gint _tmp18_;
			_tmp18_ = idx;
			result = _tmp18_ - 1;
			return result;
		} else {
			sqlite3_stmt* _tmp19_;
			const gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gint _tmp23_ = 0;
			gint _tmp24_;
			gboolean _tmp25_;
			_tmp19_ = self->priv->stmt;
			_tmp20_ = parameter;
			_tmp21_ = g_strconcat ("@", _tmp20_, NULL);
			_tmp22_ = _tmp21_;
			_tmp23_ = sqlite3_bind_parameter_index (_tmp19_, _tmp22_);
			idx = _tmp23_;
			_tmp24_ = idx;
			_tmp25_ = _tmp24_ != 0;
			_g_free0 (_tmp22_);
			if (_tmp25_) {
				gint _tmp26_;
				_tmp26_ = idx;
				result = _tmp26_ - 1;
				return result;
			}
		}
	}
	_tmp27_ = parameter;
	_tmp28_ = g_error_new (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_RANGE, "Could not find parameter '%s'.", _tmp27_);
	_inner_error_ = _tmp28_;
	if (_inner_error_->domain == SQL_HEAVY_ERROR) {
		g_propagate_error (error, _inner_error_);
		return 0;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
}


/**
     * Bind a list of parameters
     *
     * These are in groups of three, with the first argument being the
     * named parameter, the second being the type (GType), and the
     * third being the value.
     *
     * @param has_first_parameter whether the first_parameter argument should be used
     * @param first_parameter the name of the first parameter
     * @param args the remaining parameters
     */
void sql_heavy_query_set_list (SQLHeavyQuery* self, gboolean has_first_parameter, const gchar* first_parameter, va_list args, GError** error) {
	const gchar* _tmp0_;
	const gchar* current_parameter;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = first_parameter;
	current_parameter = _tmp0_;
	_tmp1_ = has_first_parameter;
	if (!_tmp1_) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = va_arg (args, gchar*);
		current_parameter = _tmp2_;
	}
	while (TRUE) {
		const gchar* _tmp3_;
		GType _tmp4_ = 0UL;
		GType current_parameter_type;
		GType _tmp5_;
		const gchar* _tmp28_ = NULL;
		_tmp3_ = current_parameter;
		if (!(_tmp3_ != NULL)) {
			break;
		}
		_tmp4_ = va_arg (args, GType);
		current_parameter_type = _tmp4_;
		_tmp5_ = current_parameter_type;
		if (_tmp5_ == G_TYPE_STRING) {
			const gchar* _tmp6_;
			const gchar* _tmp7_ = NULL;
			_tmp6_ = current_parameter;
			_tmp7_ = va_arg (args, gchar*);
			sql_heavy_query_set_string (self, _tmp6_, _tmp7_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == SQL_HEAVY_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		} else {
			GType _tmp8_;
			_tmp8_ = current_parameter_type;
			if (_tmp8_ == G_TYPE_INT) {
				const gchar* _tmp9_;
				gint _tmp10_ = 0;
				_tmp9_ = current_parameter;
				_tmp10_ = va_arg (args, gint);
				sql_heavy_query_set_int (self, _tmp9_, _tmp10_, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == SQL_HEAVY_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			} else {
				GType _tmp11_;
				_tmp11_ = current_parameter_type;
				if (_tmp11_ == G_TYPE_INT64) {
					const gchar* _tmp12_;
					gint64 _tmp13_ = 0LL;
					_tmp12_ = current_parameter;
					_tmp13_ = va_arg (args, gint64);
					sql_heavy_query_set_int64 (self, _tmp12_, _tmp13_, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == SQL_HEAVY_ERROR) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				} else {
					gboolean _tmp14_ = FALSE;
					GType _tmp15_;
					gboolean _tmp17_;
					_tmp15_ = current_parameter_type;
					if (_tmp15_ == G_TYPE_DOUBLE) {
						_tmp14_ = TRUE;
					} else {
						GType _tmp16_;
						_tmp16_ = current_parameter_type;
						_tmp14_ = _tmp16_ == G_TYPE_FLOAT;
					}
					_tmp17_ = _tmp14_;
					if (_tmp17_) {
						const gchar* _tmp18_;
						gdouble _tmp19_ = 0.0;
						_tmp18_ = current_parameter;
						_tmp19_ = va_arg (args, gdouble);
						sql_heavy_query_set_double (self, _tmp18_, _tmp19_, &_inner_error_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == SQL_HEAVY_ERROR) {
								g_propagate_error (error, _inner_error_);
								return;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
					} else {
						GType _tmp20_;
						_tmp20_ = current_parameter_type;
						if (_tmp20_ == G_TYPE_POINTER) {
							const gchar* _tmp21_;
							_tmp21_ = current_parameter;
							sql_heavy_query_set_null (self, _tmp21_, &_inner_error_);
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == SQL_HEAVY_ERROR) {
									g_propagate_error (error, _inner_error_);
									return;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
						} else {
							GType _tmp22_;
							_tmp22_ = current_parameter_type;
							if (_tmp22_ == G_TYPE_BYTE_ARRAY) {
								const gchar* _tmp23_;
								GByteArray* _tmp24_ = NULL;
								_tmp23_ = current_parameter;
								_tmp24_ = va_arg (args, GByteArray*);
								sql_heavy_query_set_byte_array (self, _tmp23_, _tmp24_, &_inner_error_);
								if (_inner_error_ != NULL) {
									if (_inner_error_->domain == SQL_HEAVY_ERROR) {
										g_propagate_error (error, _inner_error_);
										return;
									} else {
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return;
									}
								}
							} else {
								GType _tmp25_;
								const gchar* _tmp26_ = NULL;
								GError* _tmp27_;
								_tmp25_ = current_parameter_type;
								_tmp26_ = g_type_name (_tmp25_);
								_tmp27_ = g_error_new (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_DATA_TYPE, "Data type `%s' unsupported.", _tmp26_);
								_inner_error_ = _tmp27_;
								if (_inner_error_->domain == SQL_HEAVY_ERROR) {
									g_propagate_error (error, _inner_error_);
									return;
								} else {
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
						}
					}
				}
			}
		}
		_tmp28_ = va_arg (args, gchar*);
		current_parameter = _tmp28_;
	}
}


/**
     * Execute the query
     *
     * This function accepts an arbitrary number of groups of
     * arguments for binding values. The first argument in the group
     * must be the name of the parameter to bind, the second a GType,
     * and the third the value.
     *
     * @param first_parameter the name of the first parameter to bind, or null
     * @return the result
     */
SQLHeavyQueryResult* sql_heavy_query_execute (SQLHeavyQuery* self, const gchar* first_parameter, GError** error, ...) {
	SQLHeavyQueryResult* result = NULL;
	va_list args = {0};
	const gchar* _tmp0_;
	SQLHeavyQueryResult* _tmp1_;
	SQLHeavyQueryResult* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	va_start (args, first_parameter);
	_tmp0_ = first_parameter;
	sql_heavy_query_set_list (self, TRUE, _tmp0_, args, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			va_end (args);
			return NULL;
		} else {
			va_end (args);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp1_ = sql_heavy_query_result_new (self, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			va_end (args);
			return NULL;
		} else {
			va_end (args);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp2_;
	va_end (args);
	return result;
}


static void sql_heavy_query_execute_async_data_free (gpointer _data) {
	SqlHeavyQueryExecuteAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SqlHeavyQueryExecuteAsyncData, _data_);
}


void sql_heavy_query_execute_async (SQLHeavyQuery* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SqlHeavyQueryExecuteAsyncData* _data_;
	SQLHeavyQuery* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	_data_ = g_slice_new0 (SqlHeavyQueryExecuteAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, sql_heavy_query_execute_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, sql_heavy_query_execute_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = cancellable;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->cancellable = _tmp2_;
	sql_heavy_query_execute_async_co (_data_);
}


SQLHeavyQueryResult* sql_heavy_query_execute_finish (SQLHeavyQuery* self, GAsyncResult* _res_, GError** error) {
	SQLHeavyQueryResult* result;
	SqlHeavyQueryExecuteAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Execute the query asynchronously
     *
     * @param cancellable optional cancellable for aborting the operation
     * @return the result
     */
static void sql_heavy_query_execute_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SqlHeavyQueryExecuteAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	sql_heavy_query_execute_async_co (_data_);
}


static gboolean sql_heavy_query_execute_async_co (SqlHeavyQueryExecuteAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = sql_heavy_query_result_new_no_exec (_data_->self, &_data_->_inner_error_);
	_data_->res = _data_->_tmp0_;
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp1_ = _data_->res;
	_data_->_tmp2_ = _data_->cancellable;
	_data_->_state_ = 1;
	sql_heavy_query_result_next_async (_data_->_tmp1_, _data_->_tmp2_, sql_heavy_query_execute_async_ready, _data_);
	return FALSE;
	_state_1:
	sql_heavy_query_result_next_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->res);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->res);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->result = _data_->res;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->res);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
     * Execute the INSERT query
     *
     * This function accepts an arbitrary number of groups of
     * arguments for binding values. The first argument in the group
     * must be the name of the parameter to bind, the second a GType,
     * and the third the value.
     *
     * @return the inserted row ID
     */
gint64 sql_heavy_query_execute_insert (SQLHeavyQuery* self, const gchar* first_parameter, GError** error, ...) {
	gint64 result = 0LL;
	gint64 insert_id;
	va_list args = {0};
	const gchar* _tmp0_;
	SQLHeavyQueryResult* _tmp1_;
	SQLHeavyQueryResult* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0LL);
	insert_id = (gint64) 0;
	va_start (args, first_parameter);
	_tmp0_ = first_parameter;
	sql_heavy_query_set_list (self, TRUE, _tmp0_, args, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			va_end (args);
			return 0LL;
		} else {
			va_end (args);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0LL;
		}
	}
	_tmp1_ = sql_heavy_query_result_new_insert (self, &insert_id, &_inner_error_);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			va_end (args);
			return 0LL;
		} else {
			va_end (args);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0LL;
		}
	}
	result = insert_id;
	va_end (args);
	return result;
}


static void sql_heavy_query_execute_insert_async_data_free (gpointer _data) {
	SqlHeavyQueryExecuteInsertAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SqlHeavyQueryExecuteInsertAsyncData, _data_);
}


void sql_heavy_query_execute_insert_async (SQLHeavyQuery* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SqlHeavyQueryExecuteInsertAsyncData* _data_;
	SQLHeavyQuery* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	_data_ = g_slice_new0 (SqlHeavyQueryExecuteInsertAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, sql_heavy_query_execute_insert_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, sql_heavy_query_execute_insert_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = cancellable;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->cancellable = _tmp2_;
	sql_heavy_query_execute_insert_async_co (_data_);
}


gint64 sql_heavy_query_execute_insert_finish (SQLHeavyQuery* self, GAsyncResult* _res_, GError** error) {
	gint64 result;
	SqlHeavyQueryExecuteInsertAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return 0LL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


/**
     * Execute the INSERT query asynchronously
     *
     * @param cancellable optional cancellable for aborting the operation
     * @return the inserted row ID
     */
static void sql_heavy_query_execute_insert_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SqlHeavyQueryExecuteInsertAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	sql_heavy_query_execute_insert_async_co (_data_);
}


static gboolean sql_heavy_query_execute_insert_async_co (SqlHeavyQueryExecuteInsertAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = sql_heavy_query_result_new_no_exec (_data_->self, &_data_->_inner_error_);
	_data_->res = _data_->_tmp0_;
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->insert_id = (gint64) 0;
	_data_->_tmp1_ = _data_->res;
	_data_->_tmp2_ = _data_->cancellable;
	_data_->_tmp3_ = 0LL;
	_data_->_state_ = 1;
	sql_heavy_query_result_next_internal_async (_data_->_tmp1_, _data_->_tmp2_, 1, sql_heavy_query_execute_insert_async_ready, _data_);
	return FALSE;
	_state_1:
	sql_heavy_query_result_next_internal_finish (_data_->_tmp1_, _data_->_res_, &_data_->_tmp3_, &_data_->_inner_error_);
	_data_->insert_id = _data_->_tmp3_;
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->res);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->res);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->result = _data_->insert_id;
	_g_object_unref0 (_data_->res);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->res);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
     * Bind a value to the specified parameter index
     *
     * @param parameter name of the parameter
     * @param value value to bind
     * @see set
     */
void sql_heavy_query_bind (SQLHeavyQuery* self, gint parameter, GValue* value, GError** error) {
	gint _tmp0_;
	GValue* _tmp1_;
	GType _tmp2_ = 0UL;
	gboolean _tmp3_ = FALSE;
	SQLHeavyValueArray* _tmp5_;
	gint _tmp6_;
	GValue* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = parameter;
	sql_heavy_query_parameter_check_index (self, _tmp0_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp1_ = value;
	_tmp2_ = G_VALUE_TYPE (_tmp1_);
	_tmp3_ = sql_heavy_check_type (_tmp2_);
	if (!_tmp3_) {
		GError* _tmp4_;
		_tmp4_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_DATA_TYPE, "Data type unsupported.");
		_inner_error_ = _tmp4_;
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp5_ = self->priv->bindings;
	_tmp6_ = parameter;
	_tmp7_ = value;
	sql_heavy_value_array_set (_tmp5_, _tmp6_, _tmp7_);
}


/**
     * Bind a value to the specified parameter
     *
     * @param name name of the parameter
     * @param value value to bind
     * @see bind
     */
void sql_heavy_query_set (SQLHeavyQuery* self, const gchar* name, GValue* value, GError** error) {
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
	GValue* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = sql_heavy_query_parameter_index (self, _tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = value;
	sql_heavy_query_bind (self, _tmp2_, _tmp3_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
     * Bind an int value to the specified parameter index
     *
     * @param field index of the parameter
     * @param value value to bind
     * @see set_int
     * @see set
     */
void sql_heavy_query_bind_int (SQLHeavyQuery* self, gint field, gint value, GError** error) {
	gint _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
	SQLHeavyValueArray* _tmp3_;
	gint _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = field;
	_tmp1_ = sql_heavy_query_parameter_check_index (self, _tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = self->priv->bindings;
	_tmp4_ = value;
	sql_heavy_value_array_set_int (_tmp3_, _tmp2_, _tmp4_);
}


/**
     * Bind an int value to the specified parameter
     *
     * @param field name of the parameter
     * @param value value to bind
     * @see bind_int
     * @see set
     */
void sql_heavy_query_set_int (SQLHeavyQuery* self, const gchar* field, gint value, GError** error) {
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
	gint _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (field != NULL);
	_tmp0_ = field;
	_tmp1_ = sql_heavy_query_parameter_index (self, _tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = value;
	sql_heavy_query_bind_int (self, _tmp2_, _tmp3_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
     * Bind an int64 value to the specified parameter index
     *
     * @param field index of the parameter
     * @param value value to bind
     * @see set_int64
     * @see bind
     */
void sql_heavy_query_bind_int64 (SQLHeavyQuery* self, gint field, gint64 value, GError** error) {
	gint _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
	SQLHeavyValueArray* _tmp3_;
	gint64 _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = field;
	_tmp1_ = sql_heavy_query_parameter_check_index (self, _tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = self->priv->bindings;
	_tmp4_ = value;
	sql_heavy_value_array_set_int64 (_tmp3_, _tmp2_, _tmp4_);
}


/**
     * Bind an int64 value to the specified parameter
     *
     * @param field name of the parameter
     * @param value value to bind
     * @see bind_int64
     * @see set
     */
void sql_heavy_query_set_int64 (SQLHeavyQuery* self, const gchar* field, gint64 value, GError** error) {
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
	gint64 _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (field != NULL);
	_tmp0_ = field;
	_tmp1_ = sql_heavy_query_parameter_index (self, _tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = value;
	sql_heavy_query_bind_int64 (self, _tmp2_, _tmp3_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
     * Bind a string value to the specified parameter index
     *
     * @param field index of the parameter
     * @param value value to bind
     * @see set_string
     * @see bind
     */
void sql_heavy_query_bind_string (SQLHeavyQuery* self, gint field, const gchar* value, GError** error) {
	const gchar* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	if (_tmp0_ == NULL) {
		gint _tmp1_;
		_tmp1_ = field;
		sql_heavy_query_bind_null (self, _tmp1_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	} else {
		gint _tmp2_;
		gint _tmp3_ = 0;
		gint _tmp4_;
		SQLHeavyValueArray* _tmp5_;
		const gchar* _tmp6_;
		_tmp2_ = field;
		_tmp3_ = sql_heavy_query_parameter_check_index (self, _tmp2_, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp5_ = self->priv->bindings;
		_tmp6_ = value;
		sql_heavy_value_array_set_string (_tmp5_, _tmp4_, _tmp6_);
	}
}


/**
     * Bind a string value to the specified parameter
     *
     * @param field name of the parameter
     * @param value value to bind
     * @see bind_string
     * @see set
     */
void sql_heavy_query_set_string (SQLHeavyQuery* self, const gchar* field, const gchar* value, GError** error) {
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
	const gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (field != NULL);
	_tmp0_ = field;
	_tmp1_ = sql_heavy_query_parameter_index (self, _tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = value;
	sql_heavy_query_bind_string (self, _tmp2_, _tmp3_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
     * Bind null to the specified parameter index
     *
     * @param field index of the parameter
     * @see set_null
     * @see bind
     */
void sql_heavy_query_bind_null (SQLHeavyQuery* self, gint field, GError** error) {
	gint _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
	SQLHeavyValueArray* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = field;
	_tmp1_ = sql_heavy_query_parameter_check_index (self, _tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = self->priv->bindings;
	sql_heavy_value_array_set_null (_tmp3_, _tmp2_);
}


/**
     * Bind null to the specified parameter
     *
     * @param field name of the parameter
     * @see bind_null
     * @see set
     */
void sql_heavy_query_set_null (SQLHeavyQuery* self, const gchar* field, GError** error) {
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (field != NULL);
	_tmp0_ = field;
	_tmp1_ = sql_heavy_query_parameter_index (self, _tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	sql_heavy_query_bind_null (self, _tmp2_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
     * Bind a double value to the specified parameter index
     *
     * @param field index of the parameter
     * @param value value to bind
     * @see set_double
     * @see bind
     */
void sql_heavy_query_bind_double (SQLHeavyQuery* self, gint field, gdouble value, GError** error) {
	gint _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
	SQLHeavyValueArray* _tmp3_;
	gdouble _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = field;
	_tmp1_ = sql_heavy_query_parameter_check_index (self, _tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = self->priv->bindings;
	_tmp4_ = value;
	sql_heavy_value_array_set_double (_tmp3_, _tmp2_, _tmp4_);
}


/**
     * Bind an double value to the specified parameter
     *
     * @param field name of the parameter
     * @param value value to bind
     * @see bind_double
     * @see set
     */
void sql_heavy_query_set_double (SQLHeavyQuery* self, const gchar* field, gdouble value, GError** error) {
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
	gdouble _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (field != NULL);
	_tmp0_ = field;
	_tmp1_ = sql_heavy_query_parameter_index (self, _tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = value;
	sql_heavy_query_bind_double (self, _tmp2_, _tmp3_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
     * Bind a byte array value to the specified parameter index
     *
     * @param field index of the parameter
     * @param value value to bind
     * @see set_blob
     * @see bind
     */
void sql_heavy_query_bind_blob (SQLHeavyQuery* self, gint field, guint8* value, int value_length1, GError** error) {
	guint8* _tmp0_;
	gint _tmp0__length1;
	GByteArray* _tmp1_;
	GByteArray* ba;
	GByteArray* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_;
	gint _tmp5_ = 0;
	gint _tmp6_;
	GByteArray* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp0__length1 = value_length1;
	_tmp1_ = g_byte_array_sized_new ((guint) _tmp0__length1);
	ba = _tmp1_;
	_tmp2_ = ba;
	_tmp3_ = value;
	_tmp3__length1 = value_length1;
	g_byte_array_append (_tmp2_, _tmp3_, _tmp3__length1);
	_tmp4_ = field;
	_tmp5_ = sql_heavy_query_parameter_check_index (self, _tmp4_, &_inner_error_);
	_tmp6_ = _tmp5_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_byte_array_unref0 (ba);
			return;
		} else {
			_g_byte_array_unref0 (ba);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp7_ = ba;
	sql_heavy_query_bind_byte_array (self, _tmp6_, _tmp7_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_byte_array_unref0 (ba);
			return;
		} else {
			_g_byte_array_unref0 (ba);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_byte_array_unref0 (ba);
}


/**
     * Bind a byte array value to the specified parameter
     *
     * @param field name of the parameter
     * @param value value to bind
     * @see bind_blob
     * @see set
     */
void sql_heavy_query_set_blob (SQLHeavyQuery* self, const gchar* field, guint8* value, int value_length1, GError** error) {
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (field != NULL);
	_tmp0_ = field;
	_tmp1_ = sql_heavy_query_parameter_index (self, _tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = value;
	_tmp3__length1 = value_length1;
	sql_heavy_query_bind_blob (self, _tmp2_, _tmp3_, _tmp3__length1, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
     * Bind a byte array value to the specified parameter index
     *
     * @param field index of the parameter
     * @param value value to bind
     * @see set_blob
     * @see bind
     */
void sql_heavy_query_bind_byte_array (SQLHeavyQuery* self, gint field, GByteArray* value, GError** error) {
	gint _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
	SQLHeavyValueArray* _tmp3_;
	GByteArray* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = field;
	_tmp1_ = sql_heavy_query_parameter_check_index (self, _tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = self->priv->bindings;
	_tmp4_ = value;
	sql_heavy_value_array_set_byte_array (_tmp3_, _tmp2_, _tmp4_);
}


/**
     * Bind a byte array value to the specified parameter
     *
     * @param field name of the parameter
     * @param value value to bind
     * @see bind_blob
     * @see set
     */
void sql_heavy_query_set_byte_array (SQLHeavyQuery* self, const gchar* field, GByteArray* value, GError** error) {
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_;
	GByteArray* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (field != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = field;
	_tmp1_ = sql_heavy_query_parameter_index (self, _tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = value;
	sql_heavy_query_bind_byte_array (self, _tmp2_, _tmp3_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


/**
     * Clear the bindings
     */
void sql_heavy_query_clear (SQLHeavyQuery* self) {
	SQLHeavyValueArray* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bindings;
	sql_heavy_value_array_clear (_tmp0_);
}


/**
     * Retrieve the entire result set
     *
     * @return the result set
     * @see print_table
     */
static void _g_ptr_array_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL));
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void __vala_GValue_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static void g_ptr_array_set (GPtrArray* self, guint index, gpointer data) {
	gpointer _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = data;
	data = NULL;
	g_ptr_array_add (self, _tmp0_);
	_tmp1_ = index;
	g_ptr_array_remove_index_fast (self, _tmp1_);
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


GPtrArray* sql_heavy_query_get_table (SQLHeavyQuery* self, GError** error) {
	GPtrArray* result = NULL;
	GPtrArray* _tmp0_;
	GPtrArray* values;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_ptr_array_new_with_free_func (_g_ptr_array_unref0_);
	values = _tmp0_;
	{
		SQLHeavyQueryResult* _tmp1_ = NULL;
		SQLHeavyQueryResult* results;
		_tmp1_ = sql_heavy_query_execute (self, NULL, &_inner_error_, NULL);
		results = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_ptr_array_unref0 (values);
				return NULL;
			} else {
				_g_ptr_array_unref0 (values);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				SQLHeavyQueryResult* _tmp5_;
				gboolean _tmp6_;
				gboolean _tmp7_;
				SQLHeavyQueryResult* _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				gint column_l;
				GPtrArray* _tmp11_;
				GPtrArray* row;
				GPtrArray* _tmp12_;
				gint _tmp13_;
				GPtrArray* _tmp27_;
				GPtrArray* _tmp28_;
				GPtrArray* _tmp29_;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					SQLHeavyQueryResult* _tmp4_;
					_tmp4_ = results;
					sql_heavy_record_set_next ((SQLHeavyRecordSet*) _tmp4_, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == SQL_HEAVY_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (results);
							_g_ptr_array_unref0 (values);
							return NULL;
						} else {
							_g_object_unref0 (results);
							_g_ptr_array_unref0 (values);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
				}
				_tmp2_ = FALSE;
				_tmp5_ = results;
				_tmp6_ = sql_heavy_query_result_get_finished (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!(!_tmp7_)) {
					break;
				}
				_tmp8_ = results;
				_tmp9_ = sql_heavy_record_get_field_count ((SQLHeavyRecord*) _tmp8_);
				_tmp10_ = _tmp9_;
				column_l = _tmp10_;
				_tmp11_ = g_ptr_array_new_with_free_func (__vala_GValue_free0_);
				row = _tmp11_;
				_tmp12_ = row;
				_tmp13_ = column_l;
				g_ptr_array_set_length (_tmp12_, _tmp13_);
				{
					gint c;
					c = 0;
					{
						gboolean _tmp14_;
						_tmp14_ = TRUE;
						while (TRUE) {
							gboolean _tmp15_;
							gint _tmp17_;
							gint _tmp18_;
							SQLHeavyQueryResult* _tmp19_;
							gint _tmp20_;
							GValue _tmp21_ = {0};
							GValue _tmp22_;
							GPtrArray* _tmp23_;
							gint _tmp24_;
							GValue _tmp25_;
							GValue* _tmp26_;
							_tmp15_ = _tmp14_;
							if (!_tmp15_) {
								gint _tmp16_;
								_tmp16_ = c;
								c = _tmp16_ + 1;
							}
							_tmp14_ = FALSE;
							_tmp17_ = c;
							_tmp18_ = column_l;
							if (!(_tmp17_ < _tmp18_)) {
								break;
							}
							_tmp19_ = results;
							_tmp20_ = c;
							sql_heavy_record_fetch ((SQLHeavyRecord*) _tmp19_, _tmp20_, &_tmp21_, &_inner_error_);
							_tmp22_ = _tmp21_;
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == SQL_HEAVY_ERROR) {
									g_propagate_error (error, _inner_error_);
									_g_ptr_array_unref0 (row);
									_g_object_unref0 (results);
									_g_ptr_array_unref0 (values);
									return NULL;
								} else {
									_g_ptr_array_unref0 (row);
									_g_object_unref0 (results);
									_g_ptr_array_unref0 (values);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return NULL;
								}
							}
							_tmp23_ = row;
							_tmp24_ = c;
							_tmp25_ = _tmp22_;
							_tmp26_ = __g_value_dup0 (&_tmp25_);
							g_ptr_array_set (_tmp23_, (guint) _tmp24_, _tmp26_);
							G_IS_VALUE (&_tmp25_) ? (g_value_unset (&_tmp25_), NULL) : NULL;
						}
					}
				}
				_tmp27_ = values;
				_tmp28_ = row;
				_tmp29_ = _g_ptr_array_ref0 (_tmp28_);
				g_ptr_array_add (_tmp27_, _tmp29_);
				_g_ptr_array_unref0 (row);
			}
		}
		_g_object_unref0 (results);
	}
	result = values;
	return result;
}


/**
     * Print the result set to a file stream
     *
     * @param fd the stream to print to
     * @see Queryable.print_table
     */
static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


void sql_heavy_query_print_table (SQLHeavyQuery* self, FILE* fd, GError** error) {
	SQLHeavyQueryResult* _tmp0_ = NULL;
	SQLHeavyQueryResult* _result_;
	SQLHeavyQueryResult* _tmp1_;
	gint _tmp2_ = 0;
	gchar** _tmp3_ = NULL;
	gchar** field_names;
	gint field_names_length1;
	gint _field_names_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	glong* _tmp5_ = NULL;
	glong* field_lengths;
	gint field_lengths_length1;
	gint _field_lengths_size_;
	GPtrArray* _tmp6_;
	GPtrArray* data;
	FILE* _tmp7_;
	gint field;
	GString* _tmp52_;
	GString* sep;
	GString* _tmp67_;
	gchar** _tmp68_;
	gint _tmp68__length1;
	gchar** _tmp69_ = NULL;
	gchar** field_fmt;
	gint field_fmt_length1;
	gint _field_fmt_size_;
	FILE* _tmp70_;
	GString* _tmp71_;
	const gchar* _tmp72_;
	FILE* _tmp73_;
	FILE* _tmp93_;
	FILE* _tmp94_;
	GString* _tmp95_;
	const gchar* _tmp96_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = sql_heavy_query_execute (self, NULL, &_inner_error_, NULL);
	_result_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp1_ = _result_;
	_tmp3_ = sql_heavy_record_field_names ((SQLHeavyRecord*) _tmp1_, &_tmp2_);
	field_names = _tmp3_;
	field_names_length1 = _tmp2_;
	_field_names_size_ = field_names_length1;
	_tmp4_ = field_names;
	_tmp4__length1 = field_names_length1;
	_tmp5_ = g_new0 (glong, _tmp4__length1);
	field_lengths = _tmp5_;
	field_lengths_length1 = _tmp4__length1;
	_field_lengths_size_ = field_lengths_length1;
	_tmp6_ = g_ptr_array_new_with_free_func (_g_ptr_array_unref0_);
	data = _tmp6_;
	_tmp7_ = fd;
	if (_tmp7_ == NULL) {
		FILE* _tmp8_;
		_tmp8_ = stderr;
		fd = _tmp8_;
	}
	field = 0;
	{
		gboolean _tmp9_;
		field = 0;
		_tmp9_ = TRUE;
		while (TRUE) {
			gboolean _tmp10_;
			gint _tmp12_;
			glong* _tmp13_;
			gint _tmp13__length1;
			glong* _tmp14_;
			gint _tmp14__length1;
			gint _tmp15_;
			gchar** _tmp16_;
			gint _tmp16__length1;
			gint _tmp17_;
			const gchar* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			glong _tmp21_;
			_tmp10_ = _tmp9_;
			if (!_tmp10_) {
				gint _tmp11_;
				_tmp11_ = field;
				field = _tmp11_ + 1;
			}
			_tmp9_ = FALSE;
			_tmp12_ = field;
			_tmp13_ = field_lengths;
			_tmp13__length1 = field_lengths_length1;
			if (!(_tmp12_ < _tmp13__length1)) {
				break;
			}
			_tmp14_ = field_lengths;
			_tmp14__length1 = field_lengths_length1;
			_tmp15_ = field;
			_tmp16_ = field_names;
			_tmp16__length1 = field_names_length1;
			_tmp17_ = field;
			_tmp18_ = _tmp16_[_tmp17_];
			_tmp19_ = strlen (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp14_[_tmp15_] = (glong) _tmp20_;
			_tmp21_ = _tmp14_[_tmp15_];
		}
	}
	while (TRUE) {
		SQLHeavyQueryResult* _tmp22_;
		gboolean _tmp23_;
		gboolean _tmp24_;
		GPtrArray* _tmp25_;
		GPtrArray* row_data;
		GPtrArray* _tmp26_;
		GPtrArray* _tmp27_;
		GPtrArray* _tmp28_;
		SQLHeavyQueryResult* _tmp51_;
		_tmp22_ = _result_;
		_tmp23_ = sql_heavy_query_result_get_finished (_tmp22_);
		_tmp24_ = _tmp23_;
		if (!(!_tmp24_)) {
			break;
		}
		_tmp25_ = g_ptr_array_new_with_free_func (_g_free0_);
		row_data = _tmp25_;
		_tmp26_ = data;
		_tmp27_ = row_data;
		_tmp28_ = _g_ptr_array_ref0 (_tmp27_);
		g_ptr_array_add (_tmp26_, _tmp28_);
		{
			gboolean _tmp29_;
			field = 0;
			_tmp29_ = TRUE;
			while (TRUE) {
				gboolean _tmp30_;
				gint _tmp32_;
				gchar** _tmp33_;
				gint _tmp33__length1;
				SQLHeavyQueryResult* _tmp34_;
				gint _tmp35_;
				gchar* _tmp36_ = NULL;
				gchar* cell;
				const gchar* _tmp37_;
				gint _tmp38_;
				gint _tmp39_;
				gint cell_l;
				glong* _tmp40_;
				gint _tmp40__length1;
				gint _tmp41_;
				glong _tmp42_;
				gint _tmp43_;
				GPtrArray* _tmp48_;
				const gchar* _tmp49_;
				gchar* _tmp50_;
				_tmp30_ = _tmp29_;
				if (!_tmp30_) {
					gint _tmp31_;
					_tmp31_ = field;
					field = _tmp31_ + 1;
				}
				_tmp29_ = FALSE;
				_tmp32_ = field;
				_tmp33_ = field_names;
				_tmp33__length1 = field_names_length1;
				if (!(_tmp32_ < _tmp33__length1)) {
					break;
				}
				_tmp34_ = _result_;
				_tmp35_ = field;
				_tmp36_ = sql_heavy_record_fetch_string ((SQLHeavyRecord*) _tmp34_, _tmp35_, &_inner_error_);
				cell = _tmp36_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == SQL_HEAVY_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_ptr_array_unref0 (row_data);
						_g_ptr_array_unref0 (data);
						field_lengths = (g_free (field_lengths), NULL);
						field_names = (_vala_array_free (field_names, field_names_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (_result_);
						return;
					} else {
						_g_ptr_array_unref0 (row_data);
						_g_ptr_array_unref0 (data);
						field_lengths = (g_free (field_lengths), NULL);
						field_names = (_vala_array_free (field_names, field_names_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (_result_);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp37_ = cell;
				_tmp38_ = strlen (_tmp37_);
				_tmp39_ = _tmp38_;
				cell_l = _tmp39_;
				_tmp40_ = field_lengths;
				_tmp40__length1 = field_lengths_length1;
				_tmp41_ = field;
				_tmp42_ = _tmp40_[_tmp41_];
				_tmp43_ = cell_l;
				if (_tmp42_ < ((glong) _tmp43_)) {
					glong* _tmp44_;
					gint _tmp44__length1;
					gint _tmp45_;
					gint _tmp46_;
					glong _tmp47_;
					_tmp44_ = field_lengths;
					_tmp44__length1 = field_lengths_length1;
					_tmp45_ = field;
					_tmp46_ = cell_l;
					_tmp44_[_tmp45_] = (glong) _tmp46_;
					_tmp47_ = _tmp44_[_tmp45_];
				}
				_tmp48_ = row_data;
				_tmp49_ = cell;
				_tmp50_ = g_strdup (_tmp49_);
				g_ptr_array_add (_tmp48_, _tmp50_);
				_g_free0 (cell);
			}
		}
		_tmp51_ = _result_;
		sql_heavy_record_set_next ((SQLHeavyRecordSet*) _tmp51_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_ptr_array_unref0 (row_data);
				_g_ptr_array_unref0 (data);
				field_lengths = (g_free (field_lengths), NULL);
				field_names = (_vala_array_free (field_names, field_names_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (_result_);
				return;
			} else {
				_g_ptr_array_unref0 (row_data);
				_g_ptr_array_unref0 (data);
				field_lengths = (g_free (field_lengths), NULL);
				field_names = (_vala_array_free (field_names, field_names_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (_result_);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_ptr_array_unref0 (row_data);
	}
	_tmp52_ = g_string_new ("+");
	sep = _tmp52_;
	{
		gboolean _tmp53_;
		field = 0;
		_tmp53_ = TRUE;
		while (TRUE) {
			gboolean _tmp54_;
			gint _tmp56_;
			gchar** _tmp57_;
			gint _tmp57__length1;
			GString* _tmp66_;
			_tmp54_ = _tmp53_;
			if (!_tmp54_) {
				gint _tmp55_;
				_tmp55_ = field;
				field = _tmp55_ + 1;
			}
			_tmp53_ = FALSE;
			_tmp56_ = field;
			_tmp57_ = field_names;
			_tmp57__length1 = field_names_length1;
			if (!(_tmp56_ < _tmp57__length1)) {
				break;
			}
			{
				gint c;
				c = 0;
				{
					gboolean _tmp58_;
					_tmp58_ = TRUE;
					while (TRUE) {
						gboolean _tmp59_;
						gint _tmp61_;
						glong* _tmp62_;
						gint _tmp62__length1;
						gint _tmp63_;
						glong _tmp64_;
						GString* _tmp65_;
						_tmp59_ = _tmp58_;
						if (!_tmp59_) {
							gint _tmp60_;
							_tmp60_ = c;
							c = _tmp60_ + 1;
						}
						_tmp58_ = FALSE;
						_tmp61_ = c;
						_tmp62_ = field_lengths;
						_tmp62__length1 = field_lengths_length1;
						_tmp63_ = field;
						_tmp64_ = _tmp62_[_tmp63_];
						if (!(((glong) _tmp61_) < (_tmp64_ + 2))) {
							break;
						}
						_tmp65_ = sep;
						g_string_append_c (_tmp65_, '-');
					}
				}
			}
			_tmp66_ = sep;
			g_string_append_c (_tmp66_, '+');
		}
	}
	_tmp67_ = sep;
	g_string_append_c (_tmp67_, '\n');
	_tmp68_ = field_names;
	_tmp68__length1 = field_names_length1;
	_tmp69_ = g_new0 (gchar*, _tmp68__length1 + 1);
	field_fmt = _tmp69_;
	field_fmt_length1 = _tmp68__length1;
	_field_fmt_size_ = field_fmt_length1;
	_tmp70_ = fd;
	_tmp71_ = sep;
	_tmp72_ = _tmp71_->str;
	fputs (_tmp72_, _tmp70_);
	_tmp73_ = fd;
	fputc ('|', _tmp73_);
	{
		gboolean _tmp74_;
		field = 0;
		_tmp74_ = TRUE;
		while (TRUE) {
			gboolean _tmp75_;
			gint _tmp77_;
			gchar** _tmp78_;
			gint _tmp78__length1;
			gchar** _tmp79_;
			gint _tmp79__length1;
			gint _tmp80_;
			glong* _tmp81_;
			gint _tmp81__length1;
			gint _tmp82_;
			glong _tmp83_;
			gchar* _tmp84_ = NULL;
			gchar* _tmp85_;
			FILE* _tmp86_;
			gchar** _tmp87_;
			gint _tmp87__length1;
			gint _tmp88_;
			const gchar* _tmp89_;
			gchar** _tmp90_;
			gint _tmp90__length1;
			gint _tmp91_;
			const gchar* _tmp92_;
			_tmp75_ = _tmp74_;
			if (!_tmp75_) {
				gint _tmp76_;
				_tmp76_ = field;
				field = _tmp76_ + 1;
			}
			_tmp74_ = FALSE;
			_tmp77_ = field;
			_tmp78_ = field_names;
			_tmp78__length1 = field_names_length1;
			if (!(_tmp77_ < _tmp78__length1)) {
				break;
			}
			_tmp79_ = field_fmt;
			_tmp79__length1 = field_fmt_length1;
			_tmp80_ = field;
			_tmp81_ = field_lengths;
			_tmp81__length1 = field_lengths_length1;
			_tmp82_ = field;
			_tmp83_ = _tmp81_[_tmp82_];
			_tmp84_ = g_strdup_printf (" %%%lds |", _tmp83_);
			_g_free0 (_tmp79_[_tmp80_]);
			_tmp79_[_tmp80_] = _tmp84_;
			_tmp85_ = _tmp79_[_tmp80_];
			_tmp86_ = fd;
			_tmp87_ = field_fmt;
			_tmp87__length1 = field_fmt_length1;
			_tmp88_ = field;
			_tmp89_ = _tmp87_[_tmp88_];
			_tmp90_ = field_names;
			_tmp90__length1 = field_names_length1;
			_tmp91_ = field;
			_tmp92_ = _tmp90_[_tmp91_];
			fprintf (_tmp86_, _tmp89_, _tmp92_);
		}
	}
	_tmp93_ = fd;
	fputc ('\n', _tmp93_);
	_tmp94_ = fd;
	_tmp95_ = sep;
	_tmp96_ = _tmp95_->str;
	fputs (_tmp96_, _tmp94_);
	{
		gint row_n;
		row_n = 0;
		{
			gboolean _tmp97_;
			_tmp97_ = TRUE;
			while (TRUE) {
				gboolean _tmp98_;
				gint _tmp100_;
				GPtrArray* _tmp101_;
				gint _tmp102_;
				gint _tmp103_;
				GPtrArray* _tmp104_;
				gint _tmp105_;
				gconstpointer _tmp106_ = NULL;
				GPtrArray* _tmp107_;
				GPtrArray* row_data;
				FILE* _tmp108_;
				FILE* _tmp123_;
				FILE* _tmp124_;
				GString* _tmp125_;
				const gchar* _tmp126_;
				_tmp98_ = _tmp97_;
				if (!_tmp98_) {
					gint _tmp99_;
					_tmp99_ = row_n;
					row_n = _tmp99_ + 1;
				}
				_tmp97_ = FALSE;
				_tmp100_ = row_n;
				_tmp101_ = data;
				_tmp102_ = g_ptr_array_get_length (_tmp101_);
				_tmp103_ = _tmp102_;
				if (!(_tmp100_ < _tmp103_)) {
					break;
				}
				_tmp104_ = data;
				_tmp105_ = row_n;
				_tmp106_ = g_ptr_array_index (_tmp104_, (guint) _tmp105_);
				_tmp107_ = _g_ptr_array_ref0 ((GPtrArray*) _tmp106_);
				row_data = _tmp107_;
				_tmp108_ = fd;
				fputc ('|', _tmp108_);
				{
					gint col_n;
					col_n = 0;
					{
						gboolean _tmp109_;
						_tmp109_ = TRUE;
						while (TRUE) {
							gboolean _tmp110_;
							gint _tmp112_;
							GPtrArray* _tmp113_;
							gint _tmp114_;
							gint _tmp115_;
							FILE* _tmp116_;
							gchar** _tmp117_;
							gint _tmp117__length1;
							gint _tmp118_;
							const gchar* _tmp119_;
							GPtrArray* _tmp120_;
							gint _tmp121_;
							gconstpointer _tmp122_ = NULL;
							_tmp110_ = _tmp109_;
							if (!_tmp110_) {
								gint _tmp111_;
								_tmp111_ = col_n;
								col_n = _tmp111_ + 1;
							}
							_tmp109_ = FALSE;
							_tmp112_ = col_n;
							_tmp113_ = row_data;
							_tmp114_ = g_ptr_array_get_length (_tmp113_);
							_tmp115_ = _tmp114_;
							if (!(_tmp112_ < _tmp115_)) {
								break;
							}
							_tmp116_ = fd;
							_tmp117_ = field_fmt;
							_tmp117__length1 = field_fmt_length1;
							_tmp118_ = col_n;
							_tmp119_ = _tmp117_[_tmp118_];
							_tmp120_ = row_data;
							_tmp121_ = col_n;
							_tmp122_ = g_ptr_array_index (_tmp120_, (guint) _tmp121_);
							fprintf (_tmp116_, _tmp119_, (const gchar*) _tmp122_);
						}
					}
				}
				_tmp123_ = fd;
				fputc ('\n', _tmp123_);
				_tmp124_ = fd;
				_tmp125_ = sep;
				_tmp126_ = _tmp125_->str;
				fputs (_tmp126_, _tmp124_);
				_g_ptr_array_unref0 (row_data);
			}
		}
	}
	field_fmt = (_vala_array_free (field_fmt, field_fmt_length1, (GDestroyNotify) g_free), NULL);
	_g_string_free0 (sep);
	_g_ptr_array_unref0 (data);
	field_lengths = (g_free (field_lengths), NULL);
	field_names = (_vala_array_free (field_names, field_names_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_result_);
}


static gboolean sql_heavy_query_real_init (SQLHeavyQuery* self, GCancellable* cancellable, GError** error) {
	gboolean result = FALSE;
	SQLHeavyQueryable* _tmp0_;
	SQLHeavyDatabase* _tmp1_;
	SQLHeavyDatabase* _tmp2_;
	SQLHeavyDatabase* _tmp3_;
	sqlite3* _tmp4_ = NULL;
	sqlite3* _tmp5_;
	sqlite3* db;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gint _tmp8_;
	sqlite3_stmt* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	sqlite3_stmt* _tmp11_;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	sqlite3_stmt* _tmp14_;
	gint _tmp15_ = 0;
	gint _tmp16_;
	SQLHeavyValueArray* _tmp17_;
	GError * _inner_error_ = NULL;
	_tmp0_ = self->priv->_queryable;
	_tmp1_ = sql_heavy_queryable_get_database (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = sql_heavy_database_get_sqlite_db (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	db = _tmp5_;
	_tmp6_ = sql_heavy_query_get_sql (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->_sql_length;
	_tmp10_ = sqlite3_prepare_v2 (db, _tmp7_, _tmp8_, &_tmp9_, NULL);
	self->priv->stmt = _tmp9_;
	sql_heavy_error_if_not_ok (_tmp10_, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp11_ = self->priv->stmt;
	_tmp12_ = sqlite3_sql (_tmp11_);
	_tmp13_ = g_strdup (_tmp12_);
	_g_free0 (self->priv->_sql);
	self->priv->_sql = _tmp13_;
	_tmp14_ = self->priv->stmt;
	_tmp15_ = sqlite3_bind_parameter_count (_tmp14_);
	sql_heavy_query_set_parameter_count (self, _tmp15_);
	_tmp16_ = self->priv->_parameter_count;
	_tmp17_ = sql_heavy_value_array_new (_tmp16_);
	_g_object_unref0 (self->priv->bindings);
	self->priv->bindings = _tmp17_;
	result = TRUE;
	return result;
}


gboolean sql_heavy_query_init (SQLHeavyQuery* self, GCancellable* cancellable, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return SQL_HEAVY_QUERY_GET_CLASS (self)->init (self, cancellable, error);
}


/**
     * Create a new Query
     *
     * @param queryable the queryable to create the query
     * @param sql the SQL to use to create the query
     */
SQLHeavyQuery* sql_heavy_query_construct (GType object_type, SQLHeavyQueryable* queryable, const gchar* sql, GError** error) {
	SQLHeavyQuery * self = NULL;
	const gchar* _tmp0_;
	SQLHeavyQueryable* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (queryable != NULL, NULL);
	g_return_val_if_fail (sql != NULL, NULL);
	_tmp0_ = sql;
	self = (SQLHeavyQuery*) g_object_new (object_type, "sql", _tmp0_, NULL);
	_tmp1_ = queryable;
	sql_heavy_query_set_queryable (self, _tmp1_);
	sql_heavy_query_init (self, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


SQLHeavyQuery* sql_heavy_query_new (SQLHeavyQueryable* queryable, const gchar* sql, GError** error) {
	return sql_heavy_query_construct (SQL_HEAVY_TYPE_QUERY, queryable, sql, error);
}


/**
     * Create a new Query
     *
     * @param queryable the queryable to create the query
     * @param sql the SQL to use to create the query
     * @param sql_max_len the maximum length of the SQL
     * @param tail unused portion of the SQL
     */
SQLHeavyQuery* sql_heavy_query_construct_full (GType object_type, SQLHeavyQueryable* queryable, const gchar* sql, gint sql_max_len, const gchar** tail, GError** error) {
	const gchar* _vala_tail = NULL;
	SQLHeavyQuery * self = NULL;
	const gchar* _tmp0_;
	gint _tmp1_;
	SQLHeavyQueryable* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (queryable != NULL, NULL);
	g_return_val_if_fail (sql != NULL, NULL);
	_tmp0_ = sql;
	_tmp1_ = sql_max_len;
	self = (SQLHeavyQuery*) g_object_new (object_type, "sql", _tmp0_, "sql-length", _tmp1_, NULL);
	_tmp2_ = queryable;
	sql_heavy_query_set_queryable (self, _tmp2_);
	sql_heavy_query_init (self, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == SQL_HEAVY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if ((&_vala_tail) != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = self->priv->_sql;
		if (_tmp3_ != NULL) {
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			_tmp4_ = sql;
			_tmp5_ = self->priv->_sql;
			_tmp6_ = strlen (_tmp5_);
			_tmp7_ = _tmp6_;
			_vala_tail = (const gchar*) (((gsize) _tmp4_) + _tmp7_);
		} else {
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			GError* _tmp12_;
			_tmp8_ = sql;
			_tmp9_ = sql;
			_tmp10_ = strlen (_tmp9_);
			_tmp11_ = _tmp10_;
			_vala_tail = (const gchar*) (((gsize) _tmp8_) + _tmp11_);
			_tmp12_ = g_error_new_literal (SQL_HEAVY_ERROR, SQL_HEAVY_ERROR_NO_SQL, "No SQL was provided");
			_inner_error_ = _tmp12_;
			if (_inner_error_->domain == SQL_HEAVY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (self);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	if (tail) {
		*tail = _vala_tail;
	}
	return self;
}


SQLHeavyQuery* sql_heavy_query_new_full (SQLHeavyQueryable* queryable, const gchar* sql, gint sql_max_len, const gchar** tail, GError** error) {
	return sql_heavy_query_construct_full (SQL_HEAVY_TYPE_QUERY, queryable, sql, sql_max_len, tail, error);
}


SQLHeavyQueryable* sql_heavy_query_get_queryable (SQLHeavyQuery* self) {
	SQLHeavyQueryable* result;
	SQLHeavyQueryable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_queryable;
	result = _tmp0_;
	return result;
}


static void sql_heavy_query_set_queryable (SQLHeavyQuery* self, SQLHeavyQueryable* value) {
	SQLHeavyQueryable* _tmp0_;
	SQLHeavyQueryable* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_queryable);
	self->priv->_queryable = _tmp1_;
	g_object_notify ((GObject *) self, "queryable");
}


const gchar* sql_heavy_query_get_sql (SQLHeavyQuery* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sql;
	result = _tmp0_;
	return result;
}


static void sql_heavy_query_set_sql (SQLHeavyQuery* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_sql);
	self->priv->_sql = _tmp1_;
	g_object_notify ((GObject *) self, "sql");
}


static gint sql_heavy_query_get_sql_length (SQLHeavyQuery* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_sql_length;
	result = _tmp0_;
	return result;
}


static void sql_heavy_query_set_sql_length (SQLHeavyQuery* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_sql_length = _tmp0_;
	g_object_notify ((GObject *) self, "sql-length");
}


gboolean sql_heavy_query_get_auto_clear (SQLHeavyQuery* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_auto_clear;
	result = _tmp0_;
	return result;
}


void sql_heavy_query_set_auto_clear (SQLHeavyQuery* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_auto_clear = _tmp0_;
	g_object_notify ((GObject *) self, "auto-clear");
}


gint sql_heavy_query_get_parameter_count (SQLHeavyQuery* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_parameter_count;
	result = _tmp0_;
	return result;
}


static void sql_heavy_query_set_parameter_count (SQLHeavyQuery* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_parameter_count = _tmp0_;
	g_object_notify ((GObject *) self, "parameter-count");
}


static void sql_heavy_query_class_init (SQLHeavyQueryClass * klass) {
	sql_heavy_query_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SQLHeavyQueryPrivate));
	SQL_HEAVY_QUERY_CLASS (klass)->init = sql_heavy_query_real_init;
	G_OBJECT_CLASS (klass)->get_property = _vala_sql_heavy_query_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sql_heavy_query_set_property;
	G_OBJECT_CLASS (klass)->finalize = sql_heavy_query_finalize;
	/**
	     * The queryable asscociated with this query
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_QUERY_QUERYABLE, g_param_spec_object ("queryable", "queryable", "queryable", SQL_HEAVY_TYPE_QUERYABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * The SQL used to create this query 
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_QUERY_SQL, g_param_spec_string ("sql", "sql", "sql", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * The maximum length of the SQL used to create this query
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_QUERY_SQL_LENGTH, g_param_spec_int ("sql-length", "sql-length", "sql-length", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * When set the bindings will automatically be cleared when an
	     * associated {@link QueryResult} is destroyed.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_QUERY_AUTO_CLEAR, g_param_spec_boolean ("auto-clear", "auto-clear", "auto-clear", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The number of parameters in the query.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SQL_HEAVY_QUERY_PARAMETER_COUNT, g_param_spec_int ("parameter-count", "parameter-count", "parameter-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void sql_heavy_query_g_initable_interface_init (GInitableIface * iface) {
	sql_heavy_query_g_initable_parent_iface = g_type_interface_peek_parent (iface);
	iface->init = (gboolean (*)(GInitable*, GCancellable*, GError**)) sql_heavy_query_init;
}


static void sql_heavy_query_instance_init (SQLHeavyQuery * self) {
	self->priv = SQL_HEAVY_QUERY_GET_PRIVATE (self);
	self->priv->_sql_length = -1;
	g_static_rec_mutex_init (&self->priv->__lock_stmt);
	self->priv->stmt = NULL;
	self->priv->stmt_in_use = FALSE;
	self->priv->bindings = NULL;
	self->priv->_auto_clear = FALSE;
	self->priv->_parameter_count = 0;
}


static void sql_heavy_query_finalize (GObject* obj) {
	SQLHeavyQuery * self;
	self = SQL_HEAVY_QUERY (obj);
	_g_object_unref0 (self->priv->_queryable);
	_g_free0 (self->priv->_sql);
	g_static_rec_mutex_free (&self->priv->__lock_stmt);
	_g_object_unref0 (self->priv->bindings);
	G_OBJECT_CLASS (sql_heavy_query_parent_class)->finalize (obj);
}


/**
   * A prepared statement
   */
GType sql_heavy_query_get_type (void) {
	static volatile gsize sql_heavy_query_type_id__volatile = 0;
	if (g_once_init_enter (&sql_heavy_query_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SQLHeavyQueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sql_heavy_query_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SQLHeavyQuery), 0, (GInstanceInitFunc) sql_heavy_query_instance_init, NULL };
		static const GInterfaceInfo g_initable_info = { (GInterfaceInitFunc) sql_heavy_query_g_initable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType sql_heavy_query_type_id;
		sql_heavy_query_type_id = g_type_register_static (G_TYPE_OBJECT, "SQLHeavyQuery", &g_define_type_info, 0);
		g_type_add_interface_static (sql_heavy_query_type_id, G_TYPE_INITABLE, &g_initable_info);
		g_once_init_leave (&sql_heavy_query_type_id__volatile, sql_heavy_query_type_id);
	}
	return sql_heavy_query_type_id__volatile;
}


static void _vala_sql_heavy_query_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SQLHeavyQuery * self;
	self = SQL_HEAVY_QUERY (object);
	switch (property_id) {
		case SQL_HEAVY_QUERY_QUERYABLE:
		g_value_set_object (value, sql_heavy_query_get_queryable (self));
		break;
		case SQL_HEAVY_QUERY_SQL:
		g_value_set_string (value, sql_heavy_query_get_sql (self));
		break;
		case SQL_HEAVY_QUERY_SQL_LENGTH:
		g_value_set_int (value, sql_heavy_query_get_sql_length (self));
		break;
		case SQL_HEAVY_QUERY_AUTO_CLEAR:
		g_value_set_boolean (value, sql_heavy_query_get_auto_clear (self));
		break;
		case SQL_HEAVY_QUERY_PARAMETER_COUNT:
		g_value_set_int (value, sql_heavy_query_get_parameter_count (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_sql_heavy_query_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SQLHeavyQuery * self;
	self = SQL_HEAVY_QUERY (object);
	switch (property_id) {
		case SQL_HEAVY_QUERY_QUERYABLE:
		sql_heavy_query_set_queryable (self, g_value_get_object (value));
		break;
		case SQL_HEAVY_QUERY_SQL:
		sql_heavy_query_set_sql (self, g_value_get_string (value));
		break;
		case SQL_HEAVY_QUERY_SQL_LENGTH:
		sql_heavy_query_set_sql_length (self, g_value_get_int (value));
		break;
		case SQL_HEAVY_QUERY_AUTO_CLEAR:
		sql_heavy_query_set_auto_clear (self, g_value_get_boolean (value));
		break;
		case SQL_HEAVY_QUERY_PARAMETER_COUNT:
		sql_heavy_query_set_parameter_count (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



