C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE FDFFIN
C                       *****************
C
C     -------------------------------------------------------------
     * (NELRAY,SUFRAY,FDFRAY,FDFNP1)
C     -------------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C
C FONCTION :
C ----------
C      Maillage ouvert : completer les facteurs de forme
C
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  FDFRAY   ! TR ! R  ! FACTEURS DE FORME RAYONNEMENT                !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !___________!____!____!______________________________________________!
C ! /NLOFES/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C     TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C            L (LOGIQUE)   .. ET TYPES COMPOSES (EX : TR TABLEAU REEL)
C     MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (AUXILIAIRE MODIFIE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME APPELANT     :  
C
C     SOUS PROGRAMME(S) APPELE(S) :
C***********************************************************************
C
      IMPLICIT NONE        
C
C***********************************************************************
C     DONNEES EN COMMON 
C **********************************************************************
C
#include "nlofes.h"
#include "optct.h"
C
C **********************************************************************
C
C.. Variables externes
      INTEGER NELRAY
      DOUBLE PRECISION SUFRAY(NELRAY),FDFRAY(NELRAY*(NELRAY+1)/2)
      DOUBLE PRECISION FDFNP1(NELRAY)
C
C.. Variables internes
      INTEGER I,J
      DOUBLE PRECISION S,SFDF,UN
C
C***********************************************************************
C
C     1- CALCUL
C     =========
C
      UN = 1.
C
      DO 10 I=1,NELRAY
C
        S =0.
        DO 11 J=1,I-1
          S = S + FDFRAY((J-1)*NELRAY-(J-1)*J/2+I)
   11   CONTINUE
        S = S + FDFRAY((I-1)*NELRAY-(I-1)*I/2+I)
        DO 12 J=I+1,NELRAY
          S = S + FDFRAY((I-1)*NELRAY-(I-1)*I/2+J)  
   12   CONTINUE
C       
        SFDF=S/SUFRAY(I)
        IF (SFDF.GE.1.) THEN
          FDFNP1(I) = 0.
        ELSE
          FDFNP1(I) = (1.- SFDF)*SUFRAY(I)
        ENDIF
C
   10 CONTINUE
C
C       
C     2- IMPRESSIONS
C     ==============
      IF (NBLBLR.GE.10) THEN
        WRITE(NFECRA,1000)
        DO 200 I=1,NELRAY
         WRITE(NFECRA,1100) I,SUFRAY(I),FDFNP1(I)/SUFRAY(I)
 200    CONTINUE
      ENDIF
C
C--------
C FORMATS
C--------
C
 1000 FORMAT(/' *** FDFFIN : Domaines ouverts : completion ',
     *        'des facteurs de forme')
 1100 FORMAT(5X,'Ligne : ',I5,'   Surf elt = ',E12.7,
     *          '  FDFi-ouvert = ',E21.15)
C----
C FIN
C----
C
      END
