C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=INREFA,SSI=0
                        SUBROUTINE INREFA
C                       *****************
C
C     -----------------------------------
     * (NDIM,NDIELE,NELEMS,NDMATS,NBFACE,
     *  NODES,NREFAC,NPOINS,NREFS)
C     -----------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C             INITIALISATION DES REFERENCES DES FACES DANS LE CAS      *
C             OU LE MAILLEUR UTILISE NE LES FOURNIT PAS                *
C             Elles sont necessaires lorsque l'on veut imposer les     *
C             conditions aux limites sur les faces.                    *
C                                                                      *
C        Sous programme utilisateur                                    *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEMES                       !
C !  NDIELE   !  E ! D  ! DIMENSION DES ELEMENTS(2=triangles,3=tetraed)!
C !  NREFAC   ! TE ! R  ! REFERENCES DES FACES SOLIDES (volumiques)    !
C !  NODES    ! TE ! D  ! CONNECTIVITE                                 !
C !  NDMATS   !  E ! D  ! NOMBRE DE NOEUDS PAR ELEMENTS                !
C !  NBFACE   !  E ! D  ! NOMBRE DE FACES DES ELTS VOL SOLIDES         !
C !  NELEMS   !  E ! D  ! NOMBRE D'ELEMENTS                            !
C !  NREFS    ! TE ! D  ! REFERENCES DES NOEUDS SOLIDES                !
C !  NPOINS   !  E ! D  ! NOMBRE DE NOEUDS DU MAILLAGE SOLIDE          !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /XREFER/  !    ! D  !                                              !
C ! /NLOFES/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) :
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "nlofes.h"
C
C***********************************************************************
C 
C.. Variables externes
      INTEGER NDIM,NDIELE,NELEMS,NDMATS,NBFACE
      INTEGER NODES(NELEMS,NDMATS),NREFAC(NELEMS,NBFACE)
      INTEGER NPOINS,NREFS(NPOINS)
C
C.. Variables internes
      INTEGER I,J
      INTEGER N1,N2,N3,N4,N5,N6,NR1,NR2,NR3,NR4,NR5,NR6
C
C     NARE(noeud,arete), NFAC(noeud,face)
      INTEGER NARE(3,3),NFAC(6,4)
C***********************************************************************
C
      DATA NARE/1,2,4,  2,3,5,  3,1,6/
      DATA NFAC/1,2,3,5,6,7,  1,2,4,5,9,8,  1,3,4,7,10,8,  2,3,4,6,10,9/
C
C     1- INITIALISATIONS
C     ------------------
C
C
C     2- CAS D'UN MAILLAGE EN TRIANGLES
C     =================================
C
      IF (NCTHFS.EQ.3 .AND. NDIELE.EQ.2) THEN
C
CUTI    DO J=1,NBFACE
CUTI      DO I=1,NELEMS
C
C           Numeros des 3 noeuds de l'arete : 1----3----2
CUTI        N1 = NODES(I,NARE(1,J))
CUTI        N2 = NODES(I,NARE(2,J))
CUTI        N3 = NODES(I,NARE(3,J))
C
C           References des 3 noeuds
CUTI        NR1 = NREFS(N1)
CUTI        NR2 = NREFS(N2)
CUTI        NR3 = NREFS(N3)
C
C           Mise en place de la reference de l'arete courante
CUTI        NREFAC(I,J) = ...
C
CUTI      ENDDO
CUTI    ENDDO 
C
C
C     3- CAS D'UN MAILLAGE EN TETRAEDRES
C     ==================================
C
      ELSEIF (NCTHFS.EQ.3 .AND. NDIELE.EQ.3) THEN
C
CUTI    DO J=1,NBFACE
CUTI      DO I=1,NELEMS
C                                                     3
C                                                   /  \
C           Numeros des 6 noeuds de la face :      6     5
C                                                /        \
C                                               1-----4-----2
CUTI            N1 = NODES(I,NFAC(1,J))
CUTI            N2 = NODES(I,NFAC(2,J))
CUTI            N3 = NODES(I,NFAC(3,J))
CUTI            N4 = NODES(I,NFAC(4,J))
CUTI            N5 = NODES(I,NFAC(5,J))
CUTI            N6 = NODES(I,NFAC(6,J))
C
C           References des 3 noeuds
CUTI            NR1 = NREFS(N1)
CUTI            NR2 = NREFS(N2)
CUTI            NR3 = NREFS(N3)
CUTI            NR4 = NREFS(N4)
CUTI            NR5 = NREFS(N5)
CUTI            NR6 = NREFS(N6)
C
C           Mise en place de la reference de l'arete courante
CUTI        NREFAC(I,J) = ...
C
CUTI      ENDDO
CUTI    ENDDO
C
      ELSE
C
C     5- CAS D'ERREUR
C     ===============
        WRITE(NFECRA,5000)
        STOP
C
      ENDIF
C
C--------
C FORMATS
C--------
 5000 FORMAT(//,' %% ERREUR INREFA : ON N''EST DANS AUCUNE DES ', 
     &           'CONFIGURATIONS PREVUES')
C
      END
