## TFSA-2020-009: Segfault and data corruption caused by negative indexing in TFLite

### CVE Number
CVE-2020-15207

### Impact
To mimic Python's indexing with negative values, TFLite uses `ResolveAxis` to
convert negative values to positive indices. However, the only check that the
converted index is now valid is [only present in debug
builds](https://github.com/tensorflow/tensorflow/blob/0e68f4d3295eb0281a517c3662f6698992b7b2cf/tensorflow/lite/kernels/internal/reference/reduce.h#L68-L72):
```cc
    // Handle negative index. A positive index 'p_idx' can be represented as a
    // negative index 'n_idx' as: n_idx = p_idx-num_dims
    // eg: For num_dims=3, [0, 1, 2] is the same as [-3, -2, -1]  */
    int current = axis[idx] < 0 ? (axis[idx] + num_dims) : axis[idx];
    TFLITE_DCHECK(current >= 0 && current < num_dims);
```

If the `DCHECK` does not trigger, then code execution moves ahead with a
negative index. This, in turn, results in accessing data out of bounds which
results in segfaults and/or data corruption.

### Vulnerable Versions
TensorFlow 1.15.0, 1.15.1, 1.15.2, 1.15.3, 2.0.0, 2.0.1, 2.0.2, 2.1.0, 2.1.1,
2.2.0, 2.3.0.

### Patches
We have patched the issue in
[2d88f470dea2671b430884260f3626b1fe99830a](https://github.com/tensorflow/tensorflow/commit/2d88f470dea2671b430884260f3626b1fe99830a)
and will release patch releases for all versions between 1.15 and 2.3.

We recommend users to upgrade to TensorFlow 1.15.4, 2.0.3, 2.1.2, 2.2.1, or
2.3.1.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
