## TFSA-2021-171: Heap OOB in `SparseBinCount`

### CVE Number
CVE-2021-41226

### Impact
The [implementation](https://github.com/tensorflow/tensorflow/blob/e71b86d47f8bc1816bf54d7bddc4170e47670b97/tensorflow/core/kernels/bincount_op.cc#L353-L417) of `SparseBinCount` is vulnerable to a heap OOB:

```python
import tensorflow as tf


tf.raw_ops.SparseBincount(
  indices=[[0],[1],[2]]
  values=[0,-10000000]
  dense_shape=[1,1]
  size=[1]
  weights=[3,2,1]
  binary_output=False)
```

This is because of missing validation between the elements of the `values` argument and the shape of the sparse output:


```cc
for (int64_t i = 0; i < indices_mat.dimension(0); ++i) {
  const int64_t batch = indices_mat(i, 0);
  const Tidx bin = values(i);
  ...
  out(batch, bin) = ...;
}
```

### Patches
We have patched the issue in GitHub commit [f410212e373eb2aec4c9e60bf3702eba99a38aba](https://github.com/tensorflow/tensorflow/commit/f410212e373eb2aec4c9e60bf3702eba99a38aba).

The fix will be included in TensorFlow 2.7.0. We will also cherrypick this commit on TensorFlow 2.6.1, TensorFlow 2.5.2, and TensorFlow 2.4.4, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo 360.
