.\" Text automatically generated by txt2man
'\"
'\" Copyright (c) 2020 Kevin Walzer/WordTech Communications LLC.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
.TH tk systray n "" Tk "Tk Built-In Commands"
.so man.macros
.BS
.SH NAME
systray \- Creates an icon display in the platform-specific system tray.
.SH SYNOPSIS
.nf
\fBtk systray create \-image \fIimage\fR ?\fB\-text \fItext\fR? ?\fB\-button1 \fIcallback\fR? ?\fB\-button3 \fIcallback\fR?
\fBtk systray configure \fI?option? ?value option value ...?\fR
\fBtk systray exists\fR
\fBtk systray destroy\fR
.fi
.BE
.SH DESCRIPTION
.PP
.\" METHOD: create
The \fBtk systray create\fR command creates an icon in the platform-specific
tray. The widget is configured with a Tk image for the icon display, an
optional string for display in a tooltip, and optional callbacks that are
bound to <Button-1> and <Button-3>.
.PP
.\" METHOD: configure
The \fBtk systray configure\fR command sets one or more options of the systray
icon. Configurable options are the same as for the \fBcreate\fR subcommand. When
a single option name is given, the command returns the current value of this
option. When no option is given this command returns the list of all options and
their current value.
.PP
.\" METHOD: exists
The \fBtk systray exists\fR command checks whether a systray icon was created.
It returns a boolean.
.PP
.\" METHOD: destroy
The \fBtk systray destroy\fR command removes the icon from display and
deallocates it.
.PP
From a user-interface standpoint, only one icon per interpreter is
supported; attempts to create additional icons will return an error. The
existing tray icon can be modified with different images and
strings to indicate app state. Loading additional interpreters into a
running instance of Wish will allow additional icons to be displayed.
.SH EXAMPLE
.PP
Here is an example of the \fBtk systray\fR code:
.CS
image create photo book -data \e
        R0lGODlhDwAPAKIAAP//////AP8AAMDAwICAgAAAAAAAAAAAACwAAAAADwAPAAADSQhA2u5ksPeKABKSCaya29d4WKgERFF0l1IMQCAKatvBJ0OTdzzXI1xMB3TBZAvATtB6NSLKleXi3OBoLqrVgc0yv+DVSEUuFxIAOw==
tk systray create -image book -text "tk systray sample" \e
        -button1 {puts "Here is the tk systray output"} \e
        -button3 {puts "here is alternate output"}
.CE
.PP
Here is an example of modifying the \fBtk systray\fR icon:
.CS
image create photo book_page -data \e
        R0lGODlhCwAPAKIAAP//////AMDAwICAgAAA/wAAAAAAAAAAACwAAAAACwAPAAADMzi6CzAugiAgDGE68aB0RXgRJBFVX0SNpQlUWfahQOvSsgrX7eZJMlQMWBEYj8iQchlKAAA7
tk systray configure -image book_page -text "Updated sample" \e
        -button1 {puts "Different output from the tk systray"} \e
        -button3 {puts "and more different output from the tk systray"}
.CE
.SH PLATFORM NOTES
.PP
The X11 implementation is supported on a "best efforts" basis because it is
dependent on the window manager. The "text" flag, which is implemented as
a tooltip, does not always display if the WM does not support such features;
the systray icon itself may not even display with some window managers.
.PP
On Windows, the Tk image provided in the \fB\-image\fR option must be a
photo image. On other platforms either a bitmap image or a photo image
may be provided.
.SH KEYWORDS
image, callback
