/**
 * This file is a part of VideoCut package.
 * ---------------------------------------------------------------------- 
 * Copyright (C) 2007-2008 troorl
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ---------------------------------------------------------------------- 
 *
 * @author troorl <troorl@gmail.com>
 */

#ifndef _TXINE_H_
#define _TXINE_H_

#include <xine.h>
#include <QImage>
#include <QList>
#include "../const.h"

class TXine
{
	public:
		TXine();
		int init(const char *mrl);
		void close();
		const char *videoCodec();
		const char *audioCodec();
		int getLength();
		QImage getCurrentFrame(int) const;//, int*, int*);
		unsigned char *yv12ToRgb(uint8_t *src_y, uint8_t *src_u, uint8_t *src_v, int width, int height) const;
	
	private:
		int length;
		xine_t	*xine;
		char *vo_driver;
		xine_video_port_t *vo_port; // video port
		xine_stream_t	*stream; // stream
};

#endif
