;;; epop3mail.el --- retrieve mail using epop3.el ("extended" pop3.el)
;;
;; Author:        Franklin Lee <lee.franklin@worldnet.att.net>
;; Created:       11/1997
;; Keywords:      mail pop3
;; Version:       0.9
;;
;; Copyright (C) 1997, 1998 Franklin Lee
;;
;; This program is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by the
;; Free Software Foundation; either version 2, or (at your option) any
;; later version.
;;
;; epop3mail.el is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License along
;; with GNU Emacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
;;

;;; Commentary:

;; The following redefines `rmail-insert-inbox-text' so that it will
;; call `epop3-mail' rather than movemail.
;;
;; This is the emacs 19.34.6 version
;;

;;; History:
;;  --------
;;
;; 02/15/1997 broke this out to a separate file from epop3mail.
;;
;; 12/09/1998 added os/2 to (memq system-type ...) clause.  thanks to
;; jeremy bowen for this <jbowen@mas.co.nz>
;;
;; 02/02/1999 added eval-when-compile suggested by jari aalto

;;; Code:

(eval-when-compile
  (autoload 'epop3-mail "epop3mail")
  (require 'rmail))

;;
;; Look for "pop3-mail change" in comment
;;
(defun rmail-insert-inbox-text (files renamep)
  (let (file tofile delete-files movemail popmail)
    (while files
      (setq file (file-truename
                  (expand-file-name (substitute-in-file-name (car files))))
            tofile (expand-file-name
                    ;; Generate name to move to from inbox name,
                    ;; in case of multiple inboxes that need moving.
                    (concat ".newmail-" (file-name-nondirectory file))
                    ;; Use the directory of this rmail file
                    ;; because it's a nuisance to use the homedir
                    ;; if that is on a full disk and this rmail
                    ;; file isn't.
                    (file-name-directory
                     (expand-file-name buffer-file-name))))
      ;; Always use movemail to rename the file,
      ;; since there can be mailboxes in various directories.
      (setq movemail t)
;;;      ;; If getting from mail spool directory,
;;;      ;; use movemail to move rather than just renaming,
;;;      ;; so as to interlock with the mailer.
;;;      (setq movemail (string= file
;;;               (file-truename
;;;                (concat rmail-spool-directory
;;;                    (file-name-nondirectory file)))))
      (setq popmail (string-match "^po:" (file-name-nondirectory file)))
      (if popmail (setq file (file-name-nondirectory file)
                        renamep t))
      (if movemail
          (progn
            ;; On some systems, /usr/spool/mail/foo is a directory
            ;; and the actual inbox is /usr/spool/mail/foo/foo.
            (if (file-directory-p file)
                (setq file (expand-file-name (user-login-name)
                                             file)))))
      (cond (popmail
             (if (and rmail-pop-password-required (not rmail-pop-password))
                 (setq rmail-pop-password
                       (rmail-read-passwd
                        (format "Password for %s: "
                                (substring file (+ popmail 3))))))
             (if (memq system-type '(ms-dos windows-95 windows-nt emx))
                 ;; cannot have "po:" in file name
                 (setq tofile
                       (expand-file-name
                        (concat ".newmail-pop-" (substring file (+ popmail 3)))
                        (file-name-directory
                         (expand-file-name buffer-file-name)))))
             (message "Getting mail from post office ..."))
            ((and (file-exists-p tofile)
                  (/= 0 (nth 7 (file-attributes tofile))))
             (message "Getting mail from %s..." tofile))
            ((and (file-exists-p file)
                  (/= 0 (nth 7 (file-attributes file))))
             (message "Getting mail from %s..." file)))
      ;; Set TOFILE if have not already done so, and
      ;; rename or copy the file FILE to TOFILE if and as appropriate.
      (cond ((not renamep)
             (setq tofile file))
            ((or (file-exists-p tofile) (and (not popmail)
                                             (not (file-exists-p file))))
             nil)
            ((and (not movemail) (not popmail))
             ;; Try copying.  If that fails (perhaps no space),
             ;; rename instead.
             (condition-case nil
                 (copy-file file tofile nil)
               (error
                ;; Third arg is t so we can replace existing file TOFILE.
                (rename-file file tofile t)))
             ;; Make the real inbox file empty.
             ;; Leaving it deleted could cause lossage
             ;; because mailers often won't create the file.
             (condition-case ()
                 (write-region (point) (point) file)
               (file-error nil)))

            ;; <<<<<<<< pop3-mail change >>>>>>>>
            ;; Don't run movemail to pop mail for user@host, use elisp
            ((string-match "@" file)
             (epop3-mail file tofile))
            ;; <<<<<<<< end of pop3-mail change >>>>>>>>

            (t
             (let ((errors nil))
               (unwind-protect
                   (save-excursion
                     (setq errors (generate-new-buffer " *rmail loss*"))
                     (buffer-disable-undo errors)
                     (if rmail-pop-password
                         (call-process
                          (or rmail-movemail-program
                              (expand-file-name "movemail" exec-directory))
                          nil errors nil file tofile rmail-pop-password)
                       (call-process
                        (or rmail-movemail-program
                            (expand-file-name "movemail" exec-directory))
                        nil errors nil file tofile))
                     (if (not (buffer-modified-p errors))
                         ;; No output => movemail won
                         nil
                       (set-buffer errors)
                       (subst-char-in-region (point-min) (point-max)
                                             ?\n ?\  )
                       (goto-char (point-max))
                       (skip-chars-backward " \t")
                       (delete-region (point) (point-max))
                       (goto-char (point-min))
                       (if (looking-at "movemail: ")
                           (delete-region (point-min) (match-end 0)))
                       (beep t)
                       (message "movemail: %s"
                                (buffer-substring (point-min)
                                                  (point-max)))
                       (sit-for 3)
                       nil))
                 (if errors (kill-buffer errors))))))
      ;; At this point, TOFILE contains the name to read:
      ;; Either the alternate name (if we renamed)
      ;; or the actual inbox (if not renaming).
      (if (file-exists-p tofile)
          (let (size)
            (goto-char (point-max))
            (setq size (nth 1 (insert-file-contents tofile)))
            (goto-char (point-max))
            (or (= (preceding-char) ?\n)
                (zerop size)
                (insert ?\n))
            (setq delete-files (cons tofile delete-files))))
      (message "")
      (setq files (cdr files)))
    delete-files))

(provide 'epop3-riit19)

;;; epop3-riit19.el ends here
