/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.AdapterAlreadyActiveException;
import Ice.AdapterNotFoundException;
import Ice.AlreadyRegisteredException;
import Ice.Communicator;
import Ice.Connection;
import Ice.EndpointParseException;
import Ice.Identity;
import Ice.IllegalIdentityException;
import Ice.InvalidReplicaGroupIdException;
import Ice.LocalException;
import Ice.LocatorPrx;
import Ice.LocatorPrxHelper;
import Ice.LocatorRegistryPrx;
import Ice.NotRegisteredException;
import Ice.Object;
import Ice.ObjectAdapterDeactivatedException;
import Ice.ObjectAdapterIdInUseException;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.Properties;
import Ice.RouterPrx;
import Ice.RouterPrxHelper;
import Ice.Util;
import IceInternal.Endpoint;
import IceInternal.IncomingConnectionFactory;
import IceInternal.Instance;
import IceInternal.LocatorInfo;
import IceInternal.ObjectAdapterFactory;
import IceInternal.OutgoingConnectionFactory;
import IceInternal.Reference;
import IceInternal.RouterInfo;
import IceInternal.ServantManager;
import IceInternal.TraceLevels;
import IceUtil.Arrays;
import IceUtil.CloneException;
import IceUtil.StringUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class ObjectAdapter {
    private boolean _deactivated = false;
    private Instance _instance;
    private Communicator _communicator;
    private ObjectAdapterFactory _objectAdapterFactory;
    private ServantManager _servantManager;
    private boolean _activateOneOffDone;
    private String _name;
    private String _id;
    private String _replicaGroupId;
    private Vector _incomingConnectionFactories = new Vector();
    private Vector _routerEndpoints = new Vector();
    private RouterInfo _routerInfo = null;
    private Vector _publishedEndpoints = new Vector();
    private LocatorInfo _locatorInfo;
    private int _directCount;
    private boolean _waitForActivate;
    private boolean _destroying;
    private boolean _destroyed;

    public String getName() {
        return this._name;
    }

    public synchronized Communicator getCommunicator() {
        this.checkForDeactivation();
        return this._communicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() {
        java.lang.Object object;
        LocatorInfo locatorInfo = null;
        boolean bl = false;
        java.lang.Object object2 = this;
        synchronized (object2) {
            this.checkForDeactivation();
            if (this._activateOneOffDone) {
                int n = this._incomingConnectionFactories.size();
                Enumeration enumeration = this._incomingConnectionFactories.elements();
                while (enumeration.hasMoreElements()) {
                    IncomingConnectionFactory incomingConnectionFactory = (IncomingConnectionFactory)enumeration.nextElement();
                    incomingConnectionFactory.activate();
                }
                return;
            }
            this._waitForActivate = true;
            locatorInfo = this._locatorInfo;
            object = this._instance.initializationData().properties;
            bl = ((Properties)object).getPropertyAsInt("Ice.PrintAdapterReady") > 0;
        }
        try {
            object2 = new Identity();
            ((Identity)object2).name = "dummy";
            this.updateLocatorRegistry(locatorInfo, this.createDirectProxy((Identity)object2));
        }
        catch (LocalException localException) {
            object = this;
            synchronized (object) {
                this._waitForActivate = false;
                this.notifyAll();
            }
            throw localException;
        }
        if (bl) {
            System.out.println(this._name + " ready");
        }
        object2 = this;
        synchronized (object2) {
            this._waitForActivate = false;
            this.notifyAll();
            this._activateOneOffDone = true;
            int n = this._incomingConnectionFactories.size();
            Enumeration enumeration = this._incomingConnectionFactories.elements();
            while (enumeration.hasMoreElements()) {
                IncomingConnectionFactory incomingConnectionFactory = (IncomingConnectionFactory)enumeration.nextElement();
                incomingConnectionFactory.activate();
            }
        }
    }

    public synchronized void hold() {
        this.checkForDeactivation();
        Enumeration enumeration = this._incomingConnectionFactories.elements();
        while (enumeration.hasMoreElements()) {
            IncomingConnectionFactory incomingConnectionFactory = (IncomingConnectionFactory)enumeration.nextElement();
            incomingConnectionFactory.hold();
        }
    }

    public synchronized void waitForHold() {
        this.checkForDeactivation();
        Enumeration enumeration = this._incomingConnectionFactories.elements();
        while (enumeration.hasMoreElements()) {
            IncomingConnectionFactory incomingConnectionFactory = (IncomingConnectionFactory)enumeration.nextElement();
            incomingConnectionFactory.waitUntilHolding();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        LocatorInfo locatorInfo;
        OutgoingConnectionFactory outgoingConnectionFactory;
        java.lang.Object object;
        Vector vector;
        java.lang.Object object2 = this;
        synchronized (object2) {
            if (this._deactivated) {
                return;
            }
            while (this._waitForActivate) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this._routerInfo != null) {
                this._instance.routerManager().erase(this._routerInfo.getRouter());
                this._routerInfo.setAdapter(null);
            }
            vector = new Vector(this._incomingConnectionFactories.size());
            object = this._incomingConnectionFactories.elements();
            while (object.hasMoreElements()) {
                vector.addElement(object.nextElement());
            }
            outgoingConnectionFactory = this._instance.outgoingConnectionFactory();
            locatorInfo = this._locatorInfo;
            this._deactivated = true;
            this.notifyAll();
        }
        try {
            this.updateLocatorRegistry(locatorInfo, null);
        }
        catch (LocalException localException) {
            // empty catch block
        }
        object2 = vector.elements();
        while (object2.hasMoreElements()) {
            object = (IncomingConnectionFactory)object2.nextElement();
            ((IncomingConnectionFactory)object).destroy();
        }
        outgoingConnectionFactory.removeAdapter(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForDeactivate() {
        java.lang.Object[] objectArray;
        ObjectAdapter objectAdapter = this;
        synchronized (objectAdapter) {
            if (this._destroyed) {
                return;
            }
            while (!this._deactivated || this._directCount > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            objectArray = new IncomingConnectionFactory[this._incomingConnectionFactories.size()];
            this._incomingConnectionFactories.copyInto(objectArray);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            ((IncomingConnectionFactory)objectArray[i]).waitUntilFinished();
        }
    }

    public synchronized boolean isDeactivated() {
        return this._deactivated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        java.lang.Object object = this;
        synchronized (object) {
            while (this._destroying) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this._destroyed) {
                return;
            }
            this._destroying = true;
        }
        this.deactivate();
        this.waitForDeactivate();
        this._servantManager.destroy();
        ObjectAdapter objectAdapter = this;
        synchronized (objectAdapter) {
            this._destroying = false;
            this._destroyed = true;
            this.notifyAll();
            this._incomingConnectionFactories = null;
            this._instance = null;
            this._communicator = null;
            this._routerEndpoints = null;
            this._routerInfo = null;
            this._publishedEndpoints = null;
            this._locatorInfo = null;
            object = this._objectAdapterFactory;
            this._objectAdapterFactory = null;
        }
        if (object != null) {
            ((ObjectAdapterFactory)object).removeObjectAdapter(this._name);
        }
    }

    public ObjectPrx add(Object object, Identity identity) {
        return this.addFacet(object, identity, "");
    }

    public synchronized ObjectPrx addFacet(Object object, Identity identity, String string) {
        this.checkForDeactivation();
        ObjectAdapter.checkIdentity(identity);
        Identity identity2 = new Identity();
        identity2.category = identity.category;
        identity2.name = identity.name;
        this._servantManager.addServant(object, identity2, string);
        return this.newProxy(identity2, string);
    }

    public ObjectPrx addWithUUID(Object object) {
        return this.addFacetWithUUID(object, "");
    }

    public ObjectPrx addFacetWithUUID(Object object, String string) {
        Identity identity = new Identity();
        identity.category = "";
        identity.name = Util.generateUUID();
        return this.addFacet(object, identity, string);
    }

    public Object remove(Identity identity) {
        return this.removeFacet(identity, "");
    }

    public synchronized Object removeFacet(Identity identity, String string) {
        this.checkForDeactivation();
        ObjectAdapter.checkIdentity(identity);
        return this._servantManager.removeServant(identity, string);
    }

    public synchronized Hashtable removeAllFacets(Identity identity) {
        this.checkForDeactivation();
        ObjectAdapter.checkIdentity(identity);
        return this._servantManager.removeAllFacets(identity);
    }

    public Object find(Identity identity) {
        return this.findFacet(identity, "");
    }

    public synchronized Object findFacet(Identity identity, String string) {
        this.checkForDeactivation();
        ObjectAdapter.checkIdentity(identity);
        return this._servantManager.findServant(identity, string);
    }

    public synchronized Hashtable findAllFacets(Identity identity) {
        this.checkForDeactivation();
        ObjectAdapter.checkIdentity(identity);
        return this._servantManager.findAllFacets(identity);
    }

    public synchronized Object findByProxy(ObjectPrx objectPrx) {
        this.checkForDeactivation();
        Reference reference = ((ObjectPrxHelperBase)objectPrx).__reference();
        return this.findFacet(reference.getIdentity(), reference.getFacet());
    }

    public synchronized ObjectPrx createProxy(Identity identity) {
        this.checkForDeactivation();
        ObjectAdapter.checkIdentity(identity);
        return this.newProxy(identity, "");
    }

    public synchronized ObjectPrx createDirectProxy(Identity identity) {
        this.checkForDeactivation();
        ObjectAdapter.checkIdentity(identity);
        return this.newDirectProxy(identity, "");
    }

    public synchronized ObjectPrx createIndirectProxy(Identity identity) {
        this.checkForDeactivation();
        ObjectAdapter.checkIdentity(identity);
        return this.newIndirectProxy(identity, "", this._id);
    }

    public synchronized ObjectPrx createReverseProxy(Identity identity) {
        java.lang.Object[] objectArray;
        java.lang.Object object;
        this.checkForDeactivation();
        ObjectAdapter.checkIdentity(identity);
        Vector<java.lang.Object> vector = new Vector<java.lang.Object>();
        Enumeration enumeration = this._incomingConnectionFactories.elements();
        while (enumeration.hasMoreElements()) {
            object = (IncomingConnectionFactory)enumeration.nextElement();
            objectArray = ((IncomingConnectionFactory)object).connections();
            for (int i = 0; i < objectArray.length; ++i) {
                vector.addElement(objectArray[i]);
            }
        }
        object = new Endpoint[]{};
        objectArray = new Connection[vector.size()];
        vector.copyInto(objectArray);
        Reference reference = this._instance.referenceFactory().create(identity, null, "", 0, (Connection[])objectArray);
        return this._instance.proxyFactory().referenceToProxy(reference);
    }

    public synchronized void setLocator(LocatorPrx locatorPrx) {
        this.checkForDeactivation();
        this._locatorInfo = this._instance.locatorManager().get(locatorPrx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBatchRequests() {
        Vector vector;
        java.lang.Object object = this;
        synchronized (object) {
            vector = new Vector(this._incomingConnectionFactories.size());
            Enumeration enumeration = this._incomingConnectionFactories.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            ((IncomingConnectionFactory)object.nextElement()).flushBatchRequests();
        }
    }

    public synchronized void incDirectCount() {
        this.checkForDeactivation();
        ++this._directCount;
    }

    public synchronized void decDirectCount() {
        if (--this._directCount == 0) {
            this.notifyAll();
        }
    }

    public ServantManager getServantManager() {
        return this._servantManager;
    }

    public ObjectAdapter(Instance instance, Communicator communicator, ObjectAdapterFactory objectAdapterFactory, String string, String string2, RouterPrx routerPrx) {
        this._instance = instance;
        this._communicator = communicator;
        this._objectAdapterFactory = objectAdapterFactory;
        this._servantManager = new ServantManager(instance, string);
        this._activateOneOffDone = false;
        this._name = string;
        this._id = instance.initializationData().properties.getProperty(string + ".AdapterId");
        this._replicaGroupId = instance.initializationData().properties.getProperty(string + ".ReplicaGroupId");
        this._directCount = 0;
        this._waitForActivate = false;
        this._destroying = false;
        this._destroyed = false;
        try {
            java.lang.Object object;
            if (routerPrx == null && ((String)(object = this._instance.initializationData().properties.getProperty(string + ".Router"))).length() > 0) {
                routerPrx = RouterPrxHelper.uncheckedCast(this._instance.proxyFactory().stringToProxy((String)object));
            }
            if (routerPrx != null) {
                this._routerInfo = this._instance.routerManager().get(routerPrx);
                if (this._routerInfo != null) {
                    int n;
                    if (this._routerInfo.getAdapter() != null) {
                        throw new AlreadyRegisteredException("object adapter with router", this._instance.identityToString(routerPrx.ice_getIdentity()));
                    }
                    object = this._routerInfo.getServerEndpoints();
                    for (n = 0; n < ((Endpoint[])object).length; ++n) {
                        this._routerEndpoints.addElement(object[n]);
                    }
                    Arrays.sort(this._routerEndpoints);
                    n = 0;
                    while (n < this._routerEndpoints.size() - 1) {
                        java.lang.Object e;
                        java.lang.Object e2 = this._routerEndpoints.elementAt(n);
                        if (e2.equals(e = this._routerEndpoints.elementAt(n + 1))) {
                            this._routerEndpoints.removeElementAt(n);
                            continue;
                        }
                        ++n;
                    }
                    this._routerInfo.setAdapter(this);
                    this._instance.outgoingConnectionFactory().setRouterInfo(this._routerInfo);
                }
            } else {
                object = this.parseEndpoints(string2);
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    Endpoint endpoint = (Endpoint)((Vector)object).elementAt(i);
                    this._incomingConnectionFactories.addElement(new IncomingConnectionFactory(instance, endpoint, this));
                }
                if (((Vector)object).size() == 0) {
                    TraceLevels traceLevels = this._instance.traceLevels();
                    if (traceLevels.network >= 2) {
                        this._instance.initializationData().logger.trace(traceLevels.networkCat, "created adapter `" + string + "' without endpoints");
                    }
                }
                String string3 = this._instance.initializationData().properties.getProperty(string + ".PublishedEndpoints");
                this._publishedEndpoints = this.parseEndpoints(string3);
            }
            if (((String)(object = this._instance.initializationData().properties.getProperty(string + ".Locator"))).length() > 0) {
                this.setLocator(LocatorPrxHelper.uncheckedCast(this._instance.proxyFactory().stringToProxy((String)object)));
            } else {
                this.setLocator(this._instance.referenceFactory().getDefaultLocator());
            }
        }
        catch (LocalException localException) {
            this.deactivate();
            this.waitForDeactivate();
            throw localException;
        }
    }

    private ObjectPrx newProxy(Identity identity, String string) {
        if (this._id.length() == 0) {
            return this.newDirectProxy(identity, string);
        }
        if (this._replicaGroupId.length() == 0) {
            return this.newIndirectProxy(identity, string, this._id);
        }
        return this.newIndirectProxy(identity, string, this._replicaGroupId);
    }

    private ObjectPrx newDirectProxy(Identity identity, String string) {
        java.lang.Object object;
        int n;
        java.lang.Object[] objectArray;
        int n2 = this._publishedEndpoints.size();
        if (n2 > 0) {
            objectArray = new Endpoint[n2 + this._routerEndpoints.size()];
            this._publishedEndpoints.copyInto(objectArray);
        } else {
            n2 = this._incomingConnectionFactories.size();
            objectArray = new Endpoint[n2 + this._routerEndpoints.size()];
            for (n = 0; n < n2; ++n) {
                object = (IncomingConnectionFactory)this._incomingConnectionFactories.elementAt(n);
                objectArray[n] = ((IncomingConnectionFactory)object).endpoint();
            }
        }
        for (n = 0; n < this._routerEndpoints.size(); ++n) {
            objectArray[n2 + n] = (Endpoint)this._routerEndpoints.elementAt(n);
        }
        Connection[] connectionArray = new Connection[]{};
        object = this._instance.referenceFactory().create(identity, null, string, 0, false, (Endpoint[])objectArray, null);
        return this._instance.proxyFactory().referenceToProxy((Reference)object);
    }

    private ObjectPrx newIndirectProxy(Identity identity, String string, String string2) {
        Endpoint[] endpointArray = new Endpoint[]{};
        Connection[] connectionArray = new Connection[]{};
        Reference reference = this._instance.referenceFactory().create(identity, null, string, 0, false, string2, null, this._locatorInfo);
        return this._instance.proxyFactory().referenceToProxy(reference);
    }

    private void checkForDeactivation() {
        if (this._deactivated) {
            ObjectAdapterDeactivatedException objectAdapterDeactivatedException = new ObjectAdapterDeactivatedException();
            objectAdapterDeactivatedException.name = this._name;
            throw objectAdapterDeactivatedException;
        }
    }

    private static void checkIdentity(Identity identity) {
        if (identity.name == null || identity.name.length() == 0) {
            IllegalIdentityException illegalIdentityException = new IllegalIdentityException();
            try {
                illegalIdentityException.id = (Identity)identity.ice_clone();
            }
            catch (CloneException cloneException) {
                // empty catch block
            }
            throw illegalIdentityException;
        }
        if (identity.category == null) {
            identity.category = "";
        }
    }

    private Vector parseEndpoints(String string) {
        int n;
        string = string.toLowerCase();
        int n2 = 0;
        Vector<Endpoint> vector = new Vector<Endpoint>();
        while (n2 < string.length() && (n = StringUtil.findFirstNotOf(string, " \t\n\r", n2)) != -1) {
            n2 = string.indexOf(58, n);
            if (n2 == -1) {
                n2 = string.length();
            }
            if (n2 == n) {
                ++n2;
                continue;
            }
            String string2 = string.substring(n, n2);
            Endpoint endpoint = this._instance.endpointFactory().create(string2);
            if (endpoint == null) {
                EndpointParseException endpointParseException = new EndpointParseException();
                endpointParseException.str = string2;
                throw endpointParseException;
            }
            vector.addElement(endpoint);
            ++n2;
        }
        return vector;
    }

    private void updateLocatorRegistry(LocatorInfo locatorInfo, ObjectPrx objectPrx) {
        LocatorRegistryPrx locatorRegistryPrx;
        if (this._id.length() == 0) {
            return;
        }
        LocatorRegistryPrx locatorRegistryPrx2 = locatorRegistryPrx = locatorInfo != null ? locatorInfo.getLocatorRegistry() : null;
        if (locatorRegistryPrx == null) {
            return;
        }
        if (this._id.length() > 0) {
            try {
                if (this._replicaGroupId.length() == 0) {
                    locatorRegistryPrx.setAdapterDirectProxy(this._id, objectPrx);
                } else {
                    locatorRegistryPrx.setReplicatedAdapterDirectProxy(this._id, this._replicaGroupId, objectPrx);
                }
            }
            catch (AdapterNotFoundException adapterNotFoundException) {
                NotRegisteredException notRegisteredException = new NotRegisteredException();
                notRegisteredException.kindOfObject = "object adapter";
                notRegisteredException.id = this._id;
                throw notRegisteredException;
            }
            catch (InvalidReplicaGroupIdException invalidReplicaGroupIdException) {
                NotRegisteredException notRegisteredException = new NotRegisteredException();
                notRegisteredException.kindOfObject = "replica group";
                notRegisteredException.id = this._replicaGroupId;
                throw notRegisteredException;
            }
            catch (AdapterAlreadyActiveException adapterAlreadyActiveException) {
                ObjectAdapterIdInUseException objectAdapterIdInUseException = new ObjectAdapterIdInUseException();
                objectAdapterIdInUseException.id = this._id;
                throw objectAdapterIdInUseException;
            }
        }
    }
}

