/*
 * Definitions for temperature control state machine.
 * Greg Lehey, 5 June 2004
 *
 * $Id: statemachine.c,v 1.4 2004/07/10 00:54:29 grog Exp $
 *
 * Copyright (c) 2004 by Greg Lehey
 *
 *  This software is distributed under the so-called ``Berkeley
 *  License'':
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * This software is provided ``as is'', and any express or implied
 * warranties, including, but not limited to, the implied warranties of
 * merchantability and fitness for a particular purpose are disclaimed.
 * In no event shall Domenick Venezia be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even if
 * advised of the possibility of such damage.
 */

#include "statemachine.h"

char *machinestatetext [] =				    /* text description of machine states */
{
  "Initializing",					    /* initializing */
  "Idle",						    /* not doing anything */
  "Cooling",						    /* actively cooling */
  "Waiting to turn cooler on",				    /* waiting for cooler on time */
  "Waiting to turn cooler off",				    /* waiting for cooler off time */
  "Waiting for ambient temperature to increase",	    /* waiting for absolute ambient temperature
							     * difference to decrease */
  "Heating",						    /* actively heating */
  "Waiting to turn heater on",				    /* waiting for heater on time */
  "Waiting to turn heater off",				    /* waiting for heater off time */
  "Waiting for ambient temperature to decrease",	    /* waiting for absolute ambient temperature
							     * difference to decrease */
  };
