/*
 * ѥȤʤʸϤɤǡʸĹĴ
 * ǲϤη̤Ϥ
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "../include/convdb.h"

static int verbose;

static int
trim_segment(anthy_context_t ac, int nth, char *seg)
{
  int len = strlen(seg);
  while (1) {
    char seg_buf[1024];
    int cur_len;

    anthy_get_segment(ac, nth, NTH_UNCONVERTED_CANDIDATE, seg_buf, 1024);
    cur_len = strlen(seg_buf);
    if (len == cur_len) {
      return 1;
    }
    if (len > cur_len) {
      anthy_resize_segment(ac, nth, 1);
    } else {
      anthy_resize_segment(ac, nth, -1);
    }
  }
  return 0;
}

static int
trim_result(anthy_context_t ac, const char *res_str)
{
  char *str, *cur, *cur_seg;
  int nth;
  if (!res_str) {
    return 0;
  }

  str = strdup(res_str);
  cur = str;
  cur ++;
  cur_seg = cur;
  nth = 0;
  while ((cur = strchr(cur, '|'))) {
     *cur = 0;
    /**/
    trim_segment(ac, nth, cur_seg);
    /**/
    nth ++;
    cur ++;
    cur_seg = cur;
  }

  free(str);

  if (verbose) {
    anthy_print_context(ac);
  }
  
  return 1;
}

int
main(int argc, char **argv)
{
  struct res_db *db;
  struct conv_res *cr;
  anthy_context_t ac;
  int i;


  db = create_db();
  for (i = 1; i < argc; i++) {
    if (!strcmp("-v", argv[i])) {
      verbose = 1;
    } else {
      read_db(db, argv[i]);
    }
  }

  anthy_init();
  ac = anthy_create_context();

  for (cr = db->res_list.next; cr; cr = cr->next) {
    /*printf("(%s)\n", cr->src_str);*/
    anthy_set_string(ac, cr->src_str);
    if (trim_result(ac, cr->res_str)) {
      print_context_info(ac);
    }
  }
  return 0;
}
