/*
 * ʸι¤metaword򥽡Ȥ
 *
 * ʸФʣι¤θ򥽡Ȥ
 *
 */
#include <stdlib.h>
#include <math.h>

#include <segment.h>
#include <ordering.h>
#include <feature_set.h>
#include <splitter.h>
#include "sorter.h"

#define CAND_INFO
#include "../src-splitter/transition.h"

static void
mw_eval(struct seg_ent *prev_seg, struct seg_ent *seg,
	struct meta_word *mw)
{
  struct feature_list fl;
  double prob;
  anthy_feature_list_init(&fl);
  /**/
  anthy_feature_list_set_cur_class(&fl, mw->seg_class);
  anthy_feature_list_set_dep_word(&fl, mw->dep_word_hash);
  if (mw->mw_features & MW_FEATURE_SV) {
    anthy_feature_list_set_sv(&fl);
  }
  if (mw->mw_features & MW_FEATURE_WEAK) {
    anthy_feature_list_set_weak(&fl);
  }
  /* ʸ */
  if (prev_seg) {
    anthy_feature_list_set_prev_class(&fl, prev_seg->best_seg_class);
  } else {
    anthy_feature_list_set_prev_class(&fl, SEG_HEAD);
  }
  /* ׻ */
  prob = anthy_feature_list_inner_product(&fl, g_seg_lambda, MAX_SEG_STRUCT_FEATURE);
  prob = exp(prob);
  prob /= g_seg_z;
  anthy_feature_list_free(&fl);
  /*anthy_feature_list_print(&fl);
    printf(" prob=%f\n", prob);*/
  mw->struct_score = RATIO_BASE * RATIO_BASE;
  mw->struct_score *= prob;
}

static void
seg_eval(struct seg_ent *prev_seg,
	 struct seg_ent *seg)
{
  int i;
  for (i = 0; i < seg->nr_metaword; i++) {
    mw_eval(prev_seg, seg, seg->mw_array[i]);
  }
}

static void
sl_eval(struct segment_list *seg_list)
{
  int i;
  struct seg_ent *prev_seg = NULL;
  for (i = 0; i < seg_list->nr_segments; i++) {
    struct seg_ent *seg;
    seg = anthy_get_nth_segment(seg_list, i);
    seg_eval(prev_seg, seg);
    prev_seg = seg;
  }
}

static int
metaword_compare_func(const void *p1, const void *p2)
{
  const struct meta_word * const *s1 = p1;
  const struct meta_word * const *s2 = p2;
  return (*s2)->struct_score - (*s1)->struct_score;
}

void
anthy_sort_metaword(struct segment_list *seg_list)
{
  int i;
  /**/
  sl_eval(seg_list);
  /**/
  for (i = 0; i < seg_list->nr_segments; i++) {
    struct seg_ent *seg = anthy_get_nth_segment(seg_list, i);
    qsort(seg->mw_array, seg->nr_metaword, sizeof(struct meta_word *),
	  metaword_compare_func);
  }
}
