/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2008  Michael Bell <michael.bell@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

/** Test environment:
 *
 *      Combined address book and calendar sync:
 *          syncml-ds-tool
 *              -b 00:00:00:00:00:00 10
 *              --identifier "PC Suite"
 *              --wbxml --dumpinfo
 *              --slow-sync text/x-vcard Contacts
 *              --slow-sync text/x-vcalendar Calendar
 *
 *      Version:
 *          syncml-ds-tool --version
 *          0.4.7 (Revision: 614)
 *
 */
 
/** Description of the mobile:
 *
 * Mobile:          Nokia E65 (Nokia Series 60)
 * FirmwareVersion: -
 * SoftwareVersion: 1.0633.18.01
 * HardwareVersion: -
 *
 */

#include "../test_mobile.c"

SmlTransportType tspType = SML_TRANSPORT_OBEX_CLIENT;
const char *enableWbxml  = "1";
const char *useTimestamp = "1";

const char *mobile_name = "Nokia E65";
const char *maxMsgSize = "1024000";
const char *maxObjSize = "65535";

const char *identifier = "PC Suite";

const char *locList[] = {"Contacts", SML_ELEMENT_TEXT_VCARD,
                         "Calendar", SML_ELEMENT_TEXT_VCAL,
                         NULL, NULL};

