
/* Python wrapper functions auto-generated by pidl */
#include <Python.h>
#include "includes.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "librpc/gen_ndr/ndr_frstrans.h"
#include "librpc/gen_ndr/ndr_frstrans_c.h"

#include "librpc/gen_ndr/misc.h"
staticforward PyTypeObject frstrans_VersionVector_Type;
staticforward PyTypeObject frstrans_Update_Type;
staticforward PyTypeObject frstrans_EpoqueVector_Type;
staticforward PyTypeObject frstrans_AsyncVersionVectorResponse_Type;
staticforward PyTypeObject frstrans_AsyncResponseContext_Type;
staticforward PyTypeObject frstrans_RdcParameterGeneric_Type;
staticforward PyTypeObject frstrans_RdcParameterFilterMax_Type;
staticforward PyTypeObject frstrans_RdcParameterFilterPoint_Type;
staticforward PyTypeObject frstrans_RdcParameters_Type;
staticforward PyTypeObject frstrans_RdcFileInfo_Type;
staticforward PyTypeObject frstrans_InterfaceType;

void initfrstrans(void);static PyTypeObject *policy_handle_Type;
static PyTypeObject *Object_Type;
static PyTypeObject *GUID_Type;
static PyTypeObject *ClientConnection_Type;

static PyObject *py_frstrans_VersionVector_get_db_guid(PyObject *obj, void *closure)
{
	struct frstrans_VersionVector *object = (struct frstrans_VersionVector *)py_talloc_get_ptr(obj);
	PyObject *py_db_guid;
	py_db_guid = py_talloc_reference_ex(GUID_Type, py_talloc_get_mem_ctx(obj), &object->db_guid);
	return py_db_guid;
}

static int py_frstrans_VersionVector_set_db_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_VersionVector *object = (struct frstrans_VersionVector *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(py_talloc_get_mem_ctx(py_obj), py_talloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->db_guid = *(struct GUID *)py_talloc_get_ptr(value);
	return 0;
}

static PyObject *py_frstrans_VersionVector_get_low(PyObject *obj, void *closure)
{
	struct frstrans_VersionVector *object = (struct frstrans_VersionVector *)py_talloc_get_ptr(obj);
	PyObject *py_low;
	py_low = PyLong_FromLongLong(object->low);
	return py_low;
}

static int py_frstrans_VersionVector_set_low(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_VersionVector *object = (struct frstrans_VersionVector *)py_talloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->low = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->low = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frstrans_VersionVector_get_high(PyObject *obj, void *closure)
{
	struct frstrans_VersionVector *object = (struct frstrans_VersionVector *)py_talloc_get_ptr(obj);
	PyObject *py_high;
	py_high = PyLong_FromLongLong(object->high);
	return py_high;
}

static int py_frstrans_VersionVector_set_high(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_VersionVector *object = (struct frstrans_VersionVector *)py_talloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->high = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->high = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyGetSetDef py_frstrans_VersionVector_getsetters[] = {
	{ discard_const_p(char, "db_guid"), py_frstrans_VersionVector_get_db_guid, py_frstrans_VersionVector_set_db_guid },
	{ discard_const_p(char, "low"), py_frstrans_VersionVector_get_low, py_frstrans_VersionVector_set_low },
	{ discard_const_p(char, "high"), py_frstrans_VersionVector_get_high, py_frstrans_VersionVector_set_high },
	{ NULL }
};

static PyObject *py_frstrans_VersionVector_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct frstrans_VersionVector, type);
}


static PyTypeObject frstrans_VersionVector_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "frstrans.VersionVector",
	.tp_getset = py_frstrans_VersionVector_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_frstrans_VersionVector_new,
};


static PyObject *py_frstrans_Update_get_present(PyObject *obj, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(obj);
	PyObject *py_present;
	py_present = PyInt_FromLong(object->present);
	return py_present;
}

static int py_frstrans_Update_set_present(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->present = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frstrans_Update_get_name_conflict(PyObject *obj, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(obj);
	PyObject *py_name_conflict;
	py_name_conflict = PyInt_FromLong(object->name_conflict);
	return py_name_conflict;
}

static int py_frstrans_Update_set_name_conflict(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->name_conflict = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frstrans_Update_get_attributes(PyObject *obj, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(obj);
	PyObject *py_attributes;
	py_attributes = PyInt_FromLong(object->attributes);
	return py_attributes;
}

static int py_frstrans_Update_set_attributes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->attributes = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frstrans_Update_get_fence(PyObject *obj, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(obj);
	PyObject *py_fence;
	py_fence = PyLong_FromLongLong(object->fence);
	return py_fence;
}

static int py_frstrans_Update_set_fence(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->fence = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->fence = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frstrans_Update_get_clock(PyObject *obj, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(obj);
	PyObject *py_clock;
	py_clock = PyLong_FromLongLong(object->clock);
	return py_clock;
}

static int py_frstrans_Update_set_clock(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->clock = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->clock = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frstrans_Update_get_create_time(PyObject *obj, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(obj);
	PyObject *py_create_time;
	py_create_time = PyLong_FromLongLong(object->create_time);
	return py_create_time;
}

static int py_frstrans_Update_set_create_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->create_time = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->create_time = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frstrans_Update_get_content_set_guid(PyObject *obj, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(obj);
	PyObject *py_content_set_guid;
	py_content_set_guid = py_talloc_reference_ex(GUID_Type, py_talloc_get_mem_ctx(obj), &object->content_set_guid);
	return py_content_set_guid;
}

static int py_frstrans_Update_set_content_set_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(py_talloc_get_mem_ctx(py_obj), py_talloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->content_set_guid = *(struct GUID *)py_talloc_get_ptr(value);
	return 0;
}

static PyObject *py_frstrans_Update_get_sha1_hash(PyObject *obj, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(obj);
	PyObject *py_sha1_hash;
	py_sha1_hash = PyList_New(20);
	if (py_sha1_hash == NULL) {
		return NULL;
	}
	{
		int sha1_hash_cntr_0;
		for (sha1_hash_cntr_0 = 0; sha1_hash_cntr_0 < 20; sha1_hash_cntr_0++) {
			PyObject *py_sha1_hash_0;
			py_sha1_hash_0 = PyInt_FromLong(object->sha1_hash[sha1_hash_cntr_0]);
			PyList_SetItem(py_sha1_hash, sha1_hash_cntr_0, py_sha1_hash_0);
		}
	}
	return py_sha1_hash;
}

static int py_frstrans_Update_set_sha1_hash(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int sha1_hash_cntr_0;
		for (sha1_hash_cntr_0 = 0; sha1_hash_cntr_0 < PyList_GET_SIZE(value); sha1_hash_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, sha1_hash_cntr_0), return -1;);
			object->sha1_hash[sha1_hash_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, sha1_hash_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_frstrans_Update_get_rdc_similarity(PyObject *obj, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(obj);
	PyObject *py_rdc_similarity;
	py_rdc_similarity = PyList_New(16);
	if (py_rdc_similarity == NULL) {
		return NULL;
	}
	{
		int rdc_similarity_cntr_0;
		for (rdc_similarity_cntr_0 = 0; rdc_similarity_cntr_0 < 16; rdc_similarity_cntr_0++) {
			PyObject *py_rdc_similarity_0;
			py_rdc_similarity_0 = PyInt_FromLong(object->rdc_similarity[rdc_similarity_cntr_0]);
			PyList_SetItem(py_rdc_similarity, rdc_similarity_cntr_0, py_rdc_similarity_0);
		}
	}
	return py_rdc_similarity;
}

static int py_frstrans_Update_set_rdc_similarity(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int rdc_similarity_cntr_0;
		for (rdc_similarity_cntr_0 = 0; rdc_similarity_cntr_0 < PyList_GET_SIZE(value); rdc_similarity_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, rdc_similarity_cntr_0), return -1;);
			object->rdc_similarity[rdc_similarity_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, rdc_similarity_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_frstrans_Update_get_uid_db_guid(PyObject *obj, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(obj);
	PyObject *py_uid_db_guid;
	py_uid_db_guid = py_talloc_reference_ex(GUID_Type, py_talloc_get_mem_ctx(obj), &object->uid_db_guid);
	return py_uid_db_guid;
}

static int py_frstrans_Update_set_uid_db_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(py_talloc_get_mem_ctx(py_obj), py_talloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->uid_db_guid = *(struct GUID *)py_talloc_get_ptr(value);
	return 0;
}

static PyObject *py_frstrans_Update_get_uid_version(PyObject *obj, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(obj);
	PyObject *py_uid_version;
	py_uid_version = PyLong_FromLongLong(object->uid_version);
	return py_uid_version;
}

static int py_frstrans_Update_set_uid_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->uid_version = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->uid_version = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frstrans_Update_get_gsvn_db_guid(PyObject *obj, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(obj);
	PyObject *py_gsvn_db_guid;
	py_gsvn_db_guid = py_talloc_reference_ex(GUID_Type, py_talloc_get_mem_ctx(obj), &object->gsvn_db_guid);
	return py_gsvn_db_guid;
}

static int py_frstrans_Update_set_gsvn_db_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(py_talloc_get_mem_ctx(py_obj), py_talloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->gsvn_db_guid = *(struct GUID *)py_talloc_get_ptr(value);
	return 0;
}

static PyObject *py_frstrans_Update_get_gsvn_version(PyObject *obj, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(obj);
	PyObject *py_gsvn_version;
	py_gsvn_version = PyLong_FromLongLong(object->gsvn_version);
	return py_gsvn_version;
}

static int py_frstrans_Update_set_gsvn_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->gsvn_version = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->gsvn_version = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frstrans_Update_get_parent_db_guid(PyObject *obj, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(obj);
	PyObject *py_parent_db_guid;
	py_parent_db_guid = py_talloc_reference_ex(GUID_Type, py_talloc_get_mem_ctx(obj), &object->parent_db_guid);
	return py_parent_db_guid;
}

static int py_frstrans_Update_set_parent_db_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(py_talloc_get_mem_ctx(py_obj), py_talloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->parent_db_guid = *(struct GUID *)py_talloc_get_ptr(value);
	return 0;
}

static PyObject *py_frstrans_Update_get_parent_version(PyObject *obj, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(obj);
	PyObject *py_parent_version;
	py_parent_version = PyLong_FromLongLong(object->parent_version);
	return py_parent_version;
}

static int py_frstrans_Update_set_parent_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->parent_version = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->parent_version = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frstrans_Update_get_name(PyObject *obj, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(obj);
	PyObject *py_name;
	if (object->name == NULL) {
		py_name = Py_None;
		Py_INCREF(py_name);
	} else {
		py_name = PyUnicode_Decode(object->name, strlen(object->name), "utf-8", "ignore");
	}
	return py_name;
}

static int py_frstrans_Update_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(py_obj);
	if (PyUnicode_Check(value)) {
		object->name = PyString_AS_STRING(PyUnicode_AsEncodedString(value, "utf-8", "ignore"));
	} else if (PyString_Check(value)) {
		object->name = PyString_AS_STRING(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frstrans_Update_get_flags(PyObject *obj, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyInt_FromLong(object->flags);
	return py_flags;
}

static int py_frstrans_Update_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_Update *object = (struct frstrans_Update *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->flags = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_frstrans_Update_getsetters[] = {
	{ discard_const_p(char, "present"), py_frstrans_Update_get_present, py_frstrans_Update_set_present },
	{ discard_const_p(char, "name_conflict"), py_frstrans_Update_get_name_conflict, py_frstrans_Update_set_name_conflict },
	{ discard_const_p(char, "attributes"), py_frstrans_Update_get_attributes, py_frstrans_Update_set_attributes },
	{ discard_const_p(char, "fence"), py_frstrans_Update_get_fence, py_frstrans_Update_set_fence },
	{ discard_const_p(char, "clock"), py_frstrans_Update_get_clock, py_frstrans_Update_set_clock },
	{ discard_const_p(char, "create_time"), py_frstrans_Update_get_create_time, py_frstrans_Update_set_create_time },
	{ discard_const_p(char, "content_set_guid"), py_frstrans_Update_get_content_set_guid, py_frstrans_Update_set_content_set_guid },
	{ discard_const_p(char, "sha1_hash"), py_frstrans_Update_get_sha1_hash, py_frstrans_Update_set_sha1_hash },
	{ discard_const_p(char, "rdc_similarity"), py_frstrans_Update_get_rdc_similarity, py_frstrans_Update_set_rdc_similarity },
	{ discard_const_p(char, "uid_db_guid"), py_frstrans_Update_get_uid_db_guid, py_frstrans_Update_set_uid_db_guid },
	{ discard_const_p(char, "uid_version"), py_frstrans_Update_get_uid_version, py_frstrans_Update_set_uid_version },
	{ discard_const_p(char, "gsvn_db_guid"), py_frstrans_Update_get_gsvn_db_guid, py_frstrans_Update_set_gsvn_db_guid },
	{ discard_const_p(char, "gsvn_version"), py_frstrans_Update_get_gsvn_version, py_frstrans_Update_set_gsvn_version },
	{ discard_const_p(char, "parent_db_guid"), py_frstrans_Update_get_parent_db_guid, py_frstrans_Update_set_parent_db_guid },
	{ discard_const_p(char, "parent_version"), py_frstrans_Update_get_parent_version, py_frstrans_Update_set_parent_version },
	{ discard_const_p(char, "name"), py_frstrans_Update_get_name, py_frstrans_Update_set_name },
	{ discard_const_p(char, "flags"), py_frstrans_Update_get_flags, py_frstrans_Update_set_flags },
	{ NULL }
};

static PyObject *py_frstrans_Update_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct frstrans_Update, type);
}


static PyTypeObject frstrans_Update_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "frstrans.Update",
	.tp_getset = py_frstrans_Update_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_frstrans_Update_new,
};


static PyObject *py_frstrans_EpoqueVector_get_machine_guid(PyObject *obj, void *closure)
{
	struct frstrans_EpoqueVector *object = (struct frstrans_EpoqueVector *)py_talloc_get_ptr(obj);
	PyObject *py_machine_guid;
	py_machine_guid = py_talloc_reference_ex(GUID_Type, py_talloc_get_mem_ctx(obj), &object->machine_guid);
	return py_machine_guid;
}

static int py_frstrans_EpoqueVector_set_machine_guid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_EpoqueVector *object = (struct frstrans_EpoqueVector *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(py_talloc_get_mem_ctx(py_obj), py_talloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->machine_guid = *(struct GUID *)py_talloc_get_ptr(value);
	return 0;
}

static PyObject *py_frstrans_EpoqueVector_get_year(PyObject *obj, void *closure)
{
	struct frstrans_EpoqueVector *object = (struct frstrans_EpoqueVector *)py_talloc_get_ptr(obj);
	PyObject *py_year;
	py_year = PyInt_FromLong(object->year);
	return py_year;
}

static int py_frstrans_EpoqueVector_set_year(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_EpoqueVector *object = (struct frstrans_EpoqueVector *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->year = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frstrans_EpoqueVector_get_month(PyObject *obj, void *closure)
{
	struct frstrans_EpoqueVector *object = (struct frstrans_EpoqueVector *)py_talloc_get_ptr(obj);
	PyObject *py_month;
	py_month = PyInt_FromLong(object->month);
	return py_month;
}

static int py_frstrans_EpoqueVector_set_month(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_EpoqueVector *object = (struct frstrans_EpoqueVector *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->month = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frstrans_EpoqueVector_get_day_of_week(PyObject *obj, void *closure)
{
	struct frstrans_EpoqueVector *object = (struct frstrans_EpoqueVector *)py_talloc_get_ptr(obj);
	PyObject *py_day_of_week;
	py_day_of_week = PyInt_FromLong(object->day_of_week);
	return py_day_of_week;
}

static int py_frstrans_EpoqueVector_set_day_of_week(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_EpoqueVector *object = (struct frstrans_EpoqueVector *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->day_of_week = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frstrans_EpoqueVector_get_day(PyObject *obj, void *closure)
{
	struct frstrans_EpoqueVector *object = (struct frstrans_EpoqueVector *)py_talloc_get_ptr(obj);
	PyObject *py_day;
	py_day = PyInt_FromLong(object->day);
	return py_day;
}

static int py_frstrans_EpoqueVector_set_day(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_EpoqueVector *object = (struct frstrans_EpoqueVector *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->day = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frstrans_EpoqueVector_get_hour(PyObject *obj, void *closure)
{
	struct frstrans_EpoqueVector *object = (struct frstrans_EpoqueVector *)py_talloc_get_ptr(obj);
	PyObject *py_hour;
	py_hour = PyInt_FromLong(object->hour);
	return py_hour;
}

static int py_frstrans_EpoqueVector_set_hour(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_EpoqueVector *object = (struct frstrans_EpoqueVector *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->hour = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frstrans_EpoqueVector_get_minute(PyObject *obj, void *closure)
{
	struct frstrans_EpoqueVector *object = (struct frstrans_EpoqueVector *)py_talloc_get_ptr(obj);
	PyObject *py_minute;
	py_minute = PyInt_FromLong(object->minute);
	return py_minute;
}

static int py_frstrans_EpoqueVector_set_minute(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_EpoqueVector *object = (struct frstrans_EpoqueVector *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->minute = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frstrans_EpoqueVector_get_second(PyObject *obj, void *closure)
{
	struct frstrans_EpoqueVector *object = (struct frstrans_EpoqueVector *)py_talloc_get_ptr(obj);
	PyObject *py_second;
	py_second = PyInt_FromLong(object->second);
	return py_second;
}

static int py_frstrans_EpoqueVector_set_second(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_EpoqueVector *object = (struct frstrans_EpoqueVector *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->second = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frstrans_EpoqueVector_get_milli_seconds(PyObject *obj, void *closure)
{
	struct frstrans_EpoqueVector *object = (struct frstrans_EpoqueVector *)py_talloc_get_ptr(obj);
	PyObject *py_milli_seconds;
	py_milli_seconds = PyInt_FromLong(object->milli_seconds);
	return py_milli_seconds;
}

static int py_frstrans_EpoqueVector_set_milli_seconds(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_EpoqueVector *object = (struct frstrans_EpoqueVector *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->milli_seconds = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_frstrans_EpoqueVector_getsetters[] = {
	{ discard_const_p(char, "machine_guid"), py_frstrans_EpoqueVector_get_machine_guid, py_frstrans_EpoqueVector_set_machine_guid },
	{ discard_const_p(char, "year"), py_frstrans_EpoqueVector_get_year, py_frstrans_EpoqueVector_set_year },
	{ discard_const_p(char, "month"), py_frstrans_EpoqueVector_get_month, py_frstrans_EpoqueVector_set_month },
	{ discard_const_p(char, "day_of_week"), py_frstrans_EpoqueVector_get_day_of_week, py_frstrans_EpoqueVector_set_day_of_week },
	{ discard_const_p(char, "day"), py_frstrans_EpoqueVector_get_day, py_frstrans_EpoqueVector_set_day },
	{ discard_const_p(char, "hour"), py_frstrans_EpoqueVector_get_hour, py_frstrans_EpoqueVector_set_hour },
	{ discard_const_p(char, "minute"), py_frstrans_EpoqueVector_get_minute, py_frstrans_EpoqueVector_set_minute },
	{ discard_const_p(char, "second"), py_frstrans_EpoqueVector_get_second, py_frstrans_EpoqueVector_set_second },
	{ discard_const_p(char, "milli_seconds"), py_frstrans_EpoqueVector_get_milli_seconds, py_frstrans_EpoqueVector_set_milli_seconds },
	{ NULL }
};

static PyObject *py_frstrans_EpoqueVector_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct frstrans_EpoqueVector, type);
}


static PyTypeObject frstrans_EpoqueVector_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "frstrans.EpoqueVector",
	.tp_getset = py_frstrans_EpoqueVector_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_frstrans_EpoqueVector_new,
};


static PyObject *py_frstrans_AsyncVersionVectorResponse_get_vv_generation(PyObject *obj, void *closure)
{
	struct frstrans_AsyncVersionVectorResponse *object = (struct frstrans_AsyncVersionVectorResponse *)py_talloc_get_ptr(obj);
	PyObject *py_vv_generation;
	py_vv_generation = PyLong_FromLongLong(object->vv_generation);
	return py_vv_generation;
}

static int py_frstrans_AsyncVersionVectorResponse_set_vv_generation(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_AsyncVersionVectorResponse *object = (struct frstrans_AsyncVersionVectorResponse *)py_talloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->vv_generation = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->vv_generation = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frstrans_AsyncVersionVectorResponse_get_version_vector_count(PyObject *obj, void *closure)
{
	struct frstrans_AsyncVersionVectorResponse *object = (struct frstrans_AsyncVersionVectorResponse *)py_talloc_get_ptr(obj);
	PyObject *py_version_vector_count;
	py_version_vector_count = PyInt_FromLong(object->version_vector_count);
	return py_version_vector_count;
}

static int py_frstrans_AsyncVersionVectorResponse_set_version_vector_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_AsyncVersionVectorResponse *object = (struct frstrans_AsyncVersionVectorResponse *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->version_vector_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frstrans_AsyncVersionVectorResponse_get_version_vector(PyObject *obj, void *closure)
{
	struct frstrans_AsyncVersionVectorResponse *object = (struct frstrans_AsyncVersionVectorResponse *)py_talloc_get_ptr(obj);
	PyObject *py_version_vector;
	if (object->version_vector == NULL) {
		py_version_vector = Py_None;
		Py_INCREF(py_version_vector);
	} else {
		py_version_vector = PyList_New(object->version_vector_count);
		if (py_version_vector == NULL) {
			return NULL;
		}
		{
			int version_vector_cntr_1;
			for (version_vector_cntr_1 = 0; version_vector_cntr_1 < object->version_vector_count; version_vector_cntr_1++) {
				PyObject *py_version_vector_1;
				py_version_vector_1 = py_talloc_reference_ex(&frstrans_VersionVector_Type, object->version_vector, &object->version_vector[version_vector_cntr_1]);
				PyList_SetItem(py_version_vector, version_vector_cntr_1, py_version_vector_1);
			}
		}
	}
	return py_version_vector;
}

static int py_frstrans_AsyncVersionVectorResponse_set_version_vector(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_AsyncVersionVectorResponse *object = (struct frstrans_AsyncVersionVectorResponse *)py_talloc_get_ptr(py_obj);
	talloc_unlink(py_talloc_get_mem_ctx(py_obj), object->version_vector);
	if (value == Py_None) {
		object->version_vector = NULL;
	} else {
		object->version_vector = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int version_vector_cntr_1;
			object->version_vector = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->version_vector, PyList_GET_SIZE(value));
			if (!object->version_vector) { return -1;; }
			talloc_set_name_const(object->version_vector, "ARRAY: object->version_vector");
			for (version_vector_cntr_1 = 0; version_vector_cntr_1 < PyList_GET_SIZE(value); version_vector_cntr_1++) {
				PY_CHECK_TYPE(&frstrans_VersionVector_Type, PyList_GET_ITEM(value, version_vector_cntr_1), return -1;);
				if (talloc_reference(object->version_vector, py_talloc_get_mem_ctx(PyList_GET_ITEM(value, version_vector_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->version_vector[version_vector_cntr_1] = *(struct frstrans_VersionVector *)py_talloc_get_ptr(PyList_GET_ITEM(value, version_vector_cntr_1));
			}
		}
	}
	return 0;
}

static PyObject *py_frstrans_AsyncVersionVectorResponse_get_epoque_vector_count(PyObject *obj, void *closure)
{
	struct frstrans_AsyncVersionVectorResponse *object = (struct frstrans_AsyncVersionVectorResponse *)py_talloc_get_ptr(obj);
	PyObject *py_epoque_vector_count;
	py_epoque_vector_count = PyInt_FromLong(object->epoque_vector_count);
	return py_epoque_vector_count;
}

static int py_frstrans_AsyncVersionVectorResponse_set_epoque_vector_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_AsyncVersionVectorResponse *object = (struct frstrans_AsyncVersionVectorResponse *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->epoque_vector_count = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frstrans_AsyncVersionVectorResponse_get_epoque_vector(PyObject *obj, void *closure)
{
	struct frstrans_AsyncVersionVectorResponse *object = (struct frstrans_AsyncVersionVectorResponse *)py_talloc_get_ptr(obj);
	PyObject *py_epoque_vector;
	if (object->epoque_vector == NULL) {
		py_epoque_vector = Py_None;
		Py_INCREF(py_epoque_vector);
	} else {
		py_epoque_vector = PyList_New(object->epoque_vector_count);
		if (py_epoque_vector == NULL) {
			return NULL;
		}
		{
			int epoque_vector_cntr_1;
			for (epoque_vector_cntr_1 = 0; epoque_vector_cntr_1 < object->epoque_vector_count; epoque_vector_cntr_1++) {
				PyObject *py_epoque_vector_1;
				py_epoque_vector_1 = py_talloc_reference_ex(&frstrans_EpoqueVector_Type, object->epoque_vector, &object->epoque_vector[epoque_vector_cntr_1]);
				PyList_SetItem(py_epoque_vector, epoque_vector_cntr_1, py_epoque_vector_1);
			}
		}
	}
	return py_epoque_vector;
}

static int py_frstrans_AsyncVersionVectorResponse_set_epoque_vector(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_AsyncVersionVectorResponse *object = (struct frstrans_AsyncVersionVectorResponse *)py_talloc_get_ptr(py_obj);
	talloc_unlink(py_talloc_get_mem_ctx(py_obj), object->epoque_vector);
	if (value == Py_None) {
		object->epoque_vector = NULL;
	} else {
		object->epoque_vector = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int epoque_vector_cntr_1;
			object->epoque_vector = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->epoque_vector, PyList_GET_SIZE(value));
			if (!object->epoque_vector) { return -1;; }
			talloc_set_name_const(object->epoque_vector, "ARRAY: object->epoque_vector");
			for (epoque_vector_cntr_1 = 0; epoque_vector_cntr_1 < PyList_GET_SIZE(value); epoque_vector_cntr_1++) {
				PY_CHECK_TYPE(&frstrans_EpoqueVector_Type, PyList_GET_ITEM(value, epoque_vector_cntr_1), return -1;);
				if (talloc_reference(object->epoque_vector, py_talloc_get_mem_ctx(PyList_GET_ITEM(value, epoque_vector_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				object->epoque_vector[epoque_vector_cntr_1] = *(struct frstrans_EpoqueVector *)py_talloc_get_ptr(PyList_GET_ITEM(value, epoque_vector_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_frstrans_AsyncVersionVectorResponse_getsetters[] = {
	{ discard_const_p(char, "vv_generation"), py_frstrans_AsyncVersionVectorResponse_get_vv_generation, py_frstrans_AsyncVersionVectorResponse_set_vv_generation },
	{ discard_const_p(char, "version_vector_count"), py_frstrans_AsyncVersionVectorResponse_get_version_vector_count, py_frstrans_AsyncVersionVectorResponse_set_version_vector_count },
	{ discard_const_p(char, "version_vector"), py_frstrans_AsyncVersionVectorResponse_get_version_vector, py_frstrans_AsyncVersionVectorResponse_set_version_vector },
	{ discard_const_p(char, "epoque_vector_count"), py_frstrans_AsyncVersionVectorResponse_get_epoque_vector_count, py_frstrans_AsyncVersionVectorResponse_set_epoque_vector_count },
	{ discard_const_p(char, "epoque_vector"), py_frstrans_AsyncVersionVectorResponse_get_epoque_vector, py_frstrans_AsyncVersionVectorResponse_set_epoque_vector },
	{ NULL }
};

static PyObject *py_frstrans_AsyncVersionVectorResponse_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct frstrans_AsyncVersionVectorResponse, type);
}


static PyTypeObject frstrans_AsyncVersionVectorResponse_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "frstrans.AsyncVersionVectorResponse",
	.tp_getset = py_frstrans_AsyncVersionVectorResponse_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_frstrans_AsyncVersionVectorResponse_new,
};


static PyObject *py_frstrans_AsyncResponseContext_get_sequence_number(PyObject *obj, void *closure)
{
	struct frstrans_AsyncResponseContext *object = (struct frstrans_AsyncResponseContext *)py_talloc_get_ptr(obj);
	PyObject *py_sequence_number;
	py_sequence_number = PyInt_FromLong(object->sequence_number);
	return py_sequence_number;
}

static int py_frstrans_AsyncResponseContext_set_sequence_number(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_AsyncResponseContext *object = (struct frstrans_AsyncResponseContext *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->sequence_number = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frstrans_AsyncResponseContext_get_status(PyObject *obj, void *closure)
{
	struct frstrans_AsyncResponseContext *object = (struct frstrans_AsyncResponseContext *)py_talloc_get_ptr(obj);
	PyObject *py_status;
	py_status = PyErr_FromWERROR(object->status);
	return py_status;
}

static int py_frstrans_AsyncResponseContext_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_AsyncResponseContext *object = (struct frstrans_AsyncResponseContext *)py_talloc_get_ptr(py_obj);
	object->status = W_ERROR(PyInt_AsLong(value));
	return 0;
}

static PyObject *py_frstrans_AsyncResponseContext_get_response(PyObject *obj, void *closure)
{
	struct frstrans_AsyncResponseContext *object = (struct frstrans_AsyncResponseContext *)py_talloc_get_ptr(obj);
	PyObject *py_response;
	py_response = py_talloc_reference_ex(&frstrans_AsyncVersionVectorResponse_Type, py_talloc_get_mem_ctx(obj), &object->response);
	return py_response;
}

static int py_frstrans_AsyncResponseContext_set_response(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_AsyncResponseContext *object = (struct frstrans_AsyncResponseContext *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&frstrans_AsyncVersionVectorResponse_Type, value, return -1;);
	if (talloc_reference(py_talloc_get_mem_ctx(py_obj), py_talloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->response = *(struct frstrans_AsyncVersionVectorResponse *)py_talloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_frstrans_AsyncResponseContext_getsetters[] = {
	{ discard_const_p(char, "sequence_number"), py_frstrans_AsyncResponseContext_get_sequence_number, py_frstrans_AsyncResponseContext_set_sequence_number },
	{ discard_const_p(char, "status"), py_frstrans_AsyncResponseContext_get_status, py_frstrans_AsyncResponseContext_set_status },
	{ discard_const_p(char, "response"), py_frstrans_AsyncResponseContext_get_response, py_frstrans_AsyncResponseContext_set_response },
	{ NULL }
};

static PyObject *py_frstrans_AsyncResponseContext_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct frstrans_AsyncResponseContext, type);
}


static PyTypeObject frstrans_AsyncResponseContext_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "frstrans.AsyncResponseContext",
	.tp_getset = py_frstrans_AsyncResponseContext_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_frstrans_AsyncResponseContext_new,
};


static PyObject *py_frstrans_RdcParameterGeneric_get_chunker_type(PyObject *obj, void *closure)
{
	struct frstrans_RdcParameterGeneric *object = (struct frstrans_RdcParameterGeneric *)py_talloc_get_ptr(obj);
	PyObject *py_chunker_type;
	py_chunker_type = PyInt_FromLong(object->chunker_type);
	return py_chunker_type;
}

static int py_frstrans_RdcParameterGeneric_set_chunker_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_RdcParameterGeneric *object = (struct frstrans_RdcParameterGeneric *)py_talloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->chunker_type = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->chunker_type = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frstrans_RdcParameterGeneric_get_chunker_parameters(PyObject *obj, void *closure)
{
	struct frstrans_RdcParameterGeneric *object = (struct frstrans_RdcParameterGeneric *)py_talloc_get_ptr(obj);
	PyObject *py_chunker_parameters;
	py_chunker_parameters = PyList_New(64);
	if (py_chunker_parameters == NULL) {
		return NULL;
	}
	{
		int chunker_parameters_cntr_0;
		for (chunker_parameters_cntr_0 = 0; chunker_parameters_cntr_0 < 64; chunker_parameters_cntr_0++) {
			PyObject *py_chunker_parameters_0;
			py_chunker_parameters_0 = PyInt_FromLong(object->chunker_parameters[chunker_parameters_cntr_0]);
			PyList_SetItem(py_chunker_parameters, chunker_parameters_cntr_0, py_chunker_parameters_0);
		}
	}
	return py_chunker_parameters;
}

static int py_frstrans_RdcParameterGeneric_set_chunker_parameters(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_RdcParameterGeneric *object = (struct frstrans_RdcParameterGeneric *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int chunker_parameters_cntr_0;
		for (chunker_parameters_cntr_0 = 0; chunker_parameters_cntr_0 < PyList_GET_SIZE(value); chunker_parameters_cntr_0++) {
			PY_CHECK_TYPE(&PyInt_Type, PyList_GET_ITEM(value, chunker_parameters_cntr_0), return -1;);
			object->chunker_parameters[chunker_parameters_cntr_0] = PyInt_AsLong(PyList_GET_ITEM(value, chunker_parameters_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_frstrans_RdcParameterGeneric_getsetters[] = {
	{ discard_const_p(char, "chunker_type"), py_frstrans_RdcParameterGeneric_get_chunker_type, py_frstrans_RdcParameterGeneric_set_chunker_type },
	{ discard_const_p(char, "chunker_parameters"), py_frstrans_RdcParameterGeneric_get_chunker_parameters, py_frstrans_RdcParameterGeneric_set_chunker_parameters },
	{ NULL }
};

static PyObject *py_frstrans_RdcParameterGeneric_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct frstrans_RdcParameterGeneric, type);
}


static PyTypeObject frstrans_RdcParameterGeneric_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "frstrans.RdcParameterGeneric",
	.tp_getset = py_frstrans_RdcParameterGeneric_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_frstrans_RdcParameterGeneric_new,
};


static PyObject *py_frstrans_RdcParameterFilterMax_get_min_horizon_size(PyObject *obj, void *closure)
{
	struct frstrans_RdcParameterFilterMax *object = (struct frstrans_RdcParameterFilterMax *)py_talloc_get_ptr(obj);
	PyObject *py_min_horizon_size;
	py_min_horizon_size = PyInt_FromLong(object->min_horizon_size);
	return py_min_horizon_size;
}

static int py_frstrans_RdcParameterFilterMax_set_min_horizon_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_RdcParameterFilterMax *object = (struct frstrans_RdcParameterFilterMax *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->min_horizon_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frstrans_RdcParameterFilterMax_get_max_window_size(PyObject *obj, void *closure)
{
	struct frstrans_RdcParameterFilterMax *object = (struct frstrans_RdcParameterFilterMax *)py_talloc_get_ptr(obj);
	PyObject *py_max_window_size;
	py_max_window_size = PyInt_FromLong(object->max_window_size);
	return py_max_window_size;
}

static int py_frstrans_RdcParameterFilterMax_set_max_window_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_RdcParameterFilterMax *object = (struct frstrans_RdcParameterFilterMax *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->max_window_size = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_frstrans_RdcParameterFilterMax_getsetters[] = {
	{ discard_const_p(char, "min_horizon_size"), py_frstrans_RdcParameterFilterMax_get_min_horizon_size, py_frstrans_RdcParameterFilterMax_set_min_horizon_size },
	{ discard_const_p(char, "max_window_size"), py_frstrans_RdcParameterFilterMax_get_max_window_size, py_frstrans_RdcParameterFilterMax_set_max_window_size },
	{ NULL }
};

static PyObject *py_frstrans_RdcParameterFilterMax_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct frstrans_RdcParameterFilterMax, type);
}


static PyTypeObject frstrans_RdcParameterFilterMax_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "frstrans.RdcParameterFilterMax",
	.tp_getset = py_frstrans_RdcParameterFilterMax_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_frstrans_RdcParameterFilterMax_new,
};


static PyObject *py_frstrans_RdcParameterFilterPoint_get_min_chunk_size(PyObject *obj, void *closure)
{
	struct frstrans_RdcParameterFilterPoint *object = (struct frstrans_RdcParameterFilterPoint *)py_talloc_get_ptr(obj);
	PyObject *py_min_chunk_size;
	py_min_chunk_size = PyInt_FromLong(object->min_chunk_size);
	return py_min_chunk_size;
}

static int py_frstrans_RdcParameterFilterPoint_set_min_chunk_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_RdcParameterFilterPoint *object = (struct frstrans_RdcParameterFilterPoint *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->min_chunk_size = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frstrans_RdcParameterFilterPoint_get_max_chunk_size(PyObject *obj, void *closure)
{
	struct frstrans_RdcParameterFilterPoint *object = (struct frstrans_RdcParameterFilterPoint *)py_talloc_get_ptr(obj);
	PyObject *py_max_chunk_size;
	py_max_chunk_size = PyInt_FromLong(object->max_chunk_size);
	return py_max_chunk_size;
}

static int py_frstrans_RdcParameterFilterPoint_set_max_chunk_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_RdcParameterFilterPoint *object = (struct frstrans_RdcParameterFilterPoint *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->max_chunk_size = PyInt_AsLong(value);
	return 0;
}

static PyGetSetDef py_frstrans_RdcParameterFilterPoint_getsetters[] = {
	{ discard_const_p(char, "min_chunk_size"), py_frstrans_RdcParameterFilterPoint_get_min_chunk_size, py_frstrans_RdcParameterFilterPoint_set_min_chunk_size },
	{ discard_const_p(char, "max_chunk_size"), py_frstrans_RdcParameterFilterPoint_get_max_chunk_size, py_frstrans_RdcParameterFilterPoint_set_max_chunk_size },
	{ NULL }
};

static PyObject *py_frstrans_RdcParameterFilterPoint_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct frstrans_RdcParameterFilterPoint, type);
}


static PyTypeObject frstrans_RdcParameterFilterPoint_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "frstrans.RdcParameterFilterPoint",
	.tp_getset = py_frstrans_RdcParameterFilterPoint_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_frstrans_RdcParameterFilterPoint_new,
};

PyObject *py_import_frstrans_RdcParameterUnion(TALLOC_CTX *mem_ctx, int level, union frstrans_RdcParameterUnion *in)
{
	PyObject *ret;

	switch (level) {
		case FRSTRANS_RDC_FILTER_GENERIC:
			ret = py_talloc_reference_ex(&frstrans_RdcParameterGeneric_Type, mem_ctx, &in->filter_generic);
			return ret;

		case FRSTRANS_RDC_FILTER_MAX:
			ret = py_talloc_reference_ex(&frstrans_RdcParameterFilterMax_Type, mem_ctx, &in->filter_max);
			return ret;

		case FRSTRANS_RDC_FILTER_POINT:
			ret = py_talloc_reference_ex(&frstrans_RdcParameterFilterPoint_Type, mem_ctx, &in->filter_point);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

union frstrans_RdcParameterUnion *py_export_frstrans_RdcParameterUnion(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union frstrans_RdcParameterUnion *ret = talloc_zero(mem_ctx, union frstrans_RdcParameterUnion);
	switch (level) {
		case FRSTRANS_RDC_FILTER_GENERIC:
			PY_CHECK_TYPE(&frstrans_RdcParameterGeneric_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, py_talloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->filter_generic = *(struct frstrans_RdcParameterGeneric *)py_talloc_get_ptr(in);
			break;

		case FRSTRANS_RDC_FILTER_MAX:
			PY_CHECK_TYPE(&frstrans_RdcParameterFilterMax_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, py_talloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->filter_max = *(struct frstrans_RdcParameterFilterMax *)py_talloc_get_ptr(in);
			break;

		case FRSTRANS_RDC_FILTER_POINT:
			PY_CHECK_TYPE(&frstrans_RdcParameterFilterPoint_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, py_talloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->filter_point = *(struct frstrans_RdcParameterFilterPoint *)py_talloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}


static PyObject *py_frstrans_RdcParameters_get_rdc_chunker_algorithm(PyObject *obj, void *closure)
{
	struct frstrans_RdcParameters *object = (struct frstrans_RdcParameters *)py_talloc_get_ptr(obj);
	PyObject *py_rdc_chunker_algorithm;
	py_rdc_chunker_algorithm = PyInt_FromLong(object->rdc_chunker_algorithm);
	return py_rdc_chunker_algorithm;
}

static int py_frstrans_RdcParameters_set_rdc_chunker_algorithm(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_RdcParameters *object = (struct frstrans_RdcParameters *)py_talloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->rdc_chunker_algorithm = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->rdc_chunker_algorithm = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frstrans_RdcParameters_get_u(PyObject *obj, void *closure)
{
	struct frstrans_RdcParameters *object = (struct frstrans_RdcParameters *)py_talloc_get_ptr(obj);
	PyObject *py_u;
	py_u = py_import_frstrans_RdcParameterUnion(py_talloc_get_mem_ctx(obj), object->rdc_chunker_algorithm, &object->u);
	if (py_u == NULL) {
		return NULL;
	}
	return py_u;
}

static int py_frstrans_RdcParameters_set_u(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_RdcParameters *object = (struct frstrans_RdcParameters *)py_talloc_get_ptr(py_obj);
	{
		union frstrans_RdcParameterUnion *u_switch_0;
		u_switch_0 = py_export_frstrans_RdcParameterUnion(py_talloc_get_mem_ctx(py_obj), object->rdc_chunker_algorithm, value);
		if (u_switch_0 == NULL) {
			return -1;
		}
		object->u = *u_switch_0;
	}
	return 0;
}

static PyGetSetDef py_frstrans_RdcParameters_getsetters[] = {
	{ discard_const_p(char, "rdc_chunker_algorithm"), py_frstrans_RdcParameters_get_rdc_chunker_algorithm, py_frstrans_RdcParameters_set_rdc_chunker_algorithm },
	{ discard_const_p(char, "u"), py_frstrans_RdcParameters_get_u, py_frstrans_RdcParameters_set_u },
	{ NULL }
};

static PyObject *py_frstrans_RdcParameters_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct frstrans_RdcParameters, type);
}


static PyTypeObject frstrans_RdcParameters_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "frstrans.RdcParameters",
	.tp_getset = py_frstrans_RdcParameters_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_frstrans_RdcParameters_new,
};


static PyObject *py_frstrans_RdcFileInfo_get_on_disk_file_size(PyObject *obj, void *closure)
{
	struct frstrans_RdcFileInfo *object = (struct frstrans_RdcFileInfo *)py_talloc_get_ptr(obj);
	PyObject *py_on_disk_file_size;
	py_on_disk_file_size = PyLong_FromLongLong(object->on_disk_file_size);
	return py_on_disk_file_size;
}

static int py_frstrans_RdcFileInfo_set_on_disk_file_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_RdcFileInfo *object = (struct frstrans_RdcFileInfo *)py_talloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->on_disk_file_size = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->on_disk_file_size = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frstrans_RdcFileInfo_get_file_size_estimate(PyObject *obj, void *closure)
{
	struct frstrans_RdcFileInfo *object = (struct frstrans_RdcFileInfo *)py_talloc_get_ptr(obj);
	PyObject *py_file_size_estimate;
	py_file_size_estimate = PyLong_FromLongLong(object->file_size_estimate);
	return py_file_size_estimate;
}

static int py_frstrans_RdcFileInfo_set_file_size_estimate(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_RdcFileInfo *object = (struct frstrans_RdcFileInfo *)py_talloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->file_size_estimate = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->file_size_estimate = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frstrans_RdcFileInfo_get_rdc_version(PyObject *obj, void *closure)
{
	struct frstrans_RdcFileInfo *object = (struct frstrans_RdcFileInfo *)py_talloc_get_ptr(obj);
	PyObject *py_rdc_version;
	py_rdc_version = PyInt_FromLong(object->rdc_version);
	return py_rdc_version;
}

static int py_frstrans_RdcFileInfo_set_rdc_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_RdcFileInfo *object = (struct frstrans_RdcFileInfo *)py_talloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->rdc_version = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->rdc_version = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frstrans_RdcFileInfo_get_rdc_minimum_compatible_version(PyObject *obj, void *closure)
{
	struct frstrans_RdcFileInfo *object = (struct frstrans_RdcFileInfo *)py_talloc_get_ptr(obj);
	PyObject *py_rdc_minimum_compatible_version;
	py_rdc_minimum_compatible_version = PyInt_FromLong(object->rdc_minimum_compatible_version);
	return py_rdc_minimum_compatible_version;
}

static int py_frstrans_RdcFileInfo_set_rdc_minimum_compatible_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_RdcFileInfo *object = (struct frstrans_RdcFileInfo *)py_talloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->rdc_minimum_compatible_version = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->rdc_minimum_compatible_version = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frstrans_RdcFileInfo_get_rdc_signature_levels(PyObject *obj, void *closure)
{
	struct frstrans_RdcFileInfo *object = (struct frstrans_RdcFileInfo *)py_talloc_get_ptr(obj);
	PyObject *py_rdc_signature_levels;
	py_rdc_signature_levels = PyInt_FromLong(object->rdc_signature_levels);
	return py_rdc_signature_levels;
}

static int py_frstrans_RdcFileInfo_set_rdc_signature_levels(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_RdcFileInfo *object = (struct frstrans_RdcFileInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyInt_Type, value, return -1;);
	object->rdc_signature_levels = PyInt_AsLong(value);
	return 0;
}

static PyObject *py_frstrans_RdcFileInfo_get_compression_algorithm(PyObject *obj, void *closure)
{
	struct frstrans_RdcFileInfo *object = (struct frstrans_RdcFileInfo *)py_talloc_get_ptr(obj);
	PyObject *py_compression_algorithm;
	py_compression_algorithm = PyInt_FromLong(object->compression_algorithm);
	return py_compression_algorithm;
}

static int py_frstrans_RdcFileInfo_set_compression_algorithm(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_RdcFileInfo *object = (struct frstrans_RdcFileInfo *)py_talloc_get_ptr(py_obj);
	if (PyLong_Check(value)) {
		object->compression_algorithm = PyLong_AsLongLong(value);
	} else if (PyInt_Check(value)) {
		object->compression_algorithm = PyInt_AsLong(value);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return -1;
	}
	return 0;
}

static PyObject *py_frstrans_RdcFileInfo_get_rdc_filter_parameters(PyObject *obj, void *closure)
{
	struct frstrans_RdcFileInfo *object = (struct frstrans_RdcFileInfo *)py_talloc_get_ptr(obj);
	PyObject *py_rdc_filter_parameters;
	py_rdc_filter_parameters = PyList_New(object->rdc_signature_levels);
	if (py_rdc_filter_parameters == NULL) {
		return NULL;
	}
	{
		int rdc_filter_parameters_cntr_0;
		for (rdc_filter_parameters_cntr_0 = 0; rdc_filter_parameters_cntr_0 < object->rdc_signature_levels; rdc_filter_parameters_cntr_0++) {
			PyObject *py_rdc_filter_parameters_0;
			py_rdc_filter_parameters_0 = py_talloc_reference_ex(&frstrans_RdcParameters_Type, object->rdc_filter_parameters, &object->rdc_filter_parameters[rdc_filter_parameters_cntr_0]);
			PyList_SetItem(py_rdc_filter_parameters, rdc_filter_parameters_cntr_0, py_rdc_filter_parameters_0);
		}
	}
	return py_rdc_filter_parameters;
}

static int py_frstrans_RdcFileInfo_set_rdc_filter_parameters(PyObject *py_obj, PyObject *value, void *closure)
{
	struct frstrans_RdcFileInfo *object = (struct frstrans_RdcFileInfo *)py_talloc_get_ptr(py_obj);
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int rdc_filter_parameters_cntr_0;
		object->rdc_filter_parameters = talloc_array_ptrtype(py_talloc_get_mem_ctx(py_obj), object->rdc_filter_parameters, PyList_GET_SIZE(value));
		if (!object->rdc_filter_parameters) { return -1;; }
		talloc_set_name_const(object->rdc_filter_parameters, "ARRAY: object->rdc_filter_parameters");
		for (rdc_filter_parameters_cntr_0 = 0; rdc_filter_parameters_cntr_0 < PyList_GET_SIZE(value); rdc_filter_parameters_cntr_0++) {
			PY_CHECK_TYPE(&frstrans_RdcParameters_Type, PyList_GET_ITEM(value, rdc_filter_parameters_cntr_0), return -1;);
			if (talloc_reference(object->rdc_filter_parameters, py_talloc_get_mem_ctx(PyList_GET_ITEM(value, rdc_filter_parameters_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->rdc_filter_parameters[rdc_filter_parameters_cntr_0] = *(struct frstrans_RdcParameters *)py_talloc_get_ptr(PyList_GET_ITEM(value, rdc_filter_parameters_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_frstrans_RdcFileInfo_getsetters[] = {
	{ discard_const_p(char, "on_disk_file_size"), py_frstrans_RdcFileInfo_get_on_disk_file_size, py_frstrans_RdcFileInfo_set_on_disk_file_size },
	{ discard_const_p(char, "file_size_estimate"), py_frstrans_RdcFileInfo_get_file_size_estimate, py_frstrans_RdcFileInfo_set_file_size_estimate },
	{ discard_const_p(char, "rdc_version"), py_frstrans_RdcFileInfo_get_rdc_version, py_frstrans_RdcFileInfo_set_rdc_version },
	{ discard_const_p(char, "rdc_minimum_compatible_version"), py_frstrans_RdcFileInfo_get_rdc_minimum_compatible_version, py_frstrans_RdcFileInfo_set_rdc_minimum_compatible_version },
	{ discard_const_p(char, "rdc_signature_levels"), py_frstrans_RdcFileInfo_get_rdc_signature_levels, py_frstrans_RdcFileInfo_set_rdc_signature_levels },
	{ discard_const_p(char, "compression_algorithm"), py_frstrans_RdcFileInfo_get_compression_algorithm, py_frstrans_RdcFileInfo_set_compression_algorithm },
	{ discard_const_p(char, "rdc_filter_parameters"), py_frstrans_RdcFileInfo_get_rdc_filter_parameters, py_frstrans_RdcFileInfo_set_rdc_filter_parameters },
	{ NULL }
};

static PyObject *py_frstrans_RdcFileInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_talloc_new(struct frstrans_RdcFileInfo, type);
}


static PyTypeObject frstrans_RdcFileInfo_Type = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "frstrans.RdcFileInfo",
	.tp_getset = py_frstrans_RdcFileInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_basicsize = sizeof(py_talloc_Object),
	.tp_new = py_frstrans_RdcFileInfo_new,
};


static bool pack_py_frstrans_CheckConnectivity_args_in(PyObject *args, PyObject *kwargs, struct frstrans_CheckConnectivity *r)
{
	PyObject *py_replica_set_guid;
	PyObject *py_connection_guid;
	const char *kwnames[] = {
		"replica_set_guid", "connection_guid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:frstrans_CheckConnectivity", discard_const_p(char *, kwnames), &py_replica_set_guid, &py_connection_guid)) {
		return false;
	}

	PY_CHECK_TYPE(GUID_Type, py_replica_set_guid, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_replica_set_guid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.replica_set_guid = *(struct GUID *)py_talloc_get_ptr(py_replica_set_guid);
	PY_CHECK_TYPE(GUID_Type, py_connection_guid, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_connection_guid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.connection_guid = *(struct GUID *)py_talloc_get_ptr(py_connection_guid);
	return true;
}

static PyObject *unpack_py_frstrans_CheckConnectivity_args_out(struct frstrans_CheckConnectivity *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_frstrans_EstablishConnection_args_in(PyObject *args, PyObject *kwargs, struct frstrans_EstablishConnection *r)
{
	PyObject *py_replica_set_guid;
	PyObject *py_connection_guid;
	PyObject *py_downstream_protocol_version;
	PyObject *py_downstream_flags;
	const char *kwnames[] = {
		"replica_set_guid", "connection_guid", "downstream_protocol_version", "downstream_flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:frstrans_EstablishConnection", discard_const_p(char *, kwnames), &py_replica_set_guid, &py_connection_guid, &py_downstream_protocol_version, &py_downstream_flags)) {
		return false;
	}

	PY_CHECK_TYPE(GUID_Type, py_replica_set_guid, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_replica_set_guid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.replica_set_guid = *(struct GUID *)py_talloc_get_ptr(py_replica_set_guid);
	PY_CHECK_TYPE(GUID_Type, py_connection_guid, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_connection_guid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.connection_guid = *(struct GUID *)py_talloc_get_ptr(py_connection_guid);
	if (PyLong_Check(py_downstream_protocol_version)) {
		r->in.downstream_protocol_version = PyLong_AsLongLong(py_downstream_protocol_version);
	} else if (PyInt_Check(py_downstream_protocol_version)) {
		r->in.downstream_protocol_version = PyInt_AsLong(py_downstream_protocol_version);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	if (PyLong_Check(py_downstream_flags)) {
		r->in.downstream_flags = PyLong_AsLongLong(py_downstream_flags);
	} else if (PyInt_Check(py_downstream_flags)) {
		r->in.downstream_flags = PyInt_AsLong(py_downstream_flags);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_frstrans_EstablishConnection_args_out(struct frstrans_EstablishConnection *r)
{
	PyObject *result;
	PyObject *py_upstream_protocol_version;
	PyObject *py_upstream_flags;
	result = PyTuple_New(2);
	py_upstream_protocol_version = PyInt_FromLong(*r->out.upstream_protocol_version);
	PyTuple_SetItem(result, 0, py_upstream_protocol_version);
	py_upstream_flags = PyInt_FromLong(*r->out.upstream_flags);
	PyTuple_SetItem(result, 1, py_upstream_flags);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_frstrans_EstablishSession_args_in(PyObject *args, PyObject *kwargs, struct frstrans_EstablishSession *r)
{
	PyObject *py_connection_guid;
	PyObject *py_content_set_guid;
	const char *kwnames[] = {
		"connection_guid", "content_set_guid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:frstrans_EstablishSession", discard_const_p(char *, kwnames), &py_connection_guid, &py_content_set_guid)) {
		return false;
	}

	PY_CHECK_TYPE(GUID_Type, py_connection_guid, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_connection_guid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.connection_guid = *(struct GUID *)py_talloc_get_ptr(py_connection_guid);
	PY_CHECK_TYPE(GUID_Type, py_content_set_guid, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_content_set_guid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.content_set_guid = *(struct GUID *)py_talloc_get_ptr(py_content_set_guid);
	return true;
}

static PyObject *unpack_py_frstrans_EstablishSession_args_out(struct frstrans_EstablishSession *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_frstrans_RequestUpdates_args_in(PyObject *args, PyObject *kwargs, struct frstrans_RequestUpdates *r)
{
	PyObject *py_connection_guid;
	PyObject *py_content_set_guid;
	PyObject *py_credits_available;
	PyObject *py_hash_requested;
	PyObject *py_update_request_type;
	PyObject *py_version_vector_diff;
	const char *kwnames[] = {
		"connection_guid", "content_set_guid", "credits_available", "hash_requested", "update_request_type", "version_vector_diff", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:frstrans_RequestUpdates", discard_const_p(char *, kwnames), &py_connection_guid, &py_content_set_guid, &py_credits_available, &py_hash_requested, &py_update_request_type, &py_version_vector_diff)) {
		return false;
	}

	PY_CHECK_TYPE(GUID_Type, py_connection_guid, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_connection_guid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.connection_guid = *(struct GUID *)py_talloc_get_ptr(py_connection_guid);
	PY_CHECK_TYPE(GUID_Type, py_content_set_guid, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_content_set_guid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.content_set_guid = *(struct GUID *)py_talloc_get_ptr(py_content_set_guid);
	PY_CHECK_TYPE(&PyInt_Type, py_credits_available, return false;);
	r->in.credits_available = PyInt_AsLong(py_credits_available);
	PY_CHECK_TYPE(&PyInt_Type, py_hash_requested, return false;);
	r->in.hash_requested = PyInt_AsLong(py_hash_requested);
	if (PyLong_Check(py_update_request_type)) {
		r->in.update_request_type = PyLong_AsLongLong(py_update_request_type);
	} else if (PyInt_Check(py_update_request_type)) {
		r->in.update_request_type = PyInt_AsLong(py_update_request_type);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	PY_CHECK_TYPE(&PyList_Type, py_version_vector_diff, return false;);
	r->in.version_vector_diff_count = PyList_GET_SIZE(py_version_vector_diff);
	r->in.version_vector_diff = talloc_ptrtype(r, r->in.version_vector_diff);
	PY_CHECK_TYPE(&PyList_Type, py_version_vector_diff, return false;);
	{
		int version_vector_diff_cntr_1;
		r->in.version_vector_diff = talloc_array_ptrtype(r, r->in.version_vector_diff, PyList_GET_SIZE(py_version_vector_diff));
		if (!r->in.version_vector_diff) { return false;; }
		talloc_set_name_const(r->in.version_vector_diff, "ARRAY: r->in.version_vector_diff");
		for (version_vector_diff_cntr_1 = 0; version_vector_diff_cntr_1 < PyList_GET_SIZE(py_version_vector_diff); version_vector_diff_cntr_1++) {
			PY_CHECK_TYPE(&frstrans_VersionVector_Type, PyList_GET_ITEM(py_version_vector_diff, version_vector_diff_cntr_1), return false;);
			if (talloc_reference(r->in.version_vector_diff, py_talloc_get_mem_ctx(PyList_GET_ITEM(py_version_vector_diff, version_vector_diff_cntr_1))) == NULL) {
				PyErr_NoMemory();
				return false;
			}
			r->in.version_vector_diff[version_vector_diff_cntr_1] = *(struct frstrans_VersionVector *)py_talloc_get_ptr(PyList_GET_ITEM(py_version_vector_diff, version_vector_diff_cntr_1));
		}
	}
	return true;
}

static PyObject *unpack_py_frstrans_RequestUpdates_args_out(struct frstrans_RequestUpdates *r)
{
	PyObject *result;
	PyObject *py_frs_update;
	PyObject *py_update_status;
	PyObject *py_gvsn_db_guid;
	PyObject *py_gvsn_version;
	result = PyTuple_New(4);
	py_frs_update = PyList_New(*r->out.update_count);
	if (py_frs_update == NULL) {
		return NULL;
	}
	{
		int frs_update_cntr_1;
		for (frs_update_cntr_1 = 0; frs_update_cntr_1 < *r->out.update_count; frs_update_cntr_1++) {
			PyObject *py_frs_update_1;
			py_frs_update_1 = py_talloc_reference_ex(&frstrans_Update_Type, r->out.frs_update, &r->out.frs_update[frs_update_cntr_1]);
			PyList_SetItem(py_frs_update, frs_update_cntr_1, py_frs_update_1);
		}
	}
	PyTuple_SetItem(result, 0, py_frs_update);
	py_update_status = PyInt_FromLong(*r->out.update_status);
	PyTuple_SetItem(result, 1, py_update_status);
	py_gvsn_db_guid = py_talloc_reference_ex(GUID_Type, r->out.gvsn_db_guid, r->out.gvsn_db_guid);
	PyTuple_SetItem(result, 2, py_gvsn_db_guid);
	py_gvsn_version = PyLong_FromLongLong(*r->out.gvsn_version);
	PyTuple_SetItem(result, 3, py_gvsn_version);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_frstrans_RequestVersionVector_args_in(PyObject *args, PyObject *kwargs, struct frstrans_RequestVersionVector *r)
{
	PyObject *py_sequence_number;
	PyObject *py_connection_guid;
	PyObject *py_content_set_guid;
	PyObject *py_request_type;
	PyObject *py_change_type;
	PyObject *py_vv_generation;
	const char *kwnames[] = {
		"sequence_number", "connection_guid", "content_set_guid", "request_type", "change_type", "vv_generation", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOOO:frstrans_RequestVersionVector", discard_const_p(char *, kwnames), &py_sequence_number, &py_connection_guid, &py_content_set_guid, &py_request_type, &py_change_type, &py_vv_generation)) {
		return false;
	}

	PY_CHECK_TYPE(&PyInt_Type, py_sequence_number, return false;);
	r->in.sequence_number = PyInt_AsLong(py_sequence_number);
	PY_CHECK_TYPE(GUID_Type, py_connection_guid, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_connection_guid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.connection_guid = *(struct GUID *)py_talloc_get_ptr(py_connection_guid);
	PY_CHECK_TYPE(GUID_Type, py_content_set_guid, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_content_set_guid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.content_set_guid = *(struct GUID *)py_talloc_get_ptr(py_content_set_guid);
	if (PyLong_Check(py_request_type)) {
		r->in.request_type = PyLong_AsLongLong(py_request_type);
	} else if (PyInt_Check(py_request_type)) {
		r->in.request_type = PyInt_AsLong(py_request_type);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	if (PyLong_Check(py_change_type)) {
		r->in.change_type = PyLong_AsLongLong(py_change_type);
	} else if (PyInt_Check(py_change_type)) {
		r->in.change_type = PyInt_AsLong(py_change_type);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	if (PyLong_Check(py_vv_generation)) {
		r->in.vv_generation = PyLong_AsLongLong(py_vv_generation);
	} else if (PyInt_Check(py_vv_generation)) {
		r->in.vv_generation = PyInt_AsLong(py_vv_generation);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	return true;
}

static PyObject *unpack_py_frstrans_RequestVersionVector_args_out(struct frstrans_RequestVersionVector *r)
{
	PyObject *result;
	result = Py_None;
	Py_INCREF(result);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_frstrans_AsyncPoll_args_in(PyObject *args, PyObject *kwargs, struct frstrans_AsyncPoll *r)
{
	PyObject *py_connection_guid;
	const char *kwnames[] = {
		"connection_guid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:frstrans_AsyncPoll", discard_const_p(char *, kwnames), &py_connection_guid)) {
		return false;
	}

	PY_CHECK_TYPE(GUID_Type, py_connection_guid, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_connection_guid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.connection_guid = *(struct GUID *)py_talloc_get_ptr(py_connection_guid);
	return true;
}

static PyObject *unpack_py_frstrans_AsyncPoll_args_out(struct frstrans_AsyncPoll *r)
{
	PyObject *result;
	PyObject *py_response;
	py_response = py_talloc_reference_ex(&frstrans_AsyncResponseContext_Type, r->out.response, r->out.response);
	result = py_response;
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

static bool pack_py_frstrans_InitializeFileTransferAsync_args_in(PyObject *args, PyObject *kwargs, struct frstrans_InitializeFileTransferAsync *r)
{
	PyObject *py_connection_guid;
	PyObject *py_frs_update;
	PyObject *py_rdc_desired;
	PyObject *py_staging_policy;
	PyObject *py_buffer_size;
	const char *kwnames[] = {
		"connection_guid", "frs_update", "rdc_desired", "staging_policy", "buffer_size", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOOO:frstrans_InitializeFileTransferAsync", discard_const_p(char *, kwnames), &py_connection_guid, &py_frs_update, &py_rdc_desired, &py_staging_policy, &py_buffer_size)) {
		return false;
	}

	PY_CHECK_TYPE(GUID_Type, py_connection_guid, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_connection_guid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.connection_guid = *(struct GUID *)py_talloc_get_ptr(py_connection_guid);
	r->in.frs_update = talloc_ptrtype(r, r->in.frs_update);
	PY_CHECK_TYPE(&frstrans_Update_Type, py_frs_update, return false;);
	if (talloc_reference(r, py_talloc_get_mem_ctx(py_frs_update)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.frs_update = (struct frstrans_Update *)py_talloc_get_ptr(py_frs_update);
	PY_CHECK_TYPE(&PyInt_Type, py_rdc_desired, return false;);
	r->in.rdc_desired = PyInt_AsLong(py_rdc_desired);
	r->in.staging_policy = talloc_ptrtype(r, r->in.staging_policy);
	if (PyLong_Check(py_staging_policy)) {
		*r->in.staging_policy = PyLong_AsLongLong(py_staging_policy);
	} else if (PyInt_Check(py_staging_policy)) {
		*r->in.staging_policy = PyInt_AsLong(py_staging_policy);
	} else {
		PyErr_Format(PyExc_TypeError, "Expected type %s or %s",\
		  PyInt_Type.tp_name, PyLong_Type.tp_name);
		return false;
	}
	PY_CHECK_TYPE(&PyInt_Type, py_buffer_size, return false;);
	r->in.buffer_size = PyInt_AsLong(py_buffer_size);
	return true;
}

static PyObject *unpack_py_frstrans_InitializeFileTransferAsync_args_out(struct frstrans_InitializeFileTransferAsync *r)
{
	PyObject *result;
	PyObject *py_frs_update;
	PyObject *py_staging_policy;
	PyObject *py_server_context;
	PyObject *py_rdc_file_info;
	PyObject *py_data_buffer;
	PyObject *py_is_end_of_file;
	result = PyTuple_New(6);
	py_frs_update = py_talloc_reference_ex(&frstrans_Update_Type, r->out.frs_update, r->out.frs_update);
	PyTuple_SetItem(result, 0, py_frs_update);
	py_staging_policy = PyInt_FromLong(*r->out.staging_policy);
	PyTuple_SetItem(result, 1, py_staging_policy);
	py_server_context = py_talloc_reference_ex(policy_handle_Type, r->out.server_context, r->out.server_context);
	PyTuple_SetItem(result, 2, py_server_context);
	if (*r->out.rdc_file_info == NULL) {
		py_rdc_file_info = Py_None;
		Py_INCREF(py_rdc_file_info);
	} else {
		py_rdc_file_info = py_talloc_reference_ex(&frstrans_RdcFileInfo_Type, *r->out.rdc_file_info, *r->out.rdc_file_info);
	}
	PyTuple_SetItem(result, 3, py_rdc_file_info);
	py_data_buffer = PyList_New(*r->out.size_read);
	if (py_data_buffer == NULL) {
		return NULL;
	}
	{
		int data_buffer_cntr_1;
		for (data_buffer_cntr_1 = 0; data_buffer_cntr_1 < *r->out.size_read; data_buffer_cntr_1++) {
			PyObject *py_data_buffer_1;
			py_data_buffer_1 = PyInt_FromLong(r->out.data_buffer[data_buffer_cntr_1]);
			PyList_SetItem(py_data_buffer, data_buffer_cntr_1, py_data_buffer_1);
		}
	}
	PyTuple_SetItem(result, 4, py_data_buffer);
	py_is_end_of_file = PyInt_FromLong(*r->out.is_end_of_file);
	PyTuple_SetItem(result, 5, py_is_end_of_file);
	if (!W_ERROR_IS_OK(r->out.result)) {
		PyErr_SetWERROR(r->out.result);
		return NULL;
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_frstrans_methods[] = {
	{ "CheckConnectivity", "S.CheckConnectivity(replica_set_guid, connection_guid) -> None", (py_dcerpc_call_fn)dcerpc_frstrans_CheckConnectivity_r, (py_data_pack_fn)pack_py_frstrans_CheckConnectivity_args_in, (py_data_unpack_fn)unpack_py_frstrans_CheckConnectivity_args_out, 0, &ndr_table_frstrans },
	{ "EstablishConnection", "S.EstablishConnection(replica_set_guid, connection_guid, downstream_protocol_version, downstream_flags) -> (upstream_protocol_version, upstream_flags)", (py_dcerpc_call_fn)dcerpc_frstrans_EstablishConnection_r, (py_data_pack_fn)pack_py_frstrans_EstablishConnection_args_in, (py_data_unpack_fn)unpack_py_frstrans_EstablishConnection_args_out, 1, &ndr_table_frstrans },
	{ "EstablishSession", "S.EstablishSession(connection_guid, content_set_guid) -> None", (py_dcerpc_call_fn)dcerpc_frstrans_EstablishSession_r, (py_data_pack_fn)pack_py_frstrans_EstablishSession_args_in, (py_data_unpack_fn)unpack_py_frstrans_EstablishSession_args_out, 2, &ndr_table_frstrans },
	{ "RequestUpdates", "S.RequestUpdates(connection_guid, content_set_guid, credits_available, hash_requested, update_request_type, version_vector_diff) -> (frs_update, update_status, gvsn_db_guid, gvsn_version)", (py_dcerpc_call_fn)dcerpc_frstrans_RequestUpdates_r, (py_data_pack_fn)pack_py_frstrans_RequestUpdates_args_in, (py_data_unpack_fn)unpack_py_frstrans_RequestUpdates_args_out, 3, &ndr_table_frstrans },
	{ "RequestVersionVector", "S.RequestVersionVector(sequence_number, connection_guid, content_set_guid, request_type, change_type, vv_generation) -> None", (py_dcerpc_call_fn)dcerpc_frstrans_RequestVersionVector_r, (py_data_pack_fn)pack_py_frstrans_RequestVersionVector_args_in, (py_data_unpack_fn)unpack_py_frstrans_RequestVersionVector_args_out, 4, &ndr_table_frstrans },
	{ "AsyncPoll", "S.AsyncPoll(connection_guid) -> response", (py_dcerpc_call_fn)dcerpc_frstrans_AsyncPoll_r, (py_data_pack_fn)pack_py_frstrans_AsyncPoll_args_in, (py_data_unpack_fn)unpack_py_frstrans_AsyncPoll_args_out, 5, &ndr_table_frstrans },
	{ "InitializeFileTransferAsync", "S.InitializeFileTransferAsync(connection_guid, frs_update, rdc_desired, staging_policy, buffer_size) -> (frs_update, staging_policy, server_context, rdc_file_info, data_buffer, is_end_of_file)", (py_dcerpc_call_fn)dcerpc_frstrans_InitializeFileTransferAsync_r, (py_data_pack_fn)pack_py_frstrans_InitializeFileTransferAsync_args_in, (py_data_unpack_fn)unpack_py_frstrans_InitializeFileTransferAsync_args_out, 13, &ndr_table_frstrans },
	{ NULL }
};

static PyObject *interface_frstrans_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_frstrans);
}

#define PY_DOC_FRSTRANS "File Replication Service DFS-R"
static PyTypeObject frstrans_InterfaceType = {
	PyObject_HEAD_INIT(NULL) 0,
	.tp_name = "frstrans.frstrans",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "frstrans(binding, lp_ctx=None, credentials=None) -> connection\n"
"\n"
"binding should be a DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials should be a credentials.Credentials object.\n\n"PY_DOC_FRSTRANS,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_frstrans_new,
};

static PyMethodDef frstrans_methods[] = {
	{ NULL, NULL, 0, NULL }
};

void initfrstrans(void)
{
	PyObject *m;
	PyObject *dep_talloc;
	PyObject *dep_samba_dcerpc_misc;
	PyObject *dep_samba_dcerpc_base;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		return;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		return;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		return;

	policy_handle_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "policy_handle");
	if (policy_handle_Type == NULL)
		return;

	Object_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "Object");
	if (Object_Type == NULL)
		return;

	GUID_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "GUID");
	if (GUID_Type == NULL)
		return;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		return;

	frstrans_VersionVector_Type.tp_base = Object_Type;

	frstrans_Update_Type.tp_base = Object_Type;

	frstrans_EpoqueVector_Type.tp_base = Object_Type;

	frstrans_AsyncVersionVectorResponse_Type.tp_base = Object_Type;

	frstrans_AsyncResponseContext_Type.tp_base = Object_Type;

	frstrans_RdcParameterGeneric_Type.tp_base = Object_Type;

	frstrans_RdcParameterFilterMax_Type.tp_base = Object_Type;

	frstrans_RdcParameterFilterPoint_Type.tp_base = Object_Type;

	frstrans_RdcParameters_Type.tp_base = Object_Type;

	frstrans_RdcFileInfo_Type.tp_base = Object_Type;

	frstrans_InterfaceType.tp_base = ClientConnection_Type;

	if (PyType_Ready(&frstrans_VersionVector_Type) < 0)
		return;
	if (PyType_Ready(&frstrans_Update_Type) < 0)
		return;
	if (PyType_Ready(&frstrans_EpoqueVector_Type) < 0)
		return;
	if (PyType_Ready(&frstrans_AsyncVersionVectorResponse_Type) < 0)
		return;
	if (PyType_Ready(&frstrans_AsyncResponseContext_Type) < 0)
		return;
	if (PyType_Ready(&frstrans_RdcParameterGeneric_Type) < 0)
		return;
	if (PyType_Ready(&frstrans_RdcParameterFilterMax_Type) < 0)
		return;
	if (PyType_Ready(&frstrans_RdcParameterFilterPoint_Type) < 0)
		return;
	if (PyType_Ready(&frstrans_RdcParameters_Type) < 0)
		return;
	if (PyType_Ready(&frstrans_RdcFileInfo_Type) < 0)
		return;
	if (PyType_Ready(&frstrans_InterfaceType) < 0)
		return;
	if (!PyInterface_AddNdrRpcMethods(&frstrans_InterfaceType, py_ndr_frstrans_methods))
		return;

#ifdef PY_VERSIONVECTOR_PATCH
	PY_VERSIONVECTOR_PATCH(&frstrans_VersionVector_Type);
#endif
#ifdef PY_UPDATE_PATCH
	PY_UPDATE_PATCH(&frstrans_Update_Type);
#endif
#ifdef PY_EPOQUEVECTOR_PATCH
	PY_EPOQUEVECTOR_PATCH(&frstrans_EpoqueVector_Type);
#endif
#ifdef PY_ASYNCVERSIONVECTORRESPONSE_PATCH
	PY_ASYNCVERSIONVECTORRESPONSE_PATCH(&frstrans_AsyncVersionVectorResponse_Type);
#endif
#ifdef PY_ASYNCRESPONSECONTEXT_PATCH
	PY_ASYNCRESPONSECONTEXT_PATCH(&frstrans_AsyncResponseContext_Type);
#endif
#ifdef PY_RDCPARAMETERGENERIC_PATCH
	PY_RDCPARAMETERGENERIC_PATCH(&frstrans_RdcParameterGeneric_Type);
#endif
#ifdef PY_RDCPARAMETERFILTERMAX_PATCH
	PY_RDCPARAMETERFILTERMAX_PATCH(&frstrans_RdcParameterFilterMax_Type);
#endif
#ifdef PY_RDCPARAMETERFILTERPOINT_PATCH
	PY_RDCPARAMETERFILTERPOINT_PATCH(&frstrans_RdcParameterFilterPoint_Type);
#endif
#ifdef PY_RDCPARAMETERS_PATCH
	PY_RDCPARAMETERS_PATCH(&frstrans_RdcParameters_Type);
#endif
#ifdef PY_RDCFILEINFO_PATCH
	PY_RDCFILEINFO_PATCH(&frstrans_RdcFileInfo_Type);
#endif
#ifdef PY_FRSTRANS_PATCH
	PY_FRSTRANS_PATCH(&frstrans_InterfaceType);
#endif

	m = Py_InitModule3("frstrans", frstrans_methods, "frstrans DCE/RPC");
	if (m == NULL)
		return;

	PyModule_AddObject(m, "FRSTRANS_VERSION_CHANGE_NOTIFY", PyInt_FromLong(FRSTRANS_VERSION_CHANGE_NOTIFY));
	PyModule_AddObject(m, "FRSTRANS_PROTOCOL_VERSION_LONGHORN_SERVER", PyInt_FromLong(FRSTRANS_PROTOCOL_VERSION_LONGHORN_SERVER));
	PyModule_AddObject(m, "FRSTRANS_STAGING_POLICY_RESTATGING_REQUIRED", PyInt_FromLong(FRSTRANS_STAGING_POLICY_RESTATGING_REQUIRED));
	PyModule_AddObject(m, "FRSTRANS_STAGING_POLICY_SERVER_DEFAULTY", PyInt_FromLong(FRSTRANS_STAGING_POLICY_SERVER_DEFAULTY));
	PyModule_AddObject(m, "FRSTRANS_UPDATE_REQUEST_ALL", PyInt_FromLong(FRSTRANS_UPDATE_REQUEST_ALL));
	PyModule_AddObject(m, "FRSTRANS_UPDATE_STATUS_MORE", PyInt_FromLong(FRSTRANS_UPDATE_STATUS_MORE));
	PyModule_AddObject(m, "FRSTRANS_UPDATE_STATUS_DONE", PyInt_FromLong(FRSTRANS_UPDATE_STATUS_DONE));
	PyModule_AddObject(m, "FRSTRANS_RDC_VERSION_COMPATIBLE", PyInt_FromLong(FRSTRANS_RDC_VERSION_COMPATIBLE));
	PyModule_AddObject(m, "FRSTRANS_VERSION_CHANGE_ALL", PyInt_FromLong(FRSTRANS_VERSION_CHANGE_ALL));
	PyModule_AddObject(m, "FRSTRANS_RDC_UNCOMPRESSED", PyInt_FromLong(FRSTRANS_RDC_UNCOMPRESSED));
	PyModule_AddObject(m, "FRSTRANS_PROTOCOL_VERSION_W2K3R2", PyInt_FromLong(FRSTRANS_PROTOCOL_VERSION_W2K3R2));
	PyModule_AddObject(m, "FRSTRANS_STAGING_POLICY_STATGING_REQUIRED", PyInt_FromLong(FRSTRANS_STAGING_POLICY_STATGING_REQUIRED));
	PyModule_AddObject(m, "FRSTRANS_RDC_XPRESS", PyInt_FromLong(FRSTRANS_RDC_XPRESS));
	PyModule_AddObject(m, "FRSTRANS_RDC_MAX_ALGORITHM", PyInt_FromLong(FRSTRANS_RDC_MAX_ALGORITHM));
	PyModule_AddObject(m, "FRSTRANS_VERSION_REQUEST_SLAVE_SYNC", PyInt_FromLong(FRSTRANS_VERSION_REQUEST_SLAVE_SYNC));
	PyModule_AddObject(m, "FRSTRANS_RDC_FILTER_POINT", PyInt_FromLong(FRSTRANS_RDC_FILTER_POINT));
	PyModule_AddObject(m, "FRSTRANS_UPDATE_REQUEST_TOMBSTONES", PyInt_FromLong(FRSTRANS_UPDATE_REQUEST_TOMBSTONES));
	PyModule_AddObject(m, "FRSTRANS_VERSION_REQUEST_NORNAL_SYNC", PyInt_FromLong(FRSTRANS_VERSION_REQUEST_NORNAL_SYNC));
	PyModule_AddObject(m, "FRSTRANS_UPDATE_REQUEST_LIVE", PyInt_FromLong(FRSTRANS_UPDATE_REQUEST_LIVE));
	PyModule_AddObject(m, "FRSTRANS_RDC_VERSION", PyInt_FromLong(FRSTRANS_RDC_VERSION));
	PyModule_AddObject(m, "FRSTRANS_RDC_FILTER_GENERIC", PyInt_FromLong(FRSTRANS_RDC_FILTER_GENERIC));
	PyModule_AddObject(m, "FRSTRANS_VERSION_REQUEST_SLOW_SYNC", PyInt_FromLong(FRSTRANS_VERSION_REQUEST_SLOW_SYNC));
	PyModule_AddObject(m, "FRSTRANS_TRANSPORT_SUPPORTS_RDC_SIMILARITY", PyInt_FromLong(FRSTRANS_TRANSPORT_SUPPORTS_RDC_SIMILARITY));
	PyModule_AddObject(m, "FRSTRANS_RDC_FILTER_MAX", PyInt_FromLong(FRSTRANS_RDC_FILTER_MAX));
	Py_INCREF((PyObject *)(void *)&frstrans_VersionVector_Type);
	PyModule_AddObject(m, "VersionVector", (PyObject *)(void *)&frstrans_VersionVector_Type);
	Py_INCREF((PyObject *)(void *)&frstrans_Update_Type);
	PyModule_AddObject(m, "Update", (PyObject *)(void *)&frstrans_Update_Type);
	Py_INCREF((PyObject *)(void *)&frstrans_EpoqueVector_Type);
	PyModule_AddObject(m, "EpoqueVector", (PyObject *)(void *)&frstrans_EpoqueVector_Type);
	Py_INCREF((PyObject *)(void *)&frstrans_AsyncVersionVectorResponse_Type);
	PyModule_AddObject(m, "AsyncVersionVectorResponse", (PyObject *)(void *)&frstrans_AsyncVersionVectorResponse_Type);
	Py_INCREF((PyObject *)(void *)&frstrans_AsyncResponseContext_Type);
	PyModule_AddObject(m, "AsyncResponseContext", (PyObject *)(void *)&frstrans_AsyncResponseContext_Type);
	Py_INCREF((PyObject *)(void *)&frstrans_RdcParameterGeneric_Type);
	PyModule_AddObject(m, "RdcParameterGeneric", (PyObject *)(void *)&frstrans_RdcParameterGeneric_Type);
	Py_INCREF((PyObject *)(void *)&frstrans_RdcParameterFilterMax_Type);
	PyModule_AddObject(m, "RdcParameterFilterMax", (PyObject *)(void *)&frstrans_RdcParameterFilterMax_Type);
	Py_INCREF((PyObject *)(void *)&frstrans_RdcParameterFilterPoint_Type);
	PyModule_AddObject(m, "RdcParameterFilterPoint", (PyObject *)(void *)&frstrans_RdcParameterFilterPoint_Type);
	Py_INCREF((PyObject *)(void *)&frstrans_RdcParameters_Type);
	PyModule_AddObject(m, "RdcParameters", (PyObject *)(void *)&frstrans_RdcParameters_Type);
	Py_INCREF((PyObject *)(void *)&frstrans_RdcFileInfo_Type);
	PyModule_AddObject(m, "RdcFileInfo", (PyObject *)(void *)&frstrans_RdcFileInfo_Type);
	Py_INCREF((PyObject *)(void *)&frstrans_InterfaceType);
	PyModule_AddObject(m, "frstrans", (PyObject *)(void *)&frstrans_InterfaceType);
#ifdef PY_MOD_FRSTRANS_PATCH
	PY_MOD_FRSTRANS_PATCH(m);
#endif

}
